/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.newretail.bo.QuerySkuPriceBasicDataReqBO;
import com.tydic.newretail.bo.SkuPriceBO;
import com.tydic.newretail.busi.service.QuerySkuPriceBasicDataService;
import com.tydic.newretail.dao.SkuPriceDAO;
import com.tydic.newretail.dao.po.SkuPricePO;
import com.tydic.newretail.util.MoneyUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QuerySkuPriceBasicDataServiceImpl
implements QuerySkuPriceBasicDataService {
    private static final Logger logger = LoggerFactory.getLogger(QuerySkuPriceBasicDataServiceImpl.class);
    @Autowired
    private SkuPriceDAO skuPriceDAO;

    public List<SkuPriceBO> querySkuPriceBasicData(QuerySkuPriceBasicDataReqBO querySkuPriceBasicDataReqBO) {
        List<SkuPricePO> skuPrices;
        ArrayList<SkuPriceBO> skuPriceBOs = new ArrayList<SkuPriceBO>();
        logger.debug("\u67e5\u8be2sku\u4ef7\u683c\u57fa\u7840\u4fe1\u606f\u670d\u52a1\u5165\u53c2=" + JSON.toJSONString((Object)querySkuPriceBasicDataReqBO));
        if (CollectionUtils.isNotEmpty((Collection)querySkuPriceBasicDataReqBO.getSkuIds()) && CollectionUtils.isNotEmpty(skuPrices = this.skuPriceDAO.selectBySkuIds(querySkuPriceBasicDataReqBO.getSkuIds()))) {
            for (SkuPricePO skuPrice : skuPrices) {
                SkuPriceBO skuPriceBO = new SkuPriceBO();
                BeanUtils.copyProperties((Object)skuPrice, (Object)skuPriceBO);
                try {
                    if (skuPrice.getTheCostDownPrice() != null) {
                        skuPriceBO.setTheCostDownPriceY(MoneyUtils.Long2BigDecimal(skuPrice.getTheCostDownPrice()));
                    }
                    if (skuPrice.getRetailAgreementPrice() != null) {
                        skuPriceBO.setRetailAgreementPriceY(MoneyUtils.Long2BigDecimal(skuPrice.getRetailAgreementPrice()));
                    }
                    if (skuPrice.getCitiesLockPrice() != null) {
                        skuPriceBO.setCitiesLockPriceY(MoneyUtils.Long2BigDecimal(skuPrice.getCitiesLockPrice()));
                    }
                    if (skuPrice.getPurchaseFloorPrice() != null) {
                        skuPriceBO.setPurchaseFloorPriceY(MoneyUtils.Long2BigDecimal(skuPrice.getPurchaseFloorPrice()));
                    }
                    if (skuPrice.getMarketPrice() != null) {
                        skuPriceBO.setMarketPriceY(MoneyUtils.Long2BigDecimal(skuPrice.getMarketPrice()));
                    }
                    if (skuPrice.getAgreementPrice() != null) {
                        skuPriceBO.setAgreementPriceY(MoneyUtils.Long2BigDecimal(skuPrice.getAgreementPrice()));
                    }
                    if (skuPrice.getMemberPrice() != null) {
                        skuPriceBO.setMemberPriceY(MoneyUtils.Long2BigDecimal(skuPrice.getMemberPrice()));
                    }
                    if (skuPrice.getSalePrice() != null) {
                        skuPriceBO.setSalePriceY(MoneyUtils.Long2BigDecimal(skuPrice.getSalePrice()));
                    }
                    if (skuPrice.getAssessmentPrice() != null) {
                        skuPriceBO.setAssessmentPriceY(MoneyUtils.Long2BigDecimal(skuPrice.getAssessmentPrice()));
                    }
                    if (skuPrice.getPurchasePrice() != null) {
                        skuPriceBO.setPurchasePriceY(MoneyUtils.Long2BigDecimal(skuPrice.getPurchasePrice()));
                    }
                    if (skuPrice.getSparePrice1() != null) {
                        skuPriceBO.setSparePrice1Y(MoneyUtils.Long2BigDecimal(skuPrice.getSparePrice1()));
                    }
                    if (skuPrice.getMemberLadderPrice1() != null) {
                        skuPriceBO.setMemberLadderPrice1Y(MoneyUtils.Long2BigDecimal(skuPrice.getMemberLadderPrice1()));
                    }
                    if (skuPrice.getMemberLadderPrice2() != null) {
                        skuPriceBO.setMemberLadderPrice2Y(MoneyUtils.Long2BigDecimal(skuPrice.getMemberLadderPrice2()));
                    }
                    if (skuPrice.getMemberLadderPrice3() != null) {
                        skuPriceBO.setMemberLadderPrice3Y(MoneyUtils.Long2BigDecimal(skuPrice.getMemberLadderPrice3()));
                    }
                    if (skuPrice.getPurchasePrice() == null && skuPrice.getSparePrice1() != null) {
                        skuPriceBO.setPurchasePrice(skuPrice.getSparePrice1());
                        skuPriceBO.setPurchasePriceY(MoneyUtils.Long2BigDecimal(skuPrice.getSparePrice1()));
                    }
                    if (skuPrice.getMemberLadderPrice4() != null) {
                        skuPriceBO.setMemberLadderPrice4Y(MoneyUtils.Long2BigDecimal(skuPrice.getMemberLadderPrice4()));
                    }
                    if (skuPrice.getMemberLadderPrice5() != null) {
                        skuPriceBO.setMemberLadderPrice5Y(MoneyUtils.Long2BigDecimal(skuPrice.getMemberLadderPrice5()));
                    }
                    if (skuPrice.getProvAgreePrice() != null) {
                        skuPriceBO.setProvAgreePriceY(MoneyUtils.Long2BigDecimal(skuPrice.getProvAgreePrice()));
                    }
                    if (skuPrice.getLastPurchasePrice() != null) {
                        skuPriceBO.setLastPurchasePriceY(MoneyUtils.Long2BigDecimal(skuPrice.getLastPurchasePrice()));
                    }
                    if (skuPrice.getCostPrice() != null) {
                        skuPriceBO.setCostPriceY(MoneyUtils.Long2BigDecimal(skuPrice.getCostPrice()));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                skuPriceBOs.add(skuPriceBO);
            }
        }
        return skuPriceBOs;
    }
}

