/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.newretail.bo.QuerySkuShareBuyReqBO;
import com.tydic.newretail.bo.QuerySkuShareBuyRspBO;
import com.tydic.newretail.bo.RspPageBO;
import com.tydic.newretail.busi.service.QuerySkuShareBuyService;
import com.tydic.newretail.dao.DShareRecordDAO;
import com.tydic.newretail.dao.SkuDAO;
import com.tydic.newretail.dao.po.DShareRecordAndBuyPO;
import com.tydic.newretail.dao.po.SkuPO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QuerySkuShareBuyServiceImpl
implements QuerySkuShareBuyService {
    @Autowired
    private SkuDAO xlsSkuMapper;
    @Autowired
    private DShareRecordDAO dShareRecordDAO;
    private static final Logger logger = LoggerFactory.getLogger(QuerySkuShareBuyServiceImpl.class);

    public RspPageBO<QuerySkuShareBuyRspBO> querySkuShareBuy(QuerySkuShareBuyReqBO querySkuShareBuyReqBO) {
        logger.debug("\u67e5\u8be2\u4f1a\u5458\u7684\u5206\u4eab\u8d2d\u4e70\u8bb0\u5f55\u670d\u52a1\u5165\u53c2=" + querySkuShareBuyReqBO.toString());
        RspPageBO result = new RspPageBO();
        ArrayList<QuerySkuShareBuyRspBO> querySkuShareBuyRspBOs = new ArrayList<QuerySkuShareBuyRspBO>();
        result.setRows(querySkuShareBuyRspBOs);
        Long sharer = querySkuShareBuyReqBO.getSharer();
        if (sharer == null) {
            result.setRespCode("8888");
            result.setRespDesc("\u5fc5\u586b\u5b57\u6bb5\u4e3a\u7a7a");
            return result;
        }
        Page page = new Page();
        page.setLimit(querySkuShareBuyReqBO.getPageSize());
        page.setOffset(querySkuShareBuyReqBO.getOffset());
        List<DShareRecordAndBuyPO> dShareRecordAndBuyPOs = null;
        try {
            dShareRecordAndBuyPOs = this.dShareRecordDAO.selectByMemberId(sharer, (Page<DShareRecordAndBuyPO>)page);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u6839\u636e\u4f1a\u5458\u67e5\u8be2\u5206\u4eab\u8d2d\u4e70\u8bb0\u5f55\u62a5\u9519");
        }
        ArrayList<Long> skuIds = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty(dShareRecordAndBuyPOs)) {
            for (DShareRecordAndBuyPO dShareRecordAndBuyPO : dShareRecordAndBuyPOs) {
                QuerySkuShareBuyRspBO querySkuShareBuyRspBO = new QuerySkuShareBuyRspBO();
                querySkuShareBuyRspBO.setSharer(sharer);
                querySkuShareBuyRspBO.setSkuId(dShareRecordAndBuyPO.getSkuId());
                querySkuShareBuyRspBO.setShareTime(dShareRecordAndBuyPO.getCreateTime());
                querySkuShareBuyRspBO.setCountShare(dShareRecordAndBuyPO.getCountShare());
                querySkuShareBuyRspBO.setBusinessVolume(dShareRecordAndBuyPO.getBusinessVolume());
                querySkuShareBuyRspBOs.add(querySkuShareBuyRspBO);
                skuIds.add(dShareRecordAndBuyPO.getSkuId());
            }
        }
        List<SkuPO> skus = null;
        if (CollectionUtils.isNotEmpty(skuIds)) {
            SkuPO sku = new SkuPO();
            sku.setSkuIds(skuIds);
            try {
                skus = this.xlsSkuMapper.querySkuListByManyList(sku);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("\u6839\u636eskuId\u5217\u8868\u67e5\u8be2\u5355\u54c1\u5217\u8868\u4fe1\u606f\u62a5\u9519");
            }
        }
        HashMap<Long, SkuPO> mapSku = new HashMap<Long, SkuPO>();
        if (CollectionUtils.isNotEmpty(skus)) {
            for (SkuPO sku1 : skus) {
                mapSku.put(sku1.getSkuId(), sku1);
            }
        }
        if (CollectionUtils.isNotEmpty(querySkuShareBuyRspBOs)) {
            for (QuerySkuShareBuyRspBO querySkuShareBuyRspBO : querySkuShareBuyRspBOs) {
                SkuPO sku1 = (SkuPO)mapSku.get(querySkuShareBuyRspBO.getSkuId());
                BeanUtils.copyProperties((Object)sku1, (Object)querySkuShareBuyRspBO);
            }
        }
        result.setTotal(page.getTotalPages());
        result.setRecordsTotal(page.getTotalCount());
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        return result;
    }
}

