/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.tydic.newretail.bo.QuerySkuSpecReqBO;
import com.tydic.newretail.bo.QuerySkuSpecRspBO;
import com.tydic.newretail.bo.SkuSpecBO;
import com.tydic.newretail.busi.service.QuerySkuSpecBusiService;
import com.tydic.newretail.dao.SkuSpecDAO;
import com.tydic.newretail.exception.BusinessException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="querySkuSpecBusiService")
@Qualifier
public class QuerySkuSpecBusiServiceImpl
implements QuerySkuSpecBusiService {
    private static final Logger logger = LoggerFactory.getLogger(QuerySkuSpecBusiServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private SkuSpecDAO skuSpecMapper;

    public QuerySkuSpecRspBO querySkuSpec(QuerySkuSpecReqBO querySkuSpecReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u5355\u54c1\u89c4\u683c\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a{}", (Object)querySkuSpecReqBO.toString());
        }
        QuerySkuSpecRspBO querySkuSpecRspBO = new QuerySkuSpecRspBO();
        try {
            HashMap<String, Object> skuIdAndSupplierId = new HashMap<String, Object>();
            skuIdAndSupplierId.put("skuId", querySkuSpecReqBO.getSkuId());
            skuIdAndSupplierId.put("supplierId", querySkuSpecReqBO.getSupplierId());
            List<Object> skuSpecs = new ArrayList();
            skuSpecs = this.skuSpecMapper.selectSpecBySkuIdAndSupplierId(skuIdAndSupplierId);
            ArrayList skuSpecBOS = new ArrayList();
            if (CollectionUtils.isNotEmpty(skuSpecs)) {
                skuSpecs.forEach(item -> {
                    SkuSpecBO skuSpecBO = new SkuSpecBO();
                    BeanUtils.copyProperties((Object)item, (Object)skuSpecBO);
                    skuSpecBOS.add(skuSpecBO);
                });
            }
            querySkuSpecRspBO.setSpecs(skuSpecBOS);
        }
        catch (Exception e) {
            logger.error("\u5355\u54c1\u89c4\u683c\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff0c{}", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5355\u54c1\u89c4\u683c\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
        return querySkuSpecRspBO;
    }
}

