/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.tydic.newretail.bo.QueryXlsEsByCommodityIdsServiceReqBO;
import com.tydic.newretail.bo.QueryXlsEsBySkuIdsServiceReqBO;
import com.tydic.newretail.bo.SearchBarEsRspBO;
import com.tydic.newretail.bo.SearchBarEsRspInfoBO;
import com.tydic.newretail.bo.SearchEsResultRspBO;
import com.tydic.newretail.bo.SearchEsRspInfoBO;
import com.tydic.newretail.busi.SearchEsService;
import com.tydic.newretail.busi.service.QueryXlsEsBySkuIdsService;
import com.tydic.newretail.dao.po.SearchEsQueryRspPO;
import com.tydic.newretail.exception.BusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.InnerHitBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.collapse.CollapseBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="queryXlsEsBySkuIdsService")
public class QueryXlsEsBySkuIdsServiceImpl
implements QueryXlsEsBySkuIdsService {
    private static final Logger logger = LoggerFactory.getLogger(QueryXlsEsBySkuIdsServiceImpl.class);
    @Value(value="${es.sku.index.name}")
    private String skuIndexName;
    @Value(value="${es.sku.type.name}")
    private String skuTypeName;
    @Resource
    private TransportClient client;
    @Autowired
    private SearchEsService searchEsService;

    public SearchBarEsRspBO queryXlsEsBySkuIds(QueryXlsEsBySkuIdsServiceReqBO queryXlsEsBySkuIdsServiceReqBO) throws Exception {
        logger.info("QueryXlsEsBySkuIdsService\u5165\u53c2\uff1a" + queryXlsEsBySkuIdsServiceReqBO);
        List skuIds = queryXlsEsBySkuIdsServiceReqBO.getSkuIds();
        if (skuIds == null && skuIds.size() < 1) {
            logger.error("QueryXlsEsBySkuIdsService\u5165\u53c2\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u5165\u53c2\u4e3a\u7a7a");
        }
        SearchBarEsRspBO bo = new SearchBarEsRspBO();
        try {
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_status", (int)2));
            BoolQueryBuilder shouldQueryBuilder = QueryBuilders.boolQuery();
            for (Long skuId : skuIds) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"sku_id", (Object)skuId));
            }
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
            SearchResponse searchResponse = (SearchResponse)this.client.prepareSearch(new String[]{this.skuIndexName}).setTypes(new String[]{this.skuTypeName}).setQuery((QueryBuilder)boolQueryBuilder).setFrom(0).setSize(skuIds.size()).get();
            SearchEsQueryRspPO rspBO = new SearchEsQueryRspPO();
            rspBO.setSearchResponse(searchResponse);
            SearchEsResultRspBO result = this.searchEsService.searchResult(rspBO);
            List list = result.getResult();
            ArrayList<SearchBarEsRspInfoBO> rspInfos = new ArrayList<SearchBarEsRspInfoBO>();
            for (SearchEsRspInfoBO searchBarEsRspInfoBO : list) {
                SearchBarEsRspInfoBO searchBarEsRspInfo = new SearchBarEsRspInfoBO();
                BeanUtils.copyProperties((Object)searchBarEsRspInfoBO, (Object)searchBarEsRspInfo);
                rspInfos.add(searchBarEsRspInfo);
            }
            logger.error("QueryXlsEsBySkuIdsService\uff1a\u67e5\u8be2\u6210\u529f\u3002\u7ed3\u679c\u6570" + list.size());
            if (list.size() > 0) {
                bo.setRespCode("0000");
                bo.setRespDesc("\u6210\u529f");
            } else {
                bo.setRespCode("0000");
                bo.setRespDesc("\u641c\u7d22\u7ed3\u679c\u4e3a\u7a7a");
            }
            bo.setResult(rspInfos);
        }
        catch (Exception e) {
            logger.error("QueryXlsEsBySkuIdsService\uff1a\u67e5\u8be2\u5931\u8d25\uff1a{}", (Throwable)e);
            bo.setRespCode("9999");
            bo.setRespDesc("QueryXlsEsBySkuIdsService\uff1a\u67e5\u8be2\u5931\u8d25");
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "QueryXlsEsBySkuIdsService\uff1a\u67e5\u8be2\u6210\u529f\u5931\u8d25");
        }
        return bo;
    }

    public SearchBarEsRspBO queryAllXlsEsBySkuIds(QueryXlsEsBySkuIdsServiceReqBO queryXlsEsBySkuIdsServiceReqBO) throws Exception {
        List skuIds = queryXlsEsBySkuIdsServiceReqBO.getSkuIds();
        if (skuIds == null && skuIds.size() < 1) {
            logger.error("queryAllXlsEsBySkuIds\u5165\u53c2\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u5165\u53c2\u4e3a\u7a7a");
        }
        SearchBarEsRspBO bo = new SearchBarEsRspBO();
        try {
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            BoolQueryBuilder shouldQueryBuilder = QueryBuilders.boolQuery();
            for (Long skuId : skuIds) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"sku_id", (Object)skuId));
            }
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
            SearchResponse searchResponse = (SearchResponse)this.client.prepareSearch(new String[]{this.skuIndexName}).setTypes(new String[]{this.skuTypeName}).setQuery((QueryBuilder)boolQueryBuilder).setFrom(0).setSize(skuIds.size()).get();
            SearchEsQueryRspPO rspBO = new SearchEsQueryRspPO();
            rspBO.setSearchResponse(searchResponse);
            SearchEsResultRspBO result = this.searchEsService.searchResult(rspBO);
            List list = result.getResult();
            ArrayList<SearchBarEsRspInfoBO> rspInfos = new ArrayList<SearchBarEsRspInfoBO>();
            for (SearchEsRspInfoBO searchBarEsRspInfoBO : list) {
                SearchBarEsRspInfoBO searchBarEsRspInfo = new SearchBarEsRspInfoBO();
                BeanUtils.copyProperties((Object)searchBarEsRspInfoBO, (Object)searchBarEsRspInfo);
                rspInfos.add(searchBarEsRspInfo);
            }
            logger.error("QueryXlsEsBySkuIdsService\uff1a\u67e5\u8be2\u6210\u529f\u3002\u7ed3\u679c\u6570" + list.size());
            if (list.size() > 0) {
                bo.setRespCode("0000");
                bo.setRespDesc("\u6210\u529f");
            } else {
                bo.setRespCode("0000");
                bo.setRespDesc("\u641c\u7d22\u7ed3\u679c\u4e3a\u7a7a");
            }
            bo.setResult(rspInfos);
        }
        catch (Exception e) {
            logger.error("QueryXlsEsBySkuIdsService\uff1a\u67e5\u8be2\u5931\u8d25\uff1a{}", (Throwable)e);
            bo.setRespCode("9999");
            bo.setRespDesc("QueryXlsEsBySkuIdsService\uff1a\u67e5\u8be2\u5931\u8d25");
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "QueryXlsEsBySkuIdsService\uff1a\u67e5\u8be2\u6210\u529f\u5931\u8d25");
        }
        return bo;
    }

    public SearchBarEsRspBO queryAllXlsEsByCommodityIds(QueryXlsEsByCommodityIdsServiceReqBO queryXlsEsByCommodityIdsServiceReqBO) throws Exception {
        List commodityIds = queryXlsEsByCommodityIdsServiceReqBO.getCommodityIds();
        if (commodityIds == null && commodityIds.size() < 1) {
            logger.error("queryAllXlsEsBySkuIds\u5165\u53c2\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u5165\u53c2\u4e3a\u7a7a");
        }
        SearchBarEsRspBO bo = new SearchBarEsRspBO();
        try {
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_status", (int)2));
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"commodity_id", (Collection)commodityIds));
            CollapseBuilder collapseBuilder = new CollapseBuilder("commodity_id");
            InnerHitBuilder innerHit = new InnerHitBuilder("bottom_price_sku");
            ArrayList<FieldSortBuilder> sorts = new ArrayList<FieldSortBuilder>();
            SortOrder orderSalePrice = SortOrder.ASC;
            FieldSortBuilder fsb = (FieldSortBuilder)SortBuilders.fieldSort((String)"sale_price").order(orderSalePrice);
            sorts.add(fsb);
            innerHit.setSorts(sorts);
            innerHit.setSize(1);
            collapseBuilder.setInnerHits(innerHit);
            SearchResponse searchResponse = (SearchResponse)this.client.prepareSearch(new String[]{this.skuIndexName}).setTypes(new String[]{this.skuTypeName}).setQuery((QueryBuilder)boolQueryBuilder).setCollapse(collapseBuilder).setFrom(0).setSize(commodityIds.size()).get();
            SearchEsQueryRspPO rspBO = new SearchEsQueryRspPO();
            rspBO.setSearchResponse(searchResponse);
            SearchEsResultRspBO result = this.searchEsService.searchResult(rspBO);
            List list = result.getResult();
            ArrayList<SearchBarEsRspInfoBO> rspInfos = new ArrayList<SearchBarEsRspInfoBO>();
            for (SearchEsRspInfoBO searchBarEsRspInfoBO : list) {
                SearchBarEsRspInfoBO searchBarEsRspInfo = new SearchBarEsRspInfoBO();
                BeanUtils.copyProperties((Object)searchBarEsRspInfoBO, (Object)searchBarEsRspInfo);
                rspInfos.add(searchBarEsRspInfo);
            }
            if (list.size() > 0) {
                bo.setRespCode("0000");
                bo.setRespDesc("\u6210\u529f");
            } else {
                bo.setRespCode("0000");
                bo.setRespDesc("\u641c\u7d22\u7ed3\u679c\u4e3a\u7a7a");
            }
            bo.setResult(rspInfos);
        }
        catch (Exception e) {
            logger.error("QueryXlsEsBySkuIdsService\uff1a\u67e5\u8be2\u5931\u8d25\uff1a{}", (Throwable)e);
            bo.setRespCode("9999");
            bo.setRespDesc("QueryXlsEsBySkuIdsService\uff1a\u67e5\u8be2\u5931\u8d25");
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "QueryXlsEsBySkuIdsService\uff1a\u67e5\u8be2\u6210\u529f\u5931\u8d25");
        }
        return bo;
    }
}

