/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.tydic.newretail.bo.CommodityBO;
import com.tydic.newretail.bo.DSkuSpecBO;
import com.tydic.newretail.bo.QueryXlsEsRspBO;
import com.tydic.newretail.bo.SearchBarEsReqBO;
import com.tydic.newretail.bo.SearchBarEsRspBO;
import com.tydic.newretail.bo.SearchBarEsRspInfoBO;
import com.tydic.newretail.bo.XlsSearchBarEsRspInfoBO;
import com.tydic.newretail.busi.service.QueryXlsEsService;
import com.tydic.newretail.busi.service.SearchBarEsService;
import com.tydic.newretail.dao.CommodityDAO;
import com.tydic.newretail.dao.SkuDAO;
import com.tydic.newretail.dao.SkuPriceDAO;
import com.tydic.newretail.dao.SkuSpecDAO;
import com.tydic.newretail.dao.po.CommodityPO;
import com.tydic.newretail.dao.po.SkuPO;
import com.tydic.newretail.dao.po.SkuPricePO;
import com.tydic.newretail.dao.po.SkuSpecPO;
import com.tydic.newretail.util.MoneyUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.mortbay.util.ajax.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class QueryXlsEsServiceImpl
implements QueryXlsEsService {
    @Autowired
    private SearchBarEsService searchBarEsService;
    @Autowired
    private CommodityDAO commodityDAO;
    @Autowired
    private SkuPriceDAO skuPriceDAO;
    @Autowired
    private SkuDAO skuDAO;
    @Autowired
    private SkuSpecDAO skuSpecDAO;
    private static final Logger logger = LoggerFactory.getLogger(QueryXlsEsServiceImpl.class);

    public QueryXlsEsRspBO queryXlsEs(SearchBarEsReqBO searchBarEsReqBO) {
        List<CommodityPO> xlsCommodityPOs;
        logger.info("\u67e5\u8be2es\u670d\u52a1\u5165\u53c2=" + searchBarEsReqBO.toString());
        QueryXlsEsRspBO queryXlsEsRspBO = new QueryXlsEsRspBO();
        ArrayList<Long> commodityIds = new ArrayList();
        ArrayList<Long> skuIds = new ArrayList();
        SearchBarEsRspBO searchBarEsRspBO = null;
        try {
            searchBarEsRspBO = this.searchBarEsService.queryEsGroupByCommodityId(searchBarEsReqBO);
            queryXlsEsRspBO.setQueryParams(searchBarEsRspBO.getQueryParams());
            BeanUtils.copyProperties((Object)searchBarEsRspBO, (Object)queryXlsEsRspBO);
            commodityIds = searchBarEsRspBO.getCommodityIds();
            skuIds = searchBarEsRspBO.getSkuIds();
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2es\u670d\u52a1\u62a5\u9519");
            e.printStackTrace();
            queryXlsEsRspBO.setRespCode("8888");
            queryXlsEsRspBO.setRespDesc("\u67e5\u8be2es\u670d\u52a1\u62a5\u9519");
        }
        HashMap<Long, CommodityBO> mapXlsCommodityBO = new HashMap<Long, CommodityBO>();
        if (CollectionUtils.isNotEmpty(commodityIds) && CollectionUtils.isNotEmpty(xlsCommodityPOs = this.commodityDAO.selectByCommodityIds(commodityIds))) {
            for (CommodityPO xlsCommodityPO : xlsCommodityPOs) {
                CommodityBO xlsCommodityBO = new CommodityBO();
                BeanUtils.copyProperties((Object)xlsCommodityPO, (Object)xlsCommodityBO);
                mapXlsCommodityBO.put(xlsCommodityPO.getCommodityId(), xlsCommodityBO);
            }
        }
        HashMap<Long, SkuPricePO> mapSkuPrice = new HashMap<Long, SkuPricePO>();
        HashMap<Long, SkuPO> skuMap = new HashMap<Long, SkuPO>();
        HashMap dimidionMap = new HashMap();
        if (CollectionUtils.isNotEmpty(skuIds)) {
            List<SkuPricePO> skuPrices = this.skuPriceDAO.selectBySkuIds(skuIds);
            for (SkuPricePO skuPricePO : skuPrices) {
                mapSkuPrice.put(skuPricePO.getSkuId(), skuPricePO);
            }
            List<SkuPO> sku = this.skuDAO.selectBySkuIds(skuIds);
            for (SkuPO skuPO : sku) {
                skuMap.put(skuPO.getSkuId(), skuPO);
            }
            List<SkuSpecPO> list = this.skuSpecDAO.selectDimision(skuIds);
            if (!CollectionUtils.isEmpty(list)) {
                for (SkuSpecPO sp : list) {
                    if (dimidionMap.containsKey(sp.getSkuId())) {
                        DSkuSpecBO bo = new DSkuSpecBO();
                        BeanUtils.copyProperties((Object)sp, (Object)bo);
                        ((List)dimidionMap.get(sp.getSkuId())).add(bo);
                        continue;
                    }
                    ArrayList<DSkuSpecBO> list2 = new ArrayList<DSkuSpecBO>();
                    DSkuSpecBO bo = new DSkuSpecBO();
                    BeanUtils.copyProperties((Object)sp, (Object)bo);
                    list2.add(bo);
                    dimidionMap.put(sp.getSkuId(), list2);
                }
            }
        }
        ArrayList<XlsSearchBarEsRspInfoBO> result = new ArrayList<XlsSearchBarEsRspInfoBO>();
        List searchBarEsRspInfos = searchBarEsRspBO.getResult();
        if (CollectionUtils.isNotEmpty((Collection)searchBarEsRspInfos)) {
            for (SearchBarEsRspInfoBO searchBarEsRspInfoBO : searchBarEsRspInfos) {
                XlsSearchBarEsRspInfoBO xlsSearchBarEsRspInfo = new XlsSearchBarEsRspInfoBO();
                BeanUtils.copyProperties((Object)searchBarEsRspInfoBO, (Object)xlsSearchBarEsRspInfo);
                xlsSearchBarEsRspInfo.setXlsCommodityBO((CommodityBO)mapXlsCommodityBO.get(searchBarEsRspInfoBO.getCommodityId()));
                xlsSearchBarEsRspInfo.setSpec((List)dimidionMap.get(Long.parseLong(searchBarEsRspInfoBO.getSkuId())));
                SkuPricePO skuPrice = (SkuPricePO)mapSkuPrice.get(Long.parseLong(searchBarEsRspInfoBO.getSkuId()));
                xlsSearchBarEsRspInfo.setMaterialId(((SkuPO)skuMap.get(Long.parseLong(searchBarEsRspInfoBO.getSkuId()))).getMaterialId());
                logger.debug("\u7269\u6599\u7f16\u7801\uff1a" + ((SkuPO)skuMap.get(Long.parseLong(searchBarEsRspInfoBO.getSkuId()))).getMaterialId());
                try {
                    if (StringUtils.isEmpty((Object)JSON.toString((Object)skuPrice))) continue;
                    if (searchBarEsReqBO.getMemLevel() == 0) {
                        if (null != skuPrice.getMemberLadderPrice2()) {
                            xlsSearchBarEsRspInfo.setMemberLadderPrice(MoneyUtils.Long2BigDecimal(skuPrice.getMemberLadderPrice2()));
                        }
                    } else if (searchBarEsReqBO.getMemLevel() == 1) {
                        if (null != skuPrice.getMemberLadderPrice1()) {
                            xlsSearchBarEsRspInfo.setMemberLadderPrice(MoneyUtils.Long2BigDecimal(skuPrice.getMemberLadderPrice1()));
                        }
                    } else if (searchBarEsReqBO.getMemLevel() == 3) {
                        if (null != skuPrice.getMemberLadderPrice2()) {
                            xlsSearchBarEsRspInfo.setMemberLadderPrice(MoneyUtils.Long2BigDecimal(skuPrice.getMemberLadderPrice2()));
                        }
                    } else if (searchBarEsReqBO.getMemLevel() == 4 && null != skuPrice.getMemberLadderPrice3()) {
                        xlsSearchBarEsRspInfo.setMemberLadderPrice(MoneyUtils.Long2BigDecimal(skuPrice.getMemberLadderPrice3()));
                    }
                    if (xlsSearchBarEsRspInfo.getMemberLadderPrice() != null) {
                        if (skuPrice.getPurchasePrice() != null) {
                            xlsSearchBarEsRspInfo.setMemberLadderPrice(xlsSearchBarEsRspInfo.getMemberLadderPrice().setScale(0, 4));
                        } else {
                            xlsSearchBarEsRspInfo.setMemberLadderPrice(xlsSearchBarEsRspInfo.getMemberLadderPrice().setScale(2, 4));
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error("\u4f1a\u5458\u68af\u5ea6\u4ef7\u683c\u8f6c\u6362\u62a5\u9519" + e.getMessage());
                }
                result.add(xlsSearchBarEsRspInfo);
            }
        }
        queryXlsEsRspBO.setResult(result);
        queryXlsEsRspBO.setRespCode("0000");
        queryXlsEsRspBO.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        return queryXlsEsRspBO;
    }

    public QueryXlsEsRspBO queryXlsEsOnlySku(SearchBarEsReqBO searchBarEsReqBO) {
        List<CommodityPO> xlsCommodityPOs;
        logger.info("\u67e5\u8be2es\u670d\u52a1\u5165\u53c2=" + searchBarEsReqBO.toString());
        QueryXlsEsRspBO queryXlsEsRspBO = new QueryXlsEsRspBO();
        ArrayList<Long> commodityIds = new ArrayList();
        ArrayList<Long> skuIds = new ArrayList();
        SearchBarEsRspBO searchBarEsRspBO = null;
        try {
            searchBarEsRspBO = this.searchBarEsService.qryBySearchBar(searchBarEsReqBO);
            queryXlsEsRspBO.setQueryParams(searchBarEsRspBO.getQueryParams());
            BeanUtils.copyProperties((Object)searchBarEsRspBO, (Object)queryXlsEsRspBO);
            commodityIds = searchBarEsRspBO.getCommodityIds();
            skuIds = searchBarEsRspBO.getSkuIds();
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2es\u670d\u52a1\u62a5\u9519");
            e.printStackTrace();
            queryXlsEsRspBO.setRespCode("8888");
            queryXlsEsRspBO.setRespDesc("\u67e5\u8be2es\u670d\u52a1\u62a5\u9519");
        }
        HashMap<Long, CommodityBO> mapXlsCommodityBO = new HashMap<Long, CommodityBO>();
        if (CollectionUtils.isNotEmpty(commodityIds) && CollectionUtils.isNotEmpty(xlsCommodityPOs = this.commodityDAO.selectByCommodityIds(commodityIds))) {
            for (CommodityPO xlsCommodityPO : xlsCommodityPOs) {
                CommodityBO xlsCommodityBO = new CommodityBO();
                BeanUtils.copyProperties((Object)xlsCommodityPO, (Object)xlsCommodityBO);
                mapXlsCommodityBO.put(xlsCommodityPO.getCommodityId(), xlsCommodityBO);
            }
        }
        HashMap<Long, SkuPricePO> mapSkuPrice = new HashMap<Long, SkuPricePO>();
        HashMap<Long, SkuPO> skuMap = new HashMap<Long, SkuPO>();
        HashMap dimidionMap = new HashMap();
        if (CollectionUtils.isNotEmpty(skuIds)) {
            List<SkuPricePO> skuPrices = this.skuPriceDAO.selectBySkuIds(skuIds);
            for (SkuPricePO skuPricePO : skuPrices) {
                mapSkuPrice.put(skuPricePO.getSkuId(), skuPricePO);
            }
            List<SkuPO> sku = this.skuDAO.selectBySkuIds(skuIds);
            for (SkuPO skuPO : sku) {
                skuMap.put(skuPO.getSkuId(), skuPO);
            }
            List<SkuSpecPO> list = this.skuSpecDAO.selectDimision(skuIds);
            if (!CollectionUtils.isEmpty(list)) {
                for (SkuSpecPO sp : list) {
                    if (dimidionMap.containsKey(sp.getSkuId())) {
                        DSkuSpecBO bo = new DSkuSpecBO();
                        BeanUtils.copyProperties((Object)sp, (Object)bo);
                        ((List)dimidionMap.get(sp.getSkuId())).add(bo);
                        continue;
                    }
                    ArrayList<DSkuSpecBO> list2 = new ArrayList<DSkuSpecBO>();
                    DSkuSpecBO bo = new DSkuSpecBO();
                    BeanUtils.copyProperties((Object)sp, (Object)bo);
                    list2.add(bo);
                    dimidionMap.put(sp.getSkuId(), list2);
                }
            }
        }
        ArrayList<XlsSearchBarEsRspInfoBO> result = new ArrayList<XlsSearchBarEsRspInfoBO>();
        List searchBarEsRspInfos = searchBarEsRspBO.getResult();
        if (CollectionUtils.isNotEmpty((Collection)searchBarEsRspInfos) && !mapSkuPrice.isEmpty()) {
            for (SearchBarEsRspInfoBO searchBarEsRspInfoBO : searchBarEsRspInfos) {
                XlsSearchBarEsRspInfoBO xlsSearchBarEsRspInfo = new XlsSearchBarEsRspInfoBO();
                BeanUtils.copyProperties((Object)searchBarEsRspInfoBO, (Object)xlsSearchBarEsRspInfo);
                xlsSearchBarEsRspInfo.setXlsCommodityBO((CommodityBO)mapXlsCommodityBO.get(searchBarEsRspInfoBO.getCommodityId()));
                xlsSearchBarEsRspInfo.setSpec((List)dimidionMap.get(Long.parseLong(searchBarEsRspInfoBO.getSkuId())));
                SkuPricePO skuPrice = (SkuPricePO)mapSkuPrice.get(Long.parseLong(searchBarEsRspInfoBO.getSkuId()));
                xlsSearchBarEsRspInfo.setMaterialId(((SkuPO)skuMap.get(Long.parseLong(searchBarEsRspInfoBO.getSkuId()))).getMaterialId());
                logger.debug("\u7269\u6599\u7f16\u7801\uff1a" + ((SkuPO)skuMap.get(Long.parseLong(searchBarEsRspInfoBO.getSkuId()))).getMaterialId());
                if (skuPrice != null) {
                    try {
                        if (searchBarEsReqBO.getMemLevel() == 0) {
                            if (null != skuPrice.getMemberLadderPrice2()) {
                                xlsSearchBarEsRspInfo.setMemberLadderPrice(MoneyUtils.Long2BigDecimal(skuPrice.getMemberLadderPrice2()));
                            }
                        } else if (searchBarEsReqBO.getMemLevel() == 1) {
                            if (null != skuPrice.getMemberLadderPrice1()) {
                                xlsSearchBarEsRspInfo.setMemberLadderPrice(MoneyUtils.Long2BigDecimal(skuPrice.getMemberLadderPrice1()));
                            }
                        } else if (searchBarEsReqBO.getMemLevel() == 3) {
                            if (null != skuPrice.getMemberLadderPrice2()) {
                                xlsSearchBarEsRspInfo.setMemberLadderPrice(MoneyUtils.Long2BigDecimal(skuPrice.getMemberLadderPrice2()));
                            }
                        } else if (searchBarEsReqBO.getMemLevel() == 4 && null != skuPrice.getMemberLadderPrice3()) {
                            xlsSearchBarEsRspInfo.setMemberLadderPrice(MoneyUtils.Long2BigDecimal(skuPrice.getMemberLadderPrice3()));
                        }
                        if (xlsSearchBarEsRspInfo.getMemberLadderPrice() != null) {
                            if (skuPrice.getPurchasePrice() != null) {
                                xlsSearchBarEsRspInfo.setMemberLadderPrice(xlsSearchBarEsRspInfo.getMemberLadderPrice().setScale(0, 4));
                            } else {
                                xlsSearchBarEsRspInfo.setMemberLadderPrice(xlsSearchBarEsRspInfo.getMemberLadderPrice().setScale(2, 4));
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error("\u4f1a\u5458\u68af\u5ea6\u4ef7\u683c\u8f6c\u6362\u62a5\u9519" + e.getMessage());
                    }
                }
                result.add(xlsSearchBarEsRspInfo);
            }
        }
        queryXlsEsRspBO.setResult(result);
        queryXlsEsRspBO.setRespCode("0000");
        queryXlsEsRspBO.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        return queryXlsEsRspBO;
    }
}

