/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.newretail.bo.AttachSkuBusiBO;
import com.tydic.newretail.bo.BatchQuerySkuPriceReqBO;
import com.tydic.newretail.bo.BatchQuerySkuPriceRspBO;
import com.tydic.newretail.bo.QuerySkuDetailReqBO;
import com.tydic.newretail.bo.QuerySkuPicReqBO;
import com.tydic.newretail.bo.QuerySkuPicRspBO;
import com.tydic.newretail.bo.QuerySkuSpecReqBO;
import com.tydic.newretail.bo.QuerySkuSpecRspBO;
import com.tydic.newretail.bo.QueryXlsSkuAndAttachDetailRspBO;
import com.tydic.newretail.bo.SkuBusiBO;
import com.tydic.newretail.bo.SkuPriceRspBO;
import com.tydic.newretail.bo.SkuSpecBO;
import com.tydic.newretail.busi.service.BatchQuerySkuPriceBusiService;
import com.tydic.newretail.busi.service.QuerySkuPicBusiService;
import com.tydic.newretail.busi.service.QuerySkuSpecBusiService;
import com.tydic.newretail.busi.service.QueryXlsSkuAndAttachDetailService;
import com.tydic.newretail.constant.Constant;
import com.tydic.newretail.dao.SkuDAO;
import com.tydic.newretail.dao.po.SkuPO;
import com.tydic.newretail.exception.BusinessException;
import com.tydic.newretail.util.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QueryXlsSkuAndAttachDetailServiceImpl
implements QueryXlsSkuAndAttachDetailService {
    @Autowired
    private SkuDAO skuDAO;
    @Autowired
    private BatchQuerySkuPriceBusiService batchQuerySkuPriceBusiService;
    @Autowired
    private QuerySkuSpecBusiService querySkuSpecBusiService;
    @Autowired
    private QuerySkuPicBusiService querySkuPicBusiService;
    private static final Logger logger = LoggerFactory.getLogger(QueryXlsSkuAndAttachDetailServiceImpl.class);

    public QueryXlsSkuAndAttachDetailRspBO queryXlsSkuAndAttachDetail(QuerySkuDetailReqBO querySkuDetailReqBO) {
        logger.debug("\u65b0\u96f6\u552e\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u4e3a\u4e86\u8d2d\u7269\u8f66\u670d\u52a1\u5165\u53c2=" + querySkuDetailReqBO.toString());
        if (querySkuDetailReqBO.getSkuId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5355\u54c1\u4fe1\u606f\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5355\u54c1skuId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryXlsSkuAndAttachDetailRspBO result = new QueryXlsSkuAndAttachDetailRspBO();
        try {
            SkuPO sku = new SkuPO();
            if (querySkuDetailReqBO.getSkuId() != null) {
                sku = this.skuDAO.selectBySupplierIdAndSkuId(querySkuDetailReqBO.getSkuId());
            }
            if (null == sku || null == sku.getSkuId()) {
                result.setRespCode("0000");
                result.setRespDesc("\u6210\u529f");
                return result;
            }
            BeanUtils.copyProperties((Object)sku, (Object)result);
            if ("1".equals(sku.getAttachFlag())) {
                if (null != sku.getSkuPrice()) {
                    result.setSkuPrice(MoneyUtils.Long2BigDecimal(sku.getSkuPrice()));
                }
                result.setRespCode("0000");
                result.setRespDesc("\u6210\u529f");
                return result;
            }
            BatchQuerySkuPriceReqBO batchQuerySkuPriceReqBO = new BatchQuerySkuPriceReqBO();
            batchQuerySkuPriceReqBO.setSkuIds(Arrays.asList(sku.getSkuId()));
            batchQuerySkuPriceReqBO.setSupplierId(sku.getSupplierId());
            BatchQuerySkuPriceRspBO batchQuerySkuPriceRspBO = this.batchQuerySkuPriceBusiService.batchQuerySkuPrice(batchQuerySkuPriceReqBO);
            if (null != batchQuerySkuPriceRspBO && null != batchQuerySkuPriceRspBO.getPrices() && batchQuerySkuPriceRspBO.getPrices().size() > 0) {
                result.setPrice((SkuPriceRspBO)batchQuerySkuPriceRspBO.getPrices().get(0));
            }
            QuerySkuSpecReqBO querySkuSpecReqBO = new QuerySkuSpecReqBO();
            querySkuSpecReqBO.setSkuId(sku.getSkuId());
            querySkuSpecReqBO.setSupplierId(sku.getSupplierId());
            QuerySkuSpecRspBO querySkuSpecRspBO = this.querySkuSpecBusiService.querySkuSpec(querySkuSpecReqBO);
            List specs = querySkuSpecRspBO.getSpecs();
            if (CollectionUtils.isNotEmpty((Collection)specs)) {
                ArrayList<SkuSpecBO> dimensions = new ArrayList<SkuSpecBO>();
                for (SkuSpecBO skuSpecBO : specs) {
                    if (skuSpecBO.getPropValueListId() == null) continue;
                    dimensions.add(skuSpecBO);
                }
                result.setDimensions(dimensions);
                logger.info("dimensions=" + ((Object)dimensions).toString());
            }
            QuerySkuPicReqBO querySkuPicReqBO = new QuerySkuPicReqBO();
            querySkuPicReqBO.setSkuId(sku.getSkuId());
            querySkuPicReqBO.setSupplierId(sku.getSupplierId());
            QuerySkuPicRspBO querySkuPicRspBO = this.querySkuPicBusiService.querySkuPic(querySkuPicReqBO);
            if (null != querySkuPicRspBO && null != querySkuPicRspBO.getPictures()) {
                result.setPictures(querySkuPicRspBO.getPictures());
            }
            QuerySkuDetailReqBO queryAttach = new QuerySkuDetailReqBO();
            if (null != querySkuDetailReqBO.getSkuPrice()) {
                if (null != sku.getBrandName() && "\u82f9\u679c".equals(sku.getBrandName())) {
                    queryAttach.setSkuPriceLong(Constant.ATTACH_SKU_PRICE_158);
                } else if (QueryXlsSkuAndAttachDetailServiceImpl.compareDecimal(querySkuDetailReqBO.getSkuPrice(), "0.000") > 0 && QueryXlsSkuAndAttachDetailServiceImpl.compareDecimal(querySkuDetailReqBO.getSkuPrice(), "1000.000") <= 0) {
                    queryAttach.setSkuPriceLong(Constant.ATTACH_SKU_PRICE_30);
                } else if (QueryXlsSkuAndAttachDetailServiceImpl.compareDecimal(querySkuDetailReqBO.getSkuPrice(), "1000.000") > 0 && QueryXlsSkuAndAttachDetailServiceImpl.compareDecimal(querySkuDetailReqBO.getSkuPrice(), "2000.000") <= 0) {
                    queryAttach.setSkuPriceLong(Constant.ATTACH_SKU_PRICE_34);
                } else if (QueryXlsSkuAndAttachDetailServiceImpl.compareDecimal(querySkuDetailReqBO.getSkuPrice(), "2000.000") > 0 && QueryXlsSkuAndAttachDetailServiceImpl.compareDecimal(querySkuDetailReqBO.getSkuPrice(), "3000.000") <= 0) {
                    queryAttach.setSkuPriceLong(Constant.ATTACH_SKU_PRICE_49);
                } else if (QueryXlsSkuAndAttachDetailServiceImpl.compareDecimal(querySkuDetailReqBO.getSkuPrice(), "3000.000") > 0 && QueryXlsSkuAndAttachDetailServiceImpl.compareDecimal(querySkuDetailReqBO.getSkuPrice(), "4000.000") <= 0) {
                    queryAttach.setSkuPriceLong(Constant.ATTACH_SKU_PRICE_64);
                } else if (QueryXlsSkuAndAttachDetailServiceImpl.compareDecimal(querySkuDetailReqBO.getSkuPrice(), "4000.000") > 0 && QueryXlsSkuAndAttachDetailServiceImpl.compareDecimal(querySkuDetailReqBO.getSkuPrice(), "100000.000") <= 0) {
                    queryAttach.setSkuPriceLong(Constant.ATTACH_SKU_PRICE_79);
                }
            }
            queryAttach.setSkuId(sku.getSkuId());
            queryAttach.setSupplierId(sku.getSupplierId());
            List<AttachSkuBusiBO> attach = this.queryAttachSku(queryAttach);
            result.setAttachedSkus(attach);
        }
        catch (Exception e) {
            logger.error("\u5355\u54c1\u4fe1\u606f\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5355\u54c1\u4fe1\u606f\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u51fa\u9519");
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        logger.debug("\u5355\u54c1\u4fe1\u606f\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)result));
        return result;
    }

    private static int compareDecimal(String str1, String str2) {
        BigDecimal bigDecimal1 = new BigDecimal(str1);
        BigDecimal bigDecimal2 = new BigDecimal(str2);
        int i = bigDecimal1.compareTo(bigDecimal2);
        return i;
    }

    private List<AttachSkuBusiBO> queryAttachSku(QuerySkuDetailReqBO querySkuDetailReqBO) {
        logger.info("\u67e5\u8be2\u9644\u5c5e\u5355\u54c1\u4fe1\u606f\u5165\u53c2\uff1a" + querySkuDetailReqBO.toString());
        if (querySkuDetailReqBO.getSkuId() == null || querySkuDetailReqBO.getSupplierId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9644\u5c5e\u5355\u54c1\u4fe1\u606f\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u4e3b\u5355\u54c1Id[skuId]\u548c\u95e8\u5e97Id[supplierId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<AttachSkuBusiBO> rspList = new ArrayList<AttachSkuBusiBO>();
        try {
            List<Object> skuBOList = new ArrayList();
            SkuPO reqSku = new SkuPO();
            reqSku.setSupplierId(querySkuDetailReqBO.getSupplierId());
            if (null != querySkuDetailReqBO.getSkuPriceLong()) {
                reqSku.setAttachFlag("1");
                reqSku.setAttachType("01");
                reqSku.setSkuPrice(querySkuDetailReqBO.getSkuPriceLong());
                skuBOList = this.skuDAO.qryAttachSkuByRecord(reqSku);
            } else {
                reqSku.setSkuId(querySkuDetailReqBO.getSkuId());
                skuBOList = this.skuDAO.qrySkuByMainSkuId(reqSku);
            }
            HashMap map = new HashMap();
            if (null != skuBOList) {
                for (SkuBusiBO skuBusiBO : skuBOList) {
                    if (null != skuBusiBO.getSkuPrice()) {
                        skuBusiBO.setSkuPriceDecimal(MoneyUtils.Long2BigDecimal(skuBusiBO.getSkuPrice()));
                    }
                    if (map.containsKey(skuBusiBO.getAttachType())) {
                        ((List)map.get(skuBusiBO.getAttachType())).add(skuBusiBO);
                        continue;
                    }
                    ArrayList<SkuBusiBO> boList = new ArrayList<SkuBusiBO>();
                    boList.add(skuBusiBO);
                    map.put(skuBusiBO.getAttachType(), boList);
                }
            }
            if (null != map) {
                for (Map.Entry entry : map.entrySet()) {
                    AttachSkuBusiBO attachBusi = new AttachSkuBusiBO();
                    attachBusi.setAttachedType((String)entry.getKey());
                    attachBusi.setAttachedSkuList((List)entry.getValue());
                    if ("01".equals(entry.getKey())) {
                        attachBusi.setAttachedTypeName("\u788e\u5c4f\u4fdd");
                    } else if ("02".equals(entry.getKey())) {
                        attachBusi.setAttachedTypeName("\u5ef6\u4fdd");
                    }
                    rspList.add(attachBusi);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u9644\u5c5e\u5355\u54c1\u4fe1\u606f\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u51fa\u9519", (Throwable)e);
            throw new BusinessException("\u9644\u5c5e\u5355\u54c1\u4fe1\u606f\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u51fa\u9519", e.getMessage());
        }
        return rspList;
    }
}

