/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.newretail.bo.CommodityBO;
import com.tydic.newretail.bo.DSkuBO;
import com.tydic.newretail.bo.OtherBO;
import com.tydic.newretail.bo.QueryXlsSkuByMaterialAndProvReqBO;
import com.tydic.newretail.bo.QueryXlsSkuByMaterialAndProvReqPageBO;
import com.tydic.newretail.bo.QueryXlsSkuByProvBO;
import com.tydic.newretail.bo.RspInfoListBO;
import com.tydic.newretail.bo.RspPageBO;
import com.tydic.newretail.bo.XlsSearchBarEsRspInfoBO;
import com.tydic.newretail.busi.service.QueryXlsSkuByMaterialAndProvListService;
import com.tydic.newretail.dao.CommodityDAO;
import com.tydic.newretail.dao.SkuDAO;
import com.tydic.newretail.dao.SkuPriceDAO;
import com.tydic.newretail.dao.po.CommodityPO;
import com.tydic.newretail.dao.po.SkuPO;
import com.tydic.newretail.dao.po.SkuPricePO;
import com.tydic.newretail.util.MoneyUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class QueryXlsSkuByMaterialAndProvListServiceImpl
implements QueryXlsSkuByMaterialAndProvListService {
    private static final Logger logger = LoggerFactory.getLogger(QueryXlsSkuByMaterialAndProvListServiceImpl.class);
    @Autowired
    private SkuDAO xlsSkuMapper;
    @Autowired
    private CommodityDAO xlsCommodityDAO;
    @Autowired
    private SkuPriceDAO skuPriceMapper;

    public RspInfoListBO<DSkuBO> queryXlsSkuByMaterialAndProvList(QueryXlsSkuByMaterialAndProvReqBO reqBO) {
        logger.debug("\u67e5\u8be2\u5546\u54c1\u4fe1\u606f");
        RspInfoListBO result = new RspInfoListBO();
        ArrayList<DSkuBO> rows = new ArrayList<DSkuBO>();
        ArrayList<SkuPO> recore = new ArrayList<SkuPO>();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getList())) {
            SkuPO po = null;
            for (QueryXlsSkuByProvBO req : reqBO.getList()) {
                po = new SkuPO();
                po.setProvinceCode(req.getProvinceCode());
                po.setCityCode(req.getCityCode());
                po.setSupplierId(req.getSupplierId());
                po.setCountyCode(req.getCountyCode());
                po.setMaterialId(req.getMaterialId());
                recore.add(po);
            }
        } else {
            result.setRespCode("9999");
            result.setRespDesc("\u5165\u53c2\u4e3a\u7a7a");
            result.setRows(rows);
            return result;
        }
        try {
            List<SkuPO> poList = this.xlsSkuMapper.queryXlsSkuByMaterialAndProvList(recore);
            if (!CollectionUtils.isEmpty(poList)) {
                DSkuBO bo = null;
                for (SkuPO po : poList) {
                    bo = new DSkuBO();
                    BeanUtils.copyProperties((Object)po, (Object)bo);
                    rows.add(bo);
                }
            }
        }
        catch (Exception e) {
            result.setRespCode("9999");
            result.setRespDesc("\u7cfb\u7edf\u5f02\u5e38");
            result.setRows(rows);
            return result;
        }
        result.setRespCode("0000");
        result.setRows(rows);
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        return result;
    }

    public RspPageBO<DSkuBO> queryXlsSkuByMaterialAndProvListByPage(QueryXlsSkuByMaterialAndProvReqPageBO reqBO) {
        logger.debug("\u5206\u9875\u67e5\u8be2\u5546\u54c1\u4fe1\u606f");
        RspPageBO result = new RspPageBO();
        Page page = new Page();
        page.setLimit(reqBO.getPageSize());
        page.setOffset(reqBO.getOffset());
        ArrayList<DSkuBO> rows = new ArrayList<DSkuBO>();
        ArrayList<SkuPO> recore = new ArrayList<SkuPO>();
        String provinceCode = null;
        if (!CollectionUtils.isEmpty((Collection)reqBO.getList())) {
            provinceCode = ((QueryXlsSkuByProvBO)reqBO.getList().get(0)).getProvinceCode();
            SkuPO po = null;
            for (QueryXlsSkuByProvBO req : reqBO.getList()) {
                po = new SkuPO();
                po.setCityCode(req.getCityCode());
                po.setSupplierId(req.getSupplierId());
                po.setCountyCode(req.getCountyCode());
                po.setMaterialId(req.getMaterialId());
                recore.add(po);
            }
        } else {
            result.setRespCode("9999");
            result.setRespDesc("\u5165\u53c2\u4e3a\u7a7a");
            result.setRows(rows);
            return result;
        }
        try {
            logger.debug("queryXlsSkuByMaterialAndProvListByPage\u65b9\u6cd5\u5165\u53c2\u7269\u6599\u7f16\u7801\u4e3a\uff1a{}\u7701\u4efd\u7f16\u7801\u4e3a{}", (Object)JSON.toJSONString(recore), (Object)JSON.toJSONString((Object)provinceCode));
            List<SkuPO> poList = this.xlsSkuMapper.queryXlsSkuByMaterialAndProv(recore, provinceCode, (Page<SkuPO>)page);
            logger.debug("queryXlsSkuByMaterialAndProvListByPage\u65b9\u6cd5\u51fa\u53c2\u7684\u6570\u636e\u6709\uff1a{} \u6761", (Object)poList.size());
            if (!CollectionUtils.isEmpty(poList)) {
                DSkuBO bo = null;
                for (SkuPO po : poList) {
                    bo = new DSkuBO();
                    BeanUtils.copyProperties((Object)po, (Object)bo);
                    rows.add(bo);
                }
            }
        }
        catch (Exception e) {
            logger.debug("queryXlsSkuByMaterialAndProvListByPage\u65b9\u6cd5\u67e5\u8be2\u5f02\u5e38:{}", (Object)e.getMessage());
            result.setRespCode("9999");
            result.setRespDesc("\u7cfb\u7edf\u5f02\u5e38");
            result.setRows(rows);
            return result;
        }
        result.setRecordsTotal(page.getTotalCount());
        result.setTotal(page.getTotalPages());
        result.setRows(rows);
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        return result;
    }

    public RspInfoListBO<XlsSearchBarEsRspInfoBO> queryOther(OtherBO reqBO) {
        RspInfoListBO result = new RspInfoListBO();
        ArrayList<XlsSearchBarEsRspInfoBO> rows = new ArrayList<XlsSearchBarEsRspInfoBO>();
        HashMap<Long, CommodityBO> mapXlsCommodityBO = new HashMap<Long, CommodityBO>();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getCommodityIds())) {
            logger.debug("\u67e5\u8be2spu");
            List<CommodityPO> xlsCommodityPOs = this.xlsCommodityDAO.selectByCommodityIds(reqBO.getCommodityIds());
            if (!CollectionUtils.isEmpty(xlsCommodityPOs)) {
                for (CommodityPO xlsCommodityPO : xlsCommodityPOs) {
                    CommodityBO xlsCommodityBO = new CommodityBO();
                    BeanUtils.copyProperties((Object)xlsCommodityPO, (Object)xlsCommodityBO);
                    mapXlsCommodityBO.put(xlsCommodityPO.getCommodityId(), xlsCommodityBO);
                }
            }
        }
        logger.debug("sup" + JSONObject.toJSONString(mapXlsCommodityBO));
        HashMap<Long, SkuPricePO> mapSkuPrice = new HashMap<Long, SkuPricePO>();
        List<Object> skus = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSkuIds())) {
            logger.debug("\u67e5\u8be2\u4ef7\u683c");
            List<SkuPricePO> skuPrices = this.skuPriceMapper.selectBySkuIds(reqBO.getSkuIds());
            for (SkuPricePO skuPrice : skuPrices) {
                mapSkuPrice.put(skuPrice.getSkuId(), skuPrice);
            }
            logger.debug("\u67e5\u8be2sku");
            skus = this.xlsSkuMapper.selectBySkuIds(reqBO.getSkuIds());
        }
        if (!CollectionUtils.isEmpty(skus)) {
            for (SkuPO sku : skus) {
                XlsSearchBarEsRspInfoBO xlsSearchBarEsRspInfoBo = new XlsSearchBarEsRspInfoBO();
                BeanUtils.copyProperties((Object)sku, (Object)xlsSearchBarEsRspInfoBo);
                xlsSearchBarEsRspInfoBo.setSkuId(sku.getSkuId().toString());
                xlsSearchBarEsRspInfoBo.setXlsCommodityBO((CommodityBO)mapXlsCommodityBO.get(sku.getCommodityId()));
                logger.debug("supId" + sku.getCommodityId());
                SkuPricePO skuPrice = (SkuPricePO)mapSkuPrice.get(sku.getSkuId());
                xlsSearchBarEsRspInfoBo.setMaterialId(sku.getMaterialId());
                try {
                    if (reqBO.getMemLevel() == 0) {
                        if (null != skuPrice.getMemberLadderPrice2()) {
                            xlsSearchBarEsRspInfoBo.setMemberLadderPrice(MoneyUtils.Long2BigDecimal(skuPrice.getMemberLadderPrice2()));
                        }
                    } else if (reqBO.getMemLevel() == 1) {
                        if (null != skuPrice.getMemberLadderPrice1()) {
                            xlsSearchBarEsRspInfoBo.setMemberLadderPrice(MoneyUtils.Long2BigDecimal(skuPrice.getMemberLadderPrice1()));
                        }
                    } else if (reqBO.getMemLevel() == 3) {
                        if (null != skuPrice.getMemberLadderPrice2()) {
                            xlsSearchBarEsRspInfoBo.setMemberLadderPrice(MoneyUtils.Long2BigDecimal(skuPrice.getMemberLadderPrice2()));
                        }
                    } else if (reqBO.getMemLevel() == 4 && null != skuPrice.getMemberLadderPrice3()) {
                        xlsSearchBarEsRspInfoBo.setMemberLadderPrice(MoneyUtils.Long2BigDecimal(skuPrice.getMemberLadderPrice3()));
                    }
                    if (xlsSearchBarEsRspInfoBo.getMemberLadderPrice() != null) {
                        if (skuPrice.getPurchasePrice() != null) {
                            xlsSearchBarEsRspInfoBo.setMemberLadderPrice(xlsSearchBarEsRspInfoBo.getMemberLadderPrice().setScale(0, 4));
                        } else {
                            xlsSearchBarEsRspInfoBo.setMemberLadderPrice(xlsSearchBarEsRspInfoBo.getMemberLadderPrice().setScale(2, 4));
                        }
                    }
                    xlsSearchBarEsRspInfoBo.setSalePrice(MoneyUtils.Long2BigDecimal(sku.getSkuPrice()));
                    xlsSearchBarEsRspInfoBo.setMarketPrice(MoneyUtils.Long2BigDecimal(skuPrice.getMarketPrice()));
                    xlsSearchBarEsRspInfoBo.setPriPicUrl(sku.getSkuMainPicUrl());
                    xlsSearchBarEsRspInfoBo.setSkuLocation(sku.getSkuLocation().toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error("\u4f1a\u5458\u68af\u5ea6\u4ef7\u683c\u8f6c\u6362\u62a5\u9519" + e.getMessage());
                }
                rows.add(xlsSearchBarEsRspInfoBo);
            }
        }
        result.setRows(rows);
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        return result;
    }
}

