/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.newretail.bo.PriceBO;
import com.tydic.newretail.bo.QuerySkuPriceBySkuIdsRspBO;
import com.tydic.newretail.bo.QueryXlsSkuByNameAndProCodeReqBO;
import com.tydic.newretail.bo.QueryXlsSkuByNameAndProCodeRspBO;
import com.tydic.newretail.bo.SkuPriceBO;
import com.tydic.newretail.busi.service.QuerySkuPriceBySkuIdsService;
import com.tydic.newretail.busi.service.QueryXlsSkuByNameAndProCodeService;
import com.tydic.newretail.dao.SkuDAO;
import com.tydic.newretail.dao.SkuSpecDAO;
import com.tydic.newretail.dao.po.SkuPO;
import com.tydic.newretail.dao.po.SkuSpecPO;
import com.tydic.newretail.toolkit.bo.RspPageBaseBO;
import com.tydic.newretail.util.MoneyUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QueryXlsSkuByNameAndProCodeServiceImpl
implements QueryXlsSkuByNameAndProCodeService {
    @Autowired
    private SkuDAO skuDAO;
    @Autowired
    private SkuSpecDAO skuSpecDAO;
    @Autowired
    private QuerySkuPriceBySkuIdsService querySkuPriceBySkuIdsService;
    private static final Logger logger = LoggerFactory.getLogger(QueryXlsSkuByNameAndProCodeServiceImpl.class);

    public RspPageBaseBO<QueryXlsSkuByNameAndProCodeRspBO> queryXlsSkuByNameAndProCode(QueryXlsSkuByNameAndProCodeReqBO queryXlsSkuByNameAndProCodeReqBO) {
        logger.info("\u6839\u636e\u5546\u54c1\u540d\u79f0\u7269\u6599\u6216\u8005\u7701\u4efd\u7f16\u7801\u67e5\u8be2\u5546\u54c1\u5165\u53c2=" + JSON.toJSONString((Object)queryXlsSkuByNameAndProCodeReqBO));
        RspPageBaseBO result = new RspPageBaseBO();
        ArrayList<QueryXlsSkuByNameAndProCodeRspBO> queryXlsSkuByNameAndProCodeRspBOList = new ArrayList<QueryXlsSkuByNameAndProCodeRspBO>();
        Page page = new Page();
        page.setLimit(queryXlsSkuByNameAndProCodeReqBO.getPageSize());
        page.setOffset(queryXlsSkuByNameAndProCodeReqBO.getOffset());
        SkuPO sku = new SkuPO();
        sku.setSkuName(queryXlsSkuByNameAndProCodeReqBO.getSkuName());
        sku.setMaterialId(queryXlsSkuByNameAndProCodeReqBO.getMaterialId());
        String skuType = "";
        if ("1".equals(queryXlsSkuByNameAndProCodeReqBO.getmUserLevel())) {
            logger.debug("\u603b\u90e8\u67e5\u8be2");
            skuType = "00";
        } else if (StringUtils.isNotBlank((CharSequence)queryXlsSkuByNameAndProCodeReqBO.getmProvince()) && StringUtils.isBlank((CharSequence)queryXlsSkuByNameAndProCodeReqBO.getmShopId())) {
            logger.debug("\u7701\u4efd\u5730\u5e02\u67e5\u8be2");
            sku.setProvinceCode(queryXlsSkuByNameAndProCodeReqBO.getmProvince());
            skuType = "01";
        } else if (StringUtils.isNotBlank((CharSequence)queryXlsSkuByNameAndProCodeReqBO.getmProvince()) && StringUtils.isNotBlank((CharSequence)queryXlsSkuByNameAndProCodeReqBO.getmCity()) && StringUtils.isNotBlank((CharSequence)queryXlsSkuByNameAndProCodeReqBO.getmShopId())) {
            logger.debug("\u95e8\u5e97\u67e5\u8be2");
            sku.setProvinceCode(queryXlsSkuByNameAndProCodeReqBO.getmProvince());
            sku.setSupplierId(Long.parseLong(queryXlsSkuByNameAndProCodeReqBO.getmShopId()));
            skuType = "02";
        } else {
            logger.error("\u7528\u6237\u6743\u9650\u4e0d\u8db3");
            result.setRespCode("0009");
            result.setRespDesc("\u67e5\u8be2\u7528\u6237\u6743\u9650\u4e0d\u8db3");
            return result;
        }
        ArrayList<Long> skuIds = new ArrayList<Long>();
        List<SkuPO> skus = this.skuDAO.getProOrMalSkuByName(sku, (Page<SkuPO>)page);
        if (CollectionUtils.isNotEmpty(skus)) {
            for (SkuPO sku1 : skus) {
                skuIds.add(sku1.getSkuId());
            }
        }
        Map mapPriceBO = new HashMap();
        HashMap<Long, ArrayList<SkuSpecPO>> mapListSkuSpec = new HashMap<Long, ArrayList<SkuSpecPO>>();
        if (CollectionUtils.isNotEmpty(skuIds)) {
            try {
                QuerySkuPriceBySkuIdsRspBO querySkuPriceBySkuIdsRspBO = this.querySkuPriceBySkuIdsService.querySkuPriceBySkuIds(skuIds);
                mapPriceBO = querySkuPriceBySkuIdsRspBO.getMapPriceBO();
            }
            catch (Exception e) {
                result.setRespCode("8888");
                result.setRespDesc("\u67e5\u8be2\u4ef7\u683c\u62a5\u9519");
                return result;
            }
            try {
                List<SkuSpecPO> skuSpecList = this.skuSpecDAO.selectSpecBySkuIds(skuIds);
                if (CollectionUtils.isNotEmpty(skuSpecList)) {
                    for (SkuSpecPO skuSpec : skuSpecList) {
                        ArrayList<SkuSpecPO> skuSpecs = (ArrayList<SkuSpecPO>)mapListSkuSpec.get(skuSpec.getSkuId());
                        if (CollectionUtils.isNotEmpty((Collection)skuSpecs)) {
                            skuSpecs.add(skuSpec);
                            continue;
                        }
                        skuSpecs = new ArrayList<SkuSpecPO>();
                        skuSpecs.add(skuSpec);
                        mapListSkuSpec.put(skuSpec.getSkuId(), skuSpecs);
                    }
                }
            }
            catch (Exception e) {
                logger.error("\u67e5\u8be2\u89c4\u683c\u62a5\u9519");
                result.setRespCode("8888");
                result.setRespDesc("\u67e5\u8be2\u89c4\u683c\u62a5\u9519");
                return result;
            }
        }
        if (CollectionUtils.isNotEmpty(skus)) {
            for (SkuPO sku2 : skus) {
                QueryXlsSkuByNameAndProCodeRspBO queryXlsSkuByNameAndProCodeRspBO = new QueryXlsSkuByNameAndProCodeRspBO();
                BeanUtils.copyProperties((Object)sku2, (Object)queryXlsSkuByNameAndProCodeRspBO);
                queryXlsSkuByNameAndProCodeRspBO.setSkuType(skuType);
                PriceBO priceBO = (PriceBO)mapPriceBO.get(sku2.getSkuId());
                SkuPriceBO skuPriceBO = new SkuPriceBO();
                if (priceBO != null) {
                    BeanUtils.copyProperties((Object)priceBO, (Object)skuPriceBO);
                    try {
                        if (priceBO.getMarketPrice() != null) {
                            skuPriceBO.setMarketPriceY(MoneyUtils.Long2BigDecimal(priceBO.getMarketPrice()));
                        }
                        if (priceBO.getAgreementPrice() != null) {
                            skuPriceBO.setAgreementPriceY(MoneyUtils.Long2BigDecimal(priceBO.getAgreementPrice()));
                        }
                        if (priceBO.getMemberPrice() != null) {
                            skuPriceBO.setMemberPriceY(MoneyUtils.Long2BigDecimal(priceBO.getMemberPrice()));
                        }
                        if (priceBO.getSalePrice() != null) {
                            skuPriceBO.setSalePriceY(MoneyUtils.Long2BigDecimal(priceBO.getSalePrice()));
                        }
                        if (priceBO.getAssessmentPrice() != null) {
                            skuPriceBO.setAssessmentPriceY(MoneyUtils.Long2BigDecimal(priceBO.getAssessmentPrice()));
                        }
                        if (priceBO.getPurchasePrice() != null) {
                            skuPriceBO.setPurchasePriceY(MoneyUtils.Long2BigDecimal(priceBO.getPurchasePrice()));
                        }
                        if (priceBO.getSparePrice1() != null) {
                            skuPriceBO.setSparePrice1Y(MoneyUtils.Long2BigDecimal(priceBO.getSparePrice1()));
                        }
                        if (priceBO.getMemberLadderPrice1() != null) {
                            skuPriceBO.setMemberLadderPrice1Y(MoneyUtils.Long2BigDecimal(priceBO.getMemberLadderPrice1()));
                        }
                        if (priceBO.getMemberLadderPrice2() != null) {
                            skuPriceBO.setMemberLadderPrice2Y(MoneyUtils.Long2BigDecimal(priceBO.getMemberLadderPrice2()));
                        }
                        if (priceBO.getMemberLadderPrice3() != null) {
                            skuPriceBO.setMemberLadderPrice3Y(MoneyUtils.Long2BigDecimal(priceBO.getMemberLadderPrice3()));
                        }
                        if (priceBO.getMemberLadderPrice4() != null) {
                            skuPriceBO.setMemberLadderPrice4Y(MoneyUtils.Long2BigDecimal(priceBO.getMemberLadderPrice4()));
                        }
                        if (priceBO.getMemberLadderPrice5() != null) {
                            skuPriceBO.setMemberLadderPrice5Y(MoneyUtils.Long2BigDecimal(priceBO.getMemberLadderPrice5()));
                        }
                        if (priceBO.getProvAgreePrice() != null) {
                            skuPriceBO.setProvAgreePriceY(MoneyUtils.Long2BigDecimal(priceBO.getProvAgreePrice()));
                        }
                        if (priceBO.getLastPurchasePrice() != null) {
                            skuPriceBO.setLastPurchasePriceY(MoneyUtils.Long2BigDecimal(priceBO.getLastPurchasePrice()));
                        }
                        if (priceBO.getCostPrice() != null) {
                            skuPriceBO.setCostPriceY(MoneyUtils.Long2BigDecimal(priceBO.getCostPrice()));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                queryXlsSkuByNameAndProCodeRspBO.setSkuPriceBO(skuPriceBO);
                List skuSpecs = (List)mapListSkuSpec.get(sku2.getSkuId());
                if (CollectionUtils.isNotEmpty((Collection)skuSpecs)) {
                    for (SkuSpecPO skuSpec : skuSpecs) {
                        if (skuSpec.getCommodityPropGrpId() == 900991231L) {
                            queryXlsSkuByNameAndProCodeRspBO.setBrand(skuSpec.getPropValue());
                            continue;
                        }
                        if (skuSpec.getCommodityPropGrpId() == 900991232L) {
                            queryXlsSkuByNameAndProCodeRspBO.setModel(skuSpec.getPropValue());
                            continue;
                        }
                        if (skuSpec.getCommodityPropGrpId() == 900991233L) {
                            queryXlsSkuByNameAndProCodeRspBO.setColor(skuSpec.getPropValue());
                            continue;
                        }
                        if (skuSpec.getCommodityPropGrpId() != 900991234L) continue;
                        queryXlsSkuByNameAndProCodeRspBO.setRam(skuSpec.getPropValue());
                    }
                }
                queryXlsSkuByNameAndProCodeRspBOList.add(queryXlsSkuByNameAndProCodeRspBO);
            }
        }
        result.setRows(queryXlsSkuByNameAndProCodeRspBOList);
        result.setTotal(page.getTotalPages());
        result.setRecordsTotal(page.getTotalCount());
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        return result;
    }
}

