/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.alibaba.druid.filter.config.ConfigTools;
import com.mysql.jdbc.jdbc2.optional.MysqlDataSource;
import com.tydic.newretail.atom.DSkuRecommendManageService;
import com.tydic.newretail.atom.SysParamsAtomService;
import com.tydic.newretail.bo.BaseRspBO;
import com.tydic.newretail.bo.DSkuRecommendBO;
import com.tydic.newretail.bo.RecommendSkuResultReqBO;
import com.tydic.newretail.busi.service.RecommendSkuResultService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.model.jdbc.MySQLJDBCDataModel;
import org.apache.mahout.cf.taste.impl.model.jdbc.ReloadFromJDBCDataModel;
import org.apache.mahout.cf.taste.impl.neighborhood.ThresholdUserNeighborhood;
import org.apache.mahout.cf.taste.impl.recommender.GenericItemBasedRecommender;
import org.apache.mahout.cf.taste.impl.recommender.GenericUserBasedRecommender;
import org.apache.mahout.cf.taste.impl.similarity.PearsonCorrelationSimilarity;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.model.JDBCDataModel;
import org.apache.mahout.cf.taste.neighborhood.UserNeighborhood;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.apache.mahout.cf.taste.similarity.ItemSimilarity;
import org.apache.mahout.cf.taste.similarity.UserSimilarity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class RecommendSkuResultServiceImpl
implements RecommendSkuResultService {
    @Value(value="${commodity.jdbc.url}")
    private String commodityJdbcUrl;
    @Value(value="${commodity.jdbc.username}")
    private String commodityJdbcUsername;
    @Value(value="${commodity.jdbc.password}")
    private String commodityJdbcPassword;
    @Value(value="${commodity.jdbc.publicKey}")
    private String commodityJdbcPublicKey;
    @Autowired
    private DSkuRecommendManageService dSkuRecommendManageService;
    @Autowired
    private SysParamsAtomService sysParamsAtomService;
    @Autowired
    private static final Logger logger = LoggerFactory.getLogger(RecommendSkuResultServiceImpl.class);

    public BaseRspBO recommendSkuResult(RecommendSkuResultReqBO recommendSkuResultReqBO) {
        logger.info("\u8ba1\u7b97\u63a8\u8350\u7ed3\u679c\u670d\u52a1\u5165\u53c2=" + recommendSkuResultReqBO);
        BaseRspBO baseRspBO = new BaseRspBO();
        Map mapASPTS = this.sysParamsAtomService.selectByParentCode("MAHOUT_THRESHOLD");
        String mahoutThreshold = (String)mapASPTS.get("0");
        try {
            PearsonCorrelationSimilarity similarity;
            MysqlDataSource dataSource = new MysqlDataSource();
            dataSource.setUseSSL(true);
            dataSource.setUrl(this.commodityJdbcUrl);
            dataSource.setUser(this.commodityJdbcUsername);
            try {
                String commodityJdbcPassworded = ConfigTools.decrypt((String)this.commodityJdbcPublicKey, (String)this.commodityJdbcPassword);
                dataSource.setPassword(commodityJdbcPassworded);
            }
            catch (Exception e1) {
                e1.printStackTrace();
                logger.error("\u6570\u636e\u5e93\u5bc6\u7801\u89e3\u5bc6\u62a5\u9519");
            }
            MySQLJDBCDataModel dataModel = new MySQLJDBCDataModel((DataSource)dataSource, "d_sku_preferences", "member_id", "sku_id", "score", "create_time");
            ReloadFromJDBCDataModel model = new ReloadFromJDBCDataModel((JDBCDataModel)dataModel);
            GenericItemBasedRecommender recommender = null;
            if (StringUtils.isBlank((CharSequence)mahoutThreshold)) {
                logger.debug("\u7528\u6237\u76f8\u4f3c\u5ea6\u7684\u7528\u6237\u9608\u503c\u4e3a\u7a7a--\u7528itemCF");
                similarity = new PearsonCorrelationSimilarity((DataModel)model);
                recommender = new GenericItemBasedRecommender((DataModel)model, (ItemSimilarity)similarity);
            } else {
                logger.debug("\u7528\u6237\u76f8\u4f3c\u5ea6\u7684\u7528\u6237\u9608\u503c\u4e0d\u4e3a\u7a7a--\u7528userCF");
                similarity = new PearsonCorrelationSimilarity((DataModel)model);
                ThresholdUserNeighborhood neighborhood = new ThresholdUserNeighborhood(Double.parseDouble(mahoutThreshold), (UserSimilarity)similarity, (DataModel)model);
                recommender = new GenericUserBasedRecommender((DataModel)model, (UserNeighborhood)neighborhood, (UserSimilarity)similarity);
            }
            ArrayList<DSkuRecommendBO> dSkuRecommendBOs = new ArrayList<DSkuRecommendBO>();
            Long memberId = recommendSkuResultReqBO.getMemberId();
            if (memberId == null) {
                logger.debug("\u6ca1\u6709\u4f20\u4f1a\u5458ID(\u5168\u91cf\u6267\u884c\u63a8\u8350\u7ed3\u679c\u5237\u65b0)");
                LongPrimitiveIterator longPrimitiveIterator = model.getUserIDs();
                while (longPrimitiveIterator.hasNext()) {
                    Long memberId1 = longPrimitiveIterator.nextLong();
                    List recommendItems = recommender.recommend(memberId1.longValue(), 20);
                    if (!CollectionUtils.isNotEmpty((Collection)recommendItems)) continue;
                    for (RecommendedItem recommendedItem : recommendItems) {
                        DSkuRecommendBO dSkuRecommendBO = new DSkuRecommendBO();
                        dSkuRecommendBO.setMemberId(memberId1);
                        dSkuRecommendBO.setSkuId(Long.valueOf(recommendedItem.getItemID()));
                        dSkuRecommendBO.setRecommendType("0");
                        dSkuRecommendBO.setRecommendIndex(Float.valueOf(recommendedItem.getValue()));
                        dSkuRecommendBOs.add(dSkuRecommendBO);
                    }
                }
            } else {
                logger.debug("\u4f20\u4f1a\u5458ID(\u4f1a\u5458ID\u6267\u884c\u63a8\u8350\u7ed3\u679c\u5237\u65b0)");
                List recommendItems = recommender.recommend(memberId.longValue(), 20);
                if (CollectionUtils.isNotEmpty((Collection)recommendItems)) {
                    for (RecommendedItem recommendedItem : recommendItems) {
                        DSkuRecommendBO dSkuRecommendBO = new DSkuRecommendBO();
                        dSkuRecommendBO.setMemberId(memberId);
                        dSkuRecommendBO.setSkuId(Long.valueOf(recommendedItem.getItemID()));
                        dSkuRecommendBO.setRecommendType("0");
                        dSkuRecommendBO.setRecommendIndex(Float.valueOf(recommendedItem.getValue()));
                        dSkuRecommendBOs.add(dSkuRecommendBO);
                    }
                }
            }
            logger.debug("\u5220\u9664\u539f\u6709\u7684\u4f1a\u5458\u63a8\u8350\u8bb0\u5f55");
            try {
                this.dSkuRecommendManageService.deleteDSkuRecommend(memberId);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("\u5220\u9664\u539f\u6709\u7684\u4f1a\u5458\u63a8\u8350\u8bb0\u5f55");
            }
            logger.debug("\u65b0\u589e\u6700\u65b0\u7684\u4f1a\u5458\u63a8\u8350\u8bb0\u5f55");
            try {
                this.dSkuRecommendManageService.insertDSkuRecommend(dSkuRecommendBOs);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("\u5220\u9664\u539f\u6709\u7684\u4f1a\u5458\u63a8\u8350\u8bb0\u5f55");
            }
        }
        catch (TasteException e) {
            e.printStackTrace();
            logger.error("\u8ba1\u7b97\u76ae\u5c14\u68ee\u76f8\u4f3c\u5ea6\u62a5\u9519");
        }
        baseRspBO.setRespCode("0000");
        baseRspBO.setRespDesc("\u6210\u529f");
        return baseRspBO;
    }
}

