/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.tydic.newretail.atom.UpdateSkuAtomService;
import com.tydic.newretail.bo.BaseRspBO;
import com.tydic.newretail.bo.DSkuBO;
import com.tydic.newretail.bo.RelieveSkuFodderRelationReqBO;
import com.tydic.newretail.bo.RelieveSkuFodderReqBO;
import com.tydic.newretail.bo.RelieveSkuReqBO;
import com.tydic.newretail.busi.service.InitSkuFodderRelationService;
import com.tydic.newretail.busi.service.RelieveSkuFodderService;
import com.tydic.newretail.dao.SkuDAO;
import com.tydic.newretail.dao.SkuPicDAO;
import com.tydic.newretail.dao.SkuSpecDAO;
import com.tydic.newretail.dao.po.SkuPO;
import com.tydic.newretail.dao.po.SkuSpecPO;
import com.tydic.newretail.exception.BusinessException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class RelieveSkuFodderServiceImpl
implements RelieveSkuFodderService {
    @Autowired
    private SkuDAO skuMapper;
    @Autowired
    private InitSkuFodderRelationService initSkuFodderRelationService;
    @Autowired
    private SkuPicDAO skuPicMapper;
    @Autowired
    private SkuSpecDAO skuSpecMapper;
    @Autowired
    private UpdateSkuAtomService updateSkuAtomService;
    private static final Logger logger = LoggerFactory.getLogger(RelieveSkuFodderServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();

    public BaseRspBO relieveSkuFodder(RelieveSkuFodderReqBO relieveSkuFodderReqBO) {
        logger.info("\u89e3\u9664\u5355\u54c1\u7d20\u6750\u548c\u5bf9\u5e94\u5546\u54c1\u670d\u52a1\u5165\u53c2\uff1a" + relieveSkuFodderReqBO.toString());
        BaseRspBO baseRspBO = new BaseRspBO();
        try {
            if (relieveSkuFodderReqBO.getRelieveSkuReqBOs().size() > 0) {
                List relieveSkuReqBOs = relieveSkuFodderReqBO.getRelieveSkuReqBOs();
                for (RelieveSkuReqBO relieveSkuReqBO : relieveSkuReqBOs) {
                    DSkuBO DSkuBO2;
                    String extSkuId = relieveSkuReqBO.getExtSkuId();
                    Long supplierId = relieveSkuReqBO.getSupplierId();
                    if (extSkuId == null || supplierId == null) continue;
                    SkuPO SkuPO2 = this.skuMapper.selectByExtSkuIdAndSupplierId(extSkuId, supplierId);
                    RelieveSkuFodderRelationReqBO relieveSkuFodderRelationReqBO = new RelieveSkuFodderRelationReqBO();
                    relieveSkuFodderRelationReqBO.setFodderId(relieveSkuFodderReqBO.getFodderId());
                    relieveSkuFodderRelationReqBO.setSkuId(SkuPO2.getSkuId());
                    relieveSkuFodderRelationReqBO.setSupplierId(supplierId);
                    this.initSkuFodderRelationService.relieveSkuFodderRelation(relieveSkuFodderRelationReqBO);
                    ArrayList<Long> skuIds = new ArrayList<Long>();
                    skuIds.add(SkuPO2.getSkuId());
                    this.skuPicMapper.deleteBySkuIdBatch(skuIds, supplierId);
                    SkuSpecPO record = new SkuSpecPO();
                    record.setSupplierId(supplierId);
                    record.setSkuId(SkuPO2.getSkuId());
                    this.skuSpecMapper.deleteByMany(record);
                    if (SkuPO2.getSkuStatus() == 0) {
                        logger.info("\u5546\u54c1\u72b6\u6001\u4e3a\u8349\u7a3f\u72b6\u6001\uff0c\u53ea\u6709\u7d20\u6750\uff0c\u6ca1\u6709erp\u540c\u6b65");
                        this.skuMapper.deleteByPrimaryKey(SkuPO2.getSkuId());
                        continue;
                    }
                    if (SkuPO2.getSkuStatus() == 2) {
                        logger.info("\u5546\u54c1\u72b6\u6001\u4e3a\u4e0a\u67b6\u72b6\u6001\uff0c\u7d20\u6750\u548cerp\u90fd\u5728");
                        DSkuBO2 = new DSkuBO();
                        DSkuBO2.setExtSkuId(relieveSkuReqBO.getExtSkuId());
                        DSkuBO2.setMaterialId(relieveSkuReqBO.getMaterialId());
                        DSkuBO2.setSupplierId(relieveSkuReqBO.getSupplierId());
                        DSkuBO2.setSkuStatus(Integer.valueOf(1));
                        this.updateSkuAtomService.updateSku((List)DSkuBO2);
                        continue;
                    }
                    if (SkuPO2.getSkuStatus() != 5) continue;
                    logger.info("\u5546\u54c1\u72b6\u6001\u4e3a\u4e0a\u67b6\u72b6\u6001\uff0c\u7d20\u6750\u548cerp\u90fd\u5728");
                    DSkuBO2 = new DSkuBO();
                    DSkuBO2.setExtSkuId(relieveSkuReqBO.getExtSkuId());
                    DSkuBO2.setMaterialId(relieveSkuReqBO.getMaterialId());
                    DSkuBO2.setSupplierId(relieveSkuReqBO.getSupplierId());
                    DSkuBO2.setSkuStatus(Integer.valueOf(4));
                    this.updateSkuAtomService.updateSku((List)DSkuBO2);
                }
                baseRspBO.setRespCode("0000");
                baseRspBO.setRespDesc("\u6210\u529f");
                logger.error("\u89e3\u9664\u5355\u54c1\u7d20\u6750\u548c\u5bf9\u5e94\u5546\u54c1\u670d\u52a1\u7ed3\u675f");
            } else {
                baseRspBO.setRespCode("8888");
                baseRspBO.setRespDesc("\u9700\u8981\u89e3\u9664\u7d20\u6750\u7684\u5546\u54c1\u5217\u8868\u4e3a\u7a7a");
            }
        }
        catch (Exception e) {
            logger.error("\u89e3\u9664\u5355\u54c1\u7d20\u6750\u548c\u5bf9\u5e94\u5546\u54c1\u670d\u52a1\u51fa\u9519-\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38" + e.getMessage());
            baseRspBO.setRespCode("8888");
            baseRspBO.setRespDesc("\u89e3\u9664\u5355\u54c1\u7d20\u6750\u548c\u5bf9\u5e94\u5546\u54c1\u670d\u52a1-\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38");
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u89e3\u9664\u5355\u54c1\u7d20\u6750\u548c\u5bf9\u5e94\u5546\u54c1\u670d\u52a1-\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38" + e.getMessage());
        }
        return baseRspBO;
    }
}

