/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.tydic.newretail.bo.QueryParam;
import com.tydic.newretail.bo.SearchBarEsReqBO;
import com.tydic.newretail.bo.SearchBarEsRspBO;
import com.tydic.newretail.bo.SearchBarEsRspInfoBO;
import com.tydic.newretail.bo.SearchEsResultRspBO;
import com.tydic.newretail.bo.SearchEsRspInfoBO;
import com.tydic.newretail.bo.SearchEsSQLReqBO;
import com.tydic.newretail.busi.SearchEsService;
import com.tydic.newretail.busi.service.SearchBarEsService;
import com.tydic.newretail.dao.po.SearchEsQueryRspPO;
import com.tydic.newretail.dao.po.SearchEsSQLRspPO;
import com.tydic.newretail.dao.po.SearchEsSQLXlsRspPO;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SearchBarEsServiceImpl
implements SearchBarEsService {
    private static final Logger logger = LoggerFactory.getLogger(SearchBarEsServiceImpl.class);
    @Autowired
    private SearchEsService searchEsService;

    public SearchBarEsRspBO qryBySearchBar(SearchBarEsReqBO searchBarEsReqBO) {
        logger.error("SearchBarEsService---------------------------------\u5165\u53c2\uff1a" + searchBarEsReqBO.toString());
        SearchBarEsRspBO bo = new SearchBarEsRspBO();
        SearchEsSQLReqBO searchEsSQLReqBO = new SearchEsSQLReqBO();
        BeanUtils.copyProperties((Object)searchBarEsReqBO, (Object)searchEsSQLReqBO);
        List queryParams = searchBarEsReqBO.getQueryParams();
        ArrayList<QueryParam> queryParamBOs = new ArrayList<QueryParam>();
        if (queryParams != null && queryParams.size() > 0) {
            for (QueryParam queryParam : queryParams) {
                QueryParam queryParamBO = new QueryParam();
                BeanUtils.copyProperties((Object)queryParam, (Object)queryParamBO);
                queryParamBOs.add(queryParamBO);
            }
        }
        searchEsSQLReqBO.setQueryParams(queryParamBOs);
        logger.debug("searchEsSQLReqBO\u503c\u4e3a---------------------------------\uff1a" + searchEsSQLReqBO.toString());
        SearchEsSQLRspPO builderSQL = this.searchEsService.buildSQL(searchEsSQLReqBO);
        logger.debug("SearchEsSQLService\u8fd4\u56de\u67e5\u8be2\u6761\u4ef6---------------------------------\uff1a" + builderSQL.toString());
        SearchEsQueryRspPO executeSQL = this.searchEsService.executeSQL(builderSQL);
        SearchEsResultRspBO result = this.searchEsService.searchResult(executeSQL);
        List<String> hiddenParamsForRsp = builderSQL.getHiddenParamsForRsp();
        SearchResponse searchResponse = executeSQL.getSearchResponse();
        bo.setQueryStr(searchBarEsReqBO.getQueryStr());
        bo.setCategoryId(searchBarEsReqBO.getCategoryId());
        bo.setSupplierId(searchBarEsReqBO.getSupplierId());
        bo.setQueryLocation(searchBarEsReqBO.getQueryLocation());
        bo.setPageNo(searchBarEsReqBO.getPageNo());
        bo.setTotalCount(result.getTotalCount());
        bo.setCommodityIds(result.getCommodityIds());
        logger.debug("\u67e5\u8be2\u4e2a\u6570---------------------------------\uff1a" + result.getTotalCount());
        List list = null;
        if (null != result) {
            list = result.getResult();
        }
        logger.debug("\u67e5\u8be2\u4e2a\u6570result---------------------------------\uff1a" + list.size());
        ArrayList<Long> skuIds = new ArrayList<Long>();
        ArrayList<SearchBarEsRspInfoBO> rspInfos = new ArrayList<SearchBarEsRspInfoBO>();
        for (SearchEsRspInfoBO searchBarEsRspInfoBO : list) {
            if (StringUtils.isNotBlank((CharSequence)searchBarEsRspInfoBO.getSkuId())) {
                skuIds.add(Long.valueOf(searchBarEsRspInfoBO.getSkuId()));
            }
            SearchBarEsRspInfoBO searchBarEsRspInfo = new SearchBarEsRspInfoBO();
            BeanUtils.copyProperties((Object)searchBarEsRspInfoBO, (Object)searchBarEsRspInfo);
            rspInfos.add(searchBarEsRspInfo);
        }
        bo.setSkuIds(skuIds);
        bo.setResult(rspInfos);
        if (searchBarEsReqBO.getUserId() != null) {
            bo.setIsLogin(Boolean.valueOf(true));
        } else {
            bo.setIsLogin(Boolean.valueOf(false));
        }
        LinkedList<QueryParam> testParams = new LinkedList<QueryParam>();
        LinkedList supplierValue = new LinkedList();
        LinkedList brandValue = new LinkedList();
        LinkedList category3Value = new LinkedList();
        System.out.println("group_by_supplier_id");
        Terms groupBySupplierId = (Terms)searchResponse.getAggregations().get("group_by_supplier_id_name");
        QueryParam supplierQP = new QueryParam();
        supplierQP.setFilterId("supplier_id_name");
        supplierQP.setFilterName("\u4f9b\u5e94\u5546");
        groupBySupplierId.getBuckets().forEach(bucket -> {
            supplierValue.add(bucket.getKey().toString());
            supplierQP.setFilterValues(supplierValue);
        });
        if (supplierValue != null && supplierValue.size() > 0 && !hiddenParamsForRsp.contains("supplier_id_name")) {
            testParams.add(supplierQP);
        }
        System.out.println("group_by_brand_id");
        Terms groupByBrandId = (Terms)searchResponse.getAggregations().get("group_by_brand_id_name");
        QueryParam brandQP = new QueryParam();
        brandQP.setFilterId("brand_id_name");
        brandQP.setFilterName("\u54c1\u724c");
        groupByBrandId.getBuckets().forEach(bucket -> {
            brandValue.add(bucket.getKey().toString());
            brandQP.setFilterValues(brandValue);
        });
        if (brandValue != null && brandValue.size() > 0 && !hiddenParamsForRsp.contains("brand_id_name")) {
            testParams.add(brandQP);
        }
        Terms groupByCategory3Id = (Terms)searchResponse.getAggregations().get("group_by_l3_category_id_name");
        QueryParam category3IdQP = new QueryParam();
        category3IdQP.setFilterId("l3_category_id_name");
        category3IdQP.setFilterName("\u5206\u7c7b");
        groupByCategory3Id.getBuckets().forEach(bucket -> {
            String value = bucket.getKey().toString();
            if (searchBarEsReqBO.getQueryLocation() != null && value != null && value != "" && value.contains("*~~") && value.endsWith(String.valueOf(searchBarEsReqBO.getQueryLocation()))) {
                String[] values = value.split("\\*~~");
                if (values.length > 2) {
                    value = values[0] + "*~~" + values[1];
                }
                category3Value.add(value);
                category3IdQP.setFilterValues(category3Value);
            }
        });
        if (category3Value != null && category3Value.size() > 0 && !hiddenParamsForRsp.contains("l3_category_id_name")) {
            testParams.add(category3IdQP);
        }
        bo.setQueryParams(testParams);
        return bo;
    }

    public SearchBarEsRspBO queryEsGroupByCommodityId(SearchBarEsReqBO searchBarEsReqBO) {
        logger.error("SearchBarEsService---------------------------------\u5165\u53c2\uff1a" + searchBarEsReqBO.toString());
        SearchBarEsRspBO bo = new SearchBarEsRspBO();
        SearchEsSQLReqBO searchEsSQLReqBO = new SearchEsSQLReqBO();
        BeanUtils.copyProperties((Object)searchBarEsReqBO, (Object)searchEsSQLReqBO);
        List queryParams = searchBarEsReqBO.getQueryParams();
        ArrayList<QueryParam> queryParamBOs = new ArrayList<QueryParam>();
        if (queryParams != null && queryParams.size() > 0) {
            for (QueryParam queryParam : queryParams) {
                QueryParam queryParamBO = new QueryParam();
                BeanUtils.copyProperties((Object)queryParam, (Object)queryParamBO);
                queryParamBOs.add(queryParamBO);
            }
        }
        searchEsSQLReqBO.setQueryParams(queryParamBOs);
        logger.debug("searchEsSQLReqBO\u503c\u4e3a---------------------------------\uff1a" + searchEsSQLReqBO.toString());
        SearchEsSQLXlsRspPO builderXlsSQL = this.searchEsService.buildSQLXls(searchEsSQLReqBO);
        logger.debug("SearchEsSQLService\u8fd4\u56de\u67e5\u8be2\u6761\u4ef6---------------------------------\uff1a" + builderXlsSQL.toString());
        SearchEsQueryRspPO executeSQL = this.searchEsService.executeSQLXls(builderXlsSQL);
        SearchEsResultRspBO result = this.searchEsService.searchResultXls(executeSQL);
        List<String> hiddenParamsForRsp = builderXlsSQL.getHiddenParamsForRsp();
        SearchResponse searchResponse = executeSQL.getSearchResponse();
        bo.setQueryStr(searchBarEsReqBO.getQueryStr());
        bo.setCategoryId(searchBarEsReqBO.getCategoryId());
        bo.setSupplierId(searchBarEsReqBO.getSupplierId());
        bo.setQueryLocation(searchBarEsReqBO.getQueryLocation());
        bo.setPageNo(searchBarEsReqBO.getPageNo());
        bo.setTotalCount(result.getTotalCount());
        bo.setCommodityIds(result.getCommodityIds());
        logger.debug("\u67e5\u8be2\u4e2a\u6570---------------------------------\uff1a" + result.getTotalCount());
        List list = null;
        if (null != result) {
            list = result.getResult();
        }
        logger.debug("\u67e5\u8be2\u4e2a\u6570result---------------------------------\uff1a" + list.size());
        ArrayList<SearchBarEsRspInfoBO> rspInfos = new ArrayList<SearchBarEsRspInfoBO>();
        ArrayList<Long> skuIds = new ArrayList<Long>();
        for (SearchEsRspInfoBO searchBarEsRspInfoBO : list) {
            if (StringUtils.isNotBlank((CharSequence)searchBarEsRspInfoBO.getSkuId())) {
                skuIds.add(Long.valueOf(searchBarEsRspInfoBO.getSkuId()));
            }
            SearchBarEsRspInfoBO searchBarEsRspInfo = new SearchBarEsRspInfoBO();
            BeanUtils.copyProperties((Object)searchBarEsRspInfoBO, (Object)searchBarEsRspInfo);
            rspInfos.add(searchBarEsRspInfo);
        }
        bo.setSkuIds(skuIds);
        bo.setResult(rspInfos);
        if (searchBarEsReqBO.getUserId() != null) {
            bo.setIsLogin(Boolean.valueOf(true));
        } else {
            bo.setIsLogin(Boolean.valueOf(false));
        }
        LinkedList<QueryParam> testParams = new LinkedList<QueryParam>();
        LinkedList supplierValue = new LinkedList();
        LinkedList brandValue = new LinkedList();
        LinkedList category3Value = new LinkedList();
        System.out.println("group_by_supplier_id");
        Terms groupBySupplierId = (Terms)searchResponse.getAggregations().get("group_by_supplier_id_name");
        QueryParam supplierQP = new QueryParam();
        supplierQP.setFilterId("supplier_id_name");
        supplierQP.setFilterName("\u4f9b\u5e94\u5546");
        groupBySupplierId.getBuckets().forEach(bucket -> {
            supplierValue.add(bucket.getKey().toString());
            supplierQP.setFilterValues(supplierValue);
        });
        if (supplierValue != null && supplierValue.size() > 0 && !hiddenParamsForRsp.contains("supplier_id_name")) {
            testParams.add(supplierQP);
        }
        System.out.println("group_by_brand_id");
        Terms groupByBrandId = (Terms)searchResponse.getAggregations().get("group_by_brand_id_name");
        QueryParam brandQP = new QueryParam();
        brandQP.setFilterId("brand_id_name");
        brandQP.setFilterName("\u54c1\u724c");
        groupByBrandId.getBuckets().forEach(bucket -> {
            brandValue.add(bucket.getKey().toString());
            brandQP.setFilterValues(brandValue);
        });
        if (brandValue != null && brandValue.size() > 0 && !hiddenParamsForRsp.contains("brand_id_name")) {
            testParams.add(brandQP);
        }
        Terms groupByCategory3Id = (Terms)searchResponse.getAggregations().get("group_by_l3_category_id_name");
        QueryParam category3IdQP = new QueryParam();
        category3IdQP.setFilterId("l3_category_id_name");
        category3IdQP.setFilterName("\u5206\u7c7b");
        groupByCategory3Id.getBuckets().forEach(bucket -> {
            String value = bucket.getKey().toString();
            if (searchBarEsReqBO.getQueryLocation() != null && value != null && value != "" && value.contains("*~~") && value.endsWith(String.valueOf(searchBarEsReqBO.getQueryLocation()))) {
                String[] values = value.split("\\*~~");
                if (values.length > 2) {
                    value = values[0] + "*~~" + values[1];
                }
                category3Value.add(value);
                category3IdQP.setFilterValues(category3Value);
            }
        });
        if (category3Value != null && category3Value.size() > 0 && !hiddenParamsForRsp.contains("l3_category_id_name")) {
            testParams.add(category3IdQP);
        }
        bo.setQueryParams(testParams);
        return bo;
    }
}

