/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.tydic.newretail.bo.QueryParam;
import com.tydic.newretail.bo.SearchBarEsRspInfoBO;
import com.tydic.newretail.bo.SearchEsResultRspBO;
import com.tydic.newretail.bo.SearchEsRspInfoBO;
import com.tydic.newretail.bo.SearchEsSQLReqBO;
import com.tydic.newretail.busi.SearchEsService;
import com.tydic.newretail.dao.po.SearchEsQueryRspPO;
import com.tydic.newretail.dao.po.SearchEsSQLRspPO;
import com.tydic.newretail.dao.po.SearchEsSQLXlsRspPO;
import com.tydic.newretail.exception.BusinessException;
import com.tydic.newretail.util.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.annotation.Resource;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.InnerHitBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.cardinality.CardinalityAggregationBuilder;
import org.elasticsearch.search.collapse.CollapseBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@Qualifier
public class SearchEsServiceImpl
implements SearchEsService {
    private static final Logger logger = LoggerFactory.getLogger(SearchEsServiceImpl.class);
    @Resource
    private TransportClient client;
    @Value(value="${es.sku.index.name}")
    private String skuIndexName;
    @Value(value="${es.sku.type.name}")
    private String skuTypeName;

    @Override
    public SearchEsSQLRspPO buildSQL(SearchEsSQLReqBO searchEsSQLReqBO) {
        SearchEsSQLRspPO searchBarEsSQLRspBO = new SearchEsSQLRspPO();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_status", (int)2));
        if (searchEsSQLReqBO.getSupplierId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_id", (String)searchEsSQLReqBO.getSupplierId()));
        }
        if (searchEsSQLReqBO.getQueryLocation() != null && searchEsSQLReqBO.getQueryLocation() != 0) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_location", (Object)searchEsSQLReqBO.getQueryLocation()));
        }
        logger.error("searchEsSQLReqBO.getQueryStr()=========" + searchEsSQLReqBO.getQueryStr());
        if (searchEsSQLReqBO.getQueryStr() != null && !"".equals(searchEsSQLReqBO.getQueryStr())) {
            BoolQueryBuilder boolQueryBuilder1 = QueryBuilders.boolQuery();
            boolQueryBuilder1.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"sku_name", (Object)searchEsSQLReqBO.getQueryStr()));
            boolQueryBuilder1.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"sku_long_name", (Object)searchEsSQLReqBO.getQueryStr()));
            boolQueryBuilder1.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"commodity_name", (Object)searchEsSQLReqBO.getQueryStr()));
            boolQueryBuilder1.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"commodity_long_name", (Object)searchEsSQLReqBO.getQueryStr()));
            boolQueryBuilder1.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"brand_name", (Object)searchEsSQLReqBO.getQueryStr()));
            boolQueryBuilder1.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"supplier_name", (Object)searchEsSQLReqBO.getQueryStr()));
            boolQueryBuilder1.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"l2_category_name", (Object)searchEsSQLReqBO.getQueryStr()));
            boolQueryBuilder1.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"l3_category_id_name", (Object)searchEsSQLReqBO.getQueryStr()));
            boolQueryBuilder.must((QueryBuilder)boolQueryBuilder1);
        }
        LinkedList<String> hiddenParamsForRsp = new LinkedList<String>();
        if (searchEsSQLReqBO.getQueryParams() != null) {
            for (int i = 0; i < searchEsSQLReqBO.getQueryParams().size(); ++i) {
                int j;
                QueryParam param = (QueryParam)searchEsSQLReqBO.getQueryParams().get(i);
                hiddenParamsForRsp.add(param.getFilterId());
                BoolQueryBuilder boolQueryBuilder2 = QueryBuilders.boolQuery();
                if ("supplier_id_name".equals(param.getFilterId())) {
                    for (j = 0; j < param.getFilterValues().size(); ++j) {
                        boolQueryBuilder.must((QueryBuilder)boolQueryBuilder2.should((QueryBuilder)QueryBuilders.termQuery((String)"supplier_id_name", (String)((String)param.getFilterValues().get(j)))));
                    }
                    continue;
                }
                if ("brand_id_name".equals(param.getFilterId())) {
                    for (j = 0; j < param.getFilterValues().size(); ++j) {
                        boolQueryBuilder.must((QueryBuilder)boolQueryBuilder2.should((QueryBuilder)QueryBuilders.termQuery((String)"brand_id_name", (String)((String)param.getFilterValues().get(j)))));
                    }
                    continue;
                }
                if (!"l3_category_id_name".equals(param.getFilterId())) continue;
                for (j = 0; j < param.getFilterValues().size(); ++j) {
                    boolQueryBuilder.must((QueryBuilder)boolQueryBuilder2.should((QueryBuilder)QueryBuilders.termQuery((String)"l3_category_id_name", (String)((String)param.getFilterValues().get(j) + "*~~" + searchEsSQLReqBO.getQueryLocation()))));
                }
            }
        }
        if (searchEsSQLReqBO.getCategoryId() != null && searchEsSQLReqBO.getLevel() != null) {
            if (searchEsSQLReqBO.getLevel() == 1) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"l1_category_id", (String)searchEsSQLReqBO.getCategoryId()));
            } else if (searchEsSQLReqBO.getLevel() == 2) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"l2_category_id", (String)searchEsSQLReqBO.getCategoryId()));
            } else if (searchEsSQLReqBO.getLevel() == 3) {
                Integer queryLocation = searchEsSQLReqBO.getQueryLocation();
                queryLocation = queryLocation == null ? 0 : queryLocation;
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"l3_category_id", (String)(searchEsSQLReqBO.getCategoryId() + "*~~" + queryLocation)));
            }
        }
        try {
            RangeQueryBuilder qb = null;
            if (null != searchEsSQLReqBO.getMinSalesPrice()) {
                qb = searchEsSQLReqBO.getMinSalesPrice().compareTo(BigDecimal.ZERO) != 0 ? QueryBuilders.rangeQuery((String)"sale_price").gte((Object)MoneyUtils.BigDecimal2Long(searchEsSQLReqBO.getMinSalesPrice())) : QueryBuilders.rangeQuery((String)"sale_price").gte((Object)0);
            }
            if (null != searchEsSQLReqBO.getMaxSalesPrice() && searchEsSQLReqBO.getMaxSalesPrice().compareTo(BigDecimal.ZERO) != 0) {
                qb.lte((Object)MoneyUtils.BigDecimal2Long(searchEsSQLReqBO.getMaxSalesPrice()));
            }
            if (qb != null) {
                boolQueryBuilder.must(qb);
            }
        }
        catch (Exception e) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6700\u4f4e\u9500\u552e\u4ef7\u683c\u6216\u6700\u9ad8\u9500\u552e\u4ef7\u683c\u8f6c\u6362\u5f02\u5e38\uff01");
        }
        SortOrder orderType = SortOrder.DESC;
        if (searchEsSQLReqBO.getOrderType() != null && searchEsSQLReqBO.getOrderType() == 1) {
            orderType = SortOrder.ASC;
        }
        String sortField = "on_shelve_time";
        if (searchEsSQLReqBO.getOrderByColumn() != null) {
            if (searchEsSQLReqBO.getOrderByColumn() == 1) {
                sortField = "sold_number";
            } else if (searchEsSQLReqBO.getOrderByColumn() == 2) {
                sortField = "on_shelve_time";
            } else if (searchEsSQLReqBO.getOrderByColumn() == 3) {
                sortField = "sale_price";
            } else if (searchEsSQLReqBO.getOrderByColumn() == 4) {
                sortField = "discount_rate";
            }
        }
        FieldSortBuilder sortQuery = (FieldSortBuilder)SortBuilders.fieldSort((String)sortField).order(orderType);
        searchBarEsSQLRspBO.setBoolQueryBuilder(boolQueryBuilder);
        searchBarEsSQLRspBO.setSortQuery(sortQuery);
        searchBarEsSQLRspBO.setHiddenParamsForRsp(hiddenParamsForRsp);
        searchBarEsSQLRspBO.setPageNo(searchEsSQLReqBO.getPageNo());
        searchBarEsSQLRspBO.setPageSize(searchEsSQLReqBO.getPageSize());
        return searchBarEsSQLRspBO;
    }

    @Override
    public SearchEsSQLXlsRspPO buildSQLXls(SearchEsSQLReqBO searchEsSQLReqBO) {
        SearchEsSQLXlsRspPO searchEsSQLXlsRspPO = new SearchEsSQLXlsRspPO();
        CollapseBuilder collapseBuilder = new CollapseBuilder("commodity_id");
        InnerHitBuilder innerHit = new InnerHitBuilder("bottom_price_sku");
        ArrayList<FieldSortBuilder> sorts = new ArrayList<FieldSortBuilder>();
        SortOrder orderSalePrice = SortOrder.ASC;
        FieldSortBuilder fsb = (FieldSortBuilder)SortBuilders.fieldSort((String)"sale_price").order(orderSalePrice);
        sorts.add(fsb);
        innerHit.setSorts(sorts);
        innerHit.setSize(1);
        collapseBuilder.setInnerHits(innerHit);
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_status", (int)2));
        if (searchEsSQLReqBO.getSupplierId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_id", (String)searchEsSQLReqBO.getSupplierId()));
        }
        if (searchEsSQLReqBO.getQueryLocation() != null && searchEsSQLReqBO.getQueryLocation() != 0) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_location", (Object)searchEsSQLReqBO.getQueryLocation()));
        }
        logger.error("searchEsSQLReqBO.getQueryStr()=========" + searchEsSQLReqBO.getQueryStr());
        if (searchEsSQLReqBO.getQueryStr() != null && !"".equals(searchEsSQLReqBO.getQueryStr())) {
            BoolQueryBuilder boolQueryBuilder1 = QueryBuilders.boolQuery();
            boolQueryBuilder1.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"sku_name", (Object)searchEsSQLReqBO.getQueryStr()));
            boolQueryBuilder1.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"sku_long_name", (Object)searchEsSQLReqBO.getQueryStr()));
            boolQueryBuilder1.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"commodity_name", (Object)searchEsSQLReqBO.getQueryStr()));
            boolQueryBuilder1.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"commodity_long_name", (Object)searchEsSQLReqBO.getQueryStr()));
            boolQueryBuilder1.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"brand_name", (Object)searchEsSQLReqBO.getQueryStr()));
            boolQueryBuilder1.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"supplier_name", (Object)searchEsSQLReqBO.getQueryStr()));
            boolQueryBuilder1.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"l2_category_name", (Object)searchEsSQLReqBO.getQueryStr()));
            boolQueryBuilder1.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"l3_category_id_name", (Object)searchEsSQLReqBO.getQueryStr()));
            boolQueryBuilder.must((QueryBuilder)boolQueryBuilder1);
        }
        LinkedList<String> hiddenParamsForRsp = new LinkedList<String>();
        if (searchEsSQLReqBO.getQueryParams() != null) {
            for (int i = 0; i < searchEsSQLReqBO.getQueryParams().size(); ++i) {
                int j;
                QueryParam param = (QueryParam)searchEsSQLReqBO.getQueryParams().get(i);
                hiddenParamsForRsp.add(param.getFilterId());
                BoolQueryBuilder boolQueryBuilder2 = QueryBuilders.boolQuery();
                if ("supplier_id_name".equals(param.getFilterId())) {
                    for (j = 0; j < param.getFilterValues().size(); ++j) {
                        boolQueryBuilder.must((QueryBuilder)boolQueryBuilder2.should((QueryBuilder)QueryBuilders.termQuery((String)"supplier_id_name", (String)((String)param.getFilterValues().get(j)))));
                    }
                    continue;
                }
                if ("brand_id_name".equals(param.getFilterId())) {
                    for (j = 0; j < param.getFilterValues().size(); ++j) {
                        boolQueryBuilder.must((QueryBuilder)boolQueryBuilder2.should((QueryBuilder)QueryBuilders.termQuery((String)"brand_id_name", (String)((String)param.getFilterValues().get(j)))));
                    }
                    continue;
                }
                if (!"l3_category_id_name".equals(param.getFilterId())) continue;
                for (j = 0; j < param.getFilterValues().size(); ++j) {
                    boolQueryBuilder.must((QueryBuilder)boolQueryBuilder2.should((QueryBuilder)QueryBuilders.termQuery((String)"l3_category_id_name", (String)((String)param.getFilterValues().get(j) + "*~~" + searchEsSQLReqBO.getQueryLocation()))));
                }
            }
        }
        if (searchEsSQLReqBO.getCategoryId() != null && searchEsSQLReqBO.getLevel() != null) {
            if (searchEsSQLReqBO.getLevel() == 1) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"l1_category_id", (String)searchEsSQLReqBO.getCategoryId()));
            } else if (searchEsSQLReqBO.getLevel() == 2) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"l2_category_id", (String)searchEsSQLReqBO.getCategoryId()));
            } else if (searchEsSQLReqBO.getLevel() == 3) {
                Integer queryLocation = searchEsSQLReqBO.getQueryLocation();
                queryLocation = queryLocation == null ? 0 : queryLocation;
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"l3_category_id", (String)(searchEsSQLReqBO.getCategoryId() + "*~~" + queryLocation)));
            }
        }
        try {
            RangeQueryBuilder qb = null;
            if (null != searchEsSQLReqBO.getMinSalesPrice()) {
                qb = searchEsSQLReqBO.getMinSalesPrice().compareTo(BigDecimal.ZERO) != 0 ? QueryBuilders.rangeQuery((String)"sale_price").gte((Object)MoneyUtils.BigDecimal2Long(searchEsSQLReqBO.getMinSalesPrice())) : QueryBuilders.rangeQuery((String)"sale_price").gte((Object)0);
            }
            if (null != searchEsSQLReqBO.getMaxSalesPrice() && searchEsSQLReqBO.getMaxSalesPrice().compareTo(BigDecimal.ZERO) != 0) {
                qb.lte((Object)MoneyUtils.BigDecimal2Long(searchEsSQLReqBO.getMaxSalesPrice()));
            }
            if (qb != null) {
                boolQueryBuilder.must(qb);
            }
        }
        catch (Exception e) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6700\u4f4e\u9500\u552e\u4ef7\u683c\u6216\u6700\u9ad8\u9500\u552e\u4ef7\u683c\u8f6c\u6362\u5f02\u5e38\uff01");
        }
        SortOrder orderType = SortOrder.DESC;
        if (searchEsSQLReqBO.getOrderType() != null && searchEsSQLReqBO.getOrderType() == 1) {
            orderType = SortOrder.ASC;
        }
        String sortField = "on_shelve_time";
        if (searchEsSQLReqBO.getOrderByColumn() != null) {
            if (searchEsSQLReqBO.getOrderByColumn() == 1) {
                sortField = "sold_number";
            } else if (searchEsSQLReqBO.getOrderByColumn() == 2) {
                sortField = "on_shelve_time";
            } else if (searchEsSQLReqBO.getOrderByColumn() == 3) {
                sortField = "sale_price";
            } else if (searchEsSQLReqBO.getOrderByColumn() == 4) {
                sortField = "discount_rate";
            }
        }
        FieldSortBuilder sortQuery = (FieldSortBuilder)SortBuilders.fieldSort((String)sortField).order(orderType);
        searchEsSQLXlsRspPO.setCollapseBuilder(collapseBuilder);
        searchEsSQLXlsRspPO.setBoolQueryBuilder(boolQueryBuilder);
        searchEsSQLXlsRspPO.setSortQuery(sortQuery);
        searchEsSQLXlsRspPO.setHiddenParamsForRsp(hiddenParamsForRsp);
        searchEsSQLXlsRspPO.setPageNo(searchEsSQLReqBO.getPageNo());
        searchEsSQLXlsRspPO.setPageSize(searchEsSQLReqBO.getPageSize());
        return searchEsSQLXlsRspPO;
    }

    @Override
    public SearchEsQueryRspPO executeSQL(SearchEsSQLRspPO searchEsSQLRspPO) {
        SearchEsQueryRspPO searchBarEsQueryRspVO = null;
        try {
            searchBarEsQueryRspVO = new SearchEsQueryRspPO();
            Integer pageNo = 0;
            Integer pageSize = 10;
            if (searchEsSQLRspPO.getPageNo() != null && searchEsSQLRspPO.getPageNo() > 0) {
                pageNo = searchEsSQLRspPO.getPageNo() - 1;
            }
            if (searchEsSQLRspPO.getPageSize() != null && searchEsSQLRspPO.getPageSize() > 0) {
                pageSize = searchEsSQLRspPO.getPageSize();
            }
            SearchResponse searchResponse = (SearchResponse)this.client.prepareSearch(new String[]{this.skuIndexName}).setTypes(new String[]{this.skuTypeName}).setQuery((QueryBuilder)searchEsSQLRspPO.getBoolQueryBuilder()).addSort((SortBuilder)searchEsSQLRspPO.getSortQuery()).setFrom(pageNo * pageSize).setSize(pageSize.intValue()).addAggregation((AggregationBuilder)AggregationBuilders.terms((String)"group_by_supplier_id_name").field("supplier_id_name")).addAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"group_by_brand_id_name").field("brand_id_name")).size(2000)).addAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"group_by_l3_category_id_name").field("l3_category_id_name")).size(2000)).get();
            searchBarEsQueryRspVO.setSearchResponse(searchResponse);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.info("SearchEsQueryService\u51fa\u53c2\uff1a" + searchBarEsQueryRspVO.toString());
        return searchBarEsQueryRspVO;
    }

    @Override
    public SearchEsQueryRspPO executeSQLXls(SearchEsSQLXlsRspPO searchEsSQLXlsRspPO) {
        SearchEsQueryRspPO searchBarEsQueryRspVO = null;
        try {
            searchBarEsQueryRspVO = new SearchEsQueryRspPO();
            Integer pageNo = 0;
            Integer pageSize = 10;
            if (searchEsSQLXlsRspPO.getPageNo() != null && searchEsSQLXlsRspPO.getPageNo() > 0) {
                pageNo = searchEsSQLXlsRspPO.getPageNo() - 1;
            }
            if (searchEsSQLXlsRspPO.getPageSize() != null && searchEsSQLXlsRspPO.getPageSize() > 0) {
                pageSize = searchEsSQLXlsRspPO.getPageSize();
            }
            if (searchEsSQLXlsRspPO.getSortQuery() != null) {
                SearchResponse searchResponse = (SearchResponse)this.client.prepareSearch(new String[]{this.skuIndexName}).setTypes(new String[]{this.skuTypeName}).setQuery((QueryBuilder)searchEsSQLXlsRspPO.getBoolQueryBuilder()).highlighter(searchEsSQLXlsRspPO.getHighlightBuilder()).setCollapse(searchEsSQLXlsRspPO.getCollapseBuilder()).addSort((SortBuilder)searchEsSQLXlsRspPO.getSortQuery()).setFrom(pageNo * pageSize).setSize(pageSize.intValue()).addAggregation((AggregationBuilder)((CardinalityAggregationBuilder)AggregationBuilders.cardinality((String)"count").field("material_id")).precisionThreshold(20000L)).addAggregation((AggregationBuilder)AggregationBuilders.terms((String)"group_by_supplier_id_name").field("supplier_id_name")).addAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"group_by_brand_id_name").field("brand_id_name")).size(2000)).addAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"group_by_l3_category_id_name").field("l3_category_id_name")).size(2000)).get();
                logger.debug(searchResponse.toString());
                searchBarEsQueryRspVO.setSearchResponse(searchResponse);
            } else {
                SearchResponse searchResponse = (SearchResponse)this.client.prepareSearch(new String[]{this.skuIndexName}).setTypes(new String[]{this.skuTypeName}).setQuery((QueryBuilder)searchEsSQLXlsRspPO.getBoolQueryBuilder()).highlighter(searchEsSQLXlsRspPO.getHighlightBuilder()).setCollapse(searchEsSQLXlsRspPO.getCollapseBuilder()).setFrom(pageNo * pageSize).setSize(pageSize.intValue()).addAggregation((AggregationBuilder)((CardinalityAggregationBuilder)AggregationBuilders.cardinality((String)"count").field("material_id")).precisionThreshold(20000L)).addAggregation((AggregationBuilder)AggregationBuilders.terms((String)"group_by_supplier_id_name").field("supplier_id_name")).addAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"group_by_brand_id_name").field("brand_id_name")).size(2000)).addAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"group_by_l3_category_id_name").field("l3_category_id_name")).size(2000)).get();
                logger.debug(searchResponse.toString());
                searchBarEsQueryRspVO.setSearchResponse(searchResponse);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return searchBarEsQueryRspVO;
    }

    @Override
    public SearchEsResultRspBO searchResult(SearchEsQueryRspPO searchEsQueryRspPO) {
        SearchEsResultRspBO bo = new SearchEsResultRspBO();
        ArrayList<SearchEsRspInfoBO> rspInfos = new ArrayList<SearchEsRspInfoBO>();
        SearchBarEsRspInfoBO rspInfo = new SearchBarEsRspInfoBO();
        SearchResponse searchResponse = searchEsQueryRspPO.getSearchResponse();
        ArrayList<Long> commodityIds = new ArrayList<Long>();
        for (SearchHit hit : searchResponse.getHits()) {
            System.out.println("----skuid=" + hit.getSourceAsMap().get("sku_id"));
            rspInfo = new SearchBarEsRspInfoBO();
            rspInfo.setSkuId(String.valueOf(hit.getSourceAsMap().get("sku_id")));
            rspInfo.setExtSkuId(String.valueOf(hit.getSourceAsMap().get("ext_sku_id")));
            if (null != hit.getSourceAsMap().get("commodity_id")) {
                rspInfo.setCommodityId(Long.valueOf(String.valueOf(hit.getSourceAsMap().get("commodity_id"))));
                commodityIds.add(Long.valueOf(String.valueOf(hit.getSourceAsMap().get("commodity_id"))));
            }
            if (null != hit.getSourceAsMap().get("picture_url")) {
                rspInfo.setPriPicUrl(String.valueOf(hit.getSourceAsMap().get("picture_url")));
            }
            if (null != hit.getSourceAsMap().get("sale_area")) {
                rspInfo.setSaleArea(String.valueOf(hit.getSourceAsMap().get("sale_area")));
            }
            if (null != hit.getSourceAsMap().get("sku_long_name")) {
                rspInfo.setSkuName(String.valueOf(hit.getSourceAsMap().get("sku_long_name")));
            }
            if (null != hit.getSourceAsMap().get("sku_location")) {
                rspInfo.setSkuLocation(String.valueOf(hit.getSourceAsMap().get("sku_location")));
            }
            rspInfo.setSupplierId(Long.valueOf(Long.parseLong(String.valueOf(hit.getSourceAsMap().get("supplier_id")))));
            if (null != hit.getSourceAsMap().get("supplier_name")) {
                rspInfo.setSupplierName(String.valueOf(hit.getSourceAsMap().get("supplier_name")));
            }
            if (null != hit.getSourceAsMap().get("brand_name")) {
                rspInfo.setBrandName(String.valueOf(hit.getSourceAsMap().get("brand_name")));
            }
            if (null != hit.getSourceAsMap().get("mfgsku")) {
                rspInfo.setMfgsku(String.valueOf(hit.getSourceAsMap().get("mfgsku")));
            }
            if (null != hit.getSourceAsMap().get("commodity_name")) {
                rspInfo.setCommodityName(String.valueOf(hit.getSourceAsMap().get("commodity_name")));
            }
            if (null != hit.getSourceAsMap().get("commodity_long_name")) {
                rspInfo.setCommodityLongName(String.valueOf(hit.getSourceAsMap().get("commodity_long_name")));
            }
            try {
                if (hit.getSourceAsMap().get("market_price") != null) {
                    rspInfo.setMarketPrice(MoneyUtils.Long2BigDecimal(Long.parseLong(String.valueOf(hit.getSourceAsMap().get("market_price")))));
                }
                if (hit.getSourceAsMap().get("sku_price") != null) {
                    rspInfo.setSalePrice(MoneyUtils.Long2BigDecimal(Long.parseLong(String.valueOf(hit.getSourceAsMap().get("sku_price")))));
                }
                if (hit.getSourceAsMap().get("member_price") != null) {
                    rspInfo.setMemberPrice(MoneyUtils.Long2BigDecimal(Long.parseLong(String.valueOf(hit.getSourceAsMap().get("member_price")))));
                }
            }
            catch (Exception e) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
            }
            SearchEsRspInfoBO SearchBarEsRspInfoVO = new SearchEsRspInfoBO();
            BeanUtils.copyProperties((Object)rspInfo, (Object)SearchBarEsRspInfoVO);
            rspInfos.add(SearchBarEsRspInfoVO);
        }
        bo.setCommodityIds(commodityIds);
        bo.setTotalCount(Long.valueOf(searchResponse.getHits().getTotalHits()));
        bo.setResult(rspInfos);
        return bo;
    }

    @Override
    public SearchEsResultRspBO searchResultXls(SearchEsQueryRspPO searchEsQueryRspPO) {
        SearchEsResultRspBO bo = new SearchEsResultRspBO();
        ArrayList<SearchEsRspInfoBO> rspInfos = new ArrayList<SearchEsRspInfoBO>();
        SearchBarEsRspInfoBO rspInfo = new SearchBarEsRspInfoBO();
        SearchResponse searchResponse = searchEsQueryRspPO.getSearchResponse();
        ArrayList<Long> commodityIds = new ArrayList<Long>();
        for (SearchHit hit : searchResponse.getHits()) {
            commodityIds.add(Long.parseLong(String.valueOf(hit.getSourceAsMap().get("commodity_id"))));
            SearchHit sh = ((SearchHits)hit.getInnerHits().get("bottom_price_sku")).getHits()[0];
            rspInfo = new SearchBarEsRspInfoBO();
            rspInfo.setCommodityId(Long.valueOf(Long.parseLong(String.valueOf(sh.getSourceAsMap().get("commodity_id")))));
            rspInfo.setSkuId(String.valueOf(sh.getSourceAsMap().get("sku_id")));
            rspInfo.setExtSkuId(String.valueOf(sh.getSourceAsMap().get("ext_sku_id")));
            if (null != sh.getSourceAsMap().get("picture_url")) {
                rspInfo.setPriPicUrl(String.valueOf(sh.getSourceAsMap().get("picture_url")));
            }
            if (null != sh.getSourceAsMap().get("sale_area")) {
                rspInfo.setSaleArea(String.valueOf(sh.getSourceAsMap().get("sale_area")));
            }
            if (null != sh.getSourceAsMap().get("sku_long_name")) {
                rspInfo.setSkuName(String.valueOf(sh.getSourceAsMap().get("sku_long_name")));
            }
            if (null != sh.getSourceAsMap().get("sku_location")) {
                rspInfo.setSkuLocation(String.valueOf(sh.getSourceAsMap().get("sku_location")));
            }
            rspInfo.setSupplierId(Long.valueOf(Long.parseLong(String.valueOf(sh.getSourceAsMap().get("supplier_id")))));
            if (null != sh.getSourceAsMap().get("supplier_name")) {
                rspInfo.setSupplierName(String.valueOf(sh.getSourceAsMap().get("supplier_name")));
            }
            try {
                if (sh.getSourceAsMap().get("market_price") != null) {
                    rspInfo.setMarketPrice(MoneyUtils.Long2BigDecimal(Long.parseLong(String.valueOf(sh.getSourceAsMap().get("market_price")))));
                }
                if (sh.getSourceAsMap().get("sku_price") != null) {
                    rspInfo.setSalePrice(MoneyUtils.Long2BigDecimal(Long.parseLong(String.valueOf(sh.getSourceAsMap().get("sku_price")))));
                }
                if (sh.getSourceAsMap().get("member_price") != null) {
                    rspInfo.setMemberPrice(MoneyUtils.Long2BigDecimal(Long.parseLong(String.valueOf(sh.getSourceAsMap().get("member_price")))));
                }
            }
            catch (Exception e) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
            }
            SearchEsRspInfoBO SearchBarEsRspInfoVO = new SearchEsRspInfoBO();
            BeanUtils.copyProperties((Object)rspInfo, (Object)SearchBarEsRspInfoVO);
            rspInfos.add(SearchBarEsRspInfoVO);
        }
        bo.setCommodityIds(commodityIds);
        bo.setTotalCount(Long.valueOf(searchResponse.getHits().getTotalHits()));
        bo.setResult(rspInfos);
        return bo;
    }
}

