/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.tydic.newretail.bo.CommodityBO;
import com.tydic.newretail.bo.CommodityPageBO;
import com.tydic.newretail.bo.GoodsCategoryQueryBO;
import com.tydic.newretail.bo.GoodsCategoryQueryReqBO;
import com.tydic.newretail.bo.GoodsCategoryQueryResBO;
import com.tydic.newretail.bo.RspPageBO;
import com.tydic.newretail.bo.SelectXlsCommodityListPageBO;
import com.tydic.newretail.bo.SelectXlsCommodityListReqBO;
import com.tydic.newretail.bo.XlsCommodityReqBO;
import com.tydic.newretail.bo.XlsCommodityResBO;
import com.tydic.newretail.bo.selectCommodityByAppletReqBO;
import com.tydic.newretail.busi.service.GoodsCategoryQueryService;
import com.tydic.newretail.busi.service.SelectXlsCommodityListService;
import com.tydic.newretail.busi.service.SysParamTransferBusiService;
import com.tydic.newretail.busi.service.XlsCommodityManageService;
import com.tydic.newretail.dao.DDimensionNameDAO;
import com.tydic.newretail.dao.po.DDimensionNamePO;
import com.tydic.newretail.exception.BusinessException;
import com.tydic.newretail.toolkit.bo.RspPageBaseBO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SelectXlsCommodityListServiceImpl
implements SelectXlsCommodityListService {
    private static final Logger logger = LoggerFactory.getLogger(SelectXlsCommodityListServiceImpl.class);
    @Autowired
    private XlsCommodityManageService xlsCommodityManageService;
    @Autowired
    private GoodsCategoryQueryService goodsCategoryQueryService;
    @Autowired
    private SysParamTransferBusiService sysParamTransferBusiService;
    @Autowired
    private DDimensionNameDAO dDimensionNameDAO;

    public RspPageBaseBO<CommodityBO> selectXlsStatusCommodityMaterialListPage(SelectXlsCommodityListPageBO selectXlsCommodityListPageBO) {
        logger.info("\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5546\u54c1\u5217\u8868\u5206\u9875\u670d\u52a1\u5165\u53c2=" + selectXlsCommodityListPageBO.toString());
        logger.debug("\u67e5\u8be2\u53ef\u4ee5\u7ed1\u5b9a\u7684\u5546\u54c1id");
        RspPageBaseBO result = new RspPageBaseBO();
        if ("1".equals(selectXlsCommodityListPageBO.getmUserLevel())) {
            logger.debug("\u603b\u90e8\u4e0d\u53ef\u7ed1\u5b9a");
            result.setRespCode("8888");
            result.setRespDesc("\u603b\u90e8\u4e0d\u53ef\u7ed1\u5b9a\uff0c\u8bf7\u4f7f\u7528\u7701\u4efd\u8d26\u53f7\u64cd\u4f5c");
            return result;
        }
        DDimensionNamePO record = new DDimensionNamePO();
        record.setMaterialIdList(selectXlsCommodityListPageBO.getMaterialId());
        List<DDimensionNamePO> poList = this.dDimensionNameDAO.getBind(record);
        ArrayList<Long> commoIds = new ArrayList<Long>();
        for (DDimensionNamePO po : poList) {
            commoIds.add(po.getCommodityId());
        }
        logger.debug("\u67e5\u8be2\u5546\u54c1\u4fe1\u606f");
        CommodityPageBO xlsCommodityPageBO = new CommodityPageBO();
        BeanUtils.copyProperties((Object)selectXlsCommodityListPageBO, (Object)xlsCommodityPageBO);
        xlsCommodityPageBO.setCommodityIds(commoIds);
        xlsCommodityPageBO.setCommodityStatus("1");
        try {
            result = this.xlsCommodityManageService.selectXlsCommodity(xlsCommodityPageBO);
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5546\u54c1\u5217\u8868\u5206\u9875\u670d\u52a1\u62a5\u9519");
            logger.error("\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5546\u54c1\u5217\u8868\u5206\u9875\u670d\u52a1\u62a5\u9519");
            throw new BusinessException("9999", "\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5546\u54c1\u5217\u8868\u5206\u9875\u670d\u52a1\u62a5\u9519" + e.getMessage());
        }
        return result;
    }

    public XlsCommodityResBO selectXlsCommodityList(SelectXlsCommodityListReqBO selectXlsCommodityListPageBO) {
        XlsCommodityResBO result = new XlsCommodityResBO();
        logger.info("\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5546\u54c1\u5217\u8868\u670d\u52a1\u5165\u53c2=" + selectXlsCommodityListPageBO.toString());
        XlsCommodityReqBO xlsCommodityPageBO = new XlsCommodityReqBO();
        BeanUtils.copyProperties((Object)selectXlsCommodityListPageBO, (Object)xlsCommodityPageBO);
        try {
            XlsCommodityResBO xlsResult = this.xlsCommodityManageService.selectXlsCommodityNoPage(xlsCommodityPageBO);
            List boList = xlsResult.getRows();
            ArrayList<Long> commodityTypeIdList = new ArrayList<Long>();
            for (CommodityBO bo : boList) {
                commodityTypeIdList.add(bo.getCommodityTypeId());
            }
            GoodsCategoryQueryReqBO reqBO = new GoodsCategoryQueryReqBO();
            reqBO.setCommodityTypeIdList(commodityTypeIdList);
            logger.debug("\u8c03\u7528\u5546\u54c1\u7c7b\u76ee\u67e5\u8be2\u670d\u52a1");
            GoodsCategoryQueryResBO cateBO = this.goodsCategoryQueryService.goodsCategoryQuery(reqBO);
            logger.debug("\u5546\u54c1\u7c7b\u76ee\u67e5\u8be2\u670d\u52a1\u51fa\u53c2" + cateBO.toString());
            Map cateMap = cateBO.getRows();
            List<CommodityBO> xlsList = this.unitResult(boList, cateMap);
            result.setRespCode(xlsResult.getRespCode());
            result.setRespDesc(xlsResult.getRespDesc());
            result.setRows(xlsList);
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5546\u54c1\u5217\u8868\u5206\u9875\u670d\u52a1\u62a5\u9519" + e);
            throw new BusinessException("9999", "\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5546\u54c1\u5217\u8868\u5206\u9875\u670d\u52a1\u62a5\u9519" + e.getMessage());
        }
        return result;
    }

    public RspPageBaseBO<CommodityBO> selectXlsCommodityListPage(SelectXlsCommodityListPageBO selectXlsCommodityListPageBO) {
        logger.info("\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5546\u54c1\u5217\u8868\u5206\u9875\u670d\u52a1\u5165\u53c2=" + selectXlsCommodityListPageBO.toString());
        RspPageBaseBO result = new RspPageBaseBO();
        CommodityPageBO xlsCommodityPageBO = new CommodityPageBO();
        BeanUtils.copyProperties((Object)selectXlsCommodityListPageBO, (Object)xlsCommodityPageBO);
        try {
            RspPageBaseBO xlsResult = this.xlsCommodityManageService.selectXlsCommodity(xlsCommodityPageBO);
            List boList = xlsResult.getRows();
            ArrayList<Long> commodityTypeIdList = new ArrayList<Long>();
            for (CommodityBO bo : boList) {
                commodityTypeIdList.add(bo.getCommodityTypeId());
            }
            GoodsCategoryQueryReqBO reqBO = new GoodsCategoryQueryReqBO();
            reqBO.setCommodityTypeIdList(commodityTypeIdList);
            logger.debug("\u8c03\u7528\u5546\u54c1\u7c7b\u76ee\u67e5\u8be2\u670d\u52a1");
            GoodsCategoryQueryResBO cateBO = this.goodsCategoryQueryService.goodsCategoryQuery(reqBO);
            logger.debug("\u5546\u54c1\u7c7b\u76ee\u67e5\u8be2\u51fa\u53c2" + cateBO.getRespCode());
            Map cateMap = cateBO.getRows();
            List<CommodityBO> xlsList = this.unitResult(boList, cateMap);
            result.setRecordsTotal(xlsResult.getRecordsTotal());
            result.setRespCode(xlsResult.getRespCode());
            result.setRespDesc(xlsResult.getRespDesc());
            result.setTotal(xlsResult.getTotal());
            result.setRows(xlsList);
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5546\u54c1\u5217\u8868\u5206\u9875\u670d\u52a1\u62a5\u9519");
            throw new BusinessException("9999", "\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5546\u54c1\u5217\u8868\u5206\u9875\u670d\u52a1\u62a5\u9519" + e.getMessage());
        }
        return result;
    }

    public RspPageBaseBO<CommodityBO> selectXlsStatusCommodityListPage(SelectXlsCommodityListPageBO selectXlsCommodityListPageBO) {
        logger.info("\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5546\u54c1\u5217\u8868\u5206\u9875\u670d\u52a1\u5165\u53c2=" + selectXlsCommodityListPageBO.toString());
        RspPageBaseBO result = new RspPageBaseBO();
        CommodityPageBO xlsCommodityPageBO = new CommodityPageBO();
        BeanUtils.copyProperties((Object)selectXlsCommodityListPageBO, (Object)xlsCommodityPageBO);
        xlsCommodityPageBO.setCommodityStatus("1");
        try {
            result = this.xlsCommodityManageService.selectXlsCommodity(xlsCommodityPageBO);
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5546\u54c1\u5217\u8868\u5206\u9875\u670d\u52a1\u62a5\u9519");
            logger.error("\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5546\u54c1\u5217\u8868\u5206\u9875\u670d\u52a1\u62a5\u9519");
            throw new BusinessException("9999", "\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5546\u54c1\u5217\u8868\u5206\u9875\u670d\u52a1\u62a5\u9519" + e.getMessage());
        }
        return result;
    }

    public List<CommodityBO> unitResult(List<CommodityBO> boList, Map<Long, GoodsCategoryQueryBO> cateMap) {
        ArrayList<CommodityBO> result = new ArrayList<CommodityBO>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Map statusMap = this.sysParamTransferBusiService.sysParamTransferByParentCode("SYS_COMMODITY_ISBINDFODDER");
        for (CommodityBO xlsBO : boList) {
            GoodsCategoryQueryBO cateBO;
            CommodityBO bo = new CommodityBO();
            if (!cateMap.isEmpty() && (cateBO = cateMap.get(xlsBO.getCommodityTypeId())) != null) {
                bo.setGuideCatalogId(cateBO.getGuideCatalogId());
                bo.setParentCatalogName(cateBO.getParentCatalogName());
                bo.setCatalogName(cateBO.getCatalogName());
            }
            bo.setCommodityId(xlsBO.getCommodityId());
            bo.setSupplierShopId(xlsBO.getSupplierShopId());
            bo.setCommodityCode(xlsBO.getCommodityCode());
            bo.setCommodityLocation(xlsBO.getCommodityLocation());
            bo.setMaterialId(xlsBO.getMaterialId());
            bo.setCommodityTypeId(xlsBO.getCommodityTypeId());
            bo.setCommodityTypeName(xlsBO.getCommodityTypeName());
            bo.setSupplierId(xlsBO.getSupplierId());
            bo.setSupplierName(xlsBO.getSupplierName());
            bo.setCreateLoginId(xlsBO.getCreateLoginId());
            bo.setCreateTime(xlsBO.getCreateTime());
            bo.setCreateTimeStr(sdf.format(xlsBO.getCreateTime()));
            bo.setUpdateLoginId(xlsBO.getUpdateLoginId());
            bo.setUpdateTime(xlsBO.getUpdateTime());
            bo.setIsDelete(xlsBO.getIsDelete());
            bo.setRemark(xlsBO.getRemark());
            bo.setHasKnowledgeBaseStr((String)statusMap.get(xlsBO.getHasKnowledgeBase()));
            bo.setCommodityPropGrpId(xlsBO.getCommodityPropGrpId());
            bo.setCommodityLongName(xlsBO.getCommodityLongName());
            bo.setCommodityName(xlsBO.getCommodityName());
            bo.setCommodityLowestPrice(xlsBO.getCommodityLowestPrice());
            bo.setCommodityHighestPrice(xlsBO.getCommodityHighestPrice());
            bo.setCommodityBrand(xlsBO.getCommodityBrand());
            bo.setCommodityBrandId(xlsBO.getCommodityBrandId());
            bo.setCommodityMainPic(xlsBO.getCommodityMainPic());
            bo.setCommodityStatus(xlsBO.getCommodityStatus());
            bo.setCommodityStatusName(xlsBO.getCommodityStatusName());
            bo.setIsBindFodder(xlsBO.getIsBindFodder());
            bo.setIsBindSku(xlsBO.getIsBindSku());
            bo.setIsBindFodderName(xlsBO.getIsBindFodderName());
            bo.setHasKnowledgeBase(xlsBO.getHasKnowledgeBase());
            bo.setCommodityHighLight(xlsBO.getCommodityHighLight());
            bo.setCommodityMarketingSpeech(xlsBO.getCommodityMarketingSpeech());
            bo.setKnowledgeBasePic(xlsBO.getKnowledgeBasePic());
            result.add(bo);
        }
        return result;
    }

    public RspPageBO<XlsCommodityReqBO> selectCommodityByApplet(selectCommodityByAppletReqBO selectCommodityByAppletReqBO2) {
        RspPageBO xlsCommodityReqBORspPageBO;
        try {
            xlsCommodityReqBORspPageBO = selectCommodityByAppletReqBO2.getSupplierId() == null ? this.xlsCommodityManageService.selectCommodity(selectCommodityByAppletReqBO2) : this.xlsCommodityManageService.selectCommodityBySupplierId(selectCommodityByAppletReqBO2);
        }
        catch (Exception e) {
            logger.debug("selectCommodityByApplet\u670d\u52a1 \u67e5\u8be2spu\u5f02\u5e38");
            throw new BusinessException("9999", "selectCommodityByApplet\u670d\u52a1 \u67e5\u8be2spu\u5f02\u5e38" + e.getMessage());
        }
        return xlsCommodityReqBORspPageBO;
    }
}

