/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.newretail.bo.RspInfoListBO;
import com.tydic.newretail.bo.RspPageBO;
import com.tydic.newretail.bo.ShareAndBuyBO;
import com.tydic.newretail.bo.ShareAndBuyReqBO;
import com.tydic.newretail.bo.ShareAndBuyReqPageBO;
import com.tydic.newretail.busi.service.ShareAndBuyService;
import com.tydic.newretail.dao.DSkuShareBuyDAO;
import com.tydic.newretail.dao.SkuDAO;
import com.tydic.newretail.dao.po.SkuPO;
import com.tydic.newretail.dao.po.XlsShareAndByPO;
import com.tydic.newretail.exception.BusinessException;
import com.tydic.newretail.util.MoneyUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShareAndBuyServiceImpl
implements ShareAndBuyService {
    private static final Logger logger = LoggerFactory.getLogger(ShareAndBuyServiceImpl.class);
    @Autowired
    private DSkuShareBuyDAO dSkuShareBuyDAO;
    @Autowired
    private SkuDAO xlsSkuMapper;

    public RspInfoListBO<ShareAndBuyBO> getShareAndBuy(ShareAndBuyReqBO reqBO) {
        RspInfoListBO result = new RspInfoListBO();
        XlsShareAndByPO record = this.bo2PO(reqBO);
        List<XlsShareAndByPO> poList = null;
        logger.debug("\u67e5\u8be2\u8bb0\u5f55");
        try {
            poList = this.dSkuShareBuyDAO.selectShareAndBuy(reqBO.getSupplierIdList(), record);
        }
        catch (Exception e) {
            logger.error("\u5206\u4eab\u8bb0\u5f55\u67e5\u8be2\u5931\u8d25");
            throw new BusinessException("9999", "\u5206\u4eab\u8bb0\u5f55\u67e5\u8be2\u5931\u8d25" + e.getMessage());
        }
        if (CollectionUtils.isEmpty(poList)) {
            result.setRespCode("0000");
            result.setRespDesc("\u67e5\u65e0\u7ed3\u679c");
            return result;
        }
        List<Object> boList = new ArrayList();
        try {
            boList = this.getResult(poList);
        }
        catch (Exception e) {
            logger.error("\u5206\u4eab\u8bb0\u5f55\u67e5\u8be2\u5931\u8d25");
            throw new BusinessException("9999", "\u5206\u4eab\u8bb0\u5f55\u67e5\u8be2\u5931\u8d25" + e.getMessage());
        }
        result.setRespCode("0000");
        result.setRows(boList);
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        return result;
    }

    public RspPageBO<ShareAndBuyBO> getShareAndBuyByPage(ShareAndBuyReqPageBO reqBO) {
        logger.debug("\u5206\u4eab\u8bb0\u5f55\u67e5\u8be2 \u5165\u53c2\u4e3a:" + JSON.toJSONString((Object)reqBO));
        RspPageBO result = new RspPageBO();
        Page page = new Page();
        page.setLimit(reqBO.getPageSize());
        page.setOffset(reqBO.getOffset());
        XlsShareAndByPO record = this.pageBO2PO(reqBO);
        List<XlsShareAndByPO> poList = null;
        try {
            poList = this.dSkuShareBuyDAO.selectShareAndBuy(reqBO.getSupplierIdList(), record, (Page<XlsShareAndByPO>)page);
        }
        catch (Exception e) {
            logger.error("\u5206\u4eab\u8bb0\u5f55\u67e5\u8be2\u5931\u8d25");
            throw new BusinessException("9999", "\u5206\u4eab\u8bb0\u5f55\u67e5\u8be2\u5931\u8d25" + e.getMessage());
        }
        if (CollectionUtils.isEmpty(poList)) {
            result.setRespCode("0000");
            result.setRespDesc("\u67e5\u65e0\u7ed3\u679c");
            return result;
        }
        List<Object> boList = new ArrayList();
        try {
            boList = this.getResult(poList);
        }
        catch (Exception e) {
            logger.error("\u5206\u4eab\u8bb0\u5f55\u67e5\u8be2\u5931\u8d25");
            throw new BusinessException("9999", "\u5206\u4eab\u8bb0\u5f55\u67e5\u8be2\u5931\u8d25" + e.getMessage());
        }
        logger.debug("\u5206\u4eab\u8bb0\u5f55\u67e5\u8be2 \u51fa\u53c2\u4e3a:" + JSON.toJSONString(boList));
        result.setRecordsTotal(page.getTotalCount());
        result.setTotal(page.getTotalPages());
        result.setRows(boList);
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        return result;
    }

    public List<ShareAndBuyBO> getResult(List<XlsShareAndByPO> poList) throws Exception {
        ArrayList<Long> skuIds = new ArrayList<Long>();
        for (XlsShareAndByPO po : poList) {
            if (skuIds.contains(po.getSkuId())) continue;
            skuIds.add(po.getSkuId());
        }
        HashMap<Long, SkuPO> skuMap = new HashMap<Long, SkuPO>();
        logger.debug("\u67e5\u8be2sku\u4fe1\u606f");
        List<SkuPO> skuList = this.xlsSkuMapper.selectSkuBySkuIdList(skuIds);
        if (CollectionUtils.isNotEmpty(skuList)) {
            for (SkuPO sku : skuList) {
                if (skuMap.containsKey(sku.getSkuId())) continue;
                skuMap.put(sku.getSkuId(), sku);
            }
        }
        ShareAndBuyBO bo = null;
        ArrayList<ShareAndBuyBO> boList = new ArrayList<ShareAndBuyBO>();
        for (XlsShareAndByPO po : poList) {
            bo = new ShareAndBuyBO();
            if (po.getSkuId() != null) {
                bo.setSkuName(((SkuPO)skuMap.get(po.getSkuId())).getSkuName());
            }
            bo.setProvinceCode(po.getProvinceCode());
            bo.setShareBuyCount(po.getShareBuyCount());
            if (po.getShareBuyPriceCount() != null) {
                bo.setShareBuyPriceCount(MoneyUtils.Long2BigDecimal(po.getShareBuyPriceCount()));
            }
            bo.setShareCount(po.getShareCount());
            bo.setSharer(po.getSharer());
            bo.setSkuId(po.getSkuId());
            bo.setSupplierId(po.getSupplierId());
            boList.add(bo);
        }
        return boList;
    }

    public XlsShareAndByPO bo2PO(ShareAndBuyReqBO reqBO) {
        XlsShareAndByPO po = new XlsShareAndByPO();
        po.setEndTime(reqBO.getEndTime());
        po.setSharer(reqBO.getSharer());
        po.setStartTime(reqBO.getStartTime());
        return po;
    }

    public XlsShareAndByPO pageBO2PO(ShareAndBuyReqPageBO reqBO) {
        XlsShareAndByPO po = new XlsShareAndByPO();
        po.setEndTime(reqBO.getEndTime());
        po.setSharer(reqBO.getSharer());
        po.setStartTime(reqBO.getStartTime());
        return po;
    }
}

