/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.fastjson.JSONObject;
import com.tydic.newretail.bo.BaseRspBO;
import com.tydic.newretail.bo.BatchCreateSkuReqBO;
import com.tydic.newretail.bo.CreateSkuReqBO;
import com.tydic.newretail.bo.DPriceSheetBO;
import com.tydic.newretail.bo.DSkuBO;
import com.tydic.newretail.bo.ProvinceMaterialBO;
import com.tydic.newretail.bo.ShopIdAndShopNameBO;
import com.tydic.newretail.bo.SkuCreateByProvGoodsReqBO;
import com.tydic.newretail.busi.service.BatchCreateSkuService;
import com.tydic.newretail.busi.service.DPriceSheetService;
import com.tydic.newretail.busi.service.SkuCreateByProvGoodsService;
import com.tydic.newretail.busi.service.XlsSkuManageService;
import com.tydic.newretail.dao.ProvGoodsDAO;
import com.tydic.newretail.dao.ProvGoodsInsureServiceDAO;
import com.tydic.newretail.dao.ProvGoodsSupRelationDAO;
import com.tydic.newretail.dao.SkuDAO;
import com.tydic.newretail.dao.po.ProvGoodsAndSupplierPO;
import com.tydic.newretail.dao.po.ProvGoodsInsureServicePO;
import com.tydic.newretail.dao.po.ProvGoodsSupRelationPO;
import com.tydic.newretail.dao.po.SkuPO;
import com.tydic.newretail.exception.BusinessException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SkuCreateByProvGoodsServiceImpl
implements SkuCreateByProvGoodsService {
    private static final Logger logger = LoggerFactory.getLogger(SkuCreateByProvGoodsServiceImpl.class);
    @Autowired
    private ProvGoodsDAO provGoodsDAO;
    @Autowired
    private BatchCreateSkuService batchCreateSkuService;
    @Autowired
    private SkuDAO skuDAO;
    @Autowired
    private XlsSkuManageService xlsSkuManageService;
    @Autowired
    private ProvGoodsInsureServiceDAO provGoodsInsureServiceDAO;
    @Autowired
    private ProvGoodsSupRelationDAO provGoodsSupRelationDAO;
    @Autowired
    private DPriceSheetService dPriceSheetService;

    public BaseRspBO createSku(final SkuCreateByProvGoodsReqBO reqBO) {
        logger.debug("\u5165\u53c2" + JSONObject.toJSONString((Object)reqBO));
        logger.debug("\u95e8\u5e97\u5546\u54c1\u521b\u5efa");
        BaseRspBO result = new BaseRspBO();
        ProvGoodsAndSupplierPO record = new ProvGoodsAndSupplierPO();
        record.setProvinceCode(reqBO.getProvinceCode());
        List<Object> goods = new ArrayList();
        try {
            goods = this.provGoodsDAO.queryProvGoodsGroupNEW(record);
            logger.debug("\u7701\u4efd\u5546\u54c1\u6570\u91cf" + goods.size());
        }
        catch (Exception e) {
            logger.error("\u7701\u4efd\u5546\u54c1\u67e5\u8be2\u5931\u8d25");
            throw new BusinessException("9999", "\u7701\u4efd\u5546\u54c1\u67e5\u8be2\u5931\u8d25" + e.getMessage());
        }
        ArrayList<Long> shopIds = new ArrayList<Long>();
        ArrayList<String> cityCode = new ArrayList<String>();
        for (ShopIdAndShopNameBO shop : reqBO.getShops()) {
            shopIds.add(shop.getShopId());
            cityCode.add(shop.getCityCode());
        }
        logger.debug("\u67e5\u8be2\u5546\u54c1\u662f\u5426\u5b58\u5728");
        HashMap<String, Long> exitst = new HashMap<String, Long>();
        List<Object> skuList = Collections.synchronizedList(new ArrayList());
        if (!CollectionUtils.isEmpty(shopIds)) {
            skuList = this.skuDAO.queryXlsSkuByShopListNotIsDelete(shopIds);
            logger.debug("\u5df2\u5b58\u5728\u5546\u54c1" + skuList.size());
            if (!CollectionUtils.isEmpty(skuList)) {
                for (Object good : skuList) {
                    if (exitst.containsKey(((SkuPO)good).getSupplierId() + ((SkuPO)good).getMaterialId())) continue;
                    exitst.put(((SkuPO)good).getSupplierId() + ((SkuPO)good).getMaterialId(), ((SkuPO)good).getSkuId());
                }
            }
        }
        ArrayList<String> materialIds = new ArrayList<String>();
        if (!CollectionUtils.isEmpty(goods)) {
            for (ProvGoodsAndSupplierPO provGoodsAndSupplierPO : goods) {
                materialIds.add(provGoodsAndSupplierPO.getMaterialId());
            }
        }
        final AtomicReference atomSkuList = new AtomicReference(skuList);
        ProvinceMaterialBO provinceMaterialBO = new ProvinceMaterialBO();
        provinceMaterialBO.setProvinceCode(reqBO.getProvinceCode());
        provinceMaterialBO.setMaterialId(materialIds);
        provinceMaterialBO.setCityCodes(cityCode);
        Map priceSheet = this.dPriceSheetService.findDPriceSheet(provinceMaterialBO);
        int sumUpdate = 0;
        int sumAdd = 0;
        logger.debug("\u62a5\u4ef7\u5355" + priceSheet.size());
        ArrayList<Object> addSkuList = new ArrayList<CreateSkuReqBO>();
        ArrayList<Object> skuBOS = new ArrayList<DSkuBO>();
        final ExecutorService service = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2);
        if (!CollectionUtils.isEmpty(goods)) {
            for (ShopIdAndShopNameBO shop : reqBO.getShops()) {
                for (ProvGoodsAndSupplierPO provGoodsAndSupplierPO : goods) {
                    if (!StringUtils.isBlank((String)provGoodsAndSupplierPO.getMaterialId())) {
                        CreateSkuReqBO sku;
                        if (exitst.containsKey(shop.getShopId() + provGoodsAndSupplierPO.getMaterialId())) {
                            sku = this.toUpdateBO(provGoodsAndSupplierPO, shop.getShopId(), shop.getCityCode(), (Long)exitst.get(shop.getShopId() + provGoodsAndSupplierPO.getMaterialId()), shop.getCountyCode());
                            if (Objects.equals(provGoodsAndSupplierPO.getGoodsStatus(), "03")) {
                                sku.setIsDelete(Integer.valueOf(0));
                            } else if (Objects.equals(provGoodsAndSupplierPO.getGoodsStatus(), "04")) {
                                sku.setIsDelete(Integer.valueOf(1));
                            }
                            skuBOS.add((DSkuBO)sku);
                            if (skuBOS.size() < 18000) continue;
                            try {
                                ++sumUpdate;
                                this.updateSku(skuBOS, service);
                                skuBOS = new ArrayList();
                                continue;
                            }
                            catch (Exception e) {
                                service.shutdown();
                                logger.error("\u4fee\u6539\u5546\u54c1\u5931\u8d25");
                                throw new BusinessException("9999", "\u4fee\u6539\u5546\u54c1\u5931\u8d25" + e.getMessage());
                            }
                        }
                        sku = this.toAddBO(provGoodsAndSupplierPO, shop.getShopId(), shop.getCityCode(), shop.getShopName(), shop.getCountyCode(), priceSheet);
                        if (Objects.equals(provGoodsAndSupplierPO.getGoodsStatus(), "03")) {
                            sku.setIsDelete(String.valueOf(0));
                        } else if (Objects.equals(provGoodsAndSupplierPO.getGoodsStatus(), "04")) {
                            sku.setIsDelete(String.valueOf(1));
                        }
                        addSkuList.add(sku);
                        if (addSkuList.size() < 18000) continue;
                        try {
                            ++sumAdd;
                            this.addSku(addSkuList, service);
                            addSkuList = new ArrayList();
                            continue;
                        }
                        catch (Exception e) {
                            service.shutdown();
                            logger.error("\u65b0\u589e\u5546\u54c1\u5931\u8d25");
                            throw new BusinessException("9999", "\u65b0\u589e\u5546\u54c1\u5931\u8d25" + e.getMessage());
                        }
                    }
                    logger.debug("\u7269\u6599\u4e3a\u7a7a");
                }
            }
        }
        if (!CollectionUtils.isEmpty(skuBOS)) {
            try {
                logger.debug("\u6700\u540e\u4e00\u6279\u4fee\u6539sku\u76f8\u5173\u4fe1\u606f\uff0c\u5165\u53c2skuBOS\u5927\u5c0f\u4e3a\uff1a" + skuBOS.size());
                logger.debug("\u5171\u4fee\u6539\u4e86" + ++sumUpdate + "\u6279\u6570\u636e\u6570\u636e\u91cf\u4e3a\uff1a" + ((sumUpdate - 1) * 18000 + skuBOS.size()) + "\u6761\u6570\u636e");
                this.updateSku(skuBOS, service);
            }
            catch (Exception e) {
                service.shutdown();
                logger.error("\u4fee\u6539\u5546\u54c1\u5931\u8d25");
                throw new BusinessException("9999", "\u4fee\u6539\u5546\u54c1\u5931\u8d25" + e.getMessage());
            }
        }
        if (!CollectionUtils.isEmpty(addSkuList)) {
            try {
                logger.debug("\u6700\u540e\u4e00\u6279\u65b0\u589esku\u76f8\u5173\u4fe1\u606f\uff0c\u5165\u53c2addSkuList\u5927\u5c0f\u4e3a\uff1a" + addSkuList.size());
                logger.debug("\u5171\u65b0\u589e\u4e86" + ++sumAdd + "\u6279\u6570\u636e\u6570\u636e\u91cf\u4e3a\uff1a" + ((sumAdd - 1) * 18000 + addSkuList.size()) + "\u6761\u6570\u636e");
                this.addSku(addSkuList, service);
            }
            catch (Exception e) {
                service.shutdown();
                logger.error("\u65b0\u589e\u5546\u54c1\u5931\u8d25");
                throw new BusinessException("9999", "\u65b0\u589e\u5546\u54c1\u5931\u8d25" + e.getMessage());
            }
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SkuCreateByProvGoodsServiceImpl.this.createInsureGoods(reqBO.getShops(), (List)atomSkuList.get(), reqBO.getProvinceCode(), service);
                }
                catch (Exception e) {
                    logger.error("\u65b0\u589e\u4fdd\u969c\u670d\u52a1\u5546\u54c1\u5931\u8d25");
                    throw new BusinessException("9999", "\u65b0\u589e\u4fdd\u969c\u670d\u52a1\u5546\u54c1\u5931\u8d25" + e.getMessage());
                }
                finally {
                    service.shutdown();
                }
                logger.debug("\u4fdd\u969c\u670d\u52a1\u521b\u5efa\u5b8c\u6210");
            }
        }).start();
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        return result;
    }

    public DSkuBO toUpdateBO(ProvGoodsAndSupplierPO po, Long shopId, String cityCode, Long skuId, String countyCode) {
        DSkuBO skuBO = new DSkuBO();
        skuBO.setBrandId(po.getBrandId());
        skuBO.setBrandName(po.getBrandName());
        skuBO.setColor(po.getColorName());
        skuBO.setBrand(po.getBrandName());
        skuBO.setGoodsSource(po.getGoodsSource());
        skuBO.setModel(po.getGoodsModel());
        skuBO.setVendorId(po.getSupplierIds());
        skuBO.setVendorName(po.getSupplierName());
        skuBO.setSkuId(skuId);
        skuBO.setRam(po.getMemoryName());
        skuBO.setProvinceCode(po.getProvinceCode());
        skuBO.setCgType(po.getCgType());
        skuBO.setCityCode(cityCode);
        skuBO.setCountyCode(countyCode);
        skuBO.setExtSkuId(po.getExtGoodsNo());
        skuBO.setSkuCode(po.getGoodsNo());
        skuBO.setSkuName(po.getGoodsLongName());
        skuBO.setSkuLongName(po.getGoodsLongName());
        skuBO.setErpLongName(po.getGoodsLongName());
        skuBO.setSkuPriceTagName(po.getGoodsLongName());
        skuBO.setMfgSku(po.getGoodsModel());
        skuBO.setIsVirtualGood(po.getAllowNegativeStock());
        skuBO.setProvGoodsId(po.getProvGoodsId());
        skuBO.setSupplierId(shopId);
        skuBO.setIsDelete(Integer.valueOf(0));
        return skuBO;
    }

    public void updateSku(List<DSkuBO> skuBOS, ExecutorService service) throws Exception {
        int pointsDataLimit = 2000;
        Integer size = skuBOS.size();
        int part = size / pointsDataLimit;
        int len = size % pointsDataLimit == 0 ? part : part + 1;
        logger.debug("\u4fee\u6539\u5546\u54c1\u5171" + size + "\u6761\u6570\u636e\u3002\u5206" + len + "\u6761\u6267\u884c");
        for (int i = 0; i < len; ++i) {
            logger.debug("\u7b2c" + i + "\u6279\u6570\u636e");
            int start = i * pointsDataLimit;
            int end = start + pointsDataLimit;
            if (end > size) {
                end = size;
            }
            logger.debug("\u5f00\u59cb\u7ed3\u675f=" + start + "+" + end);
            List<DSkuBO> rows = skuBOS.subList(start, end);
            service.execute(() -> this.xlsSkuManageService.batchUpdate(rows));
        }
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public CreateSkuReqBO toAddBO(ProvGoodsAndSupplierPO po, Long shopId, String cityCode, String shopName, String countyCode, Map<String, DPriceSheetBO> priceSheet) {
        String key = po.getMaterialId() + po.getProvinceCode() + cityCode;
        DPriceSheetBO price = new DPriceSheetBO();
        if (!CollectionUtils.isEmpty(priceSheet)) {
            price = priceSheet.get(key.trim()) == null ? priceSheet.get(po.getMaterialId() + po.getProvinceCode()) : priceSheet.get(key.trim());
        }
        CreateSkuReqBO sku = new CreateSkuReqBO();
        sku.setBrandId(po.getBrandId());
        sku.setBrandName(po.getBrandName());
        sku.setColor(po.getColorName());
        sku.setModel(po.getGoodsModel());
        sku.setBrand(po.getBrandName());
        sku.setGoodsSource(po.getGoodsSource());
        sku.setCgType(po.getCgType());
        if (price != null) {
            sku.setSaleSrice(price.getSalePrice());
            sku.setSheetId(price.getSheetId());
            sku.setSheetLevel(price.getSheetLevel());
            sku.setAssessmentPrice(price.getAssessmentPrice());
            sku.setSparePrice1("1".equals(price.getSheetLevel()) ? null : price.getPurchasePrice());
            sku.setPurchasePrice("1".equals(price.getSheetLevel()) ? price.getPurchasePrice() : null);
            sku.setAgreementPrice(price.getAgreementPrice());
            sku.setMemberPrice(price.getMemberPrice());
        }
        sku.setCountyCode(countyCode);
        sku.setExtSkuId(po.getExtGoodsNo());
        sku.setSkuCode(po.getGoodsNo());
        sku.setRam(po.getMemoryName());
        sku.setMeasureId(po.getMeasureId());
        sku.setMeasureName(po.getMeasureName());
        sku.setFullName(po.getGoodsLongName());
        sku.setSupplierId(shopId);
        sku.setSupplierName(shopName);
        sku.setProvinceCode(po.getProvinceCode());
        sku.setCityCode(cityCode);
        sku.setName(po.getGoodsModel());
        sku.setIsVirtualGood(po.getAllowNegativeStock());
        sku.setMaterialId(po.getMaterialId());
        sku.setProvGoodsId(po.getProvGoodsId());
        sku.setVendorId(po.getSupplierIds());
        sku.setVendorName(po.getSupplierName());
        return sku;
    }

    public void addSku(List<CreateSkuReqBO> add, ExecutorService service) throws Exception {
        int pointsDataLimit = 2000;
        Integer size = add.size();
        int part = size / pointsDataLimit;
        int len = size % pointsDataLimit == 0 ? part : part + 1;
        logger.debug("\u65b0\u589e\u5546\u54c1\u5171" + size + "\u6761\u6570\u636e\u3002\u5206" + len + "\u6761\u6267\u884c");
        for (int i = 0; i < len; ++i) {
            logger.debug("\u7b2c" + i + "\u6279\u6570\u636e");
            int start = i * pointsDataLimit;
            int end = start + pointsDataLimit;
            if (end > size) {
                end = size;
            }
            logger.debug("\u5f00\u59cb\u7ed3\u675f=" + start + "+" + end);
            List<CreateSkuReqBO> rows = add.subList(start, end);
            service.execute(() -> {
                BatchCreateSkuReqBO batchCreateSkuReqBO = new BatchCreateSkuReqBO();
                batchCreateSkuReqBO.setCreateSkuReqBOs(rows);
                this.batchCreateSkuService.batchCreateSku(batchCreateSkuReqBO);
            });
        }
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void createInsureGoods(List<ShopIdAndShopNameBO> shops, List<SkuPO> skuList, String proviceCode, ExecutorService service) throws Exception {
        logger.debug("\u5efa\u5e97\u521b\u5efa\u4fdd\u969c\u670d\u52a1\u5f00\u59cb");
        ProvGoodsInsureServicePO record = new ProvGoodsInsureServicePO();
        record.setProvinceCode(proviceCode);
        record.setSecurityServicesStatus("01");
        List<ProvGoodsInsureServicePO> poList = this.provGoodsInsureServiceDAO.selectSelectiveAll(record);
        ArrayList<Long> provGoodsId = new ArrayList<Long>();
        if (CollectionUtils.isEmpty(poList)) {
            return;
        }
        for (ProvGoodsInsureServicePO in : poList) {
            provGoodsId.add(in.getProvGoodsId());
        }
        List<ProvGoodsSupRelationPO> supplier = this.provGoodsSupRelationDAO.selectByProvGoodsIds(provGoodsId);
        HashMap<Long, ProvGoodsSupRelationPO> supplierMap = new HashMap<Long, ProvGoodsSupRelationPO>();
        for (ProvGoodsSupRelationPO provGoodsSupRelationPO : supplier) {
            supplierMap.put(provGoodsSupRelationPO.getProvGoodsId(), provGoodsSupRelationPO);
        }
        ArrayList<Long> shopIds = new ArrayList<Long>();
        for (ShopIdAndShopNameBO shopIdAndShopNameBO : shops) {
            shopIds.add(shopIdAndShopNameBO.getShopId());
        }
        logger.debug("\u67e5\u8be2\u5546\u54c1\u662f\u5426\u5b58\u5728");
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        if (!CollectionUtils.isEmpty(shopIds)) {
            skuList = this.skuDAO.queryXlsSkuByShopListNotIsDelete(shopIds);
            logger.debug("\u5df2\u5b58\u5728\u5546\u54c1" + skuList.size());
            if (!CollectionUtils.isEmpty(skuList)) {
                for (SkuPO skuPO : skuList) {
                    if (hashMap.containsKey(skuPO.getSupplierId() + skuPO.getMaterialId())) continue;
                    hashMap.put(skuPO.getSupplierId() + skuPO.getMaterialId(), skuPO.getSkuId());
                }
            }
        }
        ArrayList<CreateSkuReqBO> arrayList = new ArrayList<CreateSkuReqBO>();
        for (ProvGoodsInsureServicePO po : poList) {
            for (ShopIdAndShopNameBO shop : shops) {
                if (hashMap.containsKey(shop.getShopId() + po.getMaterialId())) continue;
                CreateSkuReqBO sku = new CreateSkuReqBO();
                if ("01".equals(po.getSecurityServicesStatus())) {
                    sku.setIsDelete("0");
                } else {
                    sku.setIsDelete("1");
                }
                sku.setModel(po.getGoodsLongName());
                sku.setGoodsSource("00");
                sku.setCgType("0");
                sku.setSaleSrice(po.getRealityPrice());
                sku.setAssessmentPrice(po.getLimitPrice());
                sku.setSparePrice1(po.getPurchasePrice());
                sku.setAgreementPrice(po.getSalePrice());
                sku.setCountyCode(shop.getCountyCode());
                sku.setFullName(po.getGoodsLongName());
                sku.setSupplierId(shop.getShopId());
                sku.setSupplierName(shop.getShopName());
                sku.setProvinceCode(proviceCode);
                sku.setCityCode(shop.getCityCode());
                sku.setName(po.getGoodsLongName());
                sku.setIsVirtualGood("05".equals(po.getSecurityServicesType()) ? "0" : "1");
                sku.setMaterialId(po.getMaterialId());
                sku.setProvGoodsId(po.getProvGoodsId());
                sku.setVendorId(((ProvGoodsSupRelationPO)supplierMap.get(po.getProvGoodsId())).getSupplierId().toString());
                sku.setVendorName(((ProvGoodsSupRelationPO)supplierMap.get(po.getProvGoodsId())).getSupplierName());
                arrayList.add(sku);
            }
        }
        if (!CollectionUtils.isEmpty(arrayList)) {
            try {
                logger.debug("\u4fdd\u969c\u670d\u52a1\u65b0\u589esku\u548cskuPrice\u5165\u53c2addSkuList\u5927\u5c0f\u4e3a\uff1a" + arrayList.size());
                this.addSku(arrayList, service);
            }
            catch (Exception exception) {
                logger.error("\u65b0\u589e\u4fdd\u969c\u670d\u52a1\u5546\u54c1\u5931\u8d25");
                throw new BusinessException("9999", "\u65b0\u589e\u4fdd\u969c\u670d\u52a1\u5546\u54c1\u5931\u8d25" + exception.getMessage());
            }
            logger.debug("\u521b\u5efasku\u5b8c\u6210");
        }
    }
}

