/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.tydic.newretail.bo.BaseRspBO;
import com.tydic.newretail.bo.CommodityBO;
import com.tydic.newretail.bo.skuPriceMaxPriceAndMinPriceBO;
import com.tydic.newretail.busi.service.SortCommodityPriceService;
import com.tydic.newretail.busi.service.XlsCommodityManageService;
import com.tydic.newretail.busi.service.XlsSkuManageService;
import com.tydic.newretail.dao.CommodityDAO;
import com.tydic.newretail.dao.po.CommodityPO;
import com.tydic.newretail.exception.BusinessException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SortCommodityPriceServiceImpl
implements SortCommodityPriceService {
    @Autowired
    private XlsCommodityManageService xlsCommodityManageService;
    @Autowired
    private CommodityDAO commodityDAO;
    @Autowired
    private XlsSkuManageService xlsSkuManageService;
    private static final Logger logger = LoggerFactory.getLogger(SortCommodityPriceServiceImpl.class);

    public BaseRspBO sortCommodityPrice(Long commodityId) {
        skuPriceMaxPriceAndMinPriceBO skuPriceMaxPriceAndMinPriceBO2;
        BaseRspBO baseRspBO = new BaseRspBO();
        try {
            skuPriceMaxPriceAndMinPriceBO2 = this.xlsSkuManageService.selectSkuPriceMaxPriceAndMinPrice(commodityId);
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u5546\u54c1ID\u67e5\u8be2\u5355\u54c1\u5217\u8868\u5355\u54c1\u670d\u52a1\u62a5\u9519");
            throw new BusinessException("9999", "\u5355\u6761\u4fee\u6539\u5355\u54c1\u670d\u52a1\u62a5\u9519" + e.getMessage());
        }
        CommodityBO xlsCommodityBO = new CommodityBO();
        if (Objects.equals(skuPriceMaxPriceAndMinPriceBO2.getSkuCount(), 0)) {
            xlsCommodityBO.setIsBindSku("0");
            xlsCommodityBO.setCommodityId(commodityId);
        } else {
            xlsCommodityBO.setCommodityLowestPrice(skuPriceMaxPriceAndMinPriceBO2.getMinPrice());
            xlsCommodityBO.setCommodityHighestPrice(skuPriceMaxPriceAndMinPriceBO2.getMaxPrice());
            xlsCommodityBO.setCommodityId(commodityId);
            xlsCommodityBO.setIsBindSku("1");
        }
        try {
            this.xlsCommodityManageService.updateXlsCommodity(xlsCommodityBO);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u5546\u54c1\u7684\u6700\u9ad8\u4ef7\u548c\u6700\u4f4e\u4ef7\u670d\u52a1\u62a5\u9519");
            throw new BusinessException("9999", "\u4fee\u6539\u5546\u54c1\u7684\u6700\u9ad8\u4ef7\u548c\u6700\u4f4e\u4ef7\u670d\u52a1\u62a5\u9519" + e.getMessage());
        }
        baseRspBO.setRespCode("0000");
        baseRspBO.setRespDesc("\u6210\u529f");
        return baseRspBO;
    }

    public BaseRspBO sortCommodityPrice(List<Long> commodityIds) {
        BaseRspBO baseRspBO = new BaseRspBO();
        List skuPriceMaxPriceAndMinPriceBOS = new ArrayList();
        try {
            skuPriceMaxPriceAndMinPriceBOS = this.xlsSkuManageService.batchSelectSkuPriceMaxPriceAndMinPrice(commodityIds);
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u5546\u54c1ID\u5217\u8868\u67e5\u8be2\u5355\u54c1\u5217\u8868\u670d\u52a1\u62a5\u9519");
            throw new BusinessException("8888", "\u6839\u636e\u5546\u54c1ID\u5217\u8868\u67e5\u8be2\u5355\u54c1\u5217\u8868\u670d\u52a1\u62a5\u9519");
        }
        ArrayList<CommodityPO> xlsCommodityPOs = new ArrayList<CommodityPO>();
        if (CollectionUtils.isNotEmpty(skuPriceMaxPriceAndMinPriceBOS)) {
            for (skuPriceMaxPriceAndMinPriceBO skuPriceMaxPriceAndMinPriceBO2 : skuPriceMaxPriceAndMinPriceBOS) {
                CommodityPO xlsCommodityPO = new CommodityPO();
                logger.debug("sku\u6570\u91cf=================\uff1a" + skuPriceMaxPriceAndMinPriceBO2.getSkuCount());
                if (Objects.equals(skuPriceMaxPriceAndMinPriceBO2.getSkuCount(), 0)) {
                    xlsCommodityPO.setIsBindSku("0");
                    xlsCommodityPO.setCommodityId(skuPriceMaxPriceAndMinPriceBO2.getCommodityId());
                } else {
                    xlsCommodityPO.setCommodityId(skuPriceMaxPriceAndMinPriceBO2.getCommodityId());
                    xlsCommodityPO.setIsBindSku("1");
                    xlsCommodityPO.setCommodityLowestPrice(skuPriceMaxPriceAndMinPriceBO2.getMinPrice());
                    xlsCommodityPO.setCommodityHighestPrice(skuPriceMaxPriceAndMinPriceBO2.getMaxPrice());
                }
                xlsCommodityPOs.add(xlsCommodityPO);
            }
            try {
                this.commodityDAO.batchUpdateByPrimaryKeySelective(xlsCommodityPOs);
            }
            catch (Exception e) {
                logger.error("\u6279\u91cf\u4fee\u6539\u5546\u54c1\u7684\u6700\u9ad8\u4ef7\u548c\u6700\u4f4e\u4ef7\u62a5\u9519");
                throw new BusinessException("8888", "\u6279\u91cf\u4fee\u6539\u5546\u54c1\u7684\u6700\u9ad8\u4ef7\u548c\u6700\u4f4e\u4ef7\u62a5\u9519");
            }
        }
        baseRspBO.setRespCode("0000");
        baseRspBO.setRespDesc("\u6210\u529f");
        return baseRspBO;
    }
}

