/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.tydic.newretail.bo.BaseRspBO;
import com.tydic.newretail.bo.DDimensionNameBO;
import com.tydic.newretail.bo.DimensionAndPropBO;
import com.tydic.newretail.busi.service.DDimensionNameManageService;
import com.tydic.newretail.busi.service.RDimensionRecordManageService;
import com.tydic.newretail.busi.service.UpdateDimensionNameAndSkuNameService;
import com.tydic.newretail.busi.service.XlsElectronicPricePushBusiService;
import com.tydic.newretail.dao.SkuDAO;
import com.tydic.newretail.dao.SkuSpecDAO;
import com.tydic.newretail.dao.po.SkuPO;
import com.tydic.newretail.dao.po.SkuSpecPO;
import com.tydic.newretail.exception.BusinessException;
import com.tydic.newretail.thread.PushElectronicPriceTagThread;
import com.tydic.newretail.util.CreateThreadUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UpdateDimensionNameAndSkuNameServiceImpl
implements UpdateDimensionNameAndSkuNameService {
    @Autowired
    private RDimensionRecordManageService rDimensionRecordManageService;
    @Autowired
    private DDimensionNameManageService dDimensionNameManageService;
    @Autowired
    private SkuSpecDAO skuSpecDAO;
    @Autowired
    private XlsElectronicPricePushBusiService xlsElectronicPricePushBusiService;
    @Autowired
    private SkuDAO skuDAO;
    private static final Logger logger = LoggerFactory.getLogger(UpdateDimensionNameAndSkuNameServiceImpl.class);

    public BaseRspBO updateDimensionNameAndSkuName(DimensionAndPropBO dimensionAndPropBO) {
        logger.info("\u4fee\u6539\u5546\u54c1\u5355\u4e2a\u7ef4\u5ea6\u7ec4\u5408\u7684\u540d\u79f0\u548c\u7ef4\u5ea6\u7ed1\u5b9a\u7684\u5355\u54c1\u7684\u540d\u79f0\u5165\u53c2=" + dimensionAndPropBO.toString());
        BaseRspBO baseRspBO = new BaseRspBO();
        List propValueListIds = dimensionAndPropBO.getPropValueListIds();
        logger.info("\u8981\u4fee\u6539\u7684\u7ef4\u5ea6\u7ec4\u5408ID\u5217\u8868\u4e3a=" + propValueListIds.toString());
        int num = propValueListIds.size();
        List rDimensionRecordBOs = null;
        try {
            rDimensionRecordBOs = this.rDimensionRecordManageService.selectByPropValueListIds(propValueListIds);
        }
        catch (Exception e) {
            logger.error("\u901a\u8fc7\u7ef4\u5ea6\u503cID\u5217\u8868\u67e5\u8be2\u7ef4\u5ea6\u548c\u540d\u79f0\u5bf9\u5e94\u5173\u7cfb\u62a5\u9519");
            throw new BusinessException("9999", "\u901a\u8fc7\u7ef4\u5ea6\u503cID\u5217\u8868\u67e5\u8be2\u7ef4\u5ea6\u548c\u540d\u79f0\u5bf9\u5e94\u5173\u7cfb\u62a5\u9519" + e.getMessage());
        }
        HashMap<Long, Integer> mapDimensionId = new HashMap<Long, Integer>();
        if (CollectionUtils.isNotEmpty((Collection)rDimensionRecordBOs)) {
            for (Object rDimensionRecordBO : rDimensionRecordBOs) {
                if (mapDimensionId.containsKey(rDimensionRecordBO.getDimensionId())) {
                    mapDimensionId.put(rDimensionRecordBO.getDimensionId(), (Integer)mapDimensionId.get(rDimensionRecordBO.getDimensionId()) + 1);
                    continue;
                }
                mapDimensionId.put(rDimensionRecordBO.getDimensionId(), 1);
            }
        }
        logger.info("\u67e5\u8be2\u51fa\u6765\u7684\u7ef4\u5ea6\u7ec4\u5408\u7684\u540d\u79f0\u53ca\u7ef4\u5ea6\u503cID\u7684map=" + ((Object)mapDimensionId).toString());
        Long dimensionId = null;
        for (Map.Entry entry : mapDimensionId.entrySet()) {
            if ((Integer)entry.getValue() < num) continue;
            dimensionId = (Long)entry.getKey();
        }
        if (dimensionId != null) {
            logger.debug("\u6839\u636e\u7ef4\u5ea6\u7ec4\u5408\u7684ID\u5217\u8868\u67e5\u5230\u4e86\u7ef4\u5ea6\u7ec4\u5408\u540d\u79f0");
            logger.debug("1.\u6839\u636e\u7ef4\u5ea6\u7ec4\u5408ID\u4fee\u6539\u7ef4\u5ea6\u7ec4\u5408\u7684\u540d\u79f0\u548c\u5168\u79f0");
            DDimensionNameBO dDimensionNameBO = new DDimensionNameBO();
            dDimensionNameBO.setDimensionId(dimensionId);
            dDimensionNameBO.setDimensionName(dimensionAndPropBO.getDimensionName());
            dDimensionNameBO.setDimensionLongName(dimensionAndPropBO.getDimensionLongName());
            try {
                this.dDimensionNameManageService.updateDimensionName(dDimensionNameBO);
            }
            catch (Exception exception) {
                logger.error("\u6839\u636e\u7ef4\u5ea6\u7ec4\u5408ID\u4fee\u6539\u7ef4\u5ea6\u7ec4\u5408\u7684\u540d\u79f0\u62a5\u9519");
                throw new BusinessException("9999", "\u6839\u636e\u7ef4\u5ea6\u7ec4\u5408ID\u4fee\u6539\u5546\u54c1\u7ef4\u5ea6\u7ec4\u5408\u7684\u540d\u79f0\u62a5\u9519" + exception.getMessage());
            }
        }
        ArrayList<SkuSpecPO> record = new ArrayList<SkuSpecPO>();
        for (Long propValueListId : propValueListIds) {
            SkuSpecPO skuSpec = new SkuSpecPO();
            skuSpec.setPropValueListId(propValueListId);
            skuSpec.setCommodityId(dimensionAndPropBO.getCommodityId());
            record.add(skuSpec);
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        List<SkuSpecPO> skuSpecs = null;
        try {
            skuSpecs = this.skuSpecDAO.selectByMany(record);
        }
        catch (Exception e) {
            logger.error("\u901a\u8fc7\u7ef4\u5ea6\u503cID\u5217\u8868\u67e5\u8be2\u7ef4\u5ea6\u548c\u540d\u79f0\u5bf9\u5e94\u5173\u7cfb\u62a5\u9519");
            throw new BusinessException("9999", "\u901a\u8fc7\u7ef4\u5ea6\u503cID\u5217\u8868\u67e5\u8be2\u7ef4\u5ea6\u548c\u540d\u79f0\u5bf9\u5e94\u5173\u7cfb\u62a5\u9519" + e.getMessage());
        }
        HashMap<Long, Long> mapSupplierId = new HashMap<Long, Long>();
        if (CollectionUtils.isNotEmpty(skuSpecs)) {
            HashMap<Long, Integer> mapskuId = new HashMap<Long, Integer>();
            for (SkuSpecPO skuSpecPO : skuSpecs) {
                mapSupplierId.put(skuSpecPO.getSkuId(), skuSpecPO.getSupplierId());
                if (mapskuId.containsKey(skuSpecPO.getSkuId())) {
                    mapskuId.put(skuSpecPO.getSkuId(), (Integer)mapskuId.get(skuSpecPO.getSkuId()) + 1);
                    continue;
                }
                mapskuId.put(skuSpecPO.getSkuId(), 1);
            }
            for (Map.Entry entry : mapskuId.entrySet()) {
                if ((Integer)entry.getValue() < num) continue;
                arrayList.add((Long)entry.getKey());
            }
        }
        if (CollectionUtils.isNotEmpty(arrayList)) {
            logger.debug("2.\u6839\u636e\u7ef4\u5ea6\u7ec4\u5408\u540d\u79f0ID\u4fee\u6539\u7ef4\u5ea6\u7ec4\u5408\u7684\u540d\u79f0\u548c\u5168\u79f0");
            SkuPO sku = new SkuPO();
            sku.setSkuName(dimensionAndPropBO.getDimensionName());
            sku.setSkuLongName(dimensionAndPropBO.getDimensionLongName());
            sku.setSkuPriceTagName(dimensionAndPropBO.getDimensionName());
            try {
                this.skuDAO.updateBySkuIds(sku, arrayList);
            }
            catch (Exception e) {
                logger.error("\u6839\u636eskuIds\u4fee\u6539\u5355\u54c1\u7684\u7b80\u79f0\u5168\u79f0\u7535\u5b50\u4ef7\u7b7e\u540d\u79f0\u62a5\u9519\u51fa\u9519");
                throw new BusinessException("9999", "\u6839\u636eskuIds\u4fee\u6539\u5355\u54c1\u7684\u7b80\u79f0\u5168\u79f0\u7535\u5b50\u4ef7\u7b7e\u540d\u79f0\u62a5\u9519\u51fa\u9519" + e.getMessage());
            }
            PushElectronicPriceTagThread pushElectronicPriceTagThread = new PushElectronicPriceTagThread(this.xlsElectronicPricePushBusiService, null, null, arrayList);
            ExecutorService executorService = CreateThreadUtils.createSimpleThreadPool(pushElectronicPriceTagThread, "pushElectronicPriceTagThread", 1, 1);
            executorService.execute(() -> logger.debug(Thread.currentThread().getName()));
            executorService.shutdown();
        }
        baseRspBO.setRespCode("0000");
        baseRspBO.setRespDesc("\u6210\u529f");
        return baseRspBO;
    }
}

