/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.newretail.bo.BaseRspBO;
import com.tydic.newretail.bo.UpdateProvGoodsBO;
import com.tydic.newretail.busi.service.UpdateProvGoodsService;
import com.tydic.newretail.dao.ProvGoodsDAO;
import com.tydic.newretail.dao.po.ProvGoodsPO;
import com.tydic.newretail.exception.BusinessException;
import com.tydic.newretail.toolkit.bo.InvokeInfo;
import com.tydic.newretail.toolkit.util.TKGenericServiceUtils;
import com.tydic.newretail.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UpdateProvGoodsServiceImpl
implements UpdateProvGoodsService {
    private static final Logger logger = LoggerFactory.getLogger(UpdateProvGoodsServiceImpl.class);
    @Autowired
    private ProvGoodsDAO provGoodsDAO;
    @Value(value="${hsf.version}")
    private String hsfVersion;
    @Value(value="${hsf.group}")
    private String hsfGroup;
    @Value(value="${hsf.clientTimeout}")
    private String hsfClientTimeout;

    public BaseRspBO updateProvGoodsByHasSerialNumber(UpdateProvGoodsBO provGoodsBO) {
        BaseRspBO result;
        block7: {
            result = new BaseRspBO();
            logger.info("updateProvGoodsByHasSerialNumber\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)provGoodsBO));
            try {
                List provGoodsIds = provGoodsBO.getProvGoodsId();
                this.check(provGoodsBO, provGoodsIds);
                ArrayList<ProvGoodsPO> provGoodsPOs = new ArrayList<ProvGoodsPO>(provGoodsIds.size());
                List<ProvGoodsPO> provGoodsPOList = this.provGoodsDAO.selectByProvGoodsIds(provGoodsIds);
                if (CollectionUtils.isEmpty(provGoodsPOList)) {
                    logger.error("provGoodsPOList is null");
                    throw new BusinessException("8888", "ProvGoodsId(\u7701\u4efd\u5546\u54c1ID)\u4fe1\u606f\u4e0d\u5b58\u5728");
                }
                provGoodsPOList.forEach(provGoodsPO -> {
                    if (null == provGoodsPO || StringUtils.isEmpty(provGoodsPO.getMaterialId()).booleanValue() || StringUtils.isEmpty(provGoodsPO.getProvinceCode()).booleanValue()) {
                        throw new BusinessException("8888", "ProvGoodsId(\u7701\u4efd\u5546\u54c1ID)\u4fe1\u606f\u4e0d\u5b58\u5728");
                    }
                    ProvGoodsPO pGoodsPO = new ProvGoodsPO();
                    pGoodsPO.setProvGoodsId(provGoodsPO.getProvGoodsId());
                    pGoodsPO.setProvinceCode(provGoodsPO.getProvinceCode());
                    pGoodsPO.setMaterialId(provGoodsPO.getMaterialId());
                    if (StringUtils.isEmpty(provGoodsBO.getHasSerialNumber()).booleanValue() && !StringUtils.isEmpty(provGoodsBO.getAllowNegativeStock()).booleanValue()) {
                        pGoodsPO.setHasSerialNumber(provGoodsPO.getHasSerialNumber());
                        pGoodsPO.setAllowNegativeStock(provGoodsBO.getAllowNegativeStock());
                    } else {
                        pGoodsPO.setHasSerialNumber(provGoodsBO.getHasSerialNumber());
                        pGoodsPO.setAllowNegativeStock(provGoodsPO.getAllowNegativeStock());
                    }
                    provGoodsPOs.add(pGoodsPO);
                });
                if (!this.isRepertoryEmpty(provGoodsPOList)) {
                    throw new BusinessException("8888", "\u542b\u9884\u5360\u3001\u5728\u9014\u3001\u53ef\u552e\u3001\u5df2\u552e,\u5546\u54c1\u4e0d\u53ef\u53d8\u66f4");
                }
                logger.info("updateHasSerialNumberSelective \u66f4\u65b0\u53c2\u6570:{}", (Object)JSON.toJSONString(provGoodsPOs));
                int rt = 0;
                logger.info("\u5f00\u59cb\u6267\u884c\u66f4\u65b0\u8bed\u53e5");
                rt = this.provGoodsDAO.updateHasSerialNumberAndAllowNegativeStock(provGoodsPOs, provGoodsBO.getHasSerialNumber(), provGoodsBO.getAllowNegativeStock());
                logger.info("\u66f4\u65b0\u8bed\u53e5\u6267\u884c\u5b8c\u6210");
                if (rt > 0) {
                    logger.info("\u66f4\u65b0\u6210\u529f\uff0c\u6b63\u5728\u8fdb\u884c\u6821\u9a8c");
                    List<JSONObject> params = this.buildParamter(provGoodsPOs);
                    for (JSONObject jsonObject : params) {
                        JSONObject jSONObjectValue = this.invokeUpdateImsiFlag(jsonObject);
                        if (null != jSONObjectValue && "0000".equals(jSONObjectValue.getString("respCode"))) continue;
                        logger.error("\u66f4\u65b0\u540e\u540c\u6b65\u5931\u8d25\uff0c\u6574\u4f53\u56de\u6eda");
                        throw new BusinessException("8888", "\u7701\u5546\u54c1\u4fe1\u606f\u662f\u5426\u6709\u4e32\u53f7\u66f4\u65b0\u540c\u6b65\u5e93\u5b58\u5931\u8d25");
                    }
                    break block7;
                }
                throw new BusinessException("8888", "\u7701\u5546\u54c1\u4fe1\u606f\u662f\u5426\u6709\u4e32\u53f7\u66f4\u65b0\u5931\u8d25");
            }
            catch (BusinessException ex) {
                result.setRespCode(ex.getMsgCode());
                result.setRespDesc(ex.getMsgInfo());
                logger.error("updateProvGoodsByHasSerialNumber \u4e1a\u52a1\u5f02\u5e38:", (Throwable)ex);
                return result;
            }
            catch (Exception ex) {
                result.setRespCode("8888");
                result.setRespDesc("\u5931\u8d25");
                logger.error("updateProvGoodsByHasSerialNumber \u7cfb\u7edf\u5f02\u5e38:", (Throwable)ex);
                return result;
            }
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        return result;
    }

    public void check(UpdateProvGoodsBO provGoodsBO, List<Long> provGoodsIds) {
        if (CollectionUtils.isEmpty(provGoodsIds)) {
            logger.error("provGoodsIds\u65b9\u6cd5\u4f20\u5165\u7684\u53c2\u6570\u4e3a\u7a7a");
            throw new BusinessException("8888", "ProvGoodsId(\u7701\u4efd\u5546\u54c1ID)\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty(provGoodsBO.getHasSerialNumber()).booleanValue() && StringUtils.isEmpty(provGoodsBO.getAllowNegativeStock()).booleanValue()) {
            logger.error("\u4f20\u5165\u7684\u662f\u5426\u6709\u4e32\u53f7\u548c\u662f\u5426\u5141\u8bb8\u8d1f\u5e93\u5b58\u53c2\u6570\u90fd\u4e3a\u7a7a");
            throw new BusinessException("8888", "\u4f20\u5165\u7684\u662f\u5426\u6709\u4e32\u53f7\u548c\u662f\u5426\u5141\u8bb8\u8d1f\u5e93\u5b58\u53c2\u6570\u5fc5\u987b \u6709\u4e00\u4e2a \u6709\u503c");
        }
        List<String> hasSerialNumbers = Arrays.asList("1", "0");
        List<String> AllowNegativeStock = Arrays.asList("1", "0");
        if (!hasSerialNumbers.contains(provGoodsBO.getHasSerialNumber()) && !AllowNegativeStock.contains(provGoodsBO.getAllowNegativeStock())) {
            logger.error("\u662f\u5426\u6709\u4e32\u53f7\u53ea\u80fd\u53d6\u503c 1(\u6709) 0(\u65e0)\u548c\u4f20\u5165\u662f\u5426\u5141\u8bb8\u8d1f\u5e93\u5b58\u7684\u53c2\u6570\u53ea\u80fd\u53d6\u503c 1(\u5141\u8bb8) 0(\u4e0d\u5141\u8bb8)");
            throw new BusinessException("8888", "\u662f\u5426\u6709\u4e32\u53f7\u53ea\u80fd\u53d6\u503c 1(\u6709) 0(\u65e0)\u548c\u662f\u5426\u5141\u8bb8\u8d1f\u5e93\u5b58\u7684\u53c2\u6570\u53ea\u80fd\u53d6\u503c 1(\u5141\u8bb8) 0(\u4e0d\u5141\u8bb8),\u8bf7\u68c0\u67e5\u4f20\u5165\u53c2\u6570\u662f\u5426\u6b63\u786e");
        }
    }

    private final List<JSONObject> buildParamter(List<ProvGoodsPO> provGoods) {
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        Map<String, List<ProvGoodsPO>> provinceCodeMapGoodsList = provGoods.stream().collect(Collectors.groupingBy(ProvGoodsPO::getProvinceCode));
        Set<Map.Entry<String, List<ProvGoodsPO>>> set = provinceCodeMapGoodsList.entrySet();
        for (Map.Entry<String, List<ProvGoodsPO>> mapEntry : set) {
            if (null == mapEntry) continue;
            String provinceId = mapEntry.getKey();
            JSONArray provGoodsList = new JSONArray();
            mapEntry.getValue().forEach(provGoodsPO -> {
                JSONObject provGoodsObject = new JSONObject();
                provGoodsObject.put("materialId", (Object)provGoodsPO.getMaterialId());
                provGoodsObject.put("imsiFlag", (Object)provGoodsPO.getHasSerialNumber());
                provGoodsObject.put("negativeFlag", (Object)provGoodsPO.getAllowNegativeStock());
                provGoodsList.add((Object)provGoodsObject);
            });
            JSONObject provGoodsListMap = new JSONObject();
            provGoodsListMap.put("provinceId", (Object)provinceId);
            provGoodsListMap.put("flags", (Object)provGoodsList);
            list.add(provGoodsListMap);
        }
        return list;
    }

    private final JSONObject invokeUpdateImsiFlag(JSONObject param) {
        return this.invoke("com.tydic.smc.api.ability.SmcUpdateImsiFlagAbilityService", "updateImsiFlagByMaterialIds", "com.tydic.smc.api.ability.bo.SmcUpdateImsiFlagBO", param);
    }

    private final JSONObject invoke(String beanName, String methodName, String paramType, JSONObject param) {
        JSONObject resultData = null;
        try {
            InvokeInfo invokeInfo = new InvokeInfo(beanName, methodName, paramType);
            invokeInfo.setVersion(this.hsfVersion);
            invokeInfo.setGroup(this.hsfGroup);
            invokeInfo.setClientTimeout(Integer.valueOf(this.hsfClientTimeout));
            invokeInfo.setRegisterType("2");
            resultData = TKGenericServiceUtils.genericServiceInvoke((String)JSONObject.toJSONString((Object)param), null, (InvokeInfo)invokeInfo);
            logger.debug("\u8fdb\u884c\u6cdb\u5316\u8c03\u7528" + resultData);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("TKGenericServiceUtils.genericServiceInvoke exception params jsonObject:", (Object)JSONObject.toJSONString((Object)param));
            logger.error("" + beanName + "\uff1a" + e);
        }
        return resultData;
    }

    private final boolean isRepertoryEmpty(List<ProvGoodsPO> provGoodsPOList) {
        logger.debug("\u67e5\u8be2\u5230\u7701\u4efd\u5546\u54c1\u6570\u636e" + JSON.toJSONString(provGoodsPOList));
        JSONObject resultData = null;
        for (int i = 0; i < 3; ++i) {
            try {
                resultData = this.reqBOresultData(provGoodsPOList);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (null != resultData) break;
            long time = 2000 + i;
            try {
                TimeUnit.MILLISECONDS.sleep(time);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (null == resultData || !"0000".equals(resultData.getString("respCode"))) {
            logger.error("SmcQryUnSaleCountsAbilityService qryUnSaleCountsList error,param:{} result is null:{}", (Object)JSON.toJSONString(provGoodsPOList), (Object)JSON.toJSONString((Object)resultData));
            throw new BusinessException("8888", "\u9884\u5360\u3001\u5728\u9014\u3001\u53ef\u552e\u3001\u5df2\u552e\u72b6\u6001\u4fe1\u606f\u67e5\u8be2\u5931\u8d25");
        }
        JSONArray nums = resultData.getJSONArray("nums");
        if (null == nums || nums.size() <= 0) {
            logger.error("SmcQryUnSaleCountsAbilityService qryUnSaleCountsList error,param:{} result nums is null:{}", (Object)JSON.toJSONString(provGoodsPOList), (Object)JSON.toJSONString((Object)nums));
            return true;
        }
        for (int i = 0; i < nums.size(); ++i) {
            JSONObject numObject = nums.getJSONObject(i);
            Long unsaleNum = numObject.getLong("unsaleNum");
            Long transNum = numObject.getLong("transNum");
            Long lockNum = numObject.getLong("lockNum");
            Long saledNum = numObject.getLong("saledNum");
            if (unsaleNum <= 0L && transNum <= 0L && lockNum <= 0L && saledNum <= 0L) continue;
            return false;
        }
        return true;
    }

    private final JSONObject reqBOresultData(List<ProvGoodsPO> provPOList) {
        List provIds = provPOList.stream().map(ProvGoodsPO::getProvinceCode).collect(Collectors.toList());
        List materialCodes = provPOList.stream().map(ProvGoodsPO::getMaterialId).collect(Collectors.toList());
        JSONObject param = new JSONObject();
        param.put("provIds", provIds);
        param.put("materialCodes", materialCodes);
        logger.info("qryUnSaleCountsList \u6279\u91cf\u67e5\u8be2\u5e93\u5b58\u72b6\u6001:{}", (Object)JSON.toJSONString((Object)param));
        String beanName = "com.tydic.smc.api.ability.SmcQryUnSaleCountsAbilityService";
        String methodName = "qryUnSaleCountsList";
        String paramType = "com.tydic.smc.api.ability.bo.SmcQryUnSaleCountsAbilityReqBO";
        return this.invoke("com.tydic.smc.api.ability.SmcQryUnSaleCountsAbilityService", "qryUnSaleCountsList", "com.tydic.smc.api.ability.bo.SmcQryUnSaleCountsAbilityReqBO", param);
    }
}

