/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.newretail.atom.UpdateSkuAtomService;
import com.tydic.newretail.bo.BaseRspBO;
import com.tydic.newretail.bo.CommodityToIntellMsgBO;
import com.tydic.newretail.bo.DSkuBO;
import com.tydic.newretail.bo.InitSkuFodderPicReqBO;
import com.tydic.newretail.bo.InitSkuFodderSpecReqBO;
import com.tydic.newretail.bo.PictureBO;
import com.tydic.newretail.bo.QueryMaterialSkuBO;
import com.tydic.newretail.bo.SkuFodderPicTypeBO;
import com.tydic.newretail.bo.SkuSpecBO;
import com.tydic.newretail.bo.UpdateFodderReqBO;
import com.tydic.newretail.bo.UpdateSkuFodderReqBO;
import com.tydic.newretail.bo.WeightPicBO;
import com.tydic.newretail.busi.service.InitSkuPictureAtomService;
import com.tydic.newretail.busi.service.InitSkuSpecAtomService;
import com.tydic.newretail.busi.service.UpdateFodderService;
import com.tydic.newretail.busi.service.UpdateSkuFodderService;
import com.tydic.newretail.dao.SkuDAO;
import com.tydic.newretail.dao.SkuPicDAO;
import com.tydic.newretail.dao.SkuSpecDAO;
import com.tydic.newretail.dao.po.SkuPO;
import com.tydic.newretail.dao.po.SkuSpecPO;
import com.tydic.newretail.exception.BusinessException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Resource;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class UpdateSkuFodderServiceImpl
implements UpdateSkuFodderService {
    @Autowired
    private SkuDAO skuMapper;
    @Autowired
    private SkuSpecDAO skuSpecMapper;
    @Autowired
    private SkuPicDAO skuPicMapper;
    @Autowired
    private UpdateSkuAtomService updateSkuAtomService;
    @Autowired
    private InitSkuPictureAtomService initSkuPictureAtomService;
    @Autowired
    private DataSourceTransactionManager transactionManager;
    @Autowired
    private InitSkuSpecAtomService initSkuSpecAtomService;
    @Autowired
    private UpdateFodderService updateFodderService;
    @Resource(name="skuMaterialProducer")
    ProxyMessageProducer skuMaterialProducer;
    @Value(value="${COMMODITY_PUSHPIC_PIC}")
    private String commodityPushpic;
    @Value(value="${PID_COMMODITY_PUSHPIC_PIC}")
    private String pidCommodityPushPic;
    private static final Logger logger = LoggerFactory.getLogger(UpdateSkuFodderServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();

    public BaseRspBO updateSkuFodder(UpdateSkuFodderReqBO updateSkuFodderReqBO) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.transactionManager.getTransaction((TransactionDefinition)def);
        logger.info("\u4fee\u6539\u5355\u54c1\u7d20\u6750\u539f\u5b50\u670d\u52a1\u6267\u884c--\u5165\u53c2===" + updateSkuFodderReqBO.toString());
        BaseRspBO baseRspBO = new BaseRspBO();
        try {
            List queryMaterialSkuBOs = updateSkuFodderReqBO.getUploadingMaterialSkuBO();
            SkuFodderPicTypeBO skuFodderPicTypeBO = this.getTypePicByinitSkuFodderPicReqBOs(updateSkuFodderReqBO.getInitSkuFodderPicReqBOs());
            if (queryMaterialSkuBOs.size() > 0) {
                for (final QueryMaterialSkuBO queryMaterialSkuBO : queryMaterialSkuBOs) {
                    final SkuPO SkuPO2 = this.skuMapper.selectByExtSkuIdAndSupplierId(queryMaterialSkuBO.getExtSkuId(), queryMaterialSkuBO.getSupplierId());
                    DSkuBO DSkuBO2 = new DSkuBO();
                    DSkuBO2.setSkuId(queryMaterialSkuBO.getSkuId());
                    DSkuBO2.setSupplierId(queryMaterialSkuBO.getSupplierId());
                    DSkuBO2.setMaterialId(queryMaterialSkuBO.getMaterialId());
                    DSkuBO2.setExtSkuId(queryMaterialSkuBO.getExtSkuId());
                    DSkuBO2.setCommodityTypeId(updateSkuFodderReqBO.getCommodityTypeId());
                    DSkuBO2.setSkuName(updateSkuFodderReqBO.getSkuTitle());
                    DSkuBO2.setPackParam(updateSkuFodderReqBO.getPackParam());
                    DSkuBO2.setSkuMainPicUrl(skuFodderPicTypeBO.getSkuMainPicUrl());
                    DSkuBO2.setDistribution(updateSkuFodderReqBO.getDistribution());
                    DSkuBO2.setSkuDetail(skuFodderPicTypeBO.getSkuDetail());
                    if (StringUtils.isNotBlank((CharSequence)skuFodderPicTypeBO.getWisdomBoothMainPic())) {
                        DSkuBO2.setHasWisdom(Integer.valueOf(1));
                    } else {
                        DSkuBO2.setHasWisdom(Integer.valueOf(0));
                    }
                    if (StringUtils.isNotBlank((CharSequence)skuFodderPicTypeBO.getInteractiveScreenMainPic())) {
                        DSkuBO2.setHasInteractive(Integer.valueOf(1));
                    } else {
                        DSkuBO2.setHasInteractive(Integer.valueOf(0));
                    }
                    this.updateSkuAtomService.updateSku((List)DSkuBO2);
                    ArrayList<Long> skuIds = new ArrayList<Long>();
                    skuIds.add(queryMaterialSkuBO.getSkuId());
                    this.skuPicMapper.deleteBySkuIdBatch(skuIds, queryMaterialSkuBO.getSupplierId());
                    List pictureBOList = skuFodderPicTypeBO.getPictureBOList();
                    pictureBOList.forEach(new Consumer<PictureBO>(){

                        @Override
                        public void accept(PictureBO pictureBO) {
                            pictureBO.setCommodityId(SkuPO2.getCommodityId());
                            pictureBO.setSkuId(queryMaterialSkuBO.getSkuId());
                            pictureBO.setSupplierId(queryMaterialSkuBO.getSupplierId());
                        }
                    });
                    this.initSkuPictureAtomService.initSkuPicture(pictureBOList);
                    SkuSpecPO record = new SkuSpecPO();
                    record.setSupplierId(queryMaterialSkuBO.getSupplierId());
                    record.setSkuId(queryMaterialSkuBO.getSkuId());
                    this.skuSpecMapper.deleteByMany(record);
                    List initSkuFodderSpecReqBOs = updateSkuFodderReqBO.getInitSkuFodderSpecReqBOs();
                    ArrayList<SkuSpecBO> specBOList = new ArrayList<SkuSpecBO>();
                    for (InitSkuFodderSpecReqBO initSkuFodderSpecReqBO : initSkuFodderSpecReqBOs) {
                        if (900991231L == initSkuFodderSpecReqBO.getCommodityPropGrpId() || 900991232L == initSkuFodderSpecReqBO.getCommodityPropGrpId() || 900991233L == initSkuFodderSpecReqBO.getCommodityPropGrpId() || 900991234L == initSkuFodderSpecReqBO.getCommodityPropGrpId()) continue;
                        SkuSpecBO SkuSpecBO2 = new SkuSpecBO();
                        SkuSpecBO2.setSupplierId(queryMaterialSkuBO.getSupplierId());
                        SkuSpecBO2.setCommodityPropGrpId(initSkuFodderSpecReqBO.getCommodityPropGrpId());
                        SkuSpecBO2.setPropName(initSkuFodderSpecReqBO.getPropName());
                        SkuSpecBO2.setPropShowName(initSkuFodderSpecReqBO.getPropName());
                        SkuSpecBO2.setPropValue(initSkuFodderSpecReqBO.getPropValue());
                        specBOList.add(SkuSpecBO2);
                    }
                    specBOList.forEach(new Consumer<SkuSpecBO>(){

                        @Override
                        public void accept(SkuSpecBO SkuSpecBO2) {
                            SkuSpecBO2.setCommodityId(SkuPO2.getCommodityId());
                            SkuSpecBO2.setSkuId(queryMaterialSkuBO.getSkuId());
                        }
                    });
                    this.initSkuSpecAtomService.initSkuSpec(specBOList);
                    UpdateFodderReqBO updateFodderReqBO = new UpdateFodderReqBO();
                    updateFodderReqBO.setCommodityTypeId(updateSkuFodderReqBO.getCommodityTypeId());
                    updateFodderReqBO.setDistribution(updateSkuFodderReqBO.getDistribution());
                    updateFodderReqBO.setFodderId(updateSkuFodderReqBO.getFodderId());
                    updateFodderReqBO.setHasInteractive(updateSkuFodderReqBO.getHasInteractive());
                    updateFodderReqBO.setHasWisdom(updateSkuFodderReqBO.getHasWisdom());
                    updateFodderReqBO.setPackParam(updateSkuFodderReqBO.getPackParam());
                    updateFodderReqBO.setSkuPrice(updateSkuFodderReqBO.getSkuPrice());
                    updateFodderReqBO.setSkuTitle(updateSkuFodderReqBO.getSkuTitle());
                    updateFodderReqBO.setInitSkuFodderPicReqBOs(updateSkuFodderReqBO.getInitSkuFodderPicReqBOs());
                    updateFodderReqBO.setInitSkuFodderSpecReqBOs(updateSkuFodderReqBO.getInitSkuFodderSpecReqBOs());
                    this.updateFodderService.updateFodder(updateFodderReqBO);
                }
            } else {
                UpdateFodderReqBO updateFodderReqBO = new UpdateFodderReqBO();
                updateFodderReqBO.setCommodityTypeId(updateSkuFodderReqBO.getCommodityTypeId());
                updateFodderReqBO.setDistribution(updateSkuFodderReqBO.getDistribution());
                updateFodderReqBO.setFodderId(updateSkuFodderReqBO.getFodderId());
                updateFodderReqBO.setHasInteractive(updateSkuFodderReqBO.getHasInteractive());
                updateFodderReqBO.setHasWisdom(updateSkuFodderReqBO.getHasWisdom());
                updateFodderReqBO.setPackParam(updateSkuFodderReqBO.getPackParam());
                updateFodderReqBO.setSkuPrice(updateSkuFodderReqBO.getSkuPrice());
                updateFodderReqBO.setSkuTitle(updateSkuFodderReqBO.getSkuTitle());
                updateFodderReqBO.setInitSkuFodderPicReqBOs(updateSkuFodderReqBO.getInitSkuFodderPicReqBOs());
                updateFodderReqBO.setInitSkuFodderSpecReqBOs(updateSkuFodderReqBO.getInitSkuFodderSpecReqBOs());
                logger.info("\u4fee\u6539\u7684\u7d20\u6750\u7684\u4fe1\u606f\u4e3a======" + updateFodderReqBO.toString());
                this.updateFodderService.updateFodder(updateFodderReqBO);
            }
            baseRspBO.setRespCode("0000");
            baseRspBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            this.transactionManager.rollback(status);
            logger.error("\u4fee\u6539\u5355\u54c1\u7d20\u6750\u539f\u5b50\u670d\u52a1\u51fa\u9519-\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38" + e.getMessage());
            baseRspBO.setRespCode("8888");
            baseRspBO.setRespDesc("\u4fee\u6539\u5355\u54c1\u7d20\u6750\u539f\u5b50\u670d\u52a1-\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38");
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u4fee\u6539\u5355\u54c1\u7d20\u6750\u539f\u5b50\u670d\u52a1-\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38" + e.getMessage());
        }
        this.transactionManager.commit(status);
        return baseRspBO;
    }

    SkuFodderPicTypeBO getTypePicByinitSkuFodderPicReqBOs(List<InitSkuFodderPicReqBO> initSkuFodderPicReqBOs) {
        SkuFodderPicTypeBO skuFodderPicTypeBO = new SkuFodderPicTypeBO();
        logger.info("\u65b0\u589e----\u7d20\u6750\u56fe\u7247\u7684\u6570\u91cf\u4e3a========" + initSkuFodderPicReqBOs.size());
        ArrayList<PictureBO> pictureBOList = new ArrayList<PictureBO>();
        ArrayList<String> interactiveScreenTailPic = new ArrayList<String>();
        ArrayList<String> wisdomBoothTailPic = new ArrayList<String>();
        ArrayList<String> wisdomBoothCarouselPic = new ArrayList<String>();
        ArrayList<InitSkuFodderPicReqBO> initSkuFodderPicReqBOs1 = new ArrayList<InitSkuFodderPicReqBO>();
        JSONObject jsonDetail = new JSONObject();
        ArrayList<WeightPicBO> imgList = new ArrayList<WeightPicBO>();
        for (InitSkuFodderPicReqBO initSkuFodderPicReqBO : initSkuFodderPicReqBOs) {
            if (initSkuFodderPicReqBO.getDeviceId() == 0) {
                if (initSkuFodderPicReqBO.getFodderPicType() == 0) {
                    skuFodderPicTypeBO.setSkuMainPicUrl(initSkuFodderPicReqBO.getFodderPic());
                    continue;
                }
                if (initSkuFodderPicReqBO.getFodderPicType() == 1) {
                    WeightPicBO weightPicBO = new WeightPicBO(initSkuFodderPicReqBO.getFodderPicWeight().intValue(), initSkuFodderPicReqBO.getFodderPic());
                    imgList.add(weightPicBO);
                    continue;
                }
                if (initSkuFodderPicReqBO.getFodderPicType() != 2) continue;
                PictureBO pictureBO = new PictureBO();
                pictureBO.setPicOrder(initSkuFodderPicReqBO.getFodderPicWeight());
                pictureBO.setSkuPicUrl(initSkuFodderPicReqBO.getFodderPic());
                pictureBO.setIsPrimary(Integer.valueOf(0));
                pictureBOList.add(pictureBO);
                continue;
            }
            if (initSkuFodderPicReqBO.getDeviceId() == 1) {
                if (initSkuFodderPicReqBO.getFodderPicType() == 0) {
                    skuFodderPicTypeBO.setSelfHelpPic(initSkuFodderPicReqBO.getFodderPic());
                }
                initSkuFodderPicReqBOs1.add(initSkuFodderPicReqBO);
                continue;
            }
            if (initSkuFodderPicReqBO.getDeviceId() == 2) {
                skuFodderPicTypeBO.setArtificialPic(initSkuFodderPicReqBO.getFodderPic());
                initSkuFodderPicReqBOs1.add(initSkuFodderPicReqBO);
                continue;
            }
            if (initSkuFodderPicReqBO.getDeviceId() == 3) {
                if (initSkuFodderPicReqBO.getFodderPicType() == 0) {
                    skuFodderPicTypeBO.setInteractiveScreenMainPic(initSkuFodderPicReqBO.getFodderPic());
                } else if (initSkuFodderPicReqBO.getFodderPicType() == 2) {
                    interactiveScreenTailPic.add(initSkuFodderPicReqBO.getFodderPic());
                }
                initSkuFodderPicReqBOs1.add(initSkuFodderPicReqBO);
                continue;
            }
            if (initSkuFodderPicReqBO.getDeviceId() != 4) continue;
            if (initSkuFodderPicReqBO.getFodderPicType() == 0) {
                skuFodderPicTypeBO.setWisdomBoothMainPic(initSkuFodderPicReqBO.getFodderPic());
            } else if (initSkuFodderPicReqBO.getFodderPicType() == 1) {
                wisdomBoothTailPic.add(initSkuFodderPicReqBO.getFodderPic());
            } else if (initSkuFodderPicReqBO.getFodderPicType() == 2) {
                wisdomBoothCarouselPic.add(initSkuFodderPicReqBO.getFodderPic());
            }
            initSkuFodderPicReqBOs1.add(initSkuFodderPicReqBO);
        }
        ArrayList<String> sortimgListed = new ArrayList<String>();
        List<WeightPicBO> sortimgList = UpdateSkuFodderServiceImpl.sortPic(imgList);
        for (WeightPicBO i : sortimgList) {
            sortimgListed.add(i.getPic());
        }
        jsonDetail.put((Object)"imgList", sortimgListed);
        logger.info("jsonDetail.toString()================" + jsonDetail.toString());
        skuFodderPicTypeBO.setSkuDetail(jsonDetail.toString());
        skuFodderPicTypeBO.setPictureBOList(pictureBOList);
        skuFodderPicTypeBO.setInteractiveScreenTailPic(interactiveScreenTailPic);
        skuFodderPicTypeBO.setWisdomBoothTailPic(wisdomBoothTailPic);
        skuFodderPicTypeBO.setWisdomBoothCarouselPic(wisdomBoothCarouselPic);
        skuFodderPicTypeBO.setInitSkuFodderPicReqBOs(initSkuFodderPicReqBOs1);
        return skuFodderPicTypeBO;
    }

    public ProxySendResult pushMessage(List<InitSkuFodderPicReqBO> initSkuFodderPicReqBOs, Long supplierId, Long skuId) {
        ProxySendResult result = null;
        if (initSkuFodderPicReqBOs.size() > 0) {
            CommodityToIntellMsgBO commodityToIntellMsgBO = new CommodityToIntellMsgBO();
            commodityToIntellMsgBO.setSkuId(skuId);
            commodityToIntellMsgBO.setSupplierId(supplierId);
            commodityToIntellMsgBO.setInitSkuFodderPicReqBOs(initSkuFodderPicReqBOs);
            JSONObject json = JSONObject.fromObject((Object)commodityToIntellMsgBO);
            ProxyMessage message = new ProxyMessage(this.commodityPushpic.trim(), "UPDATE", json.toString());
            message.setMessageId(this.pidCommodityPushPic.trim());
            result = this.skuMaterialProducer.send(message);
        }
        return result;
    }

    public static List<WeightPicBO> sortPic(List<WeightPicBO> list) {
        list.sort(Comparator.naturalOrder());
        return list;
    }
}

