/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.tydic.newretail.atom.UpdateSkuAtomService;
import com.tydic.newretail.bo.BaseRspBO;
import com.tydic.newretail.bo.BindXlsCommodityExtSkuBO;
import com.tydic.newretail.bo.CommodityBO;
import com.tydic.newretail.bo.CommodityExtSkuIdBO;
import com.tydic.newretail.bo.CommodityExtSkuIdResBO;
import com.tydic.newretail.bo.DDimensionNameBO;
import com.tydic.newretail.bo.InitSkuFodderRelationReqBO;
import com.tydic.newretail.bo.JsonToStringBO;
import com.tydic.newretail.bo.JsonToStringSuperBO;
import com.tydic.newretail.bo.RDimensionRecordBO;
import com.tydic.newretail.bo.RcommodityPropDefAndValueBO;
import com.tydic.newretail.bo.RelieveSkuFodderRelationReqBO;
import com.tydic.newretail.bo.SelectBycommodityPropDefIdAndpropValueListIdBO;
import com.tydic.newretail.bo.SkuFodderSpecBO;
import com.tydic.newretail.bo.SkuSpecBO;
import com.tydic.newretail.bo.UntyingXlsCommodityExtSkuBO;
import com.tydic.newretail.bo.UpdateSkuAtomReqBO;
import com.tydic.newretail.busi.service.CommodityExtSkuIdService;
import com.tydic.newretail.busi.service.DDimensionNameManageService;
import com.tydic.newretail.busi.service.InitSkuFodderRelationService;
import com.tydic.newretail.busi.service.InitSkuFodderSpecService;
import com.tydic.newretail.busi.service.InitSkuSpecAtomService;
import com.tydic.newretail.busi.service.RDimensionRecordManageService;
import com.tydic.newretail.busi.service.SortCommodityPriceService;
import com.tydic.newretail.busi.service.XlsCommodityExtSkuManageService;
import com.tydic.newretail.busi.service.XlsCommodityManageService;
import com.tydic.newretail.busi.service.XlsElectronicPricePushBusiService;
import com.tydic.newretail.dao.CommodityExtSkuIdDAO;
import com.tydic.newretail.dao.SkuDAO;
import com.tydic.newretail.dao.SkuSpecDAO;
import com.tydic.newretail.dao.po.CommodityExtSkuIdPO;
import com.tydic.newretail.dao.po.SkuPO;
import com.tydic.newretail.dao.po.SkuSpecPO;
import com.tydic.newretail.exception.BusinessException;
import com.tydic.newretail.thread.PushElectronicPriceTagThread;
import com.tydic.newretail.util.CreateThreadUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class XlsCommodityExtSkuManageServiceImpl
implements XlsCommodityExtSkuManageService {
    private static final Logger logger = LoggerFactory.getLogger(XlsCommodityExtSkuManageServiceImpl.class);
    @Autowired
    private CommodityExtSkuIdService commodityExtSkuIdService;
    @Autowired
    private RDimensionRecordManageService rDimensionRecordManageService;
    @Autowired
    private XlsElectronicPricePushBusiService xlsElectronicPricePushBusiService;
    @Autowired
    private InitSkuSpecAtomService initSkuSpecAtomService;
    @Autowired
    private InitSkuFodderSpecService initSkuFodderSpecService;
    @Autowired
    private SkuDAO skuDAO;
    @Autowired
    private SkuSpecDAO skuSpecDAO;
    @Autowired
    private InitSkuFodderRelationService initSkuFodderRelationService;
    @Autowired
    private DDimensionNameManageService dDimensionNameManageService;
    @Autowired
    private XlsCommodityManageService xlsCommodityManageService;
    @Autowired
    private UpdateSkuAtomService updateSkuAtomService;
    @Autowired
    private SortCommodityPriceService sortCommodityPriceService;
    @Autowired
    private CommodityExtSkuIdDAO commodityExtSkuIdDAO;

    /*
     * WARNING - void declaration
     */
    public BaseRspBO bindXlsCommodityExtSku(final BindXlsCommodityExtSkuBO reqBO) {
        void var25_35;
        String materialId = reqBO.getMaterialId();
        logger.debug("\u7ed1\u5b9a\u5546\u54c1\u4e0e\u5355\u54c1\u670d\u52a1\u5165\u53c2=" + reqBO.toString());
        List rcommodityPropDefAndValueBOs = reqBO.getRcommodityPropDefAndValueBOs();
        ArrayList<Long> listOrder = new ArrayList<Long>();
        ArrayList<Long> propValueListIds = new ArrayList<Long>();
        String propValueStr = "";
        BaseRspBO baseRspBO = new BaseRspBO();
        if (reqBO.getMaterialId() == "" || "".equals(reqBO.getMaterialId())) {
            baseRspBO.setRespCode("8888");
            baseRspBO.setRespDesc("\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return baseRspBO;
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getSupplierIds())) {
            baseRspBO.setRespCode("8888");
            baseRspBO.setRespDesc("\u9002\u7528\u95e8\u5e97\u4e0d\u80fd\u4e3a\u7a7a");
            return baseRspBO;
        }
        final ArrayList<SkuSpecBO> specBOList = new ArrayList<SkuSpecBO>();
        ArrayList<SelectBycommodityPropDefIdAndpropValueListIdBO> selectBycommodityPropDefIdAndpropValueListIdBOs = new ArrayList<SelectBycommodityPropDefIdAndpropValueListIdBO>();
        List<SkuPO> skuList = null;
        HashMap<Long, String> shopNameMap = new HashMap<Long, String>();
        HashMap<String, SkuPO> supplierIdAndSkuMap = new HashMap<String, SkuPO>();
        try {
            logger.debug("\u9002\u7528\u95e8\u5e97" + reqBO.getSupplierIds());
            skuList = this.skuDAO.selectSupplierAndSkuStatusByMaterialAndShopList(reqBO.getSupplierIds(), reqBO.getMaterialId());
            if (CollectionUtils.isEmpty(skuList)) {
                baseRspBO.setRespCode("8888");
                baseRspBO.setRespDesc("\u67e5\u8be2\u5355\u54c1\u5217\u8868\u4e3a\u7a7a");
                return baseRspBO;
            }
            for (SkuPO sku2 : skuList) {
                if (StringUtils.isEmpty(shopNameMap.get(sku2.getSupplierId()))) {
                    shopNameMap.put(sku2.getSupplierId(), sku2.getSupplierName());
                }
                if (!StringUtils.isEmpty(supplierIdAndSkuMap.get(String.valueOf(sku2.getCommodityId()) + sku2.getSupplierId()))) continue;
                supplierIdAndSkuMap.put(String.valueOf(sku2.getCommodityId()) + sku2.getSupplierId(), sku2);
            }
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u7269\u6599+\u95e8\u5e97\u67e5\u8be2sku\u5217\u8868\u5931\u8d25");
            throw new BusinessException("9999", "\u6839\u636e\u7269\u6599+\u95e8\u5e97\u67e5\u8be2sku\u5217\u8868\u5931\u8d25" + e.getMessage());
        }
        JsonToStringSuperBO jsonToStringSuperBO = new JsonToStringSuperBO();
        ArrayList<JsonToStringBO> JsonToStringBOList = new ArrayList<JsonToStringBO>();
        JsonToStringBO jsonToStringBO = null;
        if (CollectionUtils.isNotEmpty((Collection)rcommodityPropDefAndValueBOs)) {
            for (RcommodityPropDefAndValueBO rcommodityPropDefAndValueBO : rcommodityPropDefAndValueBOs) {
                jsonToStringBO = new JsonToStringBO();
                jsonToStringBO.setCommodityPropDefId(rcommodityPropDefAndValueBO.getCommodityPropDefId());
                jsonToStringBO.setPropName(rcommodityPropDefAndValueBO.getPropName());
                jsonToStringBO.setPropValueListId(rcommodityPropDefAndValueBO.getRpropValueListBO().getPropValueListId());
                jsonToStringBO.setPropValue(rcommodityPropDefAndValueBO.getRpropValueListBO().getPropValue());
                JsonToStringBOList.add(jsonToStringBO);
                listOrder.add(rcommodityPropDefAndValueBO.getCommodityPropDefId());
                propValueStr = propValueStr + rcommodityPropDefAndValueBO.getRpropValueListBO().getPropValue();
                SelectBycommodityPropDefIdAndpropValueListIdBO selectBycommodityPropDefIdAndpropValueListIdBO = new SelectBycommodityPropDefIdAndpropValueListIdBO();
                selectBycommodityPropDefIdAndpropValueListIdBO.setCommodityPropDefId(rcommodityPropDefAndValueBO.getCommodityPropDefId());
                selectBycommodityPropDefIdAndpropValueListIdBO.setPropValueListId(rcommodityPropDefAndValueBO.getRpropValueListBO().getPropValueListId());
                selectBycommodityPropDefIdAndpropValueListIdBOs.add(selectBycommodityPropDefIdAndpropValueListIdBO);
                propValueListIds.add(rcommodityPropDefAndValueBO.getRpropValueListBO().getPropValueListId());
            }
            jsonToStringSuperBO.setJsonToStringBOList(JsonToStringBOList);
        }
        ArrayList<SkuPO> willBind = new ArrayList<SkuPO>();
        int num = rcommodityPropDefAndValueBOs.size();
        ArrayList bindSkuList = new ArrayList();
        ArrayList<Long> bindSkuIdS = new ArrayList<Long>();
        logger.debug("\u67e5\u8be2\u7ed1\u5b9a\u5173\u7cfb");
        ArrayList<Long> supplierIdS = new ArrayList<Long>();
        HashMap commodityIdSupplierIdHashMap = new HashMap();
        ArrayList<SkuSpecPO> skuSpecs1 = new ArrayList<SkuSpecPO>();
        try {
            skuList.stream().forEach(spec -> supplierIdS.add(spec.getSupplierId()));
            List<SkuSpecPO> skuSpecs = this.skuSpecDAO.selectByCommodityIdAndsupplierIdS(supplierIdS, reqBO.getCommodityId());
            if (CollectionUtils.isNotEmpty(skuSpecs)) {
                for (SkuSpecPO skuSpecPO : skuSpecs) {
                    if (CollectionUtils.isEmpty((Collection)((Collection)commodityIdSupplierIdHashMap.get(String.valueOf(skuSpecPO.getCommodityId()) + skuSpecPO.getSupplierId())))) {
                        skuSpecs1 = new ArrayList();
                        skuSpecs1.add(skuSpecPO);
                        commodityIdSupplierIdHashMap.put(String.valueOf(skuSpecPO.getCommodityId()) + skuSpecPO.getSupplierId(), skuSpecs1);
                        continue;
                    }
                    ((List)commodityIdSupplierIdHashMap.get(String.valueOf(skuSpecPO.getCommodityId()) + skuSpecPO.getSupplierId())).add(skuSpecPO);
                }
            }
            if (!commodityIdSupplierIdHashMap.isEmpty()) {
                for (Map.Entry entry : commodityIdSupplierIdHashMap.entrySet()) {
                    boolean existResult = this.eterminingDimensions((List)entry.getValue(), listOrder, propValueStr);
                    if (!existResult) continue;
                    if (!StringUtils.isEmpty(supplierIdAndSkuMap.get(entry.getKey())) && !bindSkuList.contains(shopNameMap.get(((SkuPO)supplierIdAndSkuMap.get(entry.getKey())).getSupplierId()))) {
                        bindSkuList.add(shopNameMap.get(((SkuPO)supplierIdAndSkuMap.get(entry.getKey())).getSupplierId()));
                    }
                    bindSkuIdS.add(((SkuPO)supplierIdAndSkuMap.get(entry.getKey())).getSkuId());
                }
            }
            skuList.stream().forEach(sku -> {
                if (!bindSkuIdS.contains(sku.getSkuId())) {
                    willBind.add((SkuPO)sku);
                }
            });
            logger.debug("\u5c06\u8981\u7ed1\u5b9a\u7684sku\u5217\u8868" + ((Object)willBind).toString());
        }
        catch (BusinessException e) {
            logger.error("\u67e5\u8be2\u7ed1\u5b9a\u5173\u7cfb\u51fa\u9519");
            throw new BusinessException("9999", "\u67e5\u8be2\u7ed1\u5b9a\u5173\u7cfb\u51fa\u9519" + e.getMessage());
        }
        if (CollectionUtils.isEmpty(willBind)) {
            baseRspBO.setRespCode("0000");
            baseRspBO.setRespDesc(((Object)bindSkuList).toString() + "\u95e8\u5e97\u4e0b\u5df2\u5b58\u5728\u8be5\u7ef4\u5ea6");
            return baseRspBO;
        }
        logger.debug("\u67e5\u8be2\u7d20\u6750");
        Long fodderId = null;
        try {
            fodderId = this.inquiryMaterial(selectBycommodityPropDefIdAndpropValueListIdBOs, num);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7d20\u6750\u51fa\u9519");
            throw new BusinessException("9999", "\u67e5\u8be2\u7d20\u6750\u51fa\u9519" + e.getMessage());
        }
        logger.debug("\u6839\u636e\u5c5e\u6027ID\u548c\u5c5e\u6027\u503cID\u67e5\u8be2\u7d20\u6750\u89c4\u683c");
        Long dimensionId = null;
        try {
            dimensionId = this.queryDimensionGroup(propValueListIds, num);
        }
        catch (Exception exception) {
            logger.error("\u901a\u8fc7\u7ef4\u5ea6\u503cID\u5217\u8868\u67e5\u8be2\u7ef4\u5ea6\u548c\u540d\u79f0\u5bf9\u5e94\u5173\u7cfb\u62a5\u9519");
            throw new BusinessException("9999", "\u901a\u8fc7\u7ef4\u5ea6\u503cID\u5217\u8868\u67e5\u8be2\u7ef4\u5ea6\u548c\u540d\u79f0\u5bf9\u5e94\u5173\u7cfb\u62a5\u9519" + exception.getMessage());
        }
        logger.debug("\u901a\u8fc7\u7ef4\u5ea6\u7ec4\u5408\u540d\u79f0ID\u67e5\u8be2\u7ef4\u5ea6\u7ec4\u5408\u540d\u79f0");
        Object var25_33 = null;
        try {
            if (dimensionId != null) {
                SkuPO skuPO = this.queryDimensionName(dimensionId);
            }
            if (!StringUtils.isEmpty((Object)var25_35.getMaterialIdList())) {
                List<String> materials = Arrays.asList(var25_35.getMaterialIdList().split(","));
                logger.debug("\u9002\u7528\u7269\u6599" + materials.toString());
                logger.debug("\u7ed1\u5b9a\u7684\u7269\u6599" + reqBO.getMaterialId());
                if (!materials.contains(reqBO.getMaterialId())) {
                    baseRspBO.setRespCode("8888");
                    baseRspBO.setRespDesc("\u8be5\u7269\u6599\u4e0d\u5728\u8be5\u7ef4\u5ea6\u8303\u56f4\u5185");
                    return baseRspBO;
                }
            }
        }
        catch (Exception e) {
            logger.error("\u901a\u8fc7\u7ef4\u5ea6\u7ec4\u5408\u540d\u79f0ID\u67e5\u8be2\u7ef4\u5ea6\u7ec4\u5408\u540d\u79f0\u62a5\u9519");
            throw new BusinessException("9999", "\u901a\u8fc7\u7ef4\u5ea6\u7ec4\u5408\u540d\u79f0ID\u67e5\u8be2\u7ef4\u5ea6\u7ec4\u5408\u540d\u79f0\u62a5\u9519" + e.getMessage());
        }
        logger.debug("\u6839\u636e\u5546\u54c1ID\u67e5\u8be2\u5546\u54c1\u670d\u52a1");
        CommodityBO xlsCommodityBO = null;
        try {
            xlsCommodityBO = this.xlsCommodityManageService.selectXlsCommodityDetail(reqBO.getCommodityId());
            if (xlsCommodityBO == null) {
                baseRspBO.setRespCode("0000");
                baseRspBO.setRespDesc("\u6839\u636e\u5546\u54c1id\u67e5\u8be2\u5546\u54c1\u670d\u52a1\u7ed3\u679c\u4e3a\u7a7a");
                return baseRspBO;
            }
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u5546\u54c1ID\u67e5\u8be2\u5546\u54c1\u670d\u52a1\u62a5\u9519");
            throw new BusinessException("9999", "\u6839\u636e\u5546\u54c1ID\u67e5\u8be2\u5546\u54c1\u670d\u52a1\u62a5\u9519" + e.getMessage());
        }
        logger.debug("\u5546\u54c1id" + xlsCommodityBO.getCommodityId());
        final List<UpdateSkuAtomReqBO> upSkuParam = this.encapsulationIntoReferences(xlsCommodityBO, willBind, (SkuPO)var25_35);
        logger.debug("\u66f4\u65b0\u5355\u54c1\u4fe1\u606f");
        try {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    XlsCommodityExtSkuManageServiceImpl.this.updateSkuAtomService.updateSku(upSkuParam);
                    XlsCommodityExtSkuManageServiceImpl.this.sortCommodityPriceService.sortCommodityPrice(reqBO.getCommodityId());
                }
            }).start();
        }
        catch (Exception e) {
            logger.error("\u5355\u6761\u4fee\u6539\u5355\u54c1\u670d\u52a1\u62a5\u9519");
            throw new BusinessException("9999", "\u5355\u6761\u4fee\u6539\u5355\u54c1\u670d\u52a1\u62a5\u9519" + e.getMessage());
        }
        final ArrayList<Long> delSkuList = new ArrayList<Long>();
        SkuSpecBO specBO = null;
        for (SkuPO sku3 : willBind) {
            delSkuList.add(sku3.getSkuId());
            for (RcommodityPropDefAndValueBO rcommodityPropDefAndValueBO : rcommodityPropDefAndValueBOs) {
                specBO = new SkuSpecBO();
                specBO.setSupplierId(sku3.getSupplierId());
                specBO.setSkuId(sku3.getSkuId());
                specBO.setCommodityId(reqBO.getCommodityId());
                specBO.setCommodityPropGrpId(reqBO.getCommodityPropGrpId());
                specBO.setCommoditySpecId(rcommodityPropDefAndValueBO.getCommodityPropDefId());
                specBO.setPropName(rcommodityPropDefAndValueBO.getPropName());
                specBO.setPropShowName(rcommodityPropDefAndValueBO.getPropName());
                specBO.setPropValueListId(rcommodityPropDefAndValueBO.getRpropValueListBO().getPropValueListId());
                specBO.setPropValue(rcommodityPropDefAndValueBO.getRpropValueListBO().getPropValue());
                specBOList.add(specBO);
            }
        }
        logger.debug("\u5220\u9664\u5df2\u7ed1\u5b9a\u7684\u7ef4\u5ea6");
        try {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    XlsCommodityExtSkuManageServiceImpl.this.initSkuSpecAtomService.delSkuSpec(delSkuList);
                }
            }).start();
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u5df2\u7ed1\u5b9a\u7684\u7ef4\u5ea6\u62a5\u9519");
            throw new BusinessException("9999", "\u5220\u9664\u5df2\u7ed1\u5b9a\u7684\u7ef4\u5ea6\u62a5\u9519" + e.getMessage());
        }
        logger.debug("\u521b\u5efa\u7ef4\u5ea6\u4e2a\u6570" + specBOList.size());
        try {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    XlsCommodityExtSkuManageServiceImpl.this.initSkuSpecAtomService.initSkuSpec(specBOList);
                }
            }).start();
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u5355\u54c1\u7ef4\u5ea6\u62a5\u9519");
            throw new BusinessException("9999", "\u521b\u5efa\u5355\u54c1\u7ef4\u5ea6\u62a5\u9519" + e.getMessage());
        }
        if (fodderId != null) {
            logger.debug("\u7ed1\u5b9a\u7d20\u6750\u548c\u5355\u54c1\u5173\u7cfb\u7d20\u6750id" + fodderId);
            final ArrayList<InitSkuFodderRelationReqBO> initSkuFodderRelationReqBOList = new ArrayList<InitSkuFodderRelationReqBO>();
            InitSkuFodderRelationReqBO initSkuFodderRelationReqBO = null;
            final ArrayList<RelieveSkuFodderRelationReqBO> relieveList = new ArrayList<RelieveSkuFodderRelationReqBO>();
            RelieveSkuFodderRelationReqBO relieveSkuFodderRelationReqBO = null;
            for (SkuPO skuPO : willBind) {
                relieveSkuFodderRelationReqBO = new RelieveSkuFodderRelationReqBO();
                relieveSkuFodderRelationReqBO.setSkuId(skuPO.getSkuId());
                initSkuFodderRelationReqBO = new InitSkuFodderRelationReqBO();
                initSkuFodderRelationReqBO.setCreateTime(new Date());
                initSkuFodderRelationReqBO.setFodderId(fodderId);
                initSkuFodderRelationReqBO.setRelationStatus(Integer.valueOf(0));
                initSkuFodderRelationReqBO.setSkuId(skuPO.getSkuId());
                initSkuFodderRelationReqBO.setSupplierId(skuPO.getSupplierId());
                initSkuFodderRelationReqBO.setUpdateTime(new Date());
                initSkuFodderRelationReqBOList.add(initSkuFodderRelationReqBO);
                relieveList.add(relieveSkuFodderRelationReqBO);
            }
            try {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        XlsCommodityExtSkuManageServiceImpl.this.initSkuFodderRelationService.relieveSkuFodderRelation(relieveList);
                    }
                }).start();
            }
            catch (Exception e) {
                logger.error("\u5220\u9664\u7d20\u6750\u548c\u5355\u54c1\u5173\u7cfb\u62a5\u9519");
                throw new BusinessException("9999", "\u5220\u9664\u7d20\u6750\u548c\u5355\u54c1\u5173\u7cfb\u5173\u7cfb\u62a5\u9519" + e.getMessage());
            }
            try {
                logger.debug("\u7ed1\u5b9a\u7d20\u6750\u548c\u5355\u54c1\u5173\u7cfb\u7d20\u6750\u5165\u53c2" + ((Object)initSkuFodderRelationReqBOList).toString());
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        XlsCommodityExtSkuManageServiceImpl.this.initSkuFodderRelationService.initSkuFodderRelation(initSkuFodderRelationReqBOList);
                    }
                }).start();
            }
            catch (Exception e) {
                logger.error("\u7ed1\u5b9a\u7d20\u6750\u548c\u5355\u54c1\u5173\u7cfb\u62a5\u9519");
                throw new BusinessException("9999", "\u7ed1\u5b9a\u7d20\u6750\u548c\u5355\u54c1\u5173\u7cfb\u62a5\u9519" + e.getMessage());
            }
        }
        String commodityDimensionJson = JSONObject.fromObject((Object)jsonToStringSuperBO).toString();
        CommodityExtSkuIdBO commodityExtSkuIdBO = new CommodityExtSkuIdBO();
        logger.debug("\u7269\u6599" + materialId);
        commodityExtSkuIdBO.setMaterialId(materialId);
        commodityExtSkuIdBO.setProvinceCode(reqBO.getProvinceCode());
        CommodityExtSkuIdResBO commodityExtSkuIdResBO = this.commodityExtSkuIdService.getRelationByExtSkuId(commodityExtSkuIdBO);
        if (CollectionUtils.isEmpty((Collection)commodityExtSkuIdResBO.getRows())) {
            CommodityExtSkuIdBO addCommodityExtSkuIdBO = new CommodityExtSkuIdBO();
            addCommodityExtSkuIdBO.setProvinceCode(reqBO.getProvinceCode());
            addCommodityExtSkuIdBO.setMaterialId(reqBO.getMaterialId());
            String suppilerIds = "";
            for (Long supplier : reqBO.getSupplierIds()) {
                suppilerIds = suppilerIds + supplier + ",";
            }
            addCommodityExtSkuIdBO.setOpreateUserId(reqBO.getmUserId().toString());
            addCommodityExtSkuIdBO.setSuppilerIdList(suppilerIds.substring(0, suppilerIds.length() - 1));
            addCommodityExtSkuIdBO.setIsValid('1');
            addCommodityExtSkuIdBO.setCommodityPropGrpId(reqBO.getCommodityPropGrpId());
            addCommodityExtSkuIdBO.setCommodityId(reqBO.getCommodityId());
            addCommodityExtSkuIdBO.setCommodityDimensionJson(commodityDimensionJson);
            addCommodityExtSkuIdBO.setCreateTime(new Date());
            addCommodityExtSkuIdBO.setExtSkuId(reqBO.getExtSkuId());
            addCommodityExtSkuIdBO.setUpdateTime(new Date());
            logger.debug("\u589e\u52a0\u5173\u8054\u5173\u7cfb" + addCommodityExtSkuIdBO);
            try {
                this.commodityExtSkuIdService.addRelation(addCommodityExtSkuIdBO);
            }
            catch (Exception exception) {
                logger.error("\u589e\u52a0\u5173\u8054\u5173\u7cfb\u5931\u8d25");
                throw new BusinessException("9999", "\u589e\u52a0\u5173\u8054\u5173\u7cfb\u5931\u8d25" + exception.getMessage());
            }
        }
        baseRspBO.setRespCode("0000");
        if (CollectionUtils.isEmpty(bindSkuList)) {
            baseRspBO.setRespDesc("\u6210\u529f");
        } else {
            baseRspBO.setRespDesc(((Object)bindSkuList).toString() + "\u95e8\u5e97\u4e0b\u5df2\u5b58\u5728\u8be5\u5546\u54c1\u7ef4\u5ea6");
        }
        return baseRspBO;
    }

    public BaseRspBO untyingXlsCommoditySku(final UntyingXlsCommodityExtSkuBO reqBO) {
        BaseRspBO result = new BaseRspBO();
        if ("1".equals(reqBO.getmUserLevel())) {
            logger.debug("\u603b\u90e8\u4e0d\u53ef\u89e3\u7ed1");
            result.setRespCode("8888");
            result.setRespDesc("\u603b\u90e8\u4e0d\u53ef\u89e3\u7ed1\uff0c\u8bf7\u4f7f\u7528\u7701\u4efd\u8d26\u53f7\u64cd\u4f5c");
            return result;
        }
        if (reqBO.getMaterialId() == "" || "".equals(reqBO.getMaterialId())) {
            result.setRespCode("8888");
            result.setRespDesc("\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return result;
        }
        final ArrayList<UpdateSkuAtomReqBO> skuBOList = new ArrayList<UpdateSkuAtomReqBO>();
        List<SkuPO> skuList = null;
        ArrayList<String> materialIds = new ArrayList<String>();
        materialIds.add(reqBO.getMaterialId());
        List<CommodityExtSkuIdPO> bind = this.commodityExtSkuIdDAO.selectByMaterials(materialIds, reqBO.getProvinceCode());
        String supplierStr = bind.get(0).getSuppilerIdList();
        List<String> supplier = Arrays.asList(supplierStr.split(","));
        ArrayList<Long> suppliers = new ArrayList<Long>();
        for (String su : supplier) {
            suppliers.add(Long.parseLong(su));
        }
        try {
            skuList = this.skuDAO.queryXlsSkuByMaterialAndShopList(suppliers, reqBO.getMaterialId());
            if (CollectionUtils.isEmpty(skuList)) {
                result.setRespCode("8888");
                result.setRespDesc("\u67e5\u8be2\u5355\u54c1\u5217\u8868\u4e3a\u7a7a");
                return result;
            }
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u95e8\u5e97ID\u548c\u7269\u6599ID\u67e5\u8be2sku\u5217\u8868\u5931\u8d25");
            throw new BusinessException("9999", "\u6839\u636e\u95e8\u5e97ID\u548c\u7269\u6599ID\u67e5\u8be2sku\u5217\u8868\u5931\u8d25" + e.getMessage());
        }
        List<SkuPO> skuStatue = null;
        try {
            skuStatue = this.skuDAO.selectBySkuIdListAndSupplierListAndstatus(skuList);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5355\u54c1\u670d\u52a1\u62a5\u9519");
            throw new BusinessException("9999", "\u67e5\u8be2\u5355\u54c1\u670d\u52a1\u62a5\u9519" + e.getMessage());
        }
        UpdateSkuAtomReqBO skuBO = null;
        for (SkuPO staSku : skuStatue) {
            skuBO = new UpdateSkuAtomReqBO();
            skuBO.setSkuId(staSku.getSkuId());
            skuBO.setSupplierId(staSku.getSupplierId());
            if (staSku.getSkuStatus() == 2) {
                skuBO.setSkuStatus(Integer.valueOf(1));
            } else if (staSku.getSkuStatus() == 5) {
                skuBO.setSkuStatus(Integer.valueOf(4));
            }
            skuBO.setSkuName(staSku.getErpLongName());
            skuBO.setSkuLongName(staSku.getErpLongName());
            skuBO.setSkuPriceTagName(staSku.getErpLongName());
            skuBOList.add(skuBO);
        }
        logger.debug("\u5982\u53c2" + ((Object)skuBOList).toString());
        try {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    XlsCommodityExtSkuManageServiceImpl.this.updateSkuAtomService.updateSkuNullCommodityId(skuBOList);
                    XlsCommodityExtSkuManageServiceImpl.this.sortCommodityPriceService.sortCommodityPrice(reqBO.getCommodityId());
                }
            }).start();
        }
        catch (Exception e) {
            logger.error("\u5355\u6761\u4fee\u6539\u5355\u54c1\u7684commodityId\u4e3a\u7a7a\u670d\u52a1\u62a5\u9519");
            throw new BusinessException("9999", "\u5355\u6761\u4fee\u6539\u5355\u54c1\u7684commodityId\u4e3a\u7a7a\u670d\u52a1" + e.getMessage());
        }
        final ArrayList<SkuSpecPO> skuSpecList = new ArrayList<SkuSpecPO>();
        final ArrayList<RelieveSkuFodderRelationReqBO> relieveSkuFodderRelationReqBOList = new ArrayList<RelieveSkuFodderRelationReqBO>();
        ArrayList<Long> skuIDs = new ArrayList<Long>();
        RelieveSkuFodderRelationReqBO relieveSkuFodderRelationReqBO = null;
        SkuSpecPO record = null;
        for (SkuPO staSku : skuList) {
            relieveSkuFodderRelationReqBO = new RelieveSkuFodderRelationReqBO();
            record = new SkuSpecPO();
            relieveSkuFodderRelationReqBO.setSkuId(staSku.getSkuId());
            relieveSkuFodderRelationReqBO.setSupplierId(staSku.getSupplierId());
            record.setSupplierId(staSku.getSupplierId());
            record.setSkuId(staSku.getSkuId());
            skuIDs.add(staSku.getSkuId());
            skuSpecList.add(record);
            relieveSkuFodderRelationReqBOList.add(relieveSkuFodderRelationReqBO);
        }
        logger.debug("\u5220\u9664\u5546\u54c1\u7684\u7d20\u6750\u89c4\u683c");
        try {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    XlsCommodityExtSkuManageServiceImpl.this.skuSpecDAO.deleteByManyList(skuSpecList);
                }
            }).start();
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u5546\u54c1\u7684\u7d20\u6750\u89c4\u683c\u62a5\u9519");
            throw new BusinessException("9999", "\u5220\u9664\u5546\u54c1\u7684\u7d20\u6750\u89c4\u683c\u62a5\u9519" + e.getMessage());
        }
        logger.debug("\u89e3\u9664\u5546\u54c1\u4e0e\u7d20\u6750\u7684\u5173\u7cfb");
        try {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    XlsCommodityExtSkuManageServiceImpl.this.initSkuFodderRelationService.relieveSkuFodderRelation(relieveSkuFodderRelationReqBOList);
                }
            }).start();
        }
        catch (Exception e) {
            logger.error("\u89e3\u9664\u5355\u54c1\u4e0e\u7d20\u6750\u7684\u5173\u7cfb\u62a5\u9519");
            throw new BusinessException("9999", "\u89e3\u9664\u5355\u54c1\u4e0e\u7d20\u6750\u7684\u5173\u7cfb\u62a5\u9519" + e.getMessage());
        }
        logger.debug("\u89e3\u9664\u5546\u54c1\u4e0e\u52a9\u8bb0\u7801\u5173\u8054\u5173\u7cfb");
        CommodityExtSkuIdBO commodityExtSkuIdBO = new CommodityExtSkuIdBO();
        commodityExtSkuIdBO.setExtSkuId(reqBO.getExtSkuId());
        commodityExtSkuIdBO.setIsValid('0');
        commodityExtSkuIdBO.setOpreateUserId(reqBO.getmUserId().toString());
        commodityExtSkuIdBO.setProvinceCode(reqBO.getProvinceCode());
        commodityExtSkuIdBO.setMaterialId(reqBO.getMaterialId());
        commodityExtSkuIdBO.setUpdateTime(new Date());
        try {
            this.commodityExtSkuIdService.updateStatus(commodityExtSkuIdBO);
        }
        catch (Exception e) {
            logger.error("\u89e3\u9664\u5546\u54c1\u4e0e\u52a9\u8bb0\u7801\u5173\u8054\u5173\u7cfb\u62a5\u9519");
            throw new BusinessException("9999", "\u89e3\u9664\u5546\u54c1\u4e0e\u52a9\u8bb0\u7801\u5173\u8054\u5173\u7cfb\u62a5\u9519" + e.getMessage());
        }
        logger.debug("\u540c\u6b65\u7535\u5b50\u4ef7\u7b7e");
        PushElectronicPriceTagThread pushElectronicPriceTagThread = new PushElectronicPriceTagThread(this.xlsElectronicPricePushBusiService, null, null, skuIDs);
        ExecutorService singleThreadPool = CreateThreadUtils.createSimpleThreadPool(pushElectronicPriceTagThread, "pushElectronicPriceTagThread", 1, 1);
        singleThreadPool.execute(() -> logger.debug(Thread.currentThread().getName()));
        singleThreadPool.shutdown();
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        return result;
    }

    public List<UpdateSkuAtomReqBO> encapsulationIntoReferences(CommodityBO xlsCommodityBO, List<SkuPO> skuStatue, SkuPO skuDimension) {
        ArrayList<UpdateSkuAtomReqBO> skuList = new ArrayList<UpdateSkuAtomReqBO>();
        UpdateSkuAtomReqBO skuParam = null;
        for (SkuPO skuSta : skuStatue) {
            skuParam = new UpdateSkuAtomReqBO();
            if (skuDimension != null) {
                skuParam.setSkuName(skuDimension.getSkuName());
                skuParam.setSkuPriceTagName(skuDimension.getSkuPriceTagName());
                skuParam.setSkuLongName(skuDimension.getSkuLongName());
            }
            skuParam.setSkuId(skuSta.getSkuId());
            skuParam.setSupplierId(skuSta.getSupplierId());
            skuParam.setCommodityId(xlsCommodityBO.getCommodityId());
            skuParam.setSkuMainPicUrl(xlsCommodityBO.getCommodityMainPic());
            skuParam.setCommodityTypeId(xlsCommodityBO.getCommodityTypeId());
            skuParam.setUpdateTime(new Date());
            skuParam.setPackParam("{\"sellList\":[{\"label\": \"\u5305\u88c5\u6e05\u5355\",\"value\": \"\u4fdd\u4fee\u5361\u3001\u8bf4\u660e\u4e66\u3002\"},{\"label\": \"\u6743\u5229\u58f0\u660e\",\"value\": \"\u548c\u52a8\u529b\u4f18\u54c1\u9986\u7684\u6240\u6709\u5546\u54c1\u4fe1\u606f\u3001\u5ba2\u6237\u8bc4\u4ef7\u3001\u5546\u54c1\u54a8\u8be2\u3001\u7f51\u53cb\u8ba8\u8bba\u7b49\u5185\u5bb9\uff0c\u662f\u548c\u52a8\u529b\u4f18\u54c1\u9986\u91cd\u8981\u7684\u7ecf\u8425\u8d44\u6e90\uff0c\u672a\u7ecf\u8bb8\u53ef\uff0c\u7981\u6b62\u975e\u6cd5\u8f6c\u8f7d\u4f7f\u7528\u3002\"}]}");
            if (skuSta.getSkuStatus() == 1) {
                skuParam.setSkuStatus(Integer.valueOf(2));
                skuParam.setOnShelveTime(new Date());
            } else if (skuSta.getSkuStatus() == 4) {
                skuParam.setSkuStatus(Integer.valueOf(5));
            }
            skuList.add(skuParam);
        }
        return skuList;
    }

    public SkuPO queryDimensionName(Long dimensionId) throws BusinessException {
        SkuPO sku = new SkuPO();
        DDimensionNameBO dDimensionNameBO = this.dDimensionNameManageService.selectByDimensionId(dimensionId);
        sku.setSkuName(dDimensionNameBO.getDimensionName());
        sku.setSkuPriceTagName(dDimensionNameBO.getDimensionName());
        sku.setSkuLongName(dDimensionNameBO.getDimensionLongName());
        sku.setMaterialIdList(dDimensionNameBO.getMaterialIdList());
        return sku;
    }

    public Long queryDimensionGroup(List<Long> propValueListIds, int num) throws BusinessException {
        logger.info("\u9009\u62e9\u7684\u7ef4\u5ea6\u503c\u7684ID\u5217\u8868\u4e3a=" + propValueListIds.toString());
        List rDimensionRecordBOs = null;
        Long dimensionId = null;
        rDimensionRecordBOs = this.rDimensionRecordManageService.selectByPropValueListIds(propValueListIds);
        logger.debug("\u7ef4\u5ea6\u7ec4\u5408\u67e5\u8be2\u7ed3\u679c" + rDimensionRecordBOs.toString());
        HashMap<Long, Integer> mapDimensionId = new HashMap<Long, Integer>();
        if (CollectionUtils.isNotEmpty((Collection)rDimensionRecordBOs)) {
            for (RDimensionRecordBO rDimensionRecordBO : rDimensionRecordBOs) {
                if (mapDimensionId.containsKey(rDimensionRecordBO.getDimensionId())) {
                    mapDimensionId.put(rDimensionRecordBO.getDimensionId(), (Integer)mapDimensionId.get(rDimensionRecordBO.getDimensionId()) + 1);
                    continue;
                }
                mapDimensionId.put(rDimensionRecordBO.getDimensionId(), 1);
            }
        }
        logger.info("\u67e5\u8be2\u51fa\u6765\u7684\u7ef4\u5ea6\u7ec4\u5408\u7684\u540d\u79f0\u53ca\u7ef4\u5ea6\u503cID=" + ((Object)mapDimensionId).toString());
        if (mapDimensionId.isEmpty()) {
            return null;
        }
        for (Map.Entry entry : mapDimensionId.entrySet()) {
            if ((Integer)entry.getValue() < num) continue;
            dimensionId = (Long)entry.getKey();
        }
        return dimensionId;
    }

    public Long inquiryMaterial(List<SelectBycommodityPropDefIdAndpropValueListIdBO> selectBycommodityPropDefIdAndpropValueListIdBOs, int num) throws BusinessException {
        List skuFodderSpecBOs = null;
        skuFodderSpecBOs = this.initSkuFodderSpecService.selectBycommodityPropDefIdAndpropValueListId(selectBycommodityPropDefIdAndpropValueListIdBOs);
        Long fodderId = null;
        if (CollectionUtils.isNotEmpty((Collection)skuFodderSpecBOs)) {
            HashMap<Long, Integer> mapFodderId = new HashMap<Long, Integer>();
            for (SkuFodderSpecBO skuFodderSpecBO : skuFodderSpecBOs) {
                if (mapFodderId.containsKey(skuFodderSpecBO.getFodderId())) {
                    mapFodderId.put(skuFodderSpecBO.getFodderId(), (Integer)mapFodderId.get(skuFodderSpecBO.getFodderId()) + 1);
                    continue;
                }
                mapFodderId.put(skuFodderSpecBO.getFodderId(), 1);
            }
            logger.info("\u67e5\u8be2\u51fa\u6765\u7684\u7d20\u6750ID\u53ca\u6570\u91cf=" + mapFodderId);
            for (Map.Entry entry : mapFodderId.entrySet()) {
                if ((Integer)entry.getValue() < num) continue;
                fodderId = (Long)entry.getKey();
            }
        }
        return fodderId;
    }

    public boolean eterminingDimensions(List<SkuSpecPO> skuSpecs, List<Long> listOrder, String propValueStr) throws BusinessException {
        boolean flag = false;
        if (CollectionUtils.isNotEmpty(skuSpecs)) {
            HashMap<Long, HashMap<Long, SkuSpecPO>> mapListSkuSpec = new HashMap<Long, HashMap<Long, SkuSpecPO>>();
            for (SkuSpecPO skuSpe : skuSpecs) {
                HashMap<Long, SkuSpecPO> mapSkuSpec = (HashMap<Long, SkuSpecPO>)mapListSkuSpec.get(skuSpe.getSkuId());
                if (mapSkuSpec == null) {
                    mapSkuSpec = new HashMap<Long, SkuSpecPO>();
                    mapSkuSpec.put(skuSpe.getCommoditySpecId(), skuSpe);
                    mapListSkuSpec.put(skuSpe.getSkuId(), mapSkuSpec);
                    continue;
                }
                mapSkuSpec.put(skuSpe.getCommoditySpecId(), skuSpe);
            }
            ArrayList<String> a = new ArrayList<String>();
            for (Map.Entry entry : mapListSkuSpec.entrySet()) {
                String aaa = "";
                for (Long commoditySpecId : listOrder) {
                    if (((Map)entry.getValue()).get(commoditySpecId) == null) continue;
                    aaa = aaa + ((SkuSpecPO)((Map)entry.getValue()).get(commoditySpecId)).getPropValue();
                }
                a.add(aaa);
            }
            logger.debug("\u5c06\u8981\u7ed1\u5b9a\u7684\u7ef4\u5ea6=" + propValueStr.toString());
            logger.debug("\u5df2\u5b58\u5728\u7ed1\u5b9a\u7684\u7ef4\u5ea6=" + ((Object)a).toString());
            for (String str1 : a) {
                if (!propValueStr.equals(str1)) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }
}

