/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.newretail.atom.SysParamsAtomService;
import com.tydic.newretail.bo.BaseRspBO;
import com.tydic.newretail.bo.CommodityBO;
import com.tydic.newretail.bo.CommodityPageBO;
import com.tydic.newretail.bo.RspPageBO;
import com.tydic.newretail.bo.SelectXlsCommodiyForStatisticsReqBO;
import com.tydic.newretail.bo.StatisticsXlsCommodityBO;
import com.tydic.newretail.bo.XlsCommodityReqBO;
import com.tydic.newretail.bo.XlsCommodityResBO;
import com.tydic.newretail.bo.selectCommodityByAppletReqBO;
import com.tydic.newretail.busi.service.XlsCommodityManageService;
import com.tydic.newretail.dao.CommodityDAO;
import com.tydic.newretail.dao.po.CommodityPO;
import com.tydic.newretail.dao.po.StatisticsXlsCommodityPO;
import com.tydic.newretail.exception.BusinessException;
import com.tydic.newretail.toolkit.bo.RspPageBaseBO;
import com.tydic.newretail.util.MoneyUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class XlsCommodityManageServiceImpl
implements XlsCommodityManageService {
    private static final Logger logger = LoggerFactory.getLogger(XlsCommodityManageServiceImpl.class);
    @Autowired
    private CommodityDAO commodityDAO;
    @Autowired
    private SysParamsAtomService sysParamsAtomService;

    public RspPageBaseBO<CommodityBO> selectXlsCommodity(CommodityPageBO commodityPageBO) {
        RspPageBaseBO result = new RspPageBaseBO();
        ArrayList<CommodityBO> commodityBOS = new ArrayList<CommodityBO>();
        CommodityPO CommodityPO2 = new CommodityPO();
        BeanUtils.copyProperties((Object)commodityPageBO, (Object)CommodityPO2);
        Page page = new Page();
        page.setLimit(commodityPageBO.getPageSize());
        page.setOffset(commodityPageBO.getOffset());
        List<CommodityPO> xlsCommodityPOs = null;
        try {
            xlsCommodityPOs = this.commodityDAO.selectByMany(CommodityPO2, (Page<CommodityPO>)page);
        }
        catch (Exception e) {
            result.setRespCode("8888");
            result.setRespDesc("\u5931\u8d25");
            e.printStackTrace();
            logger.error("\u6570\u636e\u5e93\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5546\u54c1\u5217\u8868\u51fa\u9519" + e.getMessage());
            return result;
        }
        Map mapSysCommodityStatus = this.sysParamsAtomService.selectByParentCode("SYS_COMMODITY_STATUS");
        Map mapSysCommodityIsbindfodder = this.sysParamsAtomService.selectByParentCode("SYS_COMMODITY_ISBINDFODDER");
        if (CollectionUtils.isNotEmpty(xlsCommodityPOs)) {
            for (CommodityPO xlsCommodityPO1 : xlsCommodityPOs) {
                CommodityBO commodityBO1 = new CommodityBO();
                BeanUtils.copyProperties((Object)xlsCommodityPO1, (Object)commodityBO1);
                commodityBO1.setCommodityStatusName((String)mapSysCommodityStatus.get(commodityBO1.getCommodityStatus()));
                commodityBO1.setIsBindFodderName((String)mapSysCommodityIsbindfodder.get(commodityBO1.getIsBindFodder()));
                commodityBOS.add(commodityBO1);
            }
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        result.setRows(commodityBOS);
        result.setTotal(page.getTotalPages());
        result.setRecordsTotal(page.getTotalCount());
        return result;
    }

    public CommodityBO selectXlsCommodityDetail(Long commodityId) {
        CommodityBO xlsCommodityBO = new CommodityBO();
        try {
            CommodityPO CommodityPO2 = this.commodityDAO.selectByPrimaryKey(commodityId);
            if (CommodityPO2 == null) {
                logger.debug("\u6570\u636e\u5e93\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u7ed3\u679c\u4e3a\u7a7a");
                return xlsCommodityBO;
            }
            BeanUtils.copyProperties((Object)CommodityPO2, (Object)xlsCommodityBO);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u6570\u636e\u5e93\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u51fa\u9519" + e.getMessage());
        }
        return xlsCommodityBO;
    }

    public BaseRspBO updateXlsCommodity(CommodityBO xlsCommodityBO) {
        BaseRspBO baseRspBO = new BaseRspBO();
        CommodityPO CommodityPO2 = new CommodityPO();
        BeanUtils.copyProperties((Object)xlsCommodityBO, (Object)CommodityPO2);
        try {
            CommodityPO2.setUpdateTime(new Date());
            this.commodityDAO.updateByPrimaryKeySelective(CommodityPO2);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u6570\u636e\u5e93\u5355\u6761\u4fee\u6539xls\u5546\u54c1\u51fa\u9519");
        }
        baseRspBO.setRespCode("0000");
        baseRspBO.setRespDesc("\u6210\u529f");
        return baseRspBO;
    }

    public XlsCommodityResBO selectXlsCommodityNoPage(XlsCommodityReqBO xlsCommodityPageBO) {
        XlsCommodityResBO result = new XlsCommodityResBO();
        ArrayList<CommodityBO> xlsCommodityBOs = new ArrayList<CommodityBO>();
        CommodityPO xlsCommodityPO = new CommodityPO();
        BeanUtils.copyProperties((Object)xlsCommodityPageBO, (Object)xlsCommodityPO);
        List<CommodityPO> xlsCommodityPOs = null;
        try {
            xlsCommodityPOs = this.commodityDAO.selectByMany(xlsCommodityPO);
        }
        catch (Exception e) {
            result.setRespCode("8888");
            result.setRespDesc("\u5931\u8d25");
            e.printStackTrace();
            logger.error("\u6570\u636e\u5e93\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5546\u54c1\u5217\u8868\u51fa\u9519" + e);
            logger.error("\u6570\u636e\u5e93\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5546\u54c1\u5217\u8868\u51fa\u9519" + e.getMessage());
            return result;
        }
        Map mapSysCommodityStatus = this.sysParamsAtomService.selectByParentCode("SYS_COMMODITY_STATUS");
        Map mapSysCommodityIsbindfodder = this.sysParamsAtomService.selectByParentCode("SYS_COMMODITY_ISBINDFODDER");
        if (CollectionUtils.isNotEmpty(xlsCommodityPOs)) {
            for (CommodityPO xlsCommodityPO1 : xlsCommodityPOs) {
                CommodityBO xlsCommodityBO1 = new CommodityBO();
                BeanUtils.copyProperties((Object)xlsCommodityPO1, (Object)xlsCommodityBO1);
                xlsCommodityBO1.setCommodityStatusName((String)mapSysCommodityStatus.get(xlsCommodityBO1.getCommodityStatus()));
                xlsCommodityBO1.setIsBindFodderName((String)mapSysCommodityIsbindfodder.get(xlsCommodityBO1.getIsBindFodder()));
                xlsCommodityBOs.add(xlsCommodityBO1);
            }
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        result.setRows(xlsCommodityBOs);
        return result;
    }

    public RspPageBaseBO<StatisticsXlsCommodityBO> selectXlsCommodiyForStatistics(SelectXlsCommodiyForStatisticsReqBO selectXlsCommodiyForStatisticsReqBO) {
        RspPageBaseBO result = new RspPageBaseBO();
        ArrayList<StatisticsXlsCommodityBO> statisticsXlsCommodityBOs = new ArrayList<StatisticsXlsCommodityBO>();
        Page page = new Page();
        page.setLimit(selectXlsCommodiyForStatisticsReqBO.getPageSize());
        page.setOffset(selectXlsCommodiyForStatisticsReqBO.getOffset());
        CommodityPO xlsCommodityPO = new CommodityPO();
        xlsCommodityPO.setCommodityName(selectXlsCommodiyForStatisticsReqBO.getCommodityName());
        xlsCommodityPO.setCommodityBrand(selectXlsCommodiyForStatisticsReqBO.getCommodityBrand());
        List<StatisticsXlsCommodityPO> statisticsXlsCommodityPOs = this.commodityDAO.selectXlsCommodiyForStatistics(xlsCommodityPO, (Page<StatisticsXlsCommodityPO>)page);
        if (CollectionUtils.isNotEmpty(statisticsXlsCommodityPOs)) {
            for (StatisticsXlsCommodityPO statisticsXlsCommodityPO : statisticsXlsCommodityPOs) {
                StatisticsXlsCommodityBO statisticsXlsCommodityBO = new StatisticsXlsCommodityBO();
                BeanUtils.copyProperties((Object)statisticsXlsCommodityPO, (Object)statisticsXlsCommodityBO);
                statisticsXlsCommodityBOs.add(statisticsXlsCommodityBO);
            }
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        result.setRows(statisticsXlsCommodityBOs);
        result.setRecordsTotal(page.getTotalCount());
        result.setTotal(page.getTotalPages());
        return result;
    }

    public BaseRspBO insertXlsCommodity(CommodityBO commodityBO) {
        BaseRspBO baseRspBO = new BaseRspBO();
        if (commodityBO == null) {
            baseRspBO.setRespCode("0000");
            baseRspBO.setRespDesc("\u6210\u529f");
            return baseRspBO;
        }
        CommodityPO commodityPO = new CommodityPO();
        BeanUtils.copyProperties((Object)commodityBO, (Object)commodityPO);
        try {
            this.commodityDAO.insertSelective(commodityPO);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u6570\u636e\u5e93\u5355\u6761\u6dfb\u52a0xls\u5546\u54c1\u7ec4\u51fa\u9519");
        }
        baseRspBO.setRespCode("0000");
        baseRspBO.setRespDesc("\u6210\u529f");
        return baseRspBO;
    }

    public RspPageBO<XlsCommodityReqBO> selectCommodity(selectCommodityByAppletReqBO selectCommodityByAppletReqBO2) {
        logger.debug("\u8c03\u7528\u5c0f\u7a0b\u5e8f\u67e5\u8be2spu\u5546\u54c1\u4fe1\u606f\u670d\u52a1\u5f00\u59cb---");
        logger.debug("\u8c03\u7528\u5c0f\u7a0b\u5e8f\u67e5\u8be2spu\u5546\u54c1\u4fe1\u606f\u670d\u52a1\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)selectCommodityByAppletReqBO2));
        RspPageBO result = new RspPageBO();
        CommodityPO xlsCommodityPO = new CommodityPO();
        List<Object> xlsCommodityPOS = new ArrayList();
        ArrayList xlsCommodityBOS = new ArrayList();
        if (selectCommodityByAppletReqBO2 == null) {
            result.setRespCode("0000");
            result.setRespDesc("\u6210\u529f");
            return result;
        }
        Page page = new Page();
        page.setPageSize(selectCommodityByAppletReqBO2.getPageSize());
        page.setPageNo(selectCommodityByAppletReqBO2.getCurrent());
        try {
            BeanUtils.copyProperties((Object)selectCommodityByAppletReqBO2, (Object)xlsCommodityPO);
            xlsCommodityPO.setMinPrice(MoneyUtils.BigDecimal2Long(selectCommodityByAppletReqBO2.getMinPrice()));
            xlsCommodityPO.setMaxPrice(MoneyUtils.BigDecimal2Long(selectCommodityByAppletReqBO2.getMaxPrice()));
            logger.debug("\u67e5\u8be2\u5165\u53c2\u4e3a\uff1a" + xlsCommodityPO);
            xlsCommodityPOS = this.commodityDAO.selectCommodity(xlsCommodityPO, (Page<CommodityPO>)page);
            if (xlsCommodityPOS == null) {
                logger.debug("\u6570\u636e\u5e93\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u7ed3\u679c\u4e3a\u7a7a");
                result.setRespCode("0000");
                result.setRespDesc("\u6210\u529f");
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u6570\u636e\u5e93\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u51fa\u9519" + e.getMessage());
        }
        xlsCommodityPOS.stream().forEach(xlsCommodityPO1 -> {
            XlsCommodityReqBO xlsCommodityBO1 = new XlsCommodityReqBO();
            BeanUtils.copyProperties((Object)xlsCommodityPO1, (Object)xlsCommodityBO1);
            try {
                xlsCommodityBO1.setCommodityLowestPriceStr(MoneyUtils.Long2BigDecimal(xlsCommodityPO1.getCommodityLowestPrice()));
                xlsCommodityBO1.setCommodityHighestPriceStr(MoneyUtils.Long2BigDecimal(xlsCommodityPO1.getCommodityHighestPrice()));
            }
            catch (Exception e) {
                logger.error("\u91d1\u989d\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38" + e.getMessage());
                throw new BusinessException("9999", "\u91d1\u989d\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38");
            }
            xlsCommodityBOS.add(xlsCommodityBO1);
        });
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        result.setTotal(page.getTotalPages());
        result.setRecordsTotal(page.getTotalCount());
        result.setRows(xlsCommodityBOS);
        logger.debug("\u8c03\u7528\u5c0f\u7a0b\u5e8f\u67e5\u8be2spu\u5546\u54c1\u4fe1\u606f\u670d\u52a1\u51fa\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)result));
        return result;
    }

    public RspPageBO<XlsCommodityReqBO> selectCommodityBySupplierId(selectCommodityByAppletReqBO selectCommodityByAppletReqBO2) {
        logger.debug("\u8c03\u7528\u5c0f\u7a0b\u5e8f\u6709\u95e8\u5e97\u5165\u53c2\u67e5\u8be2spu\u5546\u54c1\u4fe1\u606f\u670d\u52a1\u5f00\u59cb---");
        RspPageBO result = new RspPageBO();
        CommodityPO xlsCommodityPO = new CommodityPO();
        List<Object> xlsCommodityPOS = new ArrayList();
        ArrayList xlsCommodityBOS = new ArrayList();
        if (selectCommodityByAppletReqBO2 == null) {
            result.setRespCode("0000");
            result.setRespDesc("\u6210\u529f");
            return result;
        }
        Page page = new Page();
        page.setPageSize(selectCommodityByAppletReqBO2.getPageSize());
        page.setPageNo(selectCommodityByAppletReqBO2.getCurrent());
        try {
            BeanUtils.copyProperties((Object)selectCommodityByAppletReqBO2, (Object)xlsCommodityPO);
            xlsCommodityPO.setMinPrice(MoneyUtils.BigDecimal2Long(selectCommodityByAppletReqBO2.getMinPrice()));
            xlsCommodityPO.setMaxPrice(MoneyUtils.BigDecimal2Long(selectCommodityByAppletReqBO2.getMaxPrice()));
            xlsCommodityPOS = this.commodityDAO.selectCommodityBySupplierId(xlsCommodityPO, (Page<CommodityPO>)page);
            if (xlsCommodityPOS == null) {
                logger.debug("\u6570\u636e\u5e93\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u7ed3\u679c\u4e3a\u7a7a");
                result.setRespCode("0000");
                result.setRespDesc("\u6210\u529f");
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u6570\u636e\u5e93\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u51fa\u9519" + e.getMessage());
        }
        xlsCommodityPOS.stream().forEach(xlsCommodityPO1 -> {
            XlsCommodityReqBO xlsCommodityBO1 = new XlsCommodityReqBO();
            BeanUtils.copyProperties((Object)xlsCommodityPO1, (Object)xlsCommodityBO1);
            try {
                xlsCommodityBO1.setCommodityLowestPriceStr(MoneyUtils.Long2BigDecimal(xlsCommodityPO1.getCommodityLowestPrice()));
                xlsCommodityBO1.setCommodityHighestPriceStr(MoneyUtils.Long2BigDecimal(xlsCommodityPO1.getCommodityHighestPrice()));
            }
            catch (Exception e) {
                logger.error("\u91d1\u989d\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38" + e.getMessage());
                throw new BusinessException("9999", "\u91d1\u989d\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38");
            }
            xlsCommodityBO1.setSupplierId(selectCommodityByAppletReqBO2.getSupplierId());
            xlsCommodityBOS.add(xlsCommodityBO1);
        });
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        result.setTotal(page.getTotalPages());
        result.setRecordsTotal(page.getTotalCount());
        result.setRows(xlsCommodityBOS);
        return result;
    }
}

