/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.alibaba.dubbo.common.utils.StringUtils;
import com.tydic.newretail.bo.BaseRspBO;
import com.tydic.newretail.bo.DSkuBO;
import com.tydic.newretail.bo.skuPriceMaxPriceAndMinPriceBO;
import com.tydic.newretail.busi.service.XlsSkuManageService;
import com.tydic.newretail.dao.SkuDAO;
import com.tydic.newretail.dao.po.SkuPO;
import com.tydic.newretail.dao.po.skuPriceMaxPriceAndMinPricePO;
import com.tydic.newretail.exception.BusinessException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class XlsSkuManageServiceImpl
implements XlsSkuManageService {
    private static final Logger logger = LoggerFactory.getLogger(XlsSkuManageServiceImpl.class);
    @Autowired
    private SkuDAO xlsSkuMapper;

    public BaseRspBO batchUpdate(List<DSkuBO> skuBOS) {
        logger.debug("\u66f4\u65b0\u5546\u54c1\u4fe1\u606f\u5165\u53c2" + skuBOS.size());
        BaseRspBO baseRspBO = new BaseRspBO();
        ArrayList<SkuPO> skus = new ArrayList<SkuPO>();
        if (CollectionUtils.isNotEmpty(skuBOS)) {
            for (DSkuBO skuBO : skuBOS) {
                SkuPO sku = new SkuPO();
                BeanUtils.copyProperties((Object)skuBO, (Object)sku);
                sku.setCountyCode(skuBO.getCountyCode());
                sku.setUpdateTime(new Date());
                skus.add(sku);
            }
        }
        if (CollectionUtils.isNotEmpty(skus)) {
            try {
                logger.debug("\u66f4\u65b0\u5546\u54c1\u4fe1\u606f\u5165\u53c2" + skus.size());
                this.xlsSkuMapper.batchUpdateBySkuId(skus);
            }
            catch (Exception e) {
                throw new BusinessException("RSP_CODE_DAO_ERROR", "\u6279\u91cf\u4fee\u6539\u5546\u54c1\u5f02\u5e38", e);
            }
        }
        baseRspBO.setRespCode("0000");
        baseRspBO.setRespDesc("\u6210\u529f");
        return baseRspBO;
    }

    public void batchEnableShutdowmSkuUpdate(List<Long> provGoodsIds, Integer isDelete) {
        if (CollectionUtils.isEmpty(provGoodsIds) || 1 != isDelete && 0 != isDelete) {
            logger.error("\u66f4\u65b0\u7701\u4efd\u5546\u54c1\u72b6\u6001\u8f93\u5165\u7684\u53c2\u6570\u6709\u8bef");
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u66f4\u65b0\u7701\u4efd\u5546\u54c1\u72b6\u6001\u8f93\u5165\u7684\u53c2\u6570\u6709\u8bef");
        }
        try {
            this.xlsSkuMapper.updateSkuIsDeleteByProvGoodsID(provGoodsIds, isDelete);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u66f4\u65b0\u7701\u4efd\u5546\u54c1\u72b6\u6001\u5931\u8d25");
        }
    }

    public BaseRspBO batchUpdateSku(DSkuBO skuBO) {
        BaseRspBO baseRspBO = new BaseRspBO();
        if (StringUtils.isNotEmpty((String)skuBO.getProvinceCode()) && StringUtils.isNotEmpty((String)skuBO.getMaterialId())) {
            try {
                logger.debug("\u66f4\u65b0\u5546\u54c1\u4fe1\u606f\u5165\u53c2" + skuBO);
                SkuPO sku = new SkuPO();
                BeanUtils.copyProperties((Object)skuBO, (Object)sku);
                this.xlsSkuMapper.batchUpdateByProvinceCodeMaterialId(sku);
            }
            catch (Exception e) {
                logger.error("\u539f\u5b50\u5c42\u66f4\u65b0sku\u4fe1\u606f\u5931\u8d25---\u5165\u53c2\u7701\u4efd\u7f16\u7801\u548c\u7269\u6599\u7f16\u7801\u4e0d\u4e3a\u7a7a");
                throw new BusinessException("RSP_CODE_DAO_ERROR", "\u6279\u91cf\u4fee\u6539\u5546\u54c1\u5f02\u5e38", e);
            }
        }
        baseRspBO.setRespCode("0000");
        baseRspBO.setRespDesc("\u6210\u529f");
        return baseRspBO;
    }

    public skuPriceMaxPriceAndMinPriceBO selectSkuPriceMaxPriceAndMinPrice(Long commodityId) {
        skuPriceMaxPriceAndMinPriceBO skuPriceMaxPriceAndMinPriceBO2 = new skuPriceMaxPriceAndMinPriceBO();
        if (commodityId == null) {
            logger.error("\u6839\u636espuId\u67e5\u8be2sku\u6700\u9ad8\u4ef7\u548c\u6700\u4f4e\u4ef7\u5165\u53c2\u4e3a\u7a7a\uff01");
            return skuPriceMaxPriceAndMinPriceBO2;
        }
        try {
            skuPriceMaxPriceAndMinPricePO skuPriceMaxPriceAndMinPricePO2 = this.xlsSkuMapper.selectSkuPriceMaxPriceAndMinPrice(commodityId);
            if (skuPriceMaxPriceAndMinPricePO2 == null) {
                logger.error("\u6839\u636espuId\u67e5\u8be2sku\u6700\u9ad8\u4ef7\u548c\u6700\u4f4e\u4ef7  \u672a\u67e5\u5230sku\u4fe1\u606f\uff01");
                return skuPriceMaxPriceAndMinPriceBO2;
            }
            BeanUtils.copyProperties((Object)skuPriceMaxPriceAndMinPricePO2, (Object)skuPriceMaxPriceAndMinPriceBO2);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u6839\u636espuId\u67e5\u8be2sku\u6700\u9ad8\u4ef7\u548c\u6700\u4f4e\u4ef7\u5931\u8d25\uff01");
        }
        return skuPriceMaxPriceAndMinPriceBO2;
    }

    public List<skuPriceMaxPriceAndMinPriceBO> batchSelectSkuPriceMaxPriceAndMinPrice(List<Long> commodityIds) {
        ArrayList<skuPriceMaxPriceAndMinPriceBO> skuPriceMaxPriceAndMinPriceBOS = new ArrayList<skuPriceMaxPriceAndMinPriceBO>();
        if (CollectionUtils.isEmpty(commodityIds)) {
            logger.error("\u6839\u636espuId\u5217\u8868\u67e5\u8be2sku\u6700\u9ad8\u4ef7\u548c\u6700\u4f4e\u4ef7\u5165\u53c2\u4e3a\u7a7a\uff01");
            return skuPriceMaxPriceAndMinPriceBOS;
        }
        try {
            List<skuPriceMaxPriceAndMinPricePO> skuPriceMaxPriceAndMinPricePOS = this.xlsSkuMapper.batchSelectSkuPriceMaxPriceAndMinPrice(commodityIds);
            if (CollectionUtils.isEmpty(skuPriceMaxPriceAndMinPricePOS)) {
                logger.error("\u6839\u636espuId\u5217\u8868\u67e5\u8be2sku\u6700\u9ad8\u4ef7\u548c\u6700\u4f4e\u4ef7  \u672a\u67e5\u5230sku\u4fe1\u606f\uff01");
                return skuPriceMaxPriceAndMinPriceBOS;
            }
            skuPriceMaxPriceAndMinPricePOS.stream().forEach(skuPriceMaxPriceAndMinPricePO2 -> {
                skuPriceMaxPriceAndMinPriceBO skuPriceMaxPriceAndMinPriceBO2 = new skuPriceMaxPriceAndMinPriceBO();
                BeanUtils.copyProperties((Object)skuPriceMaxPriceAndMinPricePO2, (Object)skuPriceMaxPriceAndMinPriceBO2);
                skuPriceMaxPriceAndMinPriceBOS.add(skuPriceMaxPriceAndMinPriceBO2);
            });
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u6839\u636espuId\u5217\u8868\u67e5\u8be2sku\u6700\u9ad8\u4ef7\u548c\u6700\u4f4e\u4ef7\u5931\u8d25\uff01");
        }
        return skuPriceMaxPriceAndMinPriceBOS;
    }
}

