/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.tydic.newretail.atom.SysParamsAtomService;
import com.tydic.newretail.bo.BaseRspBO;
import com.tydic.newretail.bo.PriceBO;
import com.tydic.newretail.busi.service.XlsSkuPriceManageService;
import com.tydic.newretail.dao.SkuPriceDAO;
import com.tydic.newretail.dao.po.SkuPricePO;
import com.tydic.newretail.util.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class XlsSkuPriceManageServiceImpl
implements XlsSkuPriceManageService {
    private static final Logger logger = LoggerFactory.getLogger(XlsSkuPriceManageServiceImpl.class);
    @Autowired
    private SkuPriceDAO skuPriceMapper;
    @Autowired
    private SysParamsAtomService sysParamsAtomService;

    public BaseRspBO batchUpdateSkuPrice(List<PriceBO> priceBOList) {
        BaseRspBO baseRspBO = new BaseRspBO();
        Map mapSysCommodityStatus = this.sysParamsAtomService.selectByParentCode("MEMBER_LADDER_PRICE_RULE");
        ArrayList<SkuPricePO> skuPrices = new ArrayList<SkuPricePO>();
        if (CollectionUtils.isNotEmpty(priceBOList)) {
            for (PriceBO priceBO : priceBOList) {
                SkuPricePO skuPrice = new SkuPricePO();
                BeanUtils.copyProperties((Object)priceBO, (Object)skuPrice);
                skuPrice.setUpdateTime(new Date());
                if ("1".equals(priceBO.getSheetLevel()) && StringUtils.isNotBlank((String)priceBO.getCgType()) && "601".equals(priceBO.getCgType()) && priceBO.getPurchasePrice() != null) {
                    String discountRateMemberLadderPrice1 = (String)mapSysCommodityStatus.get("1");
                    String discountRateMemberLadderPrice2 = (String)mapSysCommodityStatus.get("3");
                    String discountRateMemberLadderPrice3 = (String)mapSysCommodityStatus.get("4");
                    Double memberLadderPrice1 = (double)priceBO.getPurchasePrice().longValue() + (double)(priceBO.getSalePrice() - priceBO.getPurchasePrice()) * Double.parseDouble(discountRateMemberLadderPrice1);
                    Double memberLadderPrice2 = (double)priceBO.getPurchasePrice().longValue() + (double)(priceBO.getSalePrice() - priceBO.getPurchasePrice()) * Double.parseDouble(discountRateMemberLadderPrice2);
                    Double memberLadderPrice3 = (double)priceBO.getPurchasePrice().longValue() + (double)(priceBO.getSalePrice() - priceBO.getPurchasePrice()) * Double.parseDouble(discountRateMemberLadderPrice3);
                    skuPrice.setMemberLadderPrice1(XlsSkuPriceManageServiceImpl.roundingMemPrice(memberLadderPrice1));
                    skuPrice.setMemberLadderPrice2(XlsSkuPriceManageServiceImpl.roundingMemPrice(memberLadderPrice2));
                    skuPrice.setMemberLadderPrice3(XlsSkuPriceManageServiceImpl.roundingMemPrice(memberLadderPrice3));
                }
                skuPrices.add(skuPrice);
            }
        }
        if (CollectionUtils.isNotEmpty(skuPrices)) {
            try {
                this.skuPriceMapper.batchUpdateBySkuId(skuPrices);
            }
            catch (Exception e) {
                logger.error("\u6279\u91cf\u4fee\u6539\u5355\u54c1\u4ef7\u683c\u6570\u636e\u5e93\u62a5\u9519" + e.getMessage());
            }
        }
        baseRspBO.setRespCode("0000");
        baseRspBO.setRespDesc("\u6210\u529f");
        return baseRspBO;
    }

    public static Long roundingMemPrice(Double price) {
        if (price == null) {
            return null;
        }
        BigDecimal memberLadderPriceBigDecimal = null;
        try {
            memberLadderPriceBigDecimal = MoneyUtils.Long2BigDecimal(price.longValue());
            memberLadderPriceBigDecimal = memberLadderPriceBigDecimal.setScale(0, 4);
            memberLadderPriceBigDecimal = memberLadderPriceBigDecimal.multiply(new BigDecimal("10000"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (memberLadderPriceBigDecimal != null) {
            return memberLadderPriceBigDecimal.longValue();
        }
        return null;
    }
}

