/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.config;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.transport.client.PreBuiltTransportClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ESConfig {
    private final Logger logger = LoggerFactory.getLogger(ESConfig.class);
    @Value(value="${es.cluster.name:}")
    private String clusterName;
    @Value(value="${es.cluster.nodes:}")
    private String clusterNodes;

    @Bean
    public TransportClient transportClient() {
        Settings settings = Settings.builder().put("cluster.name", this.clusterName).put("client.transport.sniff", false).build();
        PreBuiltTransportClient client = new PreBuiltTransportClient(settings, new Class[0]);
        List<AddressPairs> addressPairs = this.parseClusterNodes(this.clusterNodes);
        for (AddressPairs p : addressPairs) {
            try {
                client.addTransportAddress(new TransportAddress(InetAddress.getByName(p.host), p.port.intValue()));
            }
            catch (UnknownHostException var7) {
                this.logger.error(var7.getMessage(), (Throwable)var7);
            }
        }
        this.logger.info("ESConfig: successful");
        return client;
    }

    private List<AddressPairs> parseClusterNodes(String nodes) {
        return Arrays.stream(nodes.split(",")).map(e -> {
            String[] pair = e.split(":");
            return new AddressPairs(pair[0], Integer.valueOf(pair[1]));
        }).collect(Collectors.toList());
    }

    class AddressPairs {
        private String host;
        private Integer port;

        public AddressPairs(String host, Integer port) {
            this.host = host;
            this.port = port;
        }
    }
}

