/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.thread;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.newretail.bo.AddProvGoodsListReqBO;
import com.tydic.newretail.bo.BaseRspBO;
import com.tydic.newretail.bo.BatchCreateSkuReqBO;
import com.tydic.newretail.bo.CreateSkuReqBO;
import com.tydic.newretail.bo.DPriceSheetBO;
import com.tydic.newretail.bo.DSkuBO;
import com.tydic.newretail.bo.ProvAndCityCodeBO;
import com.tydic.newretail.bo.ProvGoodsBO;
import com.tydic.newretail.bo.ProvinceMaterialBO;
import com.tydic.newretail.bo.SupplierBO;
import com.tydic.newretail.busi.service.AddGoodsByProvCodeService;
import com.tydic.newretail.busi.service.BatchCreateSkuService;
import com.tydic.newretail.busi.service.DPriceSheetService;
import com.tydic.newretail.busi.service.XlsSkuManageService;
import com.tydic.newretail.dao.SkuDAO;
import com.tydic.newretail.dao.po.SkuPO;
import com.tydic.newretail.exception.BusinessException;
import com.tydic.newretail.toolkit.bo.InvokeInfo;
import com.tydic.newretail.toolkit.util.TKGenericServiceUtils;
import com.tydic.newretail.util.RedisUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import redis.clients.jedis.Jedis;

public class ImportProvGoodsThrean
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ImportProvGoodsThrean.class);
    private AddProvGoodsListReqBO reqBO;
    private AddGoodsByProvCodeService addGoodsByProvCodeService;
    private SkuDAO xlsSkuMapper;
    private XlsSkuManageService xlsSkuManageService;
    private BatchCreateSkuService batchCreateSkuService;
    private DPriceSheetService dPriceSheetService;
    private String orgPath;
    private String hsfVersion;
    private String hsfGroup;
    private String hsfClientTimeout;

    public ImportProvGoodsThrean(AddProvGoodsListReqBO reqBO, AddGoodsByProvCodeService addGoodsByProvCodeService, SkuDAO xlsSkuMapper, XlsSkuManageService xlsSkuManageService, BatchCreateSkuService batchCreateSkuService, DPriceSheetService dPriceSheetService, String orgPath, String hsfVersion, String hsfGroup, String hsfClientTimeout) {
        this.addGoodsByProvCodeService = addGoodsByProvCodeService;
        this.reqBO = reqBO;
        this.xlsSkuMapper = xlsSkuMapper;
        this.xlsSkuManageService = xlsSkuManageService;
        this.batchCreateSkuService = batchCreateSkuService;
        this.dPriceSheetService = dPriceSheetService;
        this.orgPath = orgPath;
        this.hsfClientTimeout = hsfClientTimeout;
        this.hsfGroup = hsfGroup;
        this.hsfVersion = hsfVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ImportProvGoodsThrean importProvGoodsThrean = this;
        synchronized (importProvGoodsThrean) {
            try {
                this.add();
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
            finally {
                logger.debug("\u540c\u6b65\u5b8c\u6210");
                String key = "IMPORT_PROVINCE_GOODS" + ((ProvGoodsBO)this.reqBO.getReqBO().get(0)).getProvinceCode();
                RedisUtil.del(key);
            }
        }
    }

    public void add() throws Exception {
        HashMap<String, ProvGoodsBO> materialAndProvId = new HashMap();
        try {
            logger.debug("\u5bfc\u5165\u7701\u4efd\u5546\u54c1");
            BaseRspBO result = this.addGoodsByProvCodeService.provCommodityCreation(this.reqBO);
            materialAndProvId = result.getMaterialAndProvId();
        }
        catch (Exception e) {
            logger.error("\u5bfc\u5165\u7701\u4efd\u5546\u54c1\u51fa\u9519" + e);
            throw new BusinessException("9999", "\u6279\u91cf\u65b0\u589e\u7701\u4efd\u5546\u54c1\u62a5\u9519" + e.getMessage());
        }
        ArrayList<String> materialIds = new ArrayList<String>();
        for (ProvGoodsBO req : this.reqBO.getReqBO()) {
            materialIds.add(req.getMaterialId());
        }
        ProvinceMaterialBO provinceMaterialBO = new ProvinceMaterialBO();
        provinceMaterialBO.setProvinceCode(((ProvGoodsBO)this.reqBO.getReqBO().get(0)).getProvinceCode());
        provinceMaterialBO.setMaterialId(materialIds);
        Map priceSheet = this.dPriceSheetService.findDPriceSheet(provinceMaterialBO);
        try {
            Map<String, SkuPO> skuMap = this.getSku(this.reqBO.getReqBO(), this.reqBO.getmOrgPath());
            Map<String, ProvAndCityCodeBO> shopIds = this.getProvCode();
            if (!CollectionUtils.isEmpty(skuMap)) {
                ArrayList<CreateSkuReqBO> crea = new ArrayList<CreateSkuReqBO>();
                ArrayList<ProvGoodsBO> updateList = new ArrayList<ProvGoodsBO>();
                HashMap<String, SkuPO> updateMap = new HashMap<String, SkuPO>();
                for (ProvGoodsBO bo : this.reqBO.getReqBO()) {
                    for (Map.Entry<String, ProvAndCityCodeBO> shop : shopIds.entrySet()) {
                        String key = bo.getMaterialId() + shop.getValue().getProvinceCode() + shop.getValue().getCityCode();
                        DPriceSheetBO price = new DPriceSheetBO();
                        if (!CollectionUtils.isEmpty((Map)priceSheet)) {
                            DPriceSheetBO dPriceSheetBO = price = priceSheet.get(key.trim()) == null ? (DPriceSheetBO)priceSheet.get(bo.getMaterialId() + shop.getValue().getProvinceCode()) : (DPriceSheetBO)priceSheet.get(key.trim());
                        }
                        if (skuMap.containsKey(bo.getMaterialId() + shop.getKey().trim())) {
                            updateList.add(bo);
                            updateMap.put(bo.getMaterialId() + shop.getKey().trim(), skuMap.get(bo.getMaterialId() + shop.getKey().trim()));
                            continue;
                        }
                        CreateSkuReqBO cr = new CreateSkuReqBO();
                        cr.setBrandId(bo.getBrandId());
                        cr.setBrandName(bo.getBrandName());
                        cr.setColor(bo.getColorName());
                        if (price != null) {
                            cr.setSaleSrice(price.getSalePrice());
                            cr.setSheetId(price.getSheetId());
                            cr.setSheetLevel(price.getSheetLevel());
                            cr.setAssessmentPrice(price.getAssessmentPrice());
                            cr.setSaleSrice(price.getSalePrice());
                            cr.setPurchasePrice("1".equals(price.getSheetLevel()) ? price.getPurchasePrice() : null);
                            cr.setAgreementPrice(price.getAgreementPrice());
                            cr.setMemberPrice(price.getMemberPrice());
                        }
                        cr.setBrand(bo.getBrandName());
                        cr.setGoodsSource(bo.getGoodsSource());
                        cr.setModel(bo.getGoodsModel());
                        cr.setCgType(bo.getCgType());
                        cr.setExtSkuId(bo.getExtGoodsNo());
                        cr.setSkuCode(bo.getGoodsNo());
                        cr.setRam(bo.getMemoryName());
                        cr.setMeasureId(bo.getMeasureId());
                        cr.setMeasureName(bo.getMeasureName());
                        cr.setFullName(bo.getGoodsLongName());
                        cr.setSupplierId(Long.valueOf(Long.parseLong(shop.getKey())));
                        cr.setSupplierName(shop.getValue().getShopName());
                        cr.setProvinceCode(shop.getValue().getProvinceCode());
                        cr.setCountyCode(shop.getValue().getCountryCode());
                        cr.setCityCode(shop.getValue().getCityCode());
                        cr.setName(bo.getGoodsModel());
                        cr.setIsVirtualGood(bo.getAllowNegativeStock());
                        cr.setMaterialId(bo.getMaterialId());
                        cr.setProvGoodsId(((ProvGoodsBO)materialAndProvId.get(bo.getMaterialId())).getProvGoodsId());
                        cr.setProvinceCode(bo.getProvinceCode());
                        String venId = "";
                        for (SupplierBO su : bo.getSupplierBO()) {
                            venId = venId + su.getSupplierId() + ",";
                        }
                        cr.setVendorId(StringUtils.isBlank((String)venId) ? null : venId.substring(0, venId.length() - 1));
                        cr.setVendorName(bo.getSupNo());
                        crea.add(cr);
                    }
                }
                if (!CollectionUtils.isEmpty(crea)) {
                    this.addAnother(crea);
                }
                logger.debug("crea\u5783\u573e=" + crea.size());
                if (!CollectionUtils.isEmpty(updateList)) {
                    this.update(updateList, materialAndProvId, updateMap, shopIds);
                }
            } else if (!CollectionUtils.isEmpty((Collection)this.reqBO.getReqBO())) {
                this.add(this.reqBO.getReqBO(), materialAndProvId, priceSheet, this.reqBO.getmOrgPath());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u66f4\u65b0\u5546\u54c1" + e);
        }
    }

    public void update(List<ProvGoodsBO> reqBO, Map<String, ProvGoodsBO> materialAndProvId, Map<String, SkuPO> skus, Map<String, ProvAndCityCodeBO> suppliers) throws Exception {
        ArrayList<DSkuBO> skuBOS = new ArrayList<DSkuBO>();
        HashMap<String, ProvGoodsBO> prov = new HashMap<String, ProvGoodsBO>();
        for (ProvGoodsBO provGoodsBO : reqBO) {
            if (prov.containsKey(provGoodsBO.getMaterialId())) continue;
            prov.put(provGoodsBO.getMaterialId(), provGoodsBO);
        }
        DSkuBO skuBO = null;
        for (Map.Entry<String, SkuPO> entry : skus.entrySet()) {
            skuBO = new DSkuBO();
            String supplierId = entry.getValue().getSupplierId().toString().trim();
            skuBO.setBrandId(((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getBrandId());
            skuBO.setBrandName(((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getBrandName());
            skuBO.setColor(((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getColorName());
            skuBO.setBrand(((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getBrandName());
            skuBO.setGoodsSource(((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getGoodsSource());
            String venId = "";
            for (SupplierBO su : ((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getSupplierBO()) {
                venId = venId + su.getSupplierId() + ",";
            }
            skuBO.setModel(((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getGoodsModel());
            skuBO.setVendorId(StringUtils.isBlank((String)venId) ? null : venId.substring(0, venId.length() - 1));
            skuBO.setVendorName(((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getSupNo());
            skuBO.setSkuId(entry.getValue().getSkuId());
            skuBO.setRam(((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getMemoryName());
            skuBO.setProvinceCode(entry.getValue().getProvinceCode());
            if (StringUtils.isBlank((String)suppliers.get(supplierId).getCountryCode())) {
                logger.debug("\u672a\u83b7\u53d6\u5230\u533a\u53bf\u7f16\u7801\u7684\u95e8\u5e97\uff1a" + supplierId);
            }
            skuBO.setCountyCode(suppliers.get(supplierId).getCountryCode());
            skuBO.setCityCode(suppliers.get(supplierId).getCityCode());
            skuBO.setExtSkuId(((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getExtGoodsNo());
            skuBO.setSkuCode(((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getGoodsNo());
            skuBO.setSkuName(((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getGoodsLongName());
            skuBO.setSkuLongName(((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getGoodsLongName());
            skuBO.setErpLongName(((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getGoodsLongName());
            skuBO.setSkuPriceTagName(((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getGoodsLongName());
            skuBO.setMfgSku(((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getGoodsModel());
            skuBO.setIsVirtualGood(((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getAllowNegativeStock());
            skuBO.setProvGoodsId(materialAndProvId.get(entry.getValue().getMaterialId()).getProvGoodsId());
            skuBO.setSupplierId(entry.getValue().getSupplierId());
            skuBO.setIsDelete(Integer.valueOf(0));
            skuBOS.add(skuBO);
        }
        logger.debug("\u5546\u54c1\u66f4\u65b0\u6570\u91cf" + skuBOS.size());
        int n = 2000;
        Integer n2 = skuBOS.size();
        int part = n2 / n;
        int len = n2 % n == 0 ? part : part + 1;
        logger.debug("\u65b0\u589e\u5546\u54c1\u5171" + n2 + "\u6761\u6570\u636e\u3002\u5206" + len + "\u6b21\u6267\u884c");
        ExecutorService service = Executors.newFixedThreadPool(9);
        for (int i = 0; i < len; ++i) {
            logger.debug("\u7b2c" + i + "\u6279\u6570\u636e");
            int start = i * n;
            int end = start + n;
            if (end > n2) {
                end = n2;
            }
            logger.debug("\u5f00\u59cb\u7ed3\u675f=" + start + "+" + end);
            final List rows = skuBOS.subList(start, end);
            service.execute(new Runnable(){

                @Override
                public void run() {
                    ImportProvGoodsThrean.this.xlsSkuManageService.batchUpdate(rows);
                }
            });
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        service.shutdown();
    }

    public Map<String, SkuPO> getSku(List<ProvGoodsBO> reqBO, String orgPath) throws Exception {
        HashMap<String, SkuPO> skuMap = new HashMap<String, SkuPO>();
        String provinceCode = reqBO.get(0).getProvinceCode();
        Map<String, ProvAndCityCodeBO> shopIds = this.getProvCode();
        List<Object> skus = new ArrayList();
        if (!CollectionUtils.isEmpty(shopIds)) {
            ArrayList<String> materialIds = new ArrayList<String>();
            for (ProvGoodsBO bo : reqBO) {
                materialIds.add(bo.getMaterialId());
            }
            skus = this.xlsSkuMapper.findSkuByProvinceCodeMeterialIds(provinceCode, materialIds);
        }
        if (!CollectionUtils.isEmpty(skus)) {
            for (SkuPO sk : skus) {
                if (!shopIds.containsKey(sk.getSupplierId().toString())) continue;
                sk.setProvinceCode(shopIds.get(sk.getSupplierId().toString()).getProvinceCode());
                sk.setCityCode(shopIds.get(sk.getSupplierId().toString()).getCityCode());
                if (skuMap.containsKey(sk.getMaterialId() + sk.getSupplierId())) continue;
                skuMap.put(sk.getMaterialId() + sk.getSupplierId(), sk);
            }
        }
        return skuMap;
    }

    public Map<String, ProvAndCityCodeBO> getProvCode() throws Exception {
        HashMap<String, ProvAndCityCodeBO> map = new HashMap<String, ProvAndCityCodeBO>();
        JSONObject param = new JSONObject();
        param.put("queryType", (Object)4);
        param.fluentPut("orgTreePath", (Object)this.orgPath);
        param.put("isCutoverFlag", (Object)1);
        param.put("isFilteStoreId", (Object)0);
        param.put("allStatus", (Object)1);
        logger.debug(param.toString());
        InvokeInfo invokeInfo = new InvokeInfo("com.ohaotian.authority.organisation.service.SelectOrgTreeService", "selectOrgTree", "com.ohaotian.authority.organisation.bo.SelectOrgTreeReqBO");
        invokeInfo.setVersion(this.hsfVersion);
        invokeInfo.setGroup(this.hsfGroup);
        invokeInfo.setClientTimeout(Integer.valueOf(this.hsfClientTimeout));
        invokeInfo.setRegisterType("2");
        JSONObject prov = TKGenericServiceUtils.genericServiceInvoke((String)JSONObject.toJSONString((Object)param), null, (InvokeInfo)invokeInfo);
        logger.debug("\u8fdb\u884c\u6cdb\u5316\u8c03\u7528\u8fd4\u56de\u503c" + prov);
        if (!CollectionUtils.isEmpty((Collection)prov.getJSONArray("orgTreeBOList"))) {
            JSONArray orgTreeBOList = prov.getJSONArray("orgTreeBOList");
            logger.debug("\u67e5\u8be2\u95e8\u5e97\u8fd4\u56de\u6761\u6570=" + orgTreeBOList.size());
            for (int i = 0; i < orgTreeBOList.size(); ++i) {
                JSONObject item = orgTreeBOList.getJSONObject(i);
                if (!StringUtils.isNotEmpty((String)item.getString("storeId"))) continue;
                ProvAndCityCodeBO bo = new ProvAndCityCodeBO();
                bo.setCityCode(item.getString("cityCode"));
                bo.setProvinceCode(item.getString("provinceCode"));
                bo.setShopName(item.getString("orgName"));
                if (StringUtils.isBlank((String)item.getString("districtCode"))) {
                    logger.debug("\u67e5\u8be2\u7ec4\u7ec7\u673a\u6784\u4e2d\uff0c\u672a\u83b7\u53d6\u5230\u533a\u53bf\u7f16\u7801\u7684\u95e8\u5e97\uff1a" + item.getString("storeId"));
                }
                bo.setCountryCode(item.getString("districtCode"));
                map.put(item.getString("storeId").trim(), bo);
            }
        }
        return map;
    }

    public void add(List<ProvGoodsBO> reqBO, Map<String, ProvGoodsBO> materialAndProvId, Map<String, DPriceSheetBO> priceSheet, String orgPath) throws Exception {
        Map<String, ProvAndCityCodeBO> shopIds = this.getProvCode();
        ArrayList<CreateSkuReqBO> reqList = new ArrayList<CreateSkuReqBO>();
        if (!CollectionUtils.isEmpty(shopIds)) {
            for (Map.Entry<String, ProvAndCityCodeBO> shopId : shopIds.entrySet()) {
                for (ProvGoodsBO provPO : reqBO) {
                    CreateSkuReqBO bo = new CreateSkuReqBO();
                    String key = provPO.getMaterialId() + shopId.getValue().getProvinceCode() + shopId.getValue().getCityCode();
                    DPriceSheetBO price = new DPriceSheetBO();
                    if (!CollectionUtils.isEmpty(priceSheet)) {
                        price = priceSheet.get(key.trim()) == null ? priceSheet.get(provPO.getMaterialId() + shopId.getValue().getProvinceCode()) : priceSheet.get(key.trim());
                    }
                    bo = new CreateSkuReqBO();
                    bo.setBrandId(provPO.getBrandId());
                    bo.setBrandName(provPO.getBrandName());
                    bo.setColor(provPO.getColorName());
                    bo.setBrand(provPO.getBrandName());
                    bo.setGoodsSource(provPO.getGoodsSource());
                    bo.setModel(provPO.getGoodsModel());
                    bo.setCgType(provPO.getCgType());
                    bo.setExtSkuId(provPO.getExtGoodsNo());
                    bo.setSkuCode(provPO.getGoodsNo());
                    bo.setMeasureId(provPO.getMeasureId());
                    bo.setMeasureName(provPO.getMeasureName());
                    bo.setFullName(provPO.getGoodsLongName());
                    if (price != null) {
                        bo.setSaleSrice(price.getSalePrice());
                        bo.setSheetId(price.getSheetId());
                        bo.setSheetLevel(price.getSheetLevel());
                        bo.setAssessmentPrice(price.getAssessmentPrice());
                        bo.setSaleSrice(price.getSalePrice());
                        bo.setPurchasePrice("1".equals(price.getSheetLevel()) ? price.getPurchasePrice() : null);
                        bo.setAgreementPrice(price.getAgreementPrice());
                        bo.setMemberPrice(price.getMemberPrice());
                    }
                    bo.setSupplierId(Long.valueOf(Long.parseLong(shopId.getKey())));
                    bo.setSupplierName(shopId.getValue().getShopName());
                    bo.setProvinceCode(shopId.getValue().getProvinceCode());
                    bo.setCountyCode(shopId.getValue().getCountryCode());
                    bo.setCityCode(shopId.getValue().getCityCode());
                    bo.setName(provPO.getGoodsModel());
                    bo.setIsVirtualGood(provPO.getAllowNegativeStock());
                    bo.setMaterialId(provPO.getMaterialId());
                    bo.setProvGoodsId(materialAndProvId.get(provPO.getMaterialId()).getProvGoodsId());
                    bo.setProvinceCode(provPO.getProvinceCode());
                    bo.setRam(provPO.getMemoryName());
                    String venId = "";
                    for (SupplierBO su : provPO.getSupplierBO()) {
                        venId = venId + su.getSupplierId() + ",";
                    }
                    bo.setVendorId(StringUtils.isBlank((String)venId) ? null : venId.substring(0, venId.length() - 1));
                    bo.setVendorName(provPO.getSupNo());
                    reqList.add(bo);
                }
            }
            logger.debug("\u65b0\u589e\u5546\u54c1\u6570\u91cf" + reqList.size());
            int pointsDataLimit = 2000;
            Integer size = reqList.size();
            int part = size / pointsDataLimit;
            int len = size % pointsDataLimit == 0 ? part : part + 1;
            logger.debug("\u65b0\u589e\u5546\u54c1\u5171" + size + "\u6761\u6570\u636e\u3002\u5206" + len + "\u6b21\u6267\u884c");
            ExecutorService service = Executors.newFixedThreadPool(9);
            for (int i = 0; i < len; ++i) {
                logger.debug("\u7b2c" + i + "\u6279\u6570\u636e");
                int start = i * pointsDataLimit;
                int end = start + pointsDataLimit;
                if (end > size) {
                    end = size;
                }
                logger.debug("\u5f00\u59cb\u7ed3\u675f=" + start + "+" + end);
                final List rows = reqList.subList(start, end);
                service.execute(new Runnable(){

                    @Override
                    public void run() {
                        BatchCreateSkuReqBO batchCreateSkuReqBO = new BatchCreateSkuReqBO();
                        batchCreateSkuReqBO.setCreateSkuReqBOs(rows);
                        ImportProvGoodsThrean.this.batchCreateSkuService.batchCreateSku(batchCreateSkuReqBO);
                    }
                });
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            service.shutdown();
            reqList = null;
        }
    }

    public void addAnother(List<CreateSkuReqBO> add) {
        logger.debug("\u65b0\u589e\u5176\u4ed6\u6570\u91cf" + add.size());
        int pointsDataLimit = 2000;
        Integer size = add.size();
        int part = size / pointsDataLimit;
        int len = size % pointsDataLimit == 0 ? part : part + 1;
        logger.debug("\u65b0\u589e\u5546\u54c1\u5171" + size + "\u6761\u6570\u636e\u3002\u5206" + len + "\u6b21\u6267\u884c");
        ExecutorService service = Executors.newFixedThreadPool(9);
        for (int i = 0; i < len; ++i) {
            logger.debug("\u7b2c" + i + "\u6279\u6570\u636e");
            int start = i * pointsDataLimit;
            int end = start + pointsDataLimit;
            if (end > size) {
                end = size;
            }
            logger.debug("\u5f00\u59cb\u7ed3\u675f=" + start + "+" + end);
            final List<CreateSkuReqBO> rows = add.subList(start, end);
            service.execute(new Runnable(){

                @Override
                public void run() {
                    BatchCreateSkuReqBO batchCreateSkuReqBO = new BatchCreateSkuReqBO();
                    batchCreateSkuReqBO.setCreateSkuReqBOs(rows);
                    ImportProvGoodsThrean.this.batchCreateSkuService.batchCreateSku(batchCreateSkuReqBO);
                }
            });
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        service.shutdown();
        add = null;
    }

    public void CTMSCreateProvGoods() {
        HashMap<String, ProvGoodsBO> materialAndProvId = new HashMap();
        logger.debug("CTMS\u6279\u91cf\u521b\u5efa\u7701\u4efd\u5546\u54c1\u5165\u53c2" + JSON.toJSONString((Object)this.reqBO));
        BaseRspBO result = this.addGoodsByProvCodeService.provCommodityCreation(this.reqBO);
        materialAndProvId = result.getMaterialAndProvId();
        if ("8888".equals(result.getRespCode())) {
            logger.error("CTMS\u6279\u91cf\u521b\u5efa\u7701\u4efd\u5546\u54c1\u51fa\u9519" + result.getRespDesc());
            throw new BusinessException("9999", "CTMS\u6279\u91cf\u521b\u5efa\u7701\u4efd\u5546\u54c1\u51fa\u9519" + result.getRespDesc());
        }
        ArrayList<String> materialIds = new ArrayList<String>();
        for (ProvGoodsBO req : this.reqBO.getReqBO()) {
            materialIds.add(req.getMaterialId());
        }
        ProvinceMaterialBO provinceMaterialBO = new ProvinceMaterialBO();
        provinceMaterialBO.setProvinceCode(((ProvGoodsBO)this.reqBO.getReqBO().get(0)).getProvinceCode());
        provinceMaterialBO.setMaterialId(materialIds);
        Map priceSheet = this.dPriceSheetService.findDPriceSheet(provinceMaterialBO);
        try {
            Map<String, SkuPO> skuMap = this.getSku(this.reqBO.getReqBO(), this.reqBO.getmOrgPath());
            Map<String, ProvAndCityCodeBO> shopIds = this.getProvCode();
            if (!CollectionUtils.isEmpty(skuMap)) {
                ArrayList<CreateSkuReqBO> crea = new ArrayList<CreateSkuReqBO>();
                ArrayList<ProvGoodsBO> updateList = new ArrayList<ProvGoodsBO>();
                HashMap<String, SkuPO> updateMap = new HashMap<String, SkuPO>();
                for (ProvGoodsBO bo : this.reqBO.getReqBO()) {
                    for (Map.Entry<String, ProvAndCityCodeBO> shop : shopIds.entrySet()) {
                        String key = bo.getMaterialId() + shop.getValue().getProvinceCode() + shop.getValue().getCityCode();
                        DPriceSheetBO price = new DPriceSheetBO();
                        if (!CollectionUtils.isEmpty((Map)priceSheet)) {
                            DPriceSheetBO dPriceSheetBO = price = priceSheet.get(key.trim()) == null ? (DPriceSheetBO)priceSheet.get(bo.getMaterialId() + shop.getValue().getProvinceCode()) : (DPriceSheetBO)priceSheet.get(key.trim());
                        }
                        if (skuMap.containsKey(bo.getMaterialId() + shop.getKey().trim())) {
                            updateList.add(bo);
                            updateMap.put(bo.getMaterialId() + shop.getKey().trim(), skuMap.get(bo.getMaterialId() + shop.getKey().trim()));
                            continue;
                        }
                        CreateSkuReqBO cr = new CreateSkuReqBO();
                        cr.setBrandId(bo.getBrandId());
                        cr.setBrandName(bo.getBrandName());
                        cr.setColor(bo.getColorName());
                        if (price != null) {
                            cr.setSaleSrice(price.getSalePrice());
                            cr.setSheetId(price.getSheetId());
                            cr.setSheetLevel(price.getSheetLevel());
                            cr.setAssessmentPrice(price.getAssessmentPrice());
                            cr.setSaleSrice(price.getSalePrice());
                            cr.setPurchasePrice("1".equals(price.getSheetLevel()) ? price.getPurchasePrice() : null);
                            cr.setAgreementPrice(price.getAgreementPrice());
                            cr.setMemberPrice(price.getMemberPrice());
                        }
                        cr.setBrand(bo.getBrandName());
                        cr.setGoodsSource(bo.getGoodsSource());
                        cr.setModel(bo.getGoodsModel());
                        cr.setCgType(bo.getCgType());
                        cr.setExtSkuId(bo.getExtGoodsNo());
                        cr.setSkuCode(bo.getGoodsNo());
                        cr.setRam(bo.getMemoryName());
                        cr.setMeasureId(bo.getMeasureId());
                        cr.setMeasureName(bo.getMeasureName());
                        cr.setFullName(bo.getGoodsLongName());
                        cr.setSupplierId(Long.valueOf(Long.parseLong(shop.getKey())));
                        cr.setSupplierName(shop.getValue().getShopName());
                        cr.setProvinceCode(shop.getValue().getProvinceCode());
                        cr.setCountyCode(shop.getValue().getCountryCode());
                        cr.setCityCode(shop.getValue().getCityCode());
                        cr.setName(bo.getGoodsModel());
                        cr.setIsVirtualGood(bo.getAllowNegativeStock());
                        cr.setMaterialId(bo.getMaterialId());
                        cr.setProvGoodsId(((ProvGoodsBO)materialAndProvId.get(bo.getMaterialId())).getProvGoodsId());
                        cr.setProvinceCode(bo.getProvinceCode());
                        String venId = "";
                        for (SupplierBO su : bo.getSupplierBO()) {
                            venId = venId + su.getSupplierId() + ",";
                        }
                        cr.setVendorId(StringUtils.isBlank((String)venId) ? null : venId.substring(0, venId.length() - 1));
                        cr.setVendorName(bo.getSupNo());
                        crea.add(cr);
                    }
                }
                if (!CollectionUtils.isEmpty(crea)) {
                    this.CTMSaddAnother(crea);
                }
                logger.debug("crea\u5783\u573e=" + crea.size());
                if (!CollectionUtils.isEmpty(updateList)) {
                    this.CTMSupdate(updateList, materialAndProvId, updateMap, shopIds);
                }
            } else if (!CollectionUtils.isEmpty((Collection)this.reqBO.getReqBO())) {
                this.CTMSadd(this.reqBO.getReqBO(), materialAndProvId, priceSheet, this.reqBO.getmOrgPath());
            }
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0SKU\u5546\u54c1\u51fa\u9519" + e.getMessage());
            throw new BusinessException("9999", "\u66f4\u65b0SKU\u5546\u54c1\u51fa\u9519" + e.getMessage());
        }
    }

    public void CTMSadd(List<ProvGoodsBO> reqBO, Map<String, ProvGoodsBO> materialAndProvId, Map<String, DPriceSheetBO> priceSheet, String orgPath) throws Exception {
        Map<String, ProvAndCityCodeBO> shopIds = this.getProvCode();
        ArrayList<CreateSkuReqBO> reqList = new ArrayList<CreateSkuReqBO>();
        if (!CollectionUtils.isEmpty(shopIds)) {
            for (Map.Entry<String, ProvAndCityCodeBO> shopId : shopIds.entrySet()) {
                for (ProvGoodsBO provPO : reqBO) {
                    CreateSkuReqBO bo = new CreateSkuReqBO();
                    String key = provPO.getMaterialId() + shopId.getValue().getProvinceCode() + shopId.getValue().getCityCode();
                    DPriceSheetBO price = new DPriceSheetBO();
                    if (!CollectionUtils.isEmpty(priceSheet)) {
                        price = priceSheet.get(key.trim()) == null ? priceSheet.get(provPO.getMaterialId() + shopId.getValue().getProvinceCode()) : priceSheet.get(key.trim());
                    }
                    bo = new CreateSkuReqBO();
                    bo.setBrandId(provPO.getBrandId());
                    bo.setBrandName(provPO.getBrandName());
                    bo.setColor(provPO.getColorName());
                    bo.setBrand(provPO.getBrandName());
                    bo.setGoodsSource(provPO.getGoodsSource());
                    bo.setModel(provPO.getGoodsModel());
                    bo.setCgType(provPO.getCgType());
                    bo.setExtSkuId(provPO.getExtGoodsNo());
                    bo.setSkuCode(provPO.getGoodsNo());
                    bo.setMeasureId(provPO.getMeasureId());
                    bo.setMeasureName(provPO.getMeasureName());
                    bo.setFullName(provPO.getGoodsLongName());
                    if (price != null) {
                        bo.setSaleSrice(price.getSalePrice());
                        bo.setSheetId(price.getSheetId());
                        bo.setSheetLevel(price.getSheetLevel());
                        bo.setAssessmentPrice(price.getAssessmentPrice());
                        bo.setSaleSrice(price.getSalePrice());
                        bo.setPurchasePrice("1".equals(price.getSheetLevel()) ? price.getPurchasePrice() : null);
                        bo.setAgreementPrice(price.getAgreementPrice());
                        bo.setMemberPrice(price.getMemberPrice());
                    }
                    bo.setSupplierId(Long.valueOf(Long.parseLong(shopId.getKey())));
                    bo.setSupplierName(shopId.getValue().getShopName());
                    bo.setProvinceCode(shopId.getValue().getProvinceCode());
                    bo.setCountyCode(shopId.getValue().getCountryCode());
                    bo.setCityCode(shopId.getValue().getCityCode());
                    bo.setName(provPO.getGoodsModel());
                    bo.setIsVirtualGood(provPO.getAllowNegativeStock());
                    bo.setMaterialId(provPO.getMaterialId());
                    bo.setProvGoodsId(materialAndProvId.get(provPO.getMaterialId()).getProvGoodsId());
                    bo.setProvinceCode(provPO.getProvinceCode());
                    bo.setRam(provPO.getMemoryName());
                    String venId = "";
                    for (SupplierBO su : provPO.getSupplierBO()) {
                        venId = venId + su.getSupplierId() + ",";
                    }
                    bo.setVendorId(StringUtils.isBlank((String)venId) ? null : venId.substring(0, venId.length() - 1));
                    bo.setVendorName(provPO.getSupNo());
                    reqList.add(bo);
                }
            }
            logger.debug("\u65b0\u589e\u5546\u54c1\u6570\u91cf" + reqList.size());
            int pointsDataLimit = 2000;
            Integer size = reqList.size();
            int part = size / pointsDataLimit;
            int len = size % pointsDataLimit == 0 ? part : part + 1;
            logger.debug("\u65b0\u589e\u5546\u54c1\u5171" + size + "\u6761\u6570\u636e\u3002\u5206" + len + "\u6b21\u6267\u884c");
            ExecutorService service = Executors.newFixedThreadPool(16);
            for (int i = 0; i < len; ++i) {
                logger.debug("\u7b2c" + i + "\u6279\u6570\u636e");
                int start = i * pointsDataLimit;
                int end = start + pointsDataLimit;
                if (end > size) {
                    end = size;
                }
                logger.debug("\u5f00\u59cb\u7ed3\u675f=" + start + "+" + end);
                final List rows = reqList.subList(start, end);
                try {
                    service.execute(new Runnable(){

                        @Override
                        public void run() {
                            BatchCreateSkuReqBO batchCreateSkuReqBO = new BatchCreateSkuReqBO();
                            batchCreateSkuReqBO.setCreateSkuReqBOs(rows);
                            ImportProvGoodsThrean.this.batchCreateSkuService.batchCreateSku(batchCreateSkuReqBO);
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (service != null) {
                service.shutdown();
            }
            while (true) {
                if (service.isTerminated()) {
                    ArrayList redisDeleteMaterialIds = new ArrayList();
                    reqBO.stream().forEach(str -> redisDeleteMaterialIds.add(str.getMaterialId()));
                    String key = "IMPORT_PROVINCE_GOODS" + reqBO.get(0).getProvinceCode();
                    Jedis jedis = RedisUtil.getJedis();
                    logger.debug("CTMSadds\u65b9\u6cd5\u5220\u9664Redis\u4e2d\u7684\u6570\u636e" + JSON.toJSONString(redisDeleteMaterialIds));
                    jedis.srem(key, new String[]{String.valueOf(redisDeleteMaterialIds)});
                    if (null == jedis) break;
                    jedis.close();
                    break;
                }
                Thread.sleep(1000L);
            }
            logger.debug("\u6267\u884c\u5b8c\u6bd5");
        }
    }

    public void CTMSaddAnother(List<CreateSkuReqBO> add) throws InterruptedException {
        logger.debug("\u65b0\u589e\u5176\u4ed6\u6570\u91cf" + add.size());
        int pointsDataLimit = 2000;
        Integer size = add.size();
        int part = size / pointsDataLimit;
        int len = size % pointsDataLimit == 0 ? part : part + 1;
        logger.debug("\u65b0\u589e\u5546\u54c1\u5171" + size + "\u6761\u6570\u636e\u3002\u5206" + len + "\u6b21\u6267\u884c");
        ExecutorService service = Executors.newFixedThreadPool(16);
        for (int i = 0; i < len; ++i) {
            logger.debug("\u7b2c" + i + "\u6279\u6570\u636e");
            int start = i * pointsDataLimit;
            int end = start + pointsDataLimit;
            if (end > size) {
                end = size;
            }
            logger.debug("\u5f00\u59cb\u7ed3\u675f=" + start + "+" + end);
            final List<CreateSkuReqBO> rows = add.subList(start, end);
            try {
                service.execute(new Runnable(){

                    @Override
                    public void run() {
                        BatchCreateSkuReqBO batchCreateSkuReqBO = new BatchCreateSkuReqBO();
                        batchCreateSkuReqBO.setCreateSkuReqBOs(rows);
                        ImportProvGoodsThrean.this.batchCreateSkuService.batchCreateSku(batchCreateSkuReqBO);
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (service != null) {
            service.shutdown();
        }
        while (true) {
            if (service.isTerminated()) {
                ArrayList redisDeleteMaterialIds = new ArrayList();
                add.stream().forEach(str -> redisDeleteMaterialIds.add(str.getMaterialId()));
                String key = "IMPORT_PROVINCE_GOODS" + add.get(0).getProvinceCode();
                Jedis jedis = RedisUtil.getJedis();
                logger.debug("CTMSadds\u65b9\u6cd5\u5220\u9664Redis\u4e2d\u7684\u6570\u636e" + JSON.toJSONString(redisDeleteMaterialIds));
                jedis.srem(key, new String[]{String.valueOf(redisDeleteMaterialIds)});
                if (null == jedis) break;
                jedis.close();
                break;
            }
            Thread.sleep(1000L);
        }
        logger.debug("\u6267\u884c\u5b8c\u6bd5");
    }

    public void CTMSupdate(List<ProvGoodsBO> reqBO, Map<String, ProvGoodsBO> materialAndProvId, Map<String, SkuPO> skus, Map<String, ProvAndCityCodeBO> suppliers) throws Exception {
        ArrayList<DSkuBO> skuBOS = new ArrayList<DSkuBO>();
        HashMap<String, ProvGoodsBO> prov = new HashMap<String, ProvGoodsBO>();
        for (ProvGoodsBO provGoodsBO : reqBO) {
            if (prov.containsKey(provGoodsBO.getMaterialId())) continue;
            prov.put(provGoodsBO.getMaterialId(), provGoodsBO);
        }
        DSkuBO skuBO = null;
        for (Map.Entry<String, SkuPO> entry : skus.entrySet()) {
            skuBO = new DSkuBO();
            String supplierId = entry.getValue().getSupplierId().toString().trim();
            skuBO.setBrandId(((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getBrandId());
            skuBO.setBrandName(((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getBrandName());
            skuBO.setColor(((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getColorName());
            skuBO.setBrand(((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getBrandName());
            skuBO.setGoodsSource(((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getGoodsSource());
            String venId = "";
            for (SupplierBO su : ((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getSupplierBO()) {
                venId = venId + su.getSupplierId() + ",";
            }
            skuBO.setModel(((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getGoodsModel());
            skuBO.setVendorId(StringUtils.isBlank((String)venId) ? null : venId.substring(0, venId.length() - 1));
            skuBO.setVendorName(((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getSupNo());
            skuBO.setSkuId(entry.getValue().getSkuId());
            skuBO.setRam(((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getMemoryName());
            skuBO.setProvinceCode(entry.getValue().getProvinceCode());
            if (StringUtils.isBlank((String)suppliers.get(supplierId).getCountryCode())) {
                logger.debug("\u672a\u83b7\u53d6\u5230\u533a\u53bf\u7f16\u7801\u7684\u95e8\u5e97\uff1a" + supplierId);
            }
            skuBO.setCountyCode(suppliers.get(supplierId).getCountryCode());
            skuBO.setCityCode(suppliers.get(supplierId).getCityCode());
            skuBO.setExtSkuId(((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getExtGoodsNo());
            skuBO.setSkuCode(((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getGoodsNo());
            skuBO.setSkuName(((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getGoodsLongName());
            skuBO.setSkuLongName(((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getGoodsLongName());
            skuBO.setErpLongName(((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getGoodsLongName());
            skuBO.setSkuPriceTagName(((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getGoodsLongName());
            skuBO.setMfgSku(((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getGoodsModel());
            skuBO.setIsVirtualGood(((ProvGoodsBO)prov.get(entry.getValue().getMaterialId())).getAllowNegativeStock());
            skuBO.setProvGoodsId(materialAndProvId.get(entry.getValue().getMaterialId()).getProvGoodsId());
            skuBO.setSupplierId(entry.getValue().getSupplierId());
            skuBO.setIsDelete(Integer.valueOf(0));
            skuBOS.add(skuBO);
        }
        logger.debug("\u5546\u54c1\u66f4\u65b0\u6570\u91cf" + skuBOS.size());
        int n = 2000;
        Integer n2 = skuBOS.size();
        int part = n2 / n;
        int len = n2 % n == 0 ? part : part + 1;
        logger.debug("\u65b0\u589e\u5546\u54c1\u5171" + n2 + "\u6761\u6570\u636e\u3002\u5206" + len + "\u6b21\u6267\u884c");
        ExecutorService service = Executors.newFixedThreadPool(16);
        for (int i = 0; i < len; ++i) {
            logger.debug("\u7b2c" + i + "\u6279\u6570\u636e");
            int start = i * n;
            int end = start + n;
            if (end > n2) {
                end = n2;
            }
            logger.debug("\u5f00\u59cb\u7ed3\u675f=" + start + "+" + end);
            final List rows = skuBOS.subList(start, end);
            try {
                service.execute(new Runnable(){

                    @Override
                    public void run() {
                        ImportProvGoodsThrean.this.xlsSkuManageService.batchUpdate(rows);
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (service != null) {
            service.shutdown();
        }
        while (true) {
            if (service.isTerminated()) {
                ArrayList redisDeleteMaterialIds = new ArrayList();
                reqBO.stream().forEach(str -> redisDeleteMaterialIds.add(str.getMaterialId()));
                String key = "IMPORT_PROVINCE_GOODS" + reqBO.get(0).getProvinceCode();
                Jedis jedis = RedisUtil.getJedis();
                logger.debug("CTMSadds\u65b9\u6cd5\u5220\u9664Redis\u4e2d\u7684\u6570\u636e" + JSON.toJSONString(redisDeleteMaterialIds));
                jedis.srem(key, new String[]{String.valueOf(redisDeleteMaterialIds)});
                if (null == jedis) break;
                jedis.close();
                break;
            }
            Thread.sleep(1000L);
        }
        logger.debug("\u6267\u884c\u5b8c\u6bd5");
    }
}

