/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.thread;

import com.tydic.newretail.bo.HeadquarterOfferAddReqBO;
import com.tydic.newretail.bo.PriceBO;
import com.tydic.newretail.bo.PriceSheetItemBO;
import com.tydic.newretail.busi.service.XlsSkuPriceManageService;
import com.tydic.newretail.dao.SkuDAO;
import com.tydic.newretail.dao.po.SkuPO;
import com.tydic.newretail.util.MoneyUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class PriceSheetAddThread
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(PriceSheetAddThread.class);
    private SkuDAO skuDAO;
    private XlsSkuPriceManageService xlsSkuPriceManageService;
    private List<String> provCode;
    private List<String> matreialIds;
    private HeadquarterOfferAddReqBO reqBO;
    private Long sheetId;

    public PriceSheetAddThread(SkuDAO skuDAO, XlsSkuPriceManageService xlsSkuPriceManageService, List<String> provCode, List<String> matreialIds, HeadquarterOfferAddReqBO reqBO, Long sheetId) {
        this.skuDAO = skuDAO;
        this.xlsSkuPriceManageService = xlsSkuPriceManageService;
        this.provCode = provCode;
        this.matreialIds = matreialIds;
        this.reqBO = reqBO;
        this.sheetId = sheetId;
    }

    @Override
    public void run() {
        try {
            for (String prov : this.provCode) {
                List<Object> skuList = new ArrayList();
                ArrayList<String> code = new ArrayList<String>();
                code.add(prov);
                logger.debug("sku\u5165\u53c2\u7269\u6599\u7684\u6570\u91cf\uff1a" + this.matreialIds.size());
                logger.debug("\u7701\u4efd\u7684\u6570\u91cf" + code.size());
                skuList = this.skuDAO.queryXlsSkuByProvCodesAndMaterialIds(code, this.matreialIds);
                logger.debug("\u5373\u5c06\u66f4\u65b0\u7684sku" + skuList.size());
                HashMap<String, PriceSheetItemBO> priceMap = new HashMap<String, PriceSheetItemBO>();
                for (PriceSheetItemBO price : this.reqBO.getPriceSheetItemBOList()) {
                    if (priceMap.containsKey(price.getMaterialId())) continue;
                    priceMap.put(price.getMaterialId(), price);
                }
                logger.debug("\u4fee\u6539sku\u4ef7\u683c");
                if (CollectionUtils.isEmpty(skuList)) continue;
                ArrayList<SkuPO> price = new ArrayList<SkuPO>();
                ArrayList<PriceBO> priceBOList = new ArrayList<PriceBO>();
                SkuPO po = null;
                PriceBO priceBO = null;
                for (SkuPO skuPO : skuList) {
                    po = new SkuPO();
                    po.setSkuId(skuPO.getSkuId());
                    if (skuPO.getSkuStatus() == 5) {
                        po.setSkuStatus(2);
                    } else if (skuPO.getSkuStatus() == 4) {
                        po.setSkuStatus(1);
                    }
                    po.setSkuPrice(MoneyUtils.BigDecimal2Long(((PriceSheetItemBO)priceMap.get(skuPO.getMaterialId())).getSalePriceStr()));
                    po.setUpdateTime(new Date());
                    po.setProvinceCode(skuPO.getProvinceCode());
                    price.add(po);
                    priceBO = new PriceBO();
                    priceBO.setProvinceCode(skuPO.getProvinceCode());
                    priceBO.setSkuId(skuPO.getSkuId());
                    priceBO.setAgreementPrice(MoneyUtils.BigDecimal2Long(((PriceSheetItemBO)priceMap.get(skuPO.getMaterialId())).getAgreementPriceStr()));
                    priceBO.setAssessmentPrice(MoneyUtils.BigDecimal2Long(((PriceSheetItemBO)priceMap.get(skuPO.getMaterialId())).getAssessmentPriceStr()));
                    priceBO.setPurchaseFloorPrice(MoneyUtils.BigDecimal2Long(((PriceSheetItemBO)priceMap.get(skuPO.getMaterialId())).getPurchaseFloorPriceStr()));
                    priceBO.setRetailAgreementPrice(MoneyUtils.BigDecimal2Long(((PriceSheetItemBO)priceMap.get(skuPO.getMaterialId())).getRetailAgreementPriceStr()));
                    priceBO.setCitiesLockPrice(MoneyUtils.BigDecimal2Long(((PriceSheetItemBO)priceMap.get(skuPO.getMaterialId())).getCitiesLockPriceStr()));
                    priceBO.setTheCostDownPrice(MoneyUtils.BigDecimal2Long(((PriceSheetItemBO)priceMap.get(skuPO.getMaterialId())).getTheCostDownPriceStr()));
                    priceBO.setCgType(skuPO.getCgType());
                    priceBO.setMemberLadderPrice1(MoneyUtils.BigDecimal2Long(((PriceSheetItemBO)priceMap.get(skuPO.getMaterialId())).getMemberLadderPrice1Str()));
                    priceBO.setMemberLadderPrice2(MoneyUtils.BigDecimal2Long(((PriceSheetItemBO)priceMap.get(skuPO.getMaterialId())).getMemberLadderPrice2Str()));
                    priceBO.setMemberLadderPrice3(MoneyUtils.BigDecimal2Long(((PriceSheetItemBO)priceMap.get(skuPO.getMaterialId())).getMemberLadderPrice3Str()));
                    priceBO.setMemberLadderPrice4(MoneyUtils.BigDecimal2Long(((PriceSheetItemBO)priceMap.get(skuPO.getMaterialId())).getMemberLadderPrice4Str()));
                    priceBO.setMemberLadderPrice5(MoneyUtils.BigDecimal2Long(((PriceSheetItemBO)priceMap.get(skuPO.getMaterialId())).getMemberLadderPrice5Str()));
                    priceBO.setMemberPrice(MoneyUtils.BigDecimal2Long(((PriceSheetItemBO)priceMap.get(skuPO.getMaterialId())).getMemberPriceStr()));
                    priceBO.setPurchasePrice(MoneyUtils.BigDecimal2Long(((PriceSheetItemBO)priceMap.get(skuPO.getMaterialId())).getPurchasePriceStr()));
                    priceBO.setSalePrice(MoneyUtils.BigDecimal2Long(((PriceSheetItemBO)priceMap.get(skuPO.getMaterialId())).getSalePriceStr()));
                    priceBO.setSheetLevel("1");
                    priceBO.setSheetId(this.sheetId);
                    priceBO.setFixedRoyalty(((PriceSheetItemBO)priceMap.get(skuPO.getMaterialId())).getFixedRoyalty());
                    priceBO.setGroupRoyalty(((PriceSheetItemBO)priceMap.get(skuPO.getMaterialId())).getGroupRoyalty());
                    priceBO.setProfitRoyalty(((PriceSheetItemBO)priceMap.get(skuPO.getMaterialId())).getProfitRoyalty());
                    priceBO.setRoyaltyRatio(((PriceSheetItemBO)priceMap.get(skuPO.getMaterialId())).getRoyaltyRatio());
                    priceBO.setScore(((PriceSheetItemBO)priceMap.get(skuPO.getMaterialId())).getScore());
                    priceBO.setSparePrice2(MoneyUtils.BigDecimal2Long(((PriceSheetItemBO)priceMap.get(skuPO.getMaterialId())).getSparePrice2Str()));
                    priceBO.setSparePrice3(((PriceSheetItemBO)priceMap.get(skuPO.getMaterialId())).getSparePrice3Str() == null ? null : MoneyUtils.BigDecimal2Long(((PriceSheetItemBO)priceMap.get(skuPO.getMaterialId())).getSparePrice3Str()).toString());
                    priceBO.setSparePrice4(((PriceSheetItemBO)priceMap.get(skuPO.getMaterialId())).getSparePrice4Str() == null ? null : MoneyUtils.BigDecimal2Long(((PriceSheetItemBO)priceMap.get(skuPO.getMaterialId())).getSparePrice4Str()).toString());
                    priceBO.setSparePrice5(((PriceSheetItemBO)priceMap.get(skuPO.getMaterialId())).getSparePrice5Str() == null ? null : MoneyUtils.BigDecimal2Long(((PriceSheetItemBO)priceMap.get(skuPO.getMaterialId())).getSparePrice5Str()).toString());
                    priceBO.setUpdateTime(new Date());
                    priceBO.setHasPriceSheet("1");
                    priceBO.setTradePrice(MoneyUtils.BigDecimal2Long(((PriceSheetItemBO)priceMap.get(skuPO.getMaterialId())).getTradePriceStr()));
                    priceBO.setProvAgreePrice(MoneyUtils.BigDecimal2Long(((PriceSheetItemBO)priceMap.get(skuPO.getMaterialId())).getProvAgreePriceStr()));
                    priceBO.setLastPurchasePrice(MoneyUtils.BigDecimal2Long(((PriceSheetItemBO)priceMap.get(skuPO.getMaterialId())).getLastPurchasePriceStr()));
                    priceBO.setCostPrice(MoneyUtils.BigDecimal2Long(((PriceSheetItemBO)priceMap.get(skuPO.getMaterialId())).getCostPriceStr()));
                    priceBOList.add(priceBO);
                }
                this.updateXlsSkuMapper(price);
                this.updateXlsSkuPriceManage(priceBOList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.debug("\u66f4\u65b0\u4ef7\u683c\u62a5\u9519");
        }
    }

    private void updateXlsSkuPriceManage(List<PriceBO> priceBOList) {
        logger.debug("\u4fee\u6539skuPrice" + priceBOList.size());
        int pointsDataLimit = 2000;
        Integer size = priceBOList.size();
        int part = size / pointsDataLimit;
        int len = size % pointsDataLimit == 0 ? part : part + 1;
        logger.debug("\u4fee\u6539skuPrice" + size + "\u6761\u6570\u636e\u3002\u5206" + len + "\u6b21\u6267\u884c");
        ExecutorService service = Executors.newFixedThreadPool(9);
        for (int i = 0; i < len; ++i) {
            logger.debug("\u7b2c" + i + "\u6279\u6570\u636e");
            int start = i * pointsDataLimit;
            int end = start + pointsDataLimit;
            if (end > size) {
                end = size;
            }
            logger.debug("\u5f00\u59cb\u7ed3\u675f=" + start + "+" + end);
            final List<PriceBO> rows = priceBOList.subList(start, end);
            service.execute(new Runnable(){

                @Override
                public void run() {
                    PriceSheetAddThread.this.xlsSkuPriceManageService.batchUpdateSkuPrice(rows);
                }
            });
            try {
                Thread.sleep(300L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        service.shutdown();
        priceBOList = null;
    }

    private void updateXlsSkuMapper(List<SkuPO> price) {
        logger.debug("\u4fee\u6539sku" + price.size());
        int pointsDataLimit = 2000;
        Integer size = price.size();
        int part = size / pointsDataLimit;
        int len = size % pointsDataLimit == 0 ? part : part + 1;
        logger.debug("\u4fee\u6539sku\u5546\u54c1\u5171" + size + "\u6761\u6570\u636e\u3002\u5206" + len + "\u6b21\u6267\u884c");
        ExecutorService service = Executors.newFixedThreadPool(9);
        for (int i = 0; i < len; ++i) {
            int start = i * pointsDataLimit;
            int end = start + pointsDataLimit;
            if (end > size) {
                end = size;
            }
            final List<SkuPO> rows = price.subList(start, end);
            service.execute(new Runnable(){

                @Override
                public void run() {
                    PriceSheetAddThread.this.skuDAO.batchUpdateBySkuId(rows);
                }
            });
            try {
                Thread.sleep(300L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        service.shutdown();
        price = null;
    }
}

