/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.thread;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.tydic.newretail.bo.QuerySkuAndPriceReqBO;
import com.tydic.newretail.busi.service.SortCommodityPriceService;
import com.tydic.newretail.busi.service.XlsElectronicPricePushBusiService;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushPriceTagAndSortCommodityPriceThread
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(PushPriceTagAndSortCommodityPriceThread.class);
    private SortCommodityPriceService sortCommodityPriceService;
    private XlsElectronicPricePushBusiService xlsElectronicPricePushBusiService;
    private List<Long> skuIds;
    private List<Long> commodityIds;

    public PushPriceTagAndSortCommodityPriceThread(SortCommodityPriceService sortCommodityPriceService, XlsElectronicPricePushBusiService xlsElectronicPricePushBusiService, List<Long> skuIds, List<Long> commodityIds) {
        this.sortCommodityPriceService = sortCommodityPriceService;
        this.xlsElectronicPricePushBusiService = xlsElectronicPricePushBusiService;
        this.skuIds = skuIds;
        this.commodityIds = commodityIds;
    }

    @Override
    public void run() {
        if (CollectionUtils.isNotEmpty(this.commodityIds)) {
            try {
                List newList = this.commodityIds.stream().distinct().collect(Collectors.toList());
                logger.debug("\u53bb\u91cd\u4e4b\u540e\u7684newCommodityList\u5927\u5c0f\u4e3a\uff1a" + newList.size());
                this.sortCommodityPriceService.sortCommodityPrice(newList);
            }
            catch (Exception e) {
                logger.error("\u4fee\u6539\u5bf9\u5e94\u5546\u54c1\u7684\u6700\u9ad8\u4ef7\u548c\u6700\u4f4e\u4ef7\u62a5\u9519" + e);
            }
        }
        if (CollectionUtils.isNotEmpty(this.skuIds)) {
            try {
                QuerySkuAndPriceReqBO pushReq = new QuerySkuAndPriceReqBO();
                pushReq.setSkuIds(this.skuIds);
                this.xlsElectronicPricePushBusiService.xlsPuhSku(pushReq);
            }
            catch (Exception e) {
                logger.error("\u540c\u6b65sku\u5230\u7535\u5b50\u4ef7\u7b7e\u51fa\u9519" + e);
            }
        }
    }
}

