/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.util;

import java.io.IOException;
import net.sf.json.JSONObject;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestUtils {
    private static Logger logger = LoggerFactory.getLogger(HttpRequestUtils.class);
    private static HttpClient client = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpGet(String url) {
        String jsonStr = null;
        HttpGet httpGet = new HttpGet(url);
        try {
            HttpResponse response = client.execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() == 200) {
                jsonStr = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            } else {
                logger.error("get\u8bf7\u6c42\u63d0\u4ea4\u5931\u8d25:" + httpGet.getURI());
            }
        }
        catch (IOException e) {
            logger.error("get\u8bf7\u6c42\u63d0\u4ea4\u5931\u8d25:" + url, (Throwable)e);
        }
        finally {
            if (null != httpGet) {
                httpGet.releaseConnection();
            }
        }
        return jsonStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpPost(String url, JSONObject param) {
        String jsonStr = null;
        HttpPost httpPost = new HttpPost(url);
        try {
            HttpResponse response;
            if (null != param) {
                StringEntity entity = new StringEntity(param.toString(), "utf-8");
                entity.setContentEncoding("UTF-8");
                entity.setContentType("application/json");
                httpPost.setEntity((HttpEntity)entity);
            }
            if ((response = client.execute((HttpUriRequest)httpPost)).getStatusLine().getStatusCode() == 200) {
                jsonStr = EntityUtils.toString((HttpEntity)response.getEntity());
            } else {
                logger.error("post\u8bf7\u6c42\u63d0\u4ea4\u5931\u8d25:" + httpPost.getURI());
            }
        }
        catch (IOException e) {
            logger.error("post\u8bf7\u6c42\u63d0\u4ea4\u5931\u8d25:" + url, (Throwable)e);
        }
        finally {
            if (null != httpPost) {
                httpPost.releaseConnection();
            }
        }
        return jsonStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpPostHB(String url, JSONObject param) {
        String jsonStr = null;
        HttpPost httpPost = new HttpPost(url);
        try {
            HttpResponse response;
            if (null != param) {
                StringEntity entity = new StringEntity(param.toString(), "utf-8");
                httpPost.setHeader("Content-Type", "application/json;");
                entity.setContentType("text/json");
                entity.setContentEncoding((Header)new BasicHeader("Content-Type", "application/json"));
                entity.setContentEncoding((Header)new BasicHeader("Accept-Encoding", ""));
                httpPost.setEntity((HttpEntity)entity);
            }
            if ((response = client.execute((HttpUriRequest)httpPost)).getStatusLine().getStatusCode() == 200) {
                jsonStr = EntityUtils.toString((HttpEntity)response.getEntity());
            } else {
                logger.error("post\u8bf7\u6c42\u63d0\u4ea4\u5931\u8d25:" + httpPost.getURI());
            }
        }
        catch (IOException e) {
            logger.error("post\u8bf7\u6c42\u63d0\u4ea4\u5931\u8d25:" + url, (Throwable)e);
        }
        finally {
            if (null != httpPost) {
                httpPost.releaseConnection();
            }
        }
        return jsonStr;
    }

    static {
        if (null == client) {
            client = HttpClients.createDefault();
        }
    }
}

