/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.purchase.atom.impl;

import com.tydic.externalinter.busi.bo.ScmExterReqBO;
import com.tydic.externalinter.busi.service.ScmExterRspBO;
import com.tydic.externalinter.busi.service.ScmexterCommService;
import com.tydic.externalinter.scm.ws.bo.ContractSyncReqBO;
import com.tydic.externalinter.scm.ws.bo.ContractSyncReqDetailBO;
import com.tydic.externalinter.scm.ws.bo.ContractSyncReqTableBO;
import com.tydic.externalinter.scm.ws.bo.ContractSyncRspTableBO;
import com.tydic.externalinter.scm.ws.bo.InfoRecordModifyReqBO;
import com.tydic.externalinter.scm.ws.bo.InfoRecordModifyReqDetailsBO;
import com.tydic.externalinter.scm.ws.bo.InfoRecordModifyReqTableBO;
import com.tydic.externalinter.scm.ws.bo.InfoRecordReqBO;
import com.tydic.externalinter.scm.ws.bo.InfoRecordReqDetailBO;
import com.tydic.externalinter.scm.ws.bo.InfoRecordReqTableBO;
import com.tydic.externalinter.scm.ws.bo.InfoRecordRspTableBO;
import com.tydic.externalinter.scm.ws.bo.LogisticsInsSyncReqBO;
import com.tydic.externalinter.scm.ws.bo.LogisticsInsSyncReqDetailsBO;
import com.tydic.externalinter.scm.ws.bo.LogisticsInsSyncReqHeadBO;
import com.tydic.externalinter.scm.ws.bo.LogisticsInsSyncReqTableBO;
import com.tydic.externalinter.scm.ws.bo.PurchaseOrdReqHeadBO;
import com.tydic.externalinter.scm.ws.bo.PurchaseOrdSyncReqBO;
import com.tydic.externalinter.scm.ws.bo.PurchaseOrdSyncReqDetailsBO;
import com.tydic.externalinter.scm.ws.bo.PurchaseOrdSyncReqTableBO;
import com.tydic.externalinter.scm.ws.bo.PurchaseOrdSyncRspTableBO;
import com.tydic.newretail.purchase.atom.CallScmAtomService;
import com.tydic.newretail.purchase.atom.ContractLogAtomService;
import com.tydic.newretail.purchase.atom.LogisticsInstructionAtomService;
import com.tydic.newretail.purchase.atom.PurchaseOrderAtomService;
import com.tydic.newretail.purchase.atom.bo.ContractLogBO;
import com.tydic.newretail.purchase.bo.LogisticsInstructionBO;
import com.tydic.newretail.purchase.bo.LogisticsInstructionDetailBO;
import com.tydic.newretail.purchase.bo.PurchaseOrderBO;
import com.tydic.newretail.purchase.bo.PurchaseOrderDetailBO;
import com.tydic.newretail.purchase.bo.PurchaseProvinceBO;
import com.tydic.newretail.purchase.util.PurchaseProvinceUtils;
import com.tydic.newretail.purchase.util.ThrExceptionUtils;
import com.tydic.newretail.toolkit.atom.QryEscapeAtomService;
import com.tydic.newretail.toolkit.util.TkDateUtils;
import com.tydic.newretail.toolkit.util.TkPropertiesUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CallScmAtomServiceImpl
implements CallScmAtomService {
    private static final Logger logger = LoggerFactory.getLogger(CallScmAtomServiceImpl.class);
    @Resource
    private ScmexterCommService scmexterCommService;
    @Autowired
    private PurchaseOrderAtomService purchaseOrderAtomService;
    @Autowired
    private LogisticsInstructionAtomService logisticsInstructionAtomService;
    @Autowired
    private ContractLogAtomService contractLogAtomService;
    @Resource(name="purchaseQryEscapeAtomService")
    private QryEscapeAtomService qryEscapeAtomService;

    @Override
    public void syncOrderInfo(List<PurchaseOrderBO> reqBOs) {
        if (CollectionUtils.isEmpty(reqBOs)) {
            logger.error("\u5165\u53c2\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u5165\u53c2\u4e3a\u7a7a");
        }
        List<PurchaseOrdSyncReqBO> list = this.getReqParams(reqBOs);
        ArrayList<PurchaseOrderBO> modifyBOs = new ArrayList<PurchaseOrderBO>(list.size());
        for (PurchaseOrdSyncReqBO req : list) {
            JSONObject itemJson;
            ScmExterReqBO scmExterReqBO = new ScmExterReqBO();
            scmExterReqBO.setWsdl(TkPropertiesUtils.getProperty((String)"scm.ordsync.url"));
            scmExterReqBO.setReqData((Object)req);
            PurchaseOrderBO modifyBO = new PurchaseOrderBO();
            modifyBO.setPurchaseOrderNo(req.getSInput().getCgno());
            modifyBOs.add(modifyBO);
            ScmExterRspBO scmExterRspBO = null;
            try {
                scmExterRspBO = this.scmexterCommService.scmExter(scmExterReqBO);
            }
            catch (Exception e) {
                logger.error("\u8ba2\u5355\u3010" + req.getSInput().getCgno() + "\u3011\u8c03\u7528SCM\u540c\u6b65\u5f02\u5e38\uff1a" + e.getMessage());
                modifyBO.setStatus("02");
                modifyBO.setStatusDesc("\u8c03\u7528SCM\u540c\u6b65\u5f02\u5e38");
                continue;
            }
            logger.debug("\u8ba2\u5355\u3010{}\u3011\u8c03\u7528SCM\u540c\u6b65\u63a5\u53e3\u51fa\u53c2\uff1a{}", (Object)req.getSInput().getCgno(), (Object)scmExterRspBO);
            if (!"0000".equals(scmExterRspBO.getRespCode())) {
                logger.error("\u8ba2\u5355\u3010" + req.getSInput().getCgno() + "\u3011\u8c03\u7528SCM\u540c\u6b65\u5931\u8d25\uff1a" + scmExterRspBO.getRespDesc());
                modifyBO.setStatus("02");
                modifyBO.setStatusDesc("\u8ba2\u5355\u3010" + req.getSInput().getCgno() + "\u3011\u8c03\u7528SCM\u540c\u6b65\u5931\u8d25\uff1a" + scmExterRspBO.getRespDesc());
                continue;
            }
            JSONObject rspJson = JSONObject.fromObject((Object)scmExterRspBO.getScmRspData());
            if (!rspJson.containsKey((Object)"Zmmif111Response")) {
                logger.error("\u8ba2\u5355\u3010" + req.getSInput().getCgno() + "\u3011\u89e3\u6790\u540c\u6b65\u51fa\u53c2\u5931\u8d25\uff0c\u672a\u83b7\u53d6Zmmif111Response");
                modifyBO.setStatus("02");
                modifyBO.setStatusDesc("\u89e3\u6790\u540c\u6b65\u51fa\u53c2\u5931\u8d25\uff0c\u672a\u83b7\u53d6Zmmif111Response");
                continue;
            }
            JSONObject response = rspJson.getJSONObject("Zmmif111Response");
            if (!response.containsKey((Object)"TOutput1")) {
                logger.error("\u8ba2\u5355\u3010" + req.getSInput().getCgno() + "\u3011\u89e3\u6790\u540c\u6b65\u51fa\u53c2\u5931\u8d25\uff0c\u672a\u83b7\u53d6TOutput1");
                modifyBO.setStatus("02");
                modifyBO.setStatusDesc("\u89e3\u6790\u540c\u6b65\u51fa\u53c2\u5931\u8d25\uff0c\u672a\u83b7\u53d6TOutput1");
                continue;
            }
            JSONObject outputJson = response.getJSONObject("TOutput1");
            if (!outputJson.containsKey((Object)"item")) {
                logger.error("\u8ba2\u5355\u3010" + req.getSInput().getCgno() + "\u3011\u89e3\u6790\u540c\u6b65\u51fa\u53c2\u5931\u8d25\uff0c\u672a\u83b7\u53d6item");
                modifyBO.setStatus("02");
                modifyBO.setStatusDesc("\u89e3\u6790\u540c\u6b65\u51fa\u53c2\u5931\u8d25\uff0c\u672a\u83b7\u53d6item");
                continue;
            }
            Object itemObj = outputJson.get("item");
            if (itemObj instanceof JSONObject) {
                itemJson = outputJson.getJSONObject("item");
            } else if (itemObj instanceof JSONArray) {
                JSONArray items = outputJson.getJSONArray("item");
                itemJson = items.getJSONObject(0);
            } else {
                logger.error("\u8ba2\u5355\u3010" + req.getSInput().getCgno() + "\u3011\u89e3\u6790\u540c\u6b65\u51fa\u53c2\u5931\u8d25\uff0citem\u7c7b\u578b\u9519\u8bef");
                modifyBO.setStatus("02");
                modifyBO.setStatusDesc("\u89e3\u6790\u540c\u6b65\u51fa\u53c2\u5931\u8d25\uff0citem\u7c7b\u578b\u9519\u8bef");
                continue;
            }
            if (!itemJson.containsKey((Object)"Returnstatus")) {
                logger.error("\u8ba2\u5355\u3010" + req.getSInput().getCgno() + "\u3011\u89e3\u6790\u540c\u6b65\u51fa\u53c2\u5931\u8d25\uff0c\u672a\u83b7\u53d6Returnstatus");
                modifyBO.setStatus("02");
                modifyBO.setStatusDesc("\u89e3\u6790\u540c\u6b65\u51fa\u53c2\u5931\u8d25\uff0c\u672a\u83b7\u53d6Returnstatus");
                continue;
            }
            if (!"S".equals(itemJson.getString("Returnstatus"))) {
                String desc = "\u540c\u6b65\u5931\u8d25";
                if (itemJson.containsKey((Object)"Returnmsg")) {
                    desc = itemJson.getString("Returnmsg");
                }
                logger.error("\u8ba2\u5355\u3010" + req.getSInput().getCgno() + "\u3011\u540c\u6b65\u5931\u8d25\uff1a" + desc);
                modifyBO.setStatus("02");
                modifyBO.setStatusDesc(desc);
                continue;
            }
            if (!itemJson.containsKey((Object)"Ebeln")) {
                logger.error("\u8ba2\u5355\u3010" + req.getSInput().getCgno() + "\u3011\u89e3\u6790\u540c\u6b65\u51fa\u53c2\u5931\u8d25\uff0c\u672a\u83b7\u53d6Ebeln");
                modifyBO.setStatus("02");
                modifyBO.setStatusDesc("\u89e3\u6790\u540c\u6b65\u51fa\u53c2\u5931\u8d25\uff0c\u672a\u83b7\u53d6Ebeln");
                continue;
            }
            String extOrdNo = itemJson.getString("Ebeln");
            modifyBO.setReturnOrderNo(extOrdNo);
            modifyBO.setStatus("01");
            modifyBO.setStatusDesc("\u540c\u6b65\u6210\u529f");
        }
        try {
            this.purchaseOrderAtomService.modifyPurchaseOrdByBatch(modifyBOs);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u8ba2\u5355\u540c\u6b65\u72b6\u6001\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private List<PurchaseOrdSyncReqBO> getReqParams(List<PurchaseOrderBO> reqBOs) {
        ArrayList<PurchaseOrdSyncReqBO> list = new ArrayList<PurchaseOrdSyncReqBO>(reqBOs.size());
        for (PurchaseOrderBO ord : reqBOs) {
            this.checkOrdParams(ord);
            PurchaseOrdSyncReqBO ordSyncReqBO = new PurchaseOrdSyncReqBO();
            PurchaseOrdReqHeadBO headBO = this.getHeadInfo(ord);
            PurchaseOrdSyncReqTableBO tableBO = new PurchaseOrdSyncReqTableBO();
            List<PurchaseOrdSyncReqDetailsBO> items = this.getTableInfo(ord);
            tableBO.setItem(items);
            ordSyncReqBO.setSInput(headBO);
            ordSyncReqBO.setTInput1(tableBO);
            ordSyncReqBO.setTOutput1(new PurchaseOrdSyncRspTableBO());
            list.add(ordSyncReqBO);
        }
        return list;
    }

    private PurchaseOrdReqHeadBO getHeadInfo(PurchaseOrderBO ord) {
        PurchaseOrdReqHeadBO headBO = new PurchaseOrdReqHeadBO();
        headBO.setBsart("NB");
        headBO.setBedat(TkDateUtils.formatDate((Date)ord.getCrtTime(), (String)"yyyyMMdd"));
        headBO.setCgno(ord.getPurchaseOrderNo());
        headBO.setLifnr(ord.getSupplierNo());
        PurchaseProvinceBO provinceBO = PurchaseProvinceUtils.getPorvinceByProCode(ord.getProvince());
        if (null == provinceBO) {
            logger.error("\u672a\u914d\u7f6e\u7701\u4efd\u3010" + ord.getProvince() + "\u3011");
            ThrExceptionUtils.thrQryRspEmptyExce("\u672a\u914d\u7f6e\u7701\u4efd\u3010" + ord.getProvince() + "\u3011");
        }
        headBO.setEkorg(provinceBO.getOrgNo());
        headBO.setEkgrp("601");
        headBO.setBukrs(provinceBO.getOrgNo());
        headBO.setZterm(null == ord.getPayConditionCode() ? "" : ord.getPayConditionCode());
        headBO.setInco1("");
        headBO.setWaers(null == ord.getCurrencyCode() ? "" : ord.getCurrencyCode());
        headBO.setSubmi("");
        headBO.setRes1("");
        headBO.setRes2("");
        headBO.setRes3("");
        return headBO;
    }

    private List<PurchaseOrdSyncReqDetailsBO> getTableInfo(PurchaseOrderBO ord) {
        ArrayList<PurchaseOrdSyncReqDetailsBO> items = new ArrayList<PurchaseOrdSyncReqDetailsBO>(ord.getPurchaseOrderDetailBOList().size());
        PurchaseOrdSyncReqDetailsBO item = new PurchaseOrdSyncReqDetailsBO();
        for (PurchaseOrderDetailBO detail : ord.getPurchaseOrderDetailBOList()) {
            this.checkDetailParams(detail);
            item.setAedat(detail.getLastUpdDate());
            item.setChangetype("0");
            item.setCgno(ord.getPurchaseOrderNo());
            item.setEbelp(detail.getRow());
            if ("01".equals(detail.getProjectCategory())) {
                item.setPstyp("2");
            }
            item.setUmson("");
            item.setRetpo("");
            item.setWerks(detail.getFactory());
            item.setLgort(detail.getWarehouse());
            item.setMatnr(detail.getMeterielCode());
            item.setMenge(detail.getCount().toString());
            item.setElikz("");
            item.setBednr("");
            item.setAfnam("");
            if (null != detail.getDeliveryDate()) {
                item.setEindt(TkDateUtils.formatDate((Date)detail.getDeliveryDate(), (String)"yyyyMMdd"));
            }
            item.setNetpr(detail.getPrice().toString());
            item.setPeinh(detail.getPriceUnit());
            item.setMeins(detail.getUnitName());
            item.setWebre(detail.getFlag());
            item.setMwskz(detail.getTaxCode());
            item.setKzabs(detail.getNeedFeedback());
            item.setBstae(detail.getConfirmControlCode());
            item.setMemo(null == ord.getRemark() ? "" : ord.getRemark());
            item.setRes1("");
            item.setRes2("");
            item.setRes3("");
            items.add(item);
        }
        return items;
    }

    private void checkDetailParams(PurchaseOrderDetailBO detail) {
        detail.setPriceUnit("1");
        detail.setFlag("X");
        detail.setNeedFeedback("X");
        detail.setConfirmControlCode("0001");
        if (StringUtils.isBlank((CharSequence)detail.getRow())) {
            logger.error("\u884c\u9879\u76ee\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u884c\u9879\u76ee\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)detail.getFactory())) {
            logger.error("\u5de5\u5382\u7f16\u7801\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u5de5\u5382\u7f16\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)detail.getWarehouse())) {
            logger.error("\u4ed3\u5e93\u7f16\u7801\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u4ed3\u5e93\u7f16\u7801\u4e3a\u7a7a");
        }
        if (null == detail.getCount()) {
            logger.error("\u91c7\u8d2d\u6570\u91cf\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u91c7\u8d2d\u6570\u91cf\u4e3a\u7a7a");
        }
        if (null == detail.getPrice()) {
            logger.error("\u4ef7\u683c\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u4ef7\u683c\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)detail.getUnitName())) {
            logger.error("\u5355\u4f4d\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u5355\u4f4d\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)detail.getMeterielCode())) {
            logger.error("\u7269\u6599\u7f16\u7801\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u7269\u6599\u7f16\u7801\u4e3a\u7a7a");
        }
    }

    private void checkOrdParams(PurchaseOrderBO ord) {
        if (CollectionUtils.isEmpty((Collection)ord.getPurchaseOrderDetailBOList())) {
            logger.error("\u8ba2\u5355\u660e\u7ec6\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u8ba2\u5355\u660e\u7ec6\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)ord.getPurchaseOrderNo())) {
            logger.error("\u8ba2\u5355\u7f16\u7801\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u8ba2\u5355\u7f16\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)ord.getSupplierNo())) {
            logger.error("\u4f9b\u5e94\u5546\u7f16\u7801\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u4f9b\u5e94\u5546\u7f16\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)ord.getProvince())) {
            logger.error("\u7701\u4efd\u7f16\u7801\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u7701\u4efd\u7f16\u7801\u4e3a\u7a7a");
        }
    }

    @Override
    public void syncLogisticsIns(List<LogisticsInstructionBO> logisticsInstructionBOS) {
        if (CollectionUtils.isEmpty(logisticsInstructionBOS)) {
            logger.error("\u5165\u53c2\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u5165\u53c2\u4e3a\u7a7a");
        }
        ArrayList<LogisticsInsSyncReqBO> list = new ArrayList<LogisticsInsSyncReqBO>(logisticsInstructionBOS.size());
        for (LogisticsInstructionBO logisticsInstructionBO : logisticsInstructionBOS) {
            this.checkLogisticsIns(logisticsInstructionBO);
            LogisticsInsSyncReqBO reqBO = new LogisticsInsSyncReqBO();
            reqBO.setIsHead(this.getLogisticsInsHead(logisticsInstructionBO));
            LogisticsInsSyncReqTableBO tableBO = new LogisticsInsSyncReqTableBO();
            List<LogisticsInsSyncReqDetailsBO> items = this.getLogisticsTable(logisticsInstructionBO);
            tableBO.setItem(items);
            reqBO.setItItem(tableBO);
            list.add(reqBO);
        }
        ArrayList<LogisticsInstructionBO> modifyBOs = new ArrayList<LogisticsInstructionBO>(list.size());
        for (LogisticsInsSyncReqBO reqBO : list) {
            String deliveryNo = reqBO.getIsHead().getCtpsd();
            LogisticsInstructionBO modifyBO = new LogisticsInstructionBO();
            modifyBO.setDeliveryNo(deliveryNo);
            modifyBOs.add(modifyBO);
            ScmExterReqBO scmExterReqBO = new ScmExterReqBO();
            scmExterReqBO.setWsdl(TkPropertiesUtils.getProperty((String)"scm.logisticsIns.url"));
            scmExterReqBO.setReqData((Object)reqBO);
            ScmExterRspBO scmExterRspBO = null;
            try {
                scmExterRspBO = this.scmexterCommService.scmExter(scmExterReqBO);
            }
            catch (Exception e) {
                logger.error("\u914d\u9001\u5355\u53f7\u3010" + deliveryNo + "\u3011\u8c03\u7528SCM\u540c\u6b65\u5f02\u5e38\uff1a" + e.getMessage());
                modifyBO.setSyncStatus("02");
                modifyBO.setStatusDesc("\u8c03\u7528SCM\u540c\u6b65\u5f02\u5e38");
                continue;
            }
            if (!"0000".equals(scmExterRspBO.getRespCode())) {
                logger.error("\u914d\u9001\u5355\u53f7\u3010" + deliveryNo + "\u3011\u8c03\u7528SCM\u540c\u6b65\u5931\u8d25\uff1a" + scmExterRspBO.getRespDesc());
                modifyBO.setSyncStatus("02");
                modifyBO.setStatusDesc("\u8c03\u7528SCM\u540c\u6b65\u5931\u8d25\uff1a" + scmExterRspBO.getRespDesc());
                continue;
            }
            JSONObject objJson = JSONObject.fromObject((Object)scmExterRspBO.getScmRspData());
            if (!objJson.containsKey((Object)"Zmmif190Response")) {
                logger.error("\u914d\u9001\u5355\u53f7\u3010" + deliveryNo + "\u3011\u89e3\u6790\u51fa\u53c2\u5931\u8d25\uff0c\u672a\u83b7\u53d6Zmmif190Response");
                modifyBO.setSyncStatus("02");
                modifyBO.setStatusDesc("\u89e3\u6790\u51fa\u53c2\u5931\u8d25\uff0c\u672a\u83b7\u53d6Zmmif190Response");
                continue;
            }
            JSONObject response = objJson.getJSONObject("Zmmif190Response");
            if (!response.containsKey((Object)"EsReturn")) {
                logger.error("\u914d\u9001\u5355\u53f7\u3010" + deliveryNo + "\u3011\u89e3\u6790\u51fa\u53c2\u5931\u8d25\uff0c\u672a\u83b7\u53d6EsReturn");
                modifyBO.setSyncStatus("02");
                modifyBO.setStatusDesc("\u89e3\u6790\u51fa\u53c2\u5931\u8d25\uff0c\u672a\u83b7\u53d6EsReturn");
                continue;
            }
            JSONObject rspJson = response.getJSONObject("EsReturn");
            if (!rspJson.containsKey((Object)"Xxlb")) {
                logger.error("\u914d\u9001\u5355\u53f7\u3010" + deliveryNo + "\u3011\u89e3\u6790\u51fa\u53c2\u5931\u8d25\uff0c\u672a\u83b7\u53d6Xxlb");
                modifyBO.setSyncStatus("02");
                modifyBO.setStatusDesc("\u89e3\u6790\u51fa\u53c2\u5931\u8d25\uff0c\u672a\u83b7\u53d6Xxlb");
                continue;
            }
            String respCode = rspJson.getString("Xxlb");
            if (!"S".equals(respCode)) {
                String desc = "\u540c\u6b65\u5931\u8d25";
                if (rspJson.containsKey((Object)"Message")) {
                    desc = rspJson.getString("Message");
                }
                logger.error("\u914d\u9001\u5355\u53f7\u3010" + deliveryNo + "\u3011\u540c\u6b65\u5931\u8d25\uff1a" + desc);
                modifyBO.setSyncStatus("02");
                modifyBO.setStatusDesc("\u914d\u9001\u5355\u53f7\u3010" + deliveryNo + "\u3011\u540c\u6b65\u5931\u8d25\uff1a" + desc);
                continue;
            }
            modifyBO.setSyncStatus("01");
            modifyBO.setStatusDesc("\u540c\u6b65\u6210\u529f");
            if (rspJson.containsKey((Object)"Vbeln")) {
                modifyBO.setExtDeliveryNo(rspJson.getString("Vbeln"));
            }
            if (!rspJson.containsKey((Object)"Iidno")) continue;
            modifyBO.setLogisticsInstructionNo(rspJson.getString("Iidno"));
        }
        try {
            this.logisticsInstructionAtomService.modifyInfoByBatch(modifyBOs);
        }
        catch (Exception exception) {
            logger.error("\u66f4\u65b0\u7269\u6d41\u6307\u4ee4\u540c\u6b65\u72b6\u6001\u5931\u8d25\uff1a" + exception.getMessage());
        }
    }

    private void checkLogisticsIns(LogisticsInstructionBO li) {
        if (StringUtils.isBlank((CharSequence)li.getSupplierNo())) {
            logger.error("\u4f9b\u5e94\u5546\u7f16\u7801\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u4f9b\u5e94\u5546\u7f16\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)li.getDeliveryNo())) {
            logger.error("\u914d\u9001\u5355\u53f7\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u914d\u9001\u5355\u53f7\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)li.getDetailBOS())) {
            logger.error("\u7269\u6d41\u6307\u4ee4\u660e\u7ec6\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u7269\u6d41\u6307\u4ee4\u660e\u7ec6\u4e3a\u7a7a");
        }
    }

    private List<LogisticsInsSyncReqDetailsBO> getLogisticsTable(LogisticsInstructionBO li) {
        ArrayList<LogisticsInsSyncReqDetailsBO> items = new ArrayList<LogisticsInsSyncReqDetailsBO>(li.getDetailBOS().size());
        for (LogisticsInstructionDetailBO detailBO : li.getDetailBOS()) {
            this.checkLogisticsInsDetail(detailBO);
            LogisticsInsSyncReqDetailsBO item = new LogisticsInsSyncReqDetailsBO();
            item.setCtpsd(li.getDeliveryNo());
            item.setEbeln(detailBO.getPurchaseVoucher());
            item.setEbelp(detailBO.getLineNum());
            item.setMatnr(detailBO.getMeterielCode());
            item.setMenge(detailBO.getShipCount());
            item.setWerks(detailBO.getFactory());
            item.setLgort(detailBO.getWarehouse());
            item.setSgtxt(null == detailBO.getRemark() ? "" : detailBO.getRemark());
            items.add(item);
        }
        return items;
    }

    private void checkLogisticsInsDetail(LogisticsInstructionDetailBO detailBO) {
        if (StringUtils.isBlank((CharSequence)detailBO.getPurchaseVoucher())) {
            logger.error("\u91c7\u8d2d\u51ed\u8bc1\u53f7\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u91c7\u8d2d\u51ed\u8bc1\u53f7\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)detailBO.getLineNum())) {
            logger.error("\u884c\u9879\u76ee\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u884c\u9879\u76ee\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)detailBO.getMeterielCode())) {
            logger.error("\u7269\u6599\u7f16\u7801\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u7269\u6599\u7f16\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)detailBO.getShipCount())) {
            logger.error("\u53d1\u8d27\u6570\u91cf\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u53d1\u8d27\u6570\u91cf\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)detailBO.getFactory())) {
            logger.error("\u5de5\u5382\u7f16\u7801\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u5de5\u5382\u7f16\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)detailBO.getWarehouse())) {
            logger.error("\u4ed3\u5e93\u7f16\u7801\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u4ed3\u5e93\u7f16\u7801\u4e3a\u7a7a");
        }
    }

    private LogisticsInsSyncReqHeadBO getLogisticsInsHead(LogisticsInstructionBO li) {
        LogisticsInsSyncReqHeadBO headBO = new LogisticsInsSyncReqHeadBO();
        headBO.setLifnr(li.getSupplierNo());
        headBO.setCtpsd(li.getDeliveryNo());
        Date date = new Date();
        String dateStr = TkDateUtils.formatDate((Date)date, (String)"yyyyMMdd");
        headBO.setBldat(dateStr);
        headBO.setLfdat(dateStr);
        return headBO;
    }

    @Override
    public void syncContractInfo(List<ContractLogBO> contractLogBOList) {
        if (CollectionUtils.isEmpty(contractLogBOList)) {
            logger.error("\u5165\u53c2\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u5165\u53c2\u4e3a\u7a7a");
        }
        ArrayList<ContractLogBO> contractList = new ArrayList<ContractLogBO>(contractLogBOList.size());
        ArrayList<ContractLogBO> infoList = new ArrayList<ContractLogBO>(contractLogBOList.size());
        for (ContractLogBO bo : contractLogBOList) {
            if (StringUtils.isBlank((CharSequence)bo.getMeterielCode())) continue;
            if ("01".equals(bo.getContractTypeCode())) {
                contractList.add(bo);
                continue;
            }
            infoList.add(bo);
        }
        if (CollectionUtils.isNotEmpty(contractList)) {
            this.syncContract(contractList);
        }
        if (CollectionUtils.isNotEmpty(infoList)) {
            this.syncInfo(infoList);
        }
    }

    private void syncContract(List<ContractLogBO> contractLogBOList) {
        ArrayList<ContractSyncReqBO> reqBOS = new ArrayList<ContractSyncReqBO>(contractLogBOList.size());
        for (ContractLogBO bo : contractLogBOList) {
            this.checkContractLog(bo, true);
            ContractSyncReqDetailBO detailBO = this.getContractReqDetail(bo);
            ArrayList<ContractSyncReqDetailBO> details = new ArrayList<ContractSyncReqDetailBO>(1);
            details.add(detailBO);
            ContractSyncReqTableBO tableBO = new ContractSyncReqTableBO();
            tableBO.setItem(details);
            ContractSyncReqBO reqBO = new ContractSyncReqBO();
            reqBO.settInput(tableBO);
            reqBO.settOutput(new ContractSyncRspTableBO());
            reqBOS.add(reqBO);
        }
        ArrayList<ContractLogBO> modifyBOs = new ArrayList<ContractLogBO>(reqBOS.size());
        for (ContractSyncReqBO req : reqBOS) {
            JSONObject itemJson;
            String contractNo = ((ContractSyncReqDetailBO)req.gettInput().getItem().get(0)).getHtno();
            ContractLogBO modifyBO = new ContractLogBO();
            modifyBO.setContractNo(contractNo);
            modifyBO.setFactory(((ContractSyncReqDetailBO)req.gettInput().getItem().get(0)).getWerks());
            modifyBO.setSyncTime(new Date());
            modifyBO.setSyncType("00");
            modifyBOs.add(modifyBO);
            ScmExterReqBO scmExterReqBO = new ScmExterReqBO();
            scmExterReqBO.setWsdl(TkPropertiesUtils.getProperty((String)"scm.contract.url"));
            scmExterReqBO.setReqData((Object)req);
            ScmExterRspBO scmExterRspBO = null;
            try {
                scmExterRspBO = this.scmexterCommService.scmExter(scmExterReqBO);
            }
            catch (Exception e) {
                logger.error("\u5408\u540c\u53f7\u3010" + contractNo + "\u3011\u8c03\u7528SCM\u540c\u6b65\u5f02\u5e38\uff1a" + e.getMessage());
                modifyBO.setStatus("03");
                modifyBO.setStatusDesc("\u8c03\u7528SCM\u540c\u6b65\u5f02\u5e38");
                continue;
            }
            if (!"0000".equals(scmExterRspBO.getRespCode())) {
                logger.error("\u5408\u540c\u53f7\u3010" + contractNo + "\u3011\u8c03\u7528SCM\u540c\u6b65\u5931\u8d25\uff1a" + scmExterRspBO.getRespDesc());
                modifyBO.setStatus("03");
                modifyBO.setStatusDesc("\u8c03\u7528SCM\u540c\u6b65\u5931\u8d25\uff1a" + scmExterRspBO.getRespDesc());
                continue;
            }
            JSONObject objJson = JSONObject.fromObject((Object)scmExterRspBO.getScmRspData());
            if (!objJson.containsKey((Object)"Zmmif103Response")) {
                logger.error("\u5408\u540c\u53f7\u3010" + contractNo + "\u3011\u89e3\u6790\u51fa\u53c2\u5931\u8d25\uff0c\u672a\u83b7\u53d6Zmmif103Response");
                modifyBO.setStatus("03");
                modifyBO.setStatusDesc("\u89e3\u6790\u51fa\u53c2\u5931\u8d25\uff0c\u672a\u83b7\u53d6Zmmif103Response");
                continue;
            }
            JSONObject response = objJson.getJSONObject("Zmmif103Response");
            if (!response.containsKey((Object)"TOutput")) {
                logger.error("\u5408\u540c\u53f7\u3010" + contractNo + "\u3011\u89e3\u6790\u51fa\u53c2\u5931\u8d25\uff0c\u672a\u83b7\u53d6EsReturn");
                modifyBO.setStatus("03");
                modifyBO.setStatusDesc("\u89e3\u6790\u51fa\u53c2\u5931\u8d25\uff0c\u672a\u83b7\u53d6TOutput");
                continue;
            }
            JSONObject rspJson = response.getJSONObject("TOutput");
            Object itemObj = rspJson.get("item");
            if (itemObj instanceof JSONObject) {
                itemJson = rspJson.getJSONObject("item");
            } else if (itemObj instanceof JSONArray) {
                JSONArray items = rspJson.getJSONArray("item");
                itemJson = items.getJSONObject(0);
            } else {
                logger.error("\u5408\u540c\u53f7\u3010" + contractNo + "\u3011\u89e3\u6790\u51fa\u53c2\u5931\u8d25\uff0citem\u7c7b\u578b\u9519\u8bef");
                modifyBO.setStatus("03");
                modifyBO.setStatusDesc("\u89e3\u6790\u540c\u6b65\u51fa\u53c2\u5931\u8d25\uff0citem\u7c7b\u578b\u9519\u8bef");
                continue;
            }
            if (!itemJson.containsKey((Object)"Xxlb")) {
                logger.error("\u5408\u540c\u53f7\u3010" + contractNo + "\u3011\u89e3\u6790\u51fa\u53c2\u5931\u8d25\uff0c\u672a\u83b7\u53d6Xxlb");
                modifyBO.setStatus("03");
                modifyBO.setStatusDesc("\u89e3\u6790\u51fa\u53c2\u5931\u8d25\uff0c\u672a\u83b7\u53d6Xxlb");
                continue;
            }
            String respCode = itemJson.getString("Xxlb");
            if (!"S".equals(respCode)) {
                String desc = "\u540c\u6b65\u5931\u8d25";
                if (itemJson.containsKey((Object)"Message")) {
                    desc = itemJson.getString("Message");
                }
                logger.error("\u5408\u540c\u53f7\u3010" + contractNo + "\u3011\u540c\u6b65\u5931\u8d25\uff1a" + desc);
                modifyBO.setStatus("03");
                modifyBO.setStatusDesc("\u5408\u540c\u53f7\u3010" + contractNo + "\u3011\u540c\u6b65\u5931\u8d25\uff1a" + desc);
                continue;
            }
            modifyBO.setStatus("02");
            modifyBO.setStatusDesc("\u540c\u6b65\u6210\u529f");
            if (itemJson.containsKey((Object)"Ebeln")) {
                modifyBO.setScmContractCode(rspJson.getString("Ebeln"));
            }
            if (!itemJson.containsKey((Object)"Ebelp")) continue;
            modifyBO.setScmContractItem(rspJson.getString("Ebelp"));
        }
        this.contractLogAtomService.modifyBatchByContractNo(modifyBOs);
    }

    private void syncInfo(List<ContractLogBO> contractLogBOList) {
        List<ContractLogBO> successBOs = this.contractLogAtomService.listLogInfoByCondition(contractLogBOList);
        HashMap<String, String> contractMap = new HashMap<String, String>(1);
        if (CollectionUtils.isNotEmpty(successBOs)) {
            contractMap = new HashMap(successBOs.size());
            for (ContractLogBO log : successBOs) {
                String key = log.getSupplierId() + log.getMeterielCode() + log.getFactory();
                contractMap.put(key, log.getContractNo());
            }
        }
        ArrayList<InfoRecordReqBO> saveBOs = new ArrayList<InfoRecordReqBO>(contractLogBOList.size());
        ArrayList<InfoRecordModifyReqBO> modifyInfoBOs = new ArrayList<InfoRecordModifyReqBO>(contractLogBOList.size());
        ArrayList<ContractLogBO> modifyBOs = new ArrayList<ContractLogBO>(contractLogBOList.size());
        for (ContractLogBO bo : contractLogBOList) {
            this.checkContractLog(bo, false);
            String key = bo.getSupplierId() + bo.getMeterielCode() + bo.getFactory();
            if (contractMap.containsKey(key)) {
                InfoRecordModifyReqDetailsBO detailsBO = this.getInfoRecordModifyDetails(bo);
                ArrayList<InfoRecordModifyReqDetailsBO> detailsBOS = new ArrayList<InfoRecordModifyReqDetailsBO>(1);
                detailsBOS.add(detailsBO);
                InfoRecordModifyReqTableBO modifyReqTableBO = new InfoRecordModifyReqTableBO();
                modifyReqTableBO.setItem(detailsBOS);
                InfoRecordModifyReqBO modifyReqBO = new InfoRecordModifyReqBO();
                modifyReqBO.setItTable1(modifyReqTableBO);
                modifyReqBO.setOtTable2(new InfoRecordRspTableBO());
                modifyInfoBOs.add(modifyReqBO);
                continue;
            }
            InfoRecordReqDetailBO detailBO = this.getInfoRecordDetail(bo);
            ArrayList<InfoRecordReqDetailBO> details = new ArrayList<InfoRecordReqDetailBO>(1);
            details.add(detailBO);
            InfoRecordReqTableBO tableBO = new InfoRecordReqTableBO();
            tableBO.setItem(details);
            InfoRecordReqBO reqBO = new InfoRecordReqBO();
            reqBO.setItTable1(tableBO);
            reqBO.setOtTable2(new InfoRecordRspTableBO());
            saveBOs.add(reqBO);
        }
        if (CollectionUtils.isNotEmpty(saveBOs)) {
            this.infoRecordSave(saveBOs, modifyBOs);
        }
        if (CollectionUtils.isNotEmpty(modifyInfoBOs)) {
            this.infoRecordModify(modifyInfoBOs, modifyBOs);
        }
        this.contractLogAtomService.modifyBatchByContractNo(modifyBOs);
    }

    private void infoRecordModify(List<InfoRecordModifyReqBO> modifyInfoBOs, List<ContractLogBO> modifyBOs) {
        for (InfoRecordModifyReqBO req : modifyInfoBOs) {
            JSONObject itemJson;
            String contractNo = ((InfoRecordModifyReqDetailsBO)req.getItTable1().getItem().get(0)).getHtno();
            ContractLogBO modifyBO = new ContractLogBO();
            modifyBO.setContractNo(contractNo);
            modifyBO.setSyncTime(new Date());
            modifyBO.setSyncType("04");
            modifyBO.setFactory(((InfoRecordModifyReqDetailsBO)req.getItTable1().getItem().get(0)).getWerks());
            modifyBOs.add(modifyBO);
            ScmExterReqBO scmExterReqBO = new ScmExterReqBO();
            scmExterReqBO.setWsdl(TkPropertiesUtils.getProperty((String)"scm.inforecordModify.url"));
            scmExterReqBO.setReqData((Object)req);
            ScmExterRspBO scmExterRspBO = null;
            try {
                scmExterRspBO = this.scmexterCommService.scmExter(scmExterReqBO);
            }
            catch (Exception e) {
                logger.error("\u5408\u540c\u53f7\u3010" + contractNo + "\u3011\u8c03\u7528SCM\u540c\u6b65\u5f02\u5e38\uff1a" + e.getMessage());
                modifyBO.setStatus("03");
                modifyBO.setStatusDesc("\u8c03\u7528SCM\u540c\u6b65\u5f02\u5e38");
                continue;
            }
            if (!"0000".equals(scmExterRspBO.getRespCode())) {
                logger.error("\u5408\u540c\u53f7\u3010" + contractNo + "\u3011\u8c03\u7528SCM\u540c\u6b65\u5931\u8d25\uff1a" + scmExterRspBO.getRespDesc());
                modifyBO.setStatus("03");
                modifyBO.setStatusDesc("\u8c03\u7528SCM\u540c\u6b65\u5931\u8d25\uff1a" + scmExterRspBO.getRespDesc());
                continue;
            }
            JSONObject objJson = JSONObject.fromObject((Object)scmExterRspBO.getScmRspData());
            if (!objJson.containsKey((Object)"Zmmif105Response")) {
                logger.error("\u5408\u540c\u53f7\u3010" + contractNo + "\u3011\u89e3\u6790\u51fa\u53c2\u5931\u8d25\uff0c\u672a\u83b7\u53d6Zmmif105Response");
                modifyBO.setStatus("03");
                modifyBO.setStatusDesc("\u89e3\u6790\u51fa\u53c2\u5931\u8d25\uff0c\u672a\u83b7\u53d6Zmmif105Response");
                continue;
            }
            JSONObject response = objJson.getJSONObject("Zmmif105Response");
            if (!response.containsKey((Object)"OtTable2")) {
                logger.error("\u5408\u540c\u53f7\u3010" + contractNo + "\u3011\u89e3\u6790\u51fa\u53c2\u5931\u8d25\uff0c\u672a\u83b7\u53d6OtTable2");
                modifyBO.setStatus("03");
                modifyBO.setStatusDesc("\u89e3\u6790\u51fa\u53c2\u5931\u8d25\uff0c\u672a\u83b7\u53d6OtTable2");
                continue;
            }
            JSONObject rspJson = response.getJSONObject("OtTable2");
            Object itemObj = rspJson.get("item");
            if (itemObj instanceof JSONObject) {
                itemJson = rspJson.getJSONObject("item");
            } else if (itemObj instanceof JSONArray) {
                JSONArray items = rspJson.getJSONArray("item");
                itemJson = items.getJSONObject(0);
            } else {
                logger.error("\u5408\u540c\u53f7\u3010" + contractNo + "\u3011\u89e3\u6790\u51fa\u53c2\u5931\u8d25\uff0citem\u7c7b\u578b\u9519\u8bef");
                modifyBO.setStatus("03");
                modifyBO.setStatusDesc("\u89e3\u6790\u540c\u6b65\u51fa\u53c2\u5931\u8d25\uff0citem\u7c7b\u578b\u9519\u8bef");
                continue;
            }
            if (!itemJson.containsKey((Object)"Xxlb")) {
                logger.error("\u5408\u540c\u53f7\u3010" + contractNo + "\u3011\u89e3\u6790\u51fa\u53c2\u5931\u8d25\uff0c\u672a\u83b7\u53d6Xxlb");
                modifyBO.setStatus("03");
                modifyBO.setStatusDesc("\u89e3\u6790\u51fa\u53c2\u5931\u8d25\uff0c\u672a\u83b7\u53d6Xxlb");
                continue;
            }
            String respCode = itemJson.getString("Xxlb");
            if (!"S".equals(respCode)) {
                String desc = "\u540c\u6b65\u5931\u8d25";
                if (itemJson.containsKey((Object)"Message")) {
                    desc = itemJson.getString("Message");
                }
                logger.error("\u5408\u540c\u53f7\u3010" + contractNo + "\u3011\u540c\u6b65\u5931\u8d25\uff1a" + desc);
                modifyBO.setStatus("03");
                modifyBO.setStatusDesc("\u5408\u540c\u53f7\u3010" + contractNo + "\u3011\u540c\u6b65\u5931\u8d25\uff1a" + desc);
                continue;
            }
            modifyBO.setStatus("02");
            modifyBO.setStatusDesc("\u540c\u6b65\u6210\u529f");
            if (!itemJson.containsKey((Object)"Infnr")) continue;
            modifyBO.setScmContractCode(itemJson.getString("Infnr"));
        }
    }

    private void infoRecordSave(List<InfoRecordReqBO> saveBOs, List<ContractLogBO> modifyBOs) {
        for (InfoRecordReqBO req : saveBOs) {
            JSONObject itemJson;
            String contractNo = ((InfoRecordReqDetailBO)req.getItTable1().getItem().get(0)).getHtno();
            ContractLogBO modifyBO = new ContractLogBO();
            modifyBO.setContractNo(contractNo);
            modifyBO.setSyncTime(new Date());
            modifyBO.setSyncType("03");
            modifyBO.setFactory(((InfoRecordReqDetailBO)req.getItTable1().getItem().get(0)).getWerks());
            modifyBOs.add(modifyBO);
            ScmExterReqBO scmExterReqBO = new ScmExterReqBO();
            scmExterReqBO.setWsdl(TkPropertiesUtils.getProperty((String)"scm.inforecord.url"));
            scmExterReqBO.setReqData((Object)req);
            ScmExterRspBO scmExterRspBO = null;
            try {
                scmExterRspBO = this.scmexterCommService.scmExter(scmExterReqBO);
            }
            catch (Exception e) {
                logger.error("\u5408\u540c\u53f7\u3010" + contractNo + "\u3011\u8c03\u7528SCM\u540c\u6b65\u5f02\u5e38\uff1a" + e.getMessage());
                modifyBO.setStatus("03");
                modifyBO.setStatusDesc("\u8c03\u7528SCM\u540c\u6b65\u5f02\u5e38");
                continue;
            }
            if (!"0000".equals(scmExterRspBO.getRespCode())) {
                logger.error("\u5408\u540c\u53f7\u3010" + contractNo + "\u3011\u8c03\u7528SCM\u540c\u6b65\u5931\u8d25\uff1a" + scmExterRspBO.getRespDesc());
                modifyBO.setStatus("03");
                modifyBO.setStatusDesc("\u8c03\u7528SCM\u540c\u6b65\u5931\u8d25\uff1a" + scmExterRspBO.getRespDesc());
                continue;
            }
            JSONObject objJson = JSONObject.fromObject((Object)scmExterRspBO.getScmRspData());
            if (!objJson.containsKey((Object)"Zmmif105Response")) {
                logger.error("\u5408\u540c\u53f7\u3010" + contractNo + "\u3011\u89e3\u6790\u51fa\u53c2\u5931\u8d25\uff0c\u672a\u83b7\u53d6Zmmif105Response");
                modifyBO.setStatus("03");
                modifyBO.setStatusDesc("\u89e3\u6790\u51fa\u53c2\u5931\u8d25\uff0c\u672a\u83b7\u53d6Zmmif105Response");
                continue;
            }
            JSONObject response = objJson.getJSONObject("Zmmif105Response");
            if (!response.containsKey((Object)"OtTable2")) {
                logger.error("\u5408\u540c\u53f7\u3010" + contractNo + "\u3011\u89e3\u6790\u51fa\u53c2\u5931\u8d25\uff0c\u672a\u83b7\u53d6OtTable2");
                modifyBO.setStatus("03");
                modifyBO.setStatusDesc("\u89e3\u6790\u51fa\u53c2\u5931\u8d25\uff0c\u672a\u83b7\u53d6OtTable2");
                continue;
            }
            JSONObject rspJson = response.getJSONObject("OtTable2");
            Object itemObj = rspJson.get("item");
            if (itemObj instanceof JSONObject) {
                itemJson = rspJson.getJSONObject("item");
            } else if (itemObj instanceof JSONArray) {
                JSONArray items = rspJson.getJSONArray("item");
                itemJson = items.getJSONObject(0);
            } else {
                logger.error("\u5408\u540c\u53f7\u3010" + contractNo + "\u3011\u89e3\u6790\u51fa\u53c2\u5931\u8d25\uff0citem\u7c7b\u578b\u9519\u8bef");
                modifyBO.setStatus("03");
                modifyBO.setStatusDesc("\u89e3\u6790\u540c\u6b65\u51fa\u53c2\u5931\u8d25\uff0citem\u7c7b\u578b\u9519\u8bef");
                continue;
            }
            if (!itemJson.containsKey((Object)"Xxlb")) {
                logger.error("\u5408\u540c\u53f7\u3010" + contractNo + "\u3011\u89e3\u6790\u51fa\u53c2\u5931\u8d25\uff0c\u672a\u83b7\u53d6Xxlb");
                modifyBO.setStatus("03");
                modifyBO.setStatusDesc("\u89e3\u6790\u51fa\u53c2\u5931\u8d25\uff0c\u672a\u83b7\u53d6Xxlb");
                continue;
            }
            String respCode = itemJson.getString("Xxlb");
            if (!"S".equals(respCode)) {
                String desc = "\u540c\u6b65\u5931\u8d25";
                if (itemJson.containsKey((Object)"Message")) {
                    desc = itemJson.getString("Message");
                }
                logger.error("\u5408\u540c\u53f7\u3010" + contractNo + "\u3011\u540c\u6b65\u5931\u8d25\uff1a" + desc);
                modifyBO.setStatus("03");
                modifyBO.setStatusDesc("\u5408\u540c\u53f7\u3010" + contractNo + "\u3011\u540c\u6b65\u5931\u8d25\uff1a" + desc);
                continue;
            }
            modifyBO.setStatus("02");
            modifyBO.setStatusDesc("\u540c\u6b65\u6210\u529f");
            if (!itemJson.containsKey((Object)"Infnr")) continue;
            modifyBO.setScmContractCode(itemJson.getString("Infnr"));
        }
    }

    private InfoRecordModifyReqDetailsBO getInfoRecordModifyDetails(ContractLogBO bo) {
        InfoRecordModifyReqDetailsBO detailsBO = new InfoRecordModifyReqDetailsBO();
        detailsBO.setXglb("1");
        detailsBO.setHtno(bo.getContractNo());
        detailsBO.setEsokz("2");
        detailsBO.setMatnr(bo.getMeterielCode());
        detailsBO.setLifnr(bo.getSupplierNo());
        detailsBO.setEkorg(bo.getRequireOrgNo());
        detailsBO.setWerks(bo.getFactory());
        detailsBO.setEkgrp("601");
        detailsBO.setKzabs("X");
        detailsBO.setBstae("0001");
        detailsBO.setMwskz(bo.getSaleBuyTaxCode());
        detailsBO.setKdatb(TkDateUtils.formatDate((Date)bo.getStartTime(), (String)"yyyyMMdd"));
        detailsBO.setKdate(TkDateUtils.formatDate((Date)bo.getEndTime(), (String)"yyyyMMdd"));
        detailsBO.setNetpr(bo.getPrice().toString());
        detailsBO.setWaers(bo.getCurrencyCode());
        detailsBO.setPeinh("1");
        detailsBO.setInco1("Z01");
        return detailsBO;
    }

    private InfoRecordReqDetailBO getInfoRecordDetail(ContractLogBO bo) {
        InfoRecordReqDetailBO detailBO = new InfoRecordReqDetailBO();
        detailBO.setHtno(bo.getContractNo());
        detailBO.setEsokz("2");
        detailBO.setMatnr(bo.getMeterielCode());
        detailBO.setLifnr(bo.getSupplierNo());
        detailBO.setEkorg(bo.getRequireOrgNo());
        detailBO.setWerks(bo.getFactory());
        detailBO.setEkgrp("601");
        detailBO.setKzabs("X");
        detailBO.setBstae("0001");
        detailBO.setMwskz(bo.getSaleBuyTaxCode());
        detailBO.setKdatb(TkDateUtils.formatDate((Date)bo.getStartTime(), (String)"yyyyMMdd"));
        detailBO.setKdate(TkDateUtils.formatDate((Date)bo.getEndTime(), (String)"yyyyMMdd"));
        detailBO.setNetpr(bo.getPrice().toString());
        detailBO.setWaers(bo.getCurrencyCode());
        detailBO.setPeinh("1");
        detailBO.setInco1("Z01");
        return detailBO;
    }

    private ContractSyncReqDetailBO getContractReqDetail(ContractLogBO bo) {
        ContractSyncReqDetailBO detailBO = new ContractSyncReqDetailBO();
        detailBO.setHtno(bo.getContractNo());
        detailBO.setMatnr(bo.getMeterielCode());
        detailBO.setLifnr(bo.getSupplierNo());
        detailBO.setBsart(bo.getVoucherTypeCode());
        detailBO.setEkorg(bo.getRequireOrgNo());
        detailBO.setEkgrp("601");
        detailBO.setWerks(bo.getFactory());
        detailBO.setKdatb(TkDateUtils.formatDate((Date)bo.getStartTime(), (String)"yyyyMMdd"));
        detailBO.setKdate(TkDateUtils.formatDate((Date)bo.getEndTime(), (String)"yyyyMMdd"));
        detailBO.setZterm(bo.getPayConditionCode());
        detailBO.setInco1(bo.getInternationalTradingTerms());
        detailBO.setMenge(null != bo.getCount() ? bo.getCount().toString() : "");
        detailBO.setNetpr(bo.getPrice().toString());
        detailBO.setWaers(bo.getCurrencyCode());
        detailBO.setPeinh("1");
        detailBO.setKzabs("X");
        detailBO.setBstae("0001");
        detailBO.setMwskz(bo.getSaleBuyTaxCode());
        detailBO.setKtwrt(null != bo.getTotalPrice() ? bo.getTotalPrice().toString() : "");
        detailBO.setZzqtygl(null != bo.getTotalCount() ? bo.getTotalCount().toString() : "");
        detailBO.setRes01("");
        detailBO.setRes02("");
        detailBO.setRes03("");
        detailBO.setRes04("");
        detailBO.setRes05("");
        return detailBO;
    }

    private void checkContractLog(ContractLogBO bo, boolean isBuyout) {
        if (StringUtils.isBlank((CharSequence)bo.getContractNo())) {
            logger.error("\u5408\u540c\u7f16\u7801\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u5408\u540c\u7f16\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getMeterielCode())) {
            logger.error("\u7269\u6599\u7f16\u7801\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u7269\u6599\u7f16\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getSupplierNo())) {
            logger.error("\u4f9b\u5e94\u5546\u7f16\u7801\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u4f9b\u5e94\u5546\u7f16\u7801\u4e3a\u7a7a");
        }
        if (isBuyout) {
            if (StringUtils.isBlank((CharSequence)bo.getVoucherTypeCode())) {
                logger.error("\u5408\u540c\u7c7b\u578b\u4e3a\u7a7a");
                ThrExceptionUtils.thrEmptyExce("\u5408\u540c\u7c7b\u578b\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)bo.getPayConditionCode())) {
                logger.error("\u4ed8\u6b3e\u6761\u4ef6\u4ee3\u7801\u4e3a\u7a7a");
                ThrExceptionUtils.thrEmptyExce("\u4ed8\u6b3e\u6761\u4ef6\u4ee3\u7801\u4e3a\u7a7a");
            }
            if ("MK".equals(bo.getVoucherTypeCode()) && (null == bo.getCount() || null == bo.getTotalCount())) {
                logger.error("\u5408\u540c\u6570\u91cf\u4e3a\u7a7a");
                ThrExceptionUtils.thrEmptyExce("\u5408\u540c\u6570\u91cf\u4e3a\u7a7a");
            }
            if ("WK".equals(bo.getVoucherTypeCode()) && null == bo.getTotalPrice()) {
                logger.error("\u5408\u540c\u603b\u91d1\u989d\u4e3a\u7a7a");
                ThrExceptionUtils.thrEmptyExce("\u5408\u540c\u603b\u91d1\u989d\u4e3a\u7a7a");
            }
        }
        if (StringUtils.isBlank((CharSequence)bo.getRequireOrgNo())) {
            logger.error("\u91c7\u8d2d\u7ec4\u7ec7\u7f16\u7801\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u91c7\u8d2d\u7ec4\u7ec7\u7f16\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getFactory())) {
            logger.error("\u5de5\u5382\u7f16\u7801\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u5de5\u5382\u7f16\u7801\u4e3a\u7a7a");
        }
        if (null == bo.getStartTime() || null == bo.getEndTime()) {
            logger.error("\u8d77\u6b62\u65f6\u95f4\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u8d77\u6b62\u65f6\u95f4\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getInternationalTradingTerms())) {
            bo.setInternationalTradingTerms("");
        }
        if (null == bo.getPrice()) {
            logger.error("\u4ef7\u683c\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u4ef7\u683c\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getCurrencyCode())) {
            logger.error("\u5e01\u522b\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u5e01\u522b\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bo.getSaleBuyTaxCode())) {
            logger.error("\u9500\u552e/\u8d2d\u4e70\u7a0e\u4ee3\u7801\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u9500\u552e/\u8d2d\u4e70\u7a0e\u4ee3\u7801\u4e3a\u7a7a");
        }
    }
}

