/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.purchase.atom.impl;

import com.tydic.newretail.purchase.atom.ContractLogAtomService;
import com.tydic.newretail.purchase.atom.bo.ContractLogBO;
import com.tydic.newretail.purchase.busi.impl.PurchaseReqTaskServiceImpl;
import com.tydic.newretail.purchase.dao.ContractLogDao;
import com.tydic.newretail.purchase.dao.po.ContractLogPO;
import com.tydic.newretail.purchase.util.ThrExceptionUtils;
import com.tydic.newretail.toolkit.bo.RspBatchBaseBO;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ContractLogAtomServiceImpl
implements ContractLogAtomService {
    private static final Logger logger = LoggerFactory.getLogger(ContractLogAtomServiceImpl.class);
    @Autowired
    private ContractLogDao contractLogDao;

    @Override
    public RspBatchBaseBO<ContractLogBO> queryContractLogInfo(ContractLogBO reqBO) {
        RspBatchBaseBO rspBo = new RspBatchBaseBO();
        ArrayList<ContractLogBO> contractLogBOList = new ArrayList<ContractLogBO>();
        ContractLogPO po = new ContractLogPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)po);
        List<ContractLogPO> list = this.contractLogDao.queryContractLogInfo(po);
        for (ContractLogPO contractLogPO : list) {
            ContractLogBO bo = new ContractLogBO();
            BeanUtils.copyProperties((Object)contractLogPO, (Object)bo);
            contractLogBOList.add(bo);
        }
        rspBo.setRows(contractLogBOList);
        return rspBo;
    }

    @Override
    public List<ContractLogBO> insertContractLogInfo(List<ContractLogBO> reqBO) {
        ArrayList<ContractLogPO> poList = new ArrayList<ContractLogPO>();
        for (ContractLogBO bo : reqBO) {
            ContractLogPO po = new ContractLogPO();
            BeanUtils.copyProperties((Object)bo, (Object)po);
            poList.add(po);
        }
        try {
            this.contractLogDao.insertContractLog(poList);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u5408\u540c\u540c\u6b65\u8bb0\u5f55\u5931\u8d25\uff1a" + e.getMessage());
            ThrExceptionUtils.thrInsExce("\u65b0\u589e\u5408\u540c\u540c\u6b65\u8bb0\u5f55\u5931\u8d25");
        }
        ArrayList<ContractLogBO> bos = new ArrayList<ContractLogBO>(poList.size());
        for (ContractLogPO po : poList) {
            ContractLogBO bo = po.toContractLogBO();
            bos.add(bo);
        }
        return bos;
    }

    @Override
    public void modifyBatchByContractNo(List<ContractLogBO> contractLogBOs) {
        if (CollectionUtils.isEmpty(contractLogBOs)) {
            logger.error("\u5165\u53c2\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u5165\u53c2\u4e3a\u7a7a");
        }
        ArrayList<ContractLogPO> list = new ArrayList<ContractLogPO>(contractLogBOs.size());
        for (ContractLogBO bo : contractLogBOs) {
            list.add(ContractLogPO.toContractLogPO(bo));
        }
        try {
            this.contractLogDao.updateByBatch(list);
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u66f4\u65b0\u5408\u540c\u8bb0\u5f55\u5931\u8d25\uff1a" + e.getMessage());
            ThrExceptionUtils.thrUpdExce("\u6279\u91cf\u66f4\u65b0\u5408\u540c\u8bb0\u5f55\u5931\u8d25");
        }
    }

    @Override
    public List<ContractLogBO> listLogInfoByCondition(List<ContractLogBO> reqBOs) {
        if (CollectionUtils.isEmpty(reqBOs)) {
            logger.error("\u5165\u53c2\u96c6\u5408\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u5165\u53c2\u96c6\u5408\u4e3a\u7a7a");
        }
        ArrayList<ContractLogPO> records = new ArrayList<ContractLogPO>(reqBOs.size());
        for (ContractLogBO reqBO : reqBOs) {
            if (null == reqBO.getSupplierId() || StringUtils.isBlank((CharSequence)reqBO.getMeterielCode()) || StringUtils.isBlank((CharSequence)reqBO.getFactory())) {
                logger.error("\u5165\u53c2\u4e3a\u7a7a");
                ThrExceptionUtils.thrEmptyExce("\u5165\u53c2\u4e3a\u7a7a");
            }
            ContractLogPO record = new ContractLogPO();
            record.setSupplierId(reqBO.getSupplierId());
            record.setMeterielCode(reqBO.getMeterielCode());
            record.setFactory(reqBO.getFactory());
            records.add(record);
        }
        List<ContractLogPO> rspPOs = null;
        try {
            rspPOs = this.contractLogDao.selectByCondition(records);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5408\u540c\u540c\u6b65\u8bb0\u5f55\u5931\u8d25\uff1a" + e.getMessage());
            ThrExceptionUtils.thrEmptyExce("\u67e5\u8be2\u5408\u540c\u540c\u6b65\u8bb0\u5f55\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(rspPOs)) {
            return null;
        }
        ArrayList<ContractLogBO> rspList = new ArrayList<ContractLogBO>(rspPOs.size());
        for (ContractLogPO po : rspPOs) {
            rspList.add(po.toContractLogBO());
        }
        return rspList;
    }

    @Override
    public List<ContractLogBO> listLogInfoBySkuNos(List<String> skuNos) {
        if (CollectionUtils.isEmpty(skuNos)) {
            logger.error("\u5165\u53c2\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u5165\u53c2\u4e3a\u7a7a");
        }
        List<List<String>> list = PurchaseReqTaskServiceImpl.splitList(skuNos, 1000);
        List<ContractLogPO> poList = null;
        try {
            poList = this.contractLogDao.selectBySkuNos(list);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5f85\u540c\u6b65\u5408\u540c\u8bb0\u5f55\u5931\u8d25\uff1a" + e.getMessage());
            ThrExceptionUtils.thrQryExce("\u67e5\u8be2\u5f85\u540c\u6b65\u5408\u540c\u8bb0\u5f55\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(poList)) {
            return null;
        }
        ArrayList<ContractLogBO> rspList = new ArrayList<ContractLogBO>(poList.size());
        for (ContractLogPO po : poList) {
            rspList.add(po.toContractLogBO());
        }
        return rspList;
    }

    @Override
    public ContractLogBO getLogInfoByCnCode(Long contractId) {
        if (null == contractId) {
            logger.error("\u5408\u540c\u7f16\u53f7\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u5408\u540c\u7f16\u53f7\u4e3a\u7a7a");
        }
        ContractLogPO contractLogPO = null;
        try {
            contractLogPO = this.contractLogDao.selectByCnNo(contractId);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u540c\u6b65\u8bb0\u5f55\u5931\u8d25\uff1a" + e.getMessage());
            ThrExceptionUtils.thrEmptyExce("\u67e5\u8be2\u540c\u6b65\u8bb0\u5f55\u5931\u8d25");
        }
        if (null == contractLogPO) {
            return null;
        }
        return contractLogPO.toContractLogBO();
    }
}

