/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.purchase.atom.impl;

import com.tydic.newretail.purchase.atom.LogisticsInstructionAtomService;
import com.tydic.newretail.purchase.bo.LogisticsInstructionBO;
import com.tydic.newretail.purchase.bo.LogisticsInstructionDetailBO;
import com.tydic.newretail.purchase.dao.LogisticsInstructionDao;
import com.tydic.newretail.purchase.dao.LogisticsInstructionDetailDao;
import com.tydic.newretail.purchase.dao.po.LogisticsInstructionDetailPO;
import com.tydic.newretail.purchase.dao.po.LogisticsInstructionPO;
import com.tydic.newretail.purchase.util.ThrExceptionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LogisticsInstructionAtomServiceImpl
implements LogisticsInstructionAtomService {
    private static final Logger logger = LoggerFactory.getLogger(LogisticsInstructionAtomServiceImpl.class);
    @Autowired
    private LogisticsInstructionDao logisticsInstructionDao;
    @Autowired
    private LogisticsInstructionDetailDao logisticsInstructionDetailDao;

    @Override
    public void saveInfoByBatch(List<LogisticsInstructionBO> reqBOs) {
        if (CollectionUtils.isEmpty(reqBOs)) {
            logger.error("\u5165\u53c2\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u5165\u53c2\u4e3a\u7a7a");
        }
        ArrayList<LogisticsInstructionPO> list = new ArrayList<LogisticsInstructionPO>(reqBOs.size());
        ArrayList<LogisticsInstructionDetailPO> detailPOS = new ArrayList<LogisticsInstructionDetailPO>();
        for (LogisticsInstructionBO bo : reqBOs) {
            this.checkParams(bo);
            LogisticsInstructionPO po = LogisticsInstructionPO.toLogisticsInstructionPO(bo);
            if (CollectionUtils.isNotEmpty((Collection)bo.getDetailBOS())) {
                this.getDetailBOs(bo.getDetailBOS(), po.getDeliveryNo(), detailPOS);
            }
            list.add(po);
        }
        try {
            this.logisticsInstructionDao.insertByBatch(list);
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u65b0\u589e\u7269\u6d41\u6307\u4ee4\u4fe1\u606f\u5931\u8d25\uff1a" + e.getCause());
            ThrExceptionUtils.thrInsExce("\u6279\u91cf\u65b0\u589e\u7269\u6d41\u6307\u4ee4\u4fe1\u606f\u5931\u8d25");
        }
        if (CollectionUtils.isNotEmpty(detailPOS)) {
            try {
                this.logisticsInstructionDetailDao.insertByBatch(detailPOS);
            }
            catch (Exception e) {
                logger.error("\u6279\u91cf\u65b0\u589e\u7269\u6d41\u6307\u4ee4\u660e\u7ec6\u4fe1\u606f\u5931\u8d25\uff1a" + e.getCause());
                ThrExceptionUtils.thrInsExce("\u6279\u91cf\u65b0\u589e\u7269\u6d41\u6307\u4ee4\u660e\u7ec6\u4fe1\u606f\u5931\u8d25");
            }
        }
    }

    private void checkParams(LogisticsInstructionBO bo) {
        if (null == bo.getSupplierId() || StringUtils.isBlank((CharSequence)bo.getSupplierNo()) || StringUtils.isBlank((CharSequence)bo.getDeliveryNo())) {
            logger.error("\u5165\u53c2\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u5165\u53c2\u4e3a\u7a7a");
        }
    }

    private void getDetailBOs(List<LogisticsInstructionDetailBO> detailBOS, String deliveryNo, List<LogisticsInstructionDetailPO> detailPOS) {
        for (LogisticsInstructionDetailBO bo : detailBOS) {
            if (null == bo.getOrderDetailId() || StringUtils.isBlank((CharSequence)deliveryNo) || StringUtils.isBlank((CharSequence)bo.getPurchaseVoucher()) || StringUtils.isBlank((CharSequence)bo.getLineNum()) || StringUtils.isBlank((CharSequence)bo.getMeterielCode()) || null == bo.getShipCount() || StringUtils.isBlank((CharSequence)bo.getFactory()) || StringUtils.isBlank((CharSequence)bo.getWarehouse()) || StringUtils.isBlank((CharSequence)bo.getPurchaseOrderNo()) || StringUtils.isBlank((CharSequence)bo.getProvince())) {
                logger.error("\u5165\u53c2\u4e3a\u7a7a");
                ThrExceptionUtils.thrEmptyExce("\u5165\u53c2\u4e3a\u7a7a");
            }
            LogisticsInstructionDetailPO po = LogisticsInstructionDetailPO.toLogisticsInstructionDetailPO(bo);
            po.setDeliveryNo(deliveryNo);
            detailPOS.add(po);
        }
    }

    @Override
    public void modifyInfoByBatch(List<LogisticsInstructionBO> reqBOs) {
        if (CollectionUtils.isEmpty(reqBOs)) {
            logger.error("\u5165\u53c2\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u5165\u53c2\u4e3a\u7a7a");
        }
        ArrayList<LogisticsInstructionPO> list = new ArrayList<LogisticsInstructionPO>(reqBOs.size());
        for (LogisticsInstructionBO bo : reqBOs) {
            if (StringUtils.isBlank((CharSequence)bo.getDeliveryNo())) {
                logger.error("\u914d\u9001\u5355\u53f7\u4e3a\u7a7a");
                ThrExceptionUtils.thrEmptyExce("\u914d\u9001\u5355\u53f7\u4e3a\u7a7a");
            }
            list.add(LogisticsInstructionPO.toLogisticsInstructionPO(bo));
        }
        try {
            this.logisticsInstructionDao.updateByBatch(list);
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u66f4\u65b0\u7269\u6d41\u6307\u4ee4\u5931\u8d25\uff1a" + e.getMessage());
            ThrExceptionUtils.thrUpdExce("\u6279\u91cf\u66f4\u65b0\u7269\u6d41\u6307\u4ee4\u5931\u8d25");
        }
    }
}

