/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.purchase.atom.impl;

import com.tydic.newretail.purchase.atom.PurchaseOrderAtomService;
import com.tydic.newretail.purchase.bo.PurchaseOrdAndDetailBO;
import com.tydic.newretail.purchase.bo.PurchaseOrderBO;
import com.tydic.newretail.purchase.bo.PurchaseOrderDetailBO;
import com.tydic.newretail.purchase.bo.QryPurchaseOrdRspBO;
import com.tydic.newretail.purchase.bo.QryPurchaseOrderDetailBO;
import com.tydic.newretail.purchase.dao.PurchaseOrderDao;
import com.tydic.newretail.purchase.dao.PurchaseOrderDetailDao;
import com.tydic.newretail.purchase.dao.po.PurchaseOrdAndDetailPO;
import com.tydic.newretail.purchase.dao.po.PurchaseOrderDetailPO;
import com.tydic.newretail.purchase.dao.po.PurchaseOrderPO;
import com.tydic.newretail.purchase.util.ThrExceptionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseOrderAtomServiceImpl
implements PurchaseOrderAtomService {
    private static final Logger logger = LoggerFactory.getLogger(PurchaseOrderAtomServiceImpl.class);
    @Autowired
    private PurchaseOrderDao purchaseOrderDao;
    @Autowired
    private PurchaseOrderDetailDao purchaseOrderDetailDao;

    @Override
    public PurchaseOrderBO saveOrderInfo(PurchaseOrderBO reqBO) {
        if (null == reqBO || StringUtils.isBlank((CharSequence)reqBO.getPurchaseOrderNo()) || StringUtils.isBlank((CharSequence)reqBO.getBuyingFlag()) || StringUtils.isBlank((CharSequence)reqBO.getNo()) || StringUtils.isBlank((CharSequence)reqBO.getProvince()) || null == reqBO.getSupplierId() || StringUtils.isBlank((CharSequence)reqBO.getSupplierNo()) || StringUtils.isBlank((CharSequence)reqBO.getOperUser())) {
            logger.error("\u5165\u53c2\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u5165\u53c2\u4e3a\u7a7a");
        }
        PurchaseOrderPO orderPO = PurchaseOrderPO.toPurchaseOrderPO(reqBO);
        try {
            this.purchaseOrderDao.insertSelective(orderPO);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            ThrExceptionUtils.thrInsExce("\u65b0\u589e\u8ba2\u5355\u4fe1\u606f\u5931\u8d25");
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getPurchaseOrderDetailBOList())) {
            this.saveOrderDetailInfo(reqBO.getPurchaseOrderDetailBOList(), orderPO.getPurchaseOrderNo());
        }
        return orderPO.toPurchaseOrderBO();
    }

    @Override
    public void saveOrderinfoByBatch(List<PurchaseOrderBO> reqBOs) {
        if (CollectionUtils.isEmpty(reqBOs)) {
            logger.error("\u5165\u53c2\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u5165\u53c2\u4e3a\u7a7a");
        }
        for (PurchaseOrderBO bo : reqBOs) {
            this.saveOrderInfo(bo);
        }
    }

    @Override
    public void saveOrderDetailInfo(List<PurchaseOrderDetailBO> reqBOs, String orderCode) {
        if (StringUtils.isBlank((CharSequence)orderCode) || CollectionUtils.isEmpty(reqBOs)) {
            logger.error("\u5165\u53c2\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u5165\u53c2\u4e3a\u7a7a");
        }
        ArrayList<PurchaseOrderDetailPO> pos = new ArrayList<PurchaseOrderDetailPO>(reqBOs.size());
        for (PurchaseOrderDetailBO bo : reqBOs) {
            PurchaseOrderDetailPO po = PurchaseOrderDetailPO.toPurchaseOrderDetailPO(bo);
            po.setPurchaseOrderNo(orderCode);
            pos.add(po);
        }
        try {
            this.purchaseOrderDetailDao.insertByBatch(pos);
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u65b0\u589e\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6\u5931\u8d25\uff1a" + e.getMessage());
            ThrExceptionUtils.thrInsExce("\u6279\u91cf\u65b0\u589e\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6\u5931\u8d25");
        }
    }

    @Override
    public void modifyOrderInfo(PurchaseOrderBO reqBO) {
    }

    @Override
    public void modifyOrderDetailInfo(PurchaseOrderDetailBO reqBO) {
    }

    @Override
    public List<QryPurchaseOrderDetailBO> getOrderDetail(String orderNo) {
        List<PurchaseOrderDetailPO> list;
        if (StringUtils.isBlank((CharSequence)orderNo)) {
            logger.error("\u8ba2\u5355\u7f16\u7801\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u8ba2\u5355\u7f16\u7801\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(list = this.purchaseOrderDetailDao.selectByOrderNo(orderNo))) {
            return null;
        }
        ArrayList<QryPurchaseOrderDetailBO> rspList = null;
        for (PurchaseOrderDetailPO po : list) {
            rspList = new ArrayList<QryPurchaseOrderDetailBO>(list.size());
            rspList.add(po.toQryPurchaseOrderDetailBO());
        }
        return rspList;
    }

    @Override
    public QryPurchaseOrdRspBO getOrderByOrderNo(String orderNo) {
        if (StringUtils.isBlank((CharSequence)orderNo)) {
            logger.error("\u5165\u53c2\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u5165\u53c2\u4e3a\u7a7a");
        }
        PurchaseOrderPO po = null;
        try {
            po = this.purchaseOrderDao.selectByOrderNo(orderNo);
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u8ba2\u5355\u53f7\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u5931\u8d25\uff1a" + e.getMessage());
            ThrExceptionUtils.thrQryExce("\u6839\u636e\u8ba2\u5355\u53f7\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u5931\u8d25");
        }
        if (null == po) {
            return null;
        }
        return po.toQryPurchaseOrdRspBO();
    }

    @Override
    public void modifyOrderDetailByBatch(List<PurchaseOrderDetailBO> reqBOs) {
        if (CollectionUtils.isEmpty(reqBOs)) {
            logger.error("\u5165\u53c2\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u5165\u53c2\u4e3a\u7a7a");
        }
        ArrayList<PurchaseOrderDetailPO> list = new ArrayList<PurchaseOrderDetailPO>(reqBOs.size());
        for (PurchaseOrderDetailBO bo : reqBOs) {
            if (null == bo.getId()) {
                logger.error("\u660e\u7ec6ID\u4e3a\u7a7a");
                ThrExceptionUtils.thrEmptyExce("\u660e\u7ec6ID\u4e3a\u7a7a");
            }
            list.add(PurchaseOrderDetailPO.toPurchaseOrderDetailPO(bo));
        }
        try {
            this.purchaseOrderDetailDao.updateByBatch(list);
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u66f4\u65b0\u8ba2\u5355\u660e\u7ec6\u5931\u8d25\uff1a" + e.getMessage());
            ThrExceptionUtils.thrUpdExce("\u6279\u91cf\u66f4\u65b0\u8ba2\u5355\u660e\u7ec6\u5931\u8d25");
        }
    }

    @Override
    public List<PurchaseOrdAndDetailBO> listSyncedDetail(PurchaseOrdAndDetailBO reqBO) {
        List<PurchaseOrdAndDetailPO> purchaseOrderDetailPOS = null;
        try {
            PurchaseOrdAndDetailPO record = new PurchaseOrdAndDetailPO();
            record.setProvince(reqBO.getProvince());
            record.setSkuNo(reqBO.getSkuNo());
            record.setSupplierId(reqBO.getSupplierId());
            record.setBuyingFlag(reqBO.getBuyingFlag());
            record.setDetailIds(reqBO.getDetailIds());
            purchaseOrderDetailPOS = this.purchaseOrderDetailDao.selectByRole(record);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u8ba2\u5355\u660e\u7ec6\u5931\u8d25\uff1a" + e.getMessage());
            ThrExceptionUtils.thrQryExce("\u67e5\u8be2\u8ba2\u5355\u660e\u7ec6\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(purchaseOrderDetailPOS)) {
            return null;
        }
        ArrayList<PurchaseOrdAndDetailBO> rspList = new ArrayList<PurchaseOrdAndDetailBO>(purchaseOrderDetailPOS.size());
        for (PurchaseOrdAndDetailPO po : purchaseOrderDetailPOS) {
            rspList.add(po.toPurchaseOrdAndDetailBO());
        }
        return rspList;
    }

    @Override
    public void modifyPurchaseOrdByBatch(List<PurchaseOrderBO> reqBOs) {
        if (CollectionUtils.isEmpty(reqBOs)) {
            logger.error("\u5165\u53c2\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u5165\u53c2\u4e3a\u7a7a");
        }
        ArrayList<PurchaseOrderPO> pos = new ArrayList<PurchaseOrderPO>(reqBOs.size());
        for (PurchaseOrderBO bo : reqBOs) {
            if (StringUtils.isBlank((CharSequence)bo.getPurchaseOrderNo())) {
                logger.error("\u8ba2\u5355\u7f16\u7801\u4e3a\u7a7a");
                ThrExceptionUtils.thrEmptyExce("\u8ba2\u5355\u7f16\u7801\u4e3a\u7a7a");
            }
            PurchaseOrderPO po = PurchaseOrderPO.toPurchaseOrderPO(bo);
            pos.add(po);
        }
        try {
            this.purchaseOrderDao.updateByBatch(pos);
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u66f4\u65b0\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            ThrExceptionUtils.thrUpdExce("\u6279\u91cf\u66f4\u65b0\u8ba2\u5355\u4fe1\u606f\u5931\u8d25");
        }
    }
}

