/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.purchase.atom.impl;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.ohaotian.plugin.db.OrderSequence;
import com.ohaotian.plugin.db.SnowFlake;
import com.tydic.newretail.purchase.atom.PurchaseRequireAtomService;
import com.tydic.newretail.purchase.bo.PurchaseRequireBO;
import com.tydic.newretail.purchase.bo.PurchaseRequireDetailBO;
import com.tydic.newretail.purchase.bo.QryPurchaseRequireDetailBO;
import com.tydic.newretail.purchase.bo.QryPurchaseRequireRspBO;
import com.tydic.newretail.purchase.dao.PurchaseRequireDao;
import com.tydic.newretail.purchase.dao.PurchaseRequireDetailDao;
import com.tydic.newretail.purchase.dao.po.PurchaseRequireDetailPO;
import com.tydic.newretail.purchase.dao.po.PurchaseRequirePO;
import com.tydic.newretail.purchase.util.ThrExceptionUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseRequireAtomServiceImpl
implements PurchaseRequireAtomService {
    private static final Logger logger = LoggerFactory.getLogger(PurchaseRequireAtomServiceImpl.class);
    @Autowired
    private PurchaseRequireDao purchaseRequireDao;
    @Autowired
    private PurchaseRequireDetailDao purchaseRequireDetailDao;
    @Resource(name="prRequireSequence")
    private OrderSequence prRequireSequence;

    @Override
    public PurchaseRequireBO saveRequireInfo(PurchaseRequireBO reqBO) {
        if (StringUtils.isBlank((CharSequence)reqBO.getAuditStatus())) {
            logger.error("\u5ba1\u6838\u72b6\u6001\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u5ba1\u6838\u72b6\u6001\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getOperUser())) {
            logger.error("\u64cd\u4f5c\u4eba\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u64cd\u4f5c\u4eba\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getBuyingFlag())) {
            logger.error("\u662f\u5426\u4e70\u624b\u56e2\u6807\u8bc6\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u662f\u5426\u4e70\u624b\u56e2\u6807\u8bc6\u4e3a\u7a7a");
        }
        String no = null;
        try {
            no = "AP" + String.valueOf(this.prRequireSequence.nextId());
        }
        catch (SQLException e) {
            logger.error("\u751f\u6210\u9700\u6c42\u5355\u7f16\u7801\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0003", "\u751f\u6210\u9700\u6c42\u5355\u7f16\u7801\u5931\u8d25");
        }
        reqBO.setNo(no);
        PurchaseRequirePO record = PurchaseRequirePO.toPurchaseRequirePO(reqBO);
        try {
            this.purchaseRequireDao.insertSelective(record);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u9700\u6c42\u5355\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0006", "\u65b0\u589e\u9700\u6c42\u5355\u5931\u8d25");
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getPurchaseRequireDetailBOS())) {
            for (PurchaseRequireDetailBO detailBO : reqBO.getPurchaseRequireDetailBOS()) {
                detailBO.setReqNo(no);
                this.checkDetailParams(detailBO);
            }
            this.saveRequireDetailByBatch(reqBO.getPurchaseRequireDetailBOS());
        }
        return reqBO;
    }

    @Override
    public PurchaseRequireDetailBO saveRequireDetailInfo(PurchaseRequireDetailBO reqBO) {
        this.checkDetailParams(reqBO);
        PurchaseRequireDetailPO record = PurchaseRequireDetailPO.toPurchaseRequireDetailPO(reqBO);
        try {
            this.purchaseRequireDetailDao.insertSelective(record);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u9700\u6c42\u5355\u8be6\u60c5\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0006", "\u65b0\u589e\u9700\u6c42\u5355\u8be6\u60c5\u5931\u8d25");
        }
        return reqBO;
    }

    private void checkDetailParams(PurchaseRequireDetailBO reqBO) {
        if (StringUtils.isBlank((CharSequence)reqBO.getFactory()) || StringUtils.isBlank((CharSequence)reqBO.getWarehouse()) || StringUtils.isBlank((CharSequence)reqBO.getReqNo()) || StringUtils.isBlank((CharSequence)reqBO.getProvince()) || null == reqBO.getSupplierId() || StringUtils.isBlank((CharSequence)reqBO.getSkuNo()) || null == reqBO.getCount()) {
            logger.error("\u5165\u53c2\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u5165\u53c2\u4e3a\u7a7a");
        }
    }

    @Override
    public void modifyRequireInfoById(PurchaseRequireBO reqBO) {
        if (null == reqBO.getId()) {
            logger.error("ID\u4e3a\u7a7a");
            throw new ResourceException("0001", "ID\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getOperUser())) {
            logger.error("\u64cd\u4f5c\u4eba\u4e3a\u7a7a");
            throw new ResourceException("0001", "\u64cd\u4f5c\u4eba\u4e3a\u7a7a");
        }
        PurchaseRequirePO record = PurchaseRequirePO.toPurchaseRequirePO(reqBO);
        try {
            this.purchaseRequireDao.updateByPrimaryKeySelective(record);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u9700\u6c42\u5355\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0004", "\u66f4\u65b0\u9700\u6c42\u5355\u5931\u8d25");
        }
    }

    @Override
    public void modifyRequireDetailInfoById(PurchaseRequireDetailBO reqBO) {
        if (null == reqBO.getDetailId()) {
            logger.error("ID\u4e3a\u7a7a");
            throw new ResourceException("0001", "ID\u4e3a\u7a7a");
        }
        PurchaseRequireDetailPO record = PurchaseRequireDetailPO.toPurchaseRequireDetailPO(reqBO);
        try {
            this.purchaseRequireDetailDao.updateByPrimaryKeySelective(record);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u9700\u6c42\u5355\u660e\u7ec6\u5931\u8d25\uff1a" + e.getMessage());
            throw new ResourceException("0004", "\u66f4\u65b0\u9700\u6c42\u5355\u660e\u7ec6\u5931\u8d25");
        }
    }

    @Override
    public List<QryPurchaseRequireDetailBO> getRequireDetailByCondition(PurchaseRequireDetailBO reqBO) {
        if (StringUtils.isBlank((CharSequence)reqBO.getReqNo())) {
            logger.error("\u9700\u6c42\u5355\u53f7\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u9700\u6c42\u5355\u53f7\u4e3a\u7a7a");
        }
        List<PurchaseRequireDetailPO> list = null;
        PurchaseRequireDetailPO record = new PurchaseRequireDetailPO();
        record.setProvince(reqBO.getProvince());
        record.setNo(reqBO.getReqNo());
        record.setStatus(reqBO.getStatus());
        try {
            list = this.purchaseRequireDetailDao.selectByCondition(record);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u9700\u6c42\u5355\u8be6\u60c5\u5931\u8d25\uff1a" + e.getMessage());
            ThrExceptionUtils.thrQryExce("\u67e5\u8be2\u9700\u6c42\u5355\u8be6\u60c5\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        ArrayList<QryPurchaseRequireDetailBO> rspList = new ArrayList<QryPurchaseRequireDetailBO>(list.size());
        for (PurchaseRequireDetailPO po : list) {
            QryPurchaseRequireDetailBO bo = po.toQryPurchaseRequireDetailBO();
            rspList.add(bo);
        }
        return rspList;
    }

    @Override
    public QryPurchaseRequireRspBO getRequireByReqNo(String reqNo) {
        if (StringUtils.isBlank((CharSequence)reqNo)) {
            logger.error("\u5165\u53c2\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u5165\u53c2\u4e3a\u7a7a");
        }
        PurchaseRequirePO requirePO = null;
        try {
            requirePO = this.purchaseRequireDao.selectByReqNo(reqNo);
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u9700\u6c42\u5355\u53f7\u67e5\u8be2\u91c7\u8d2d\u9700\u6c42\u5355\u5931\u8d25\uff1a" + e.getMessage());
            ThrExceptionUtils.thrQryExce("\u6839\u636e\u9700\u6c42\u5355\u53f7\u67e5\u8be2\u91c7\u8d2d\u9700\u6c42\u5355\u5931\u8d25");
        }
        if (null == requirePO) {
            return null;
        }
        return requirePO.toQryPurchaseRequireRspBO();
    }

    @Override
    public void modifyRequireByBatch(List<PurchaseRequireBO> list) {
        if (CollectionUtils.isEmpty(list)) {
            ThrExceptionUtils.thrEmptyExce("\u5165\u53c2\u4e3a\u7a7a");
        }
        ArrayList<PurchaseRequireDetailBO> detailBOS = new ArrayList<PurchaseRequireDetailBO>();
        ArrayList<PurchaseRequirePO> records = new ArrayList<PurchaseRequirePO>(list.size());
        for (PurchaseRequireBO bo : list) {
            records.add(PurchaseRequirePO.toPurchaseRequirePO(bo));
            if (!CollectionUtils.isNotEmpty((Collection)bo.getPurchaseRequireDetailBOS())) continue;
            detailBOS.addAll(bo.getPurchaseRequireDetailBOS());
        }
        try {
            this.purchaseRequireDao.updateByBatch(records);
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u66f4\u65b0\u9700\u6c42\u5355\u5931\u8d25\uff1a" + e.getMessage());
            ThrExceptionUtils.thrUpdExce("\u6279\u91cf\u66f4\u65b0\u9700\u6c42\u5355\u5931\u8d25");
        }
        if (CollectionUtils.isNotEmpty(detailBOS)) {
            this.modifyRequireDetailByBatch(detailBOS);
        }
    }

    @Override
    public void modifyRequireDetailByBatch(List<PurchaseRequireDetailBO> list) {
        if (CollectionUtils.isEmpty(list)) {
            logger.error("\u5165\u53c2\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u5165\u53c2\u4e3a\u7a7a");
        }
        ArrayList<PurchaseRequireDetailPO> records = new ArrayList<PurchaseRequireDetailPO>(list.size());
        for (PurchaseRequireDetailBO bo : list) {
            records.add(PurchaseRequireDetailPO.toPurchaseRequireDetailPO(bo));
        }
        try {
            this.purchaseRequireDetailDao.updateByBatch(records);
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u66f4\u65b0\u9700\u6c42\u5355\u8be6\u60c5\u5931\u8d25\uff1a" + e.getMessage());
            ThrExceptionUtils.thrUpdExce("\u6279\u91cf\u66f4\u65b0\u9700\u6c42\u5355\u8be6\u60c5\u5931\u8d25");
        }
    }

    @Override
    public void saveRequireDetailByBatch(List<PurchaseRequireDetailBO> list) {
        if (CollectionUtils.isEmpty(list)) {
            logger.error("\u9700\u6c42\u5355\u660e\u7ec6\u96c6\u5408\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u9700\u6c42\u5355\u660e\u7ec6\u96c6\u5408\u4e3a\u7a7a");
        }
        ArrayList<PurchaseRequireDetailPO> detailPOS = new ArrayList<PurchaseRequireDetailPO>(list.size());
        for (PurchaseRequireDetailBO bo : list) {
            detailPOS.add(PurchaseRequireDetailPO.toPurchaseRequireDetailPO(bo));
        }
        try {
            this.purchaseRequireDetailDao.insertByBatch(detailPOS);
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u65b0\u589e\u9700\u6c42\u5355\u660e\u7ec6\u5931\u8d25\uff1a" + e.getMessage());
            ThrExceptionUtils.thrInsExce("\u6279\u91cf\u65b0\u589e\u9700\u6c42\u5355\u660e\u7ec6\u5931\u8d25");
        }
    }

    @Override
    public List<PurchaseRequireDetailBO> listDetailByIds(Set<Long> detailIds) {
        if (CollectionUtils.isEmpty(detailIds)) {
            logger.error("\u5165\u53c2\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u5165\u53c2\u4e3a\u7a7a");
        }
        List<PurchaseRequireDetailPO> list = null;
        try {
            list = this.purchaseRequireDetailDao.selectByIds(detailIds);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u91c7\u8d2d\u9700\u6c42\u8be6\u60c5\u5931\u8d25\uff1a" + e.getMessage());
            ThrExceptionUtils.thrQryExce("\u67e5\u8be2\u91c7\u8d2d\u9700\u6c42\u8be6\u60c5\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        ArrayList<PurchaseRequireDetailBO> rspList = new ArrayList<PurchaseRequireDetailBO>(list.size());
        for (PurchaseRequireDetailPO po : list) {
            rspList.add(po.toPurchaseRequireDetailBO());
        }
        return rspList;
    }

    @Override
    public List<PurchaseRequireBO> listReqByNos(Set<String> reqNoList) {
        if (CollectionUtils.isEmpty(reqNoList)) {
            logger.error("\u5165\u53c2\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u5165\u53c2\u4e3a\u7a7a");
        }
        List<PurchaseRequirePO> list = null;
        try {
            list = this.purchaseRequireDao.selectByNos(reqNoList);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u9700\u6c42\u5355\u5931\u8d25\uff1a" + e.getMessage());
            ThrExceptionUtils.thrQryExce("\u67e5\u8be2\u9700\u6c42\u5355\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        ArrayList<PurchaseRequireBO> rspList = new ArrayList<PurchaseRequireBO>(list.size());
        for (PurchaseRequirePO po : list) {
            rspList.add(po.toPurchaseRequireBO());
        }
        return rspList;
    }

    public static void main(String[] args) {
        SnowFlake snowFlake = new SnowFlake(1L, 1L);
        for (int i = 0; i < 100; ++i) {
            System.out.println(snowFlake.nextId());
        }
    }
}

