/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.purchase.atom.impl;

import com.tydic.newretail.purchase.atom.ShoppingCartAtomService;
import com.tydic.newretail.purchase.bo.PurchaseFactoryWarehouseBO;
import com.tydic.newretail.purchase.bo.ShoppingCartBO;
import com.tydic.newretail.purchase.dao.PurchaseShoppingCartDao;
import com.tydic.newretail.purchase.dao.po.PurchaseShoppingCartPO;
import com.tydic.newretail.purchase.util.FactoryWarehouseUtils;
import com.tydic.newretail.purchase.util.ThrExceptionUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShoppingCartAtomServiceImpl
implements ShoppingCartAtomService {
    private static final Logger logger = LoggerFactory.getLogger(ShoppingCartAtomServiceImpl.class);
    @Autowired
    private PurchaseShoppingCartDao purchaseShoppingCartDao;

    @Override
    public ShoppingCartBO getShoppingCartById(Long id) {
        if (null == id) {
            logger.error("ID\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("ID\u4e3a\u7a7a");
        }
        PurchaseShoppingCartPO po = null;
        try {
            po = this.purchaseShoppingCartDao.selectByPrimaryKey(id);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u8d2d\u7269\u8f66\u5931\u8d25\uff1a" + e.getMessage());
            ThrExceptionUtils.thrQryExce("\u67e5\u8be2\u8d2d\u7269\u8f66\u5931\u8d25");
        }
        if (null == po) {
            return null;
        }
        ShoppingCartBO bo = po.toShoppingCartBO();
        return bo;
    }

    @Override
    public List<ShoppingCartBO> listShoppingCartByOperUser(String operUser) {
        if (StringUtils.isBlank((CharSequence)operUser)) {
            ThrExceptionUtils.thrEmptyExce("\u8d26\u53f7\u4e3a\u7a7a");
        }
        List<PurchaseShoppingCartPO> shoppingCartPOS = null;
        try {
            shoppingCartPOS = this.purchaseShoppingCartDao.selectByOperUser(operUser);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u8d2d\u7269\u8f66\u5931\u8d25\uff1a" + e.getMessage());
            ThrExceptionUtils.thrQryExce("\u67e5\u8be2\u8d2d\u7269\u8f66\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(shoppingCartPOS)) {
            return null;
        }
        ArrayList<ShoppingCartBO> list = new ArrayList<ShoppingCartBO>(shoppingCartPOS.size());
        for (PurchaseShoppingCartPO po : shoppingCartPOS) {
            ShoppingCartBO bo = po.toShoppingCartBO();
            list.add(bo);
        }
        return list;
    }

    @Override
    public ShoppingCartBO saveShoppingCart(ShoppingCartBO reqBO) {
        if (StringUtils.isNotBlank((CharSequence)reqBO.getFactory()) && StringUtils.isBlank((CharSequence)reqBO.getWarehouse())) {
            reqBO.setWarehouse(this.getWarehouse(reqBO.getFactory()).getWarehouseNo());
        }
        this.checkSaveParams(reqBO);
        PurchaseShoppingCartPO record = PurchaseShoppingCartPO.toPurchaseShoppingCartPO(reqBO);
        record.setId(null);
        try {
            this.purchaseShoppingCartDao.insertSelective(record);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u8d2d\u7269\u8f66\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            ThrExceptionUtils.thrInsExce("\u65b0\u589e\u8d2d\u7269\u8f66\u4fe1\u606f\u5931\u8d25");
        }
        reqBO.setCartId(record.getId());
        return reqBO;
    }

    @Override
    public List<ShoppingCartBO> saveBatchShoppingCart(List<ShoppingCartBO> reqBOs) {
        if (CollectionUtils.isEmpty(reqBOs)) {
            logger.error("\u8d2d\u7269\u8f66\u4fe1\u606f\u96c6\u5408\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u8d2d\u7269\u8f66\u4fe1\u606f\u96c6\u5408\u4e3a\u7a7a");
        }
        ArrayList<PurchaseShoppingCartPO> pos = new ArrayList<PurchaseShoppingCartPO>(reqBOs.size());
        for (ShoppingCartBO bo : reqBOs) {
            if (StringUtils.isNotBlank((CharSequence)bo.getFactory()) && StringUtils.isBlank((CharSequence)bo.getWarehouse())) {
                bo.setWarehouse(this.getWarehouse(bo.getFactory()).getWarehouseNo());
            }
            this.checkSaveParams(bo);
            PurchaseShoppingCartPO record = PurchaseShoppingCartPO.toPurchaseShoppingCartPO(bo);
            pos.add(record);
        }
        try {
            this.purchaseShoppingCartDao.insertByBatch(pos);
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u65b0\u589e\u8d2d\u7269\u8f66\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            ThrExceptionUtils.thrInsExce("\u6279\u91cf\u65b0\u589e\u8d2d\u7269\u8f66\u4fe1\u606f\u5931\u8d25");
        }
        ArrayList<ShoppingCartBO> rspBOs = new ArrayList<ShoppingCartBO>(pos.size());
        for (PurchaseShoppingCartPO po : pos) {
            rspBOs.add(po.toShoppingCartBO());
        }
        return rspBOs;
    }

    private void checkSaveParams(ShoppingCartBO bo) {
        if (StringUtils.isBlank((CharSequence)bo.getBuyingFlag()) || StringUtils.isBlank((CharSequence)bo.getOperUser()) || null == bo.getSupplierId() || null == bo.getSkuId() || StringUtils.isBlank((CharSequence)bo.getSkuNo())) {
            logger.error("\u5165\u53c2\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u5165\u53c2\u4e3a\u7a7a");
        }
    }

    @Override
    public void modifyShoppingCart(ShoppingCartBO reqBO) {
        PurchaseShoppingCartPO record;
        if (null == reqBO.getCartId()) {
            logger.error("\u8d2d\u7269\u8f66ID\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u8d2d\u7269\u8f66ID\u4e3a\u7a7a");
        }
        if (StringUtils.isNotBlank((CharSequence)(record = PurchaseShoppingCartPO.toPurchaseShoppingCartPO(reqBO)).getFactory())) {
            record.setWarehouse(this.getWarehouse(record.getFactory()).getWarehouseNo());
        } else if (StringUtils.isBlank((CharSequence)record.getFactory())) {
            record.setWarehouse(null);
        }
        try {
            record.setLastUpdDate(new Date());
            this.purchaseShoppingCartDao.updateByPrimaryKey(record);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u8d2d\u7269\u8f66\u4fe1\u606f\u5931\u8d25:" + e.getMessage());
            ThrExceptionUtils.thrUpdExce("\u66f4\u65b0\u8d2d\u7269\u8f66\u4fe1\u606f\u5931\u8d25");
        }
    }

    @Override
    public List<ShoppingCartBO> listShoppingCartByCondition(ShoppingCartBO reqBO) {
        if (null == reqBO || StringUtils.isBlank((CharSequence)reqBO.getOperUser())) {
            logger.error("\u5165\u53c2\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u5165\u53c2\u4e3a\u7a7a");
        }
        List<PurchaseShoppingCartPO> pos = null;
        try {
            pos = this.purchaseShoppingCartDao.selectByCondition(PurchaseShoppingCartPO.toPurchaseShoppingCartPO(reqBO));
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u8d2d\u7269\u8f66\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            ThrExceptionUtils.thrQryExce("\u67e5\u8be2\u8d2d\u7269\u8f66\u4fe1\u606f\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(pos)) {
            return null;
        }
        ArrayList<ShoppingCartBO> rspList = new ArrayList<ShoppingCartBO>(pos.size());
        for (PurchaseShoppingCartPO po : pos) {
            rspList.add(po.toShoppingCartBO());
        }
        return rspList;
    }

    @Override
    public void removeShippingCartByCondition(ShoppingCartBO reqBO) {
        if (null == reqBO.getCartId() && StringUtils.isBlank((CharSequence)reqBO.getOperUser()) && null == reqBO.getSkuId()) {
            logger.error("\u8d2d\u7269\u8f66ID\u3001\u7528\u6237\u8d26\u53f7\u548c\u5546\u54c1ID\u5fc5\u586b\u5176\u4e00");
            ThrExceptionUtils.thrEmptyExce("\u8d2d\u7269\u8f66ID\u3001\u7528\u6237\u8d26\u53f7\u548c\u5546\u54c1ID\u5fc5\u586b\u5176\u4e00");
        }
        PurchaseShoppingCartPO record = new PurchaseShoppingCartPO();
        if (null != reqBO.getCartId()) {
            record.setId(reqBO.getCartId());
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOperUser())) {
            record.setOperUser(reqBO.getOperUser());
        }
        if (null != reqBO.getSkuId()) {
            record.setSkuId(reqBO.getSkuId());
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getProvince())) {
            record.setProvince(reqBO.getProvince());
        }
        try {
            this.purchaseShoppingCartDao.deleteByCondition(record);
        }
        catch (Exception e) {
            logger.error("\u6e05\u9664\u8d2d\u7269\u8f66\u5931\u8d25\uff1a" + e.getMessage());
            ThrExceptionUtils.thrDelExce("\u6e05\u9664\u8d2d\u7269\u8f66\u5931\u8d25");
        }
    }

    @Override
    public void removeByBatch(List<Long> skuIds, List<Long> cardIds, String operUser) {
        if (StringUtils.isBlank((CharSequence)operUser)) {
            logger.error("\u7528\u6237\u540d\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u7528\u6237\u540d\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(skuIds) && CollectionUtils.isEmpty(cardIds)) {
            logger.error("\u5546\u54c1ID\u96c6\u5408\u4e0e\u8d2d\u7269\u8f66ID\u96c6\u5408\u5fc5\u586b\u5176\u4e00");
            ThrExceptionUtils.thrEmptyExce("\u5546\u54c1ID\u96c6\u5408\u4e0e\u8d2d\u7269\u8f66ID\u96c6\u5408\u5fc5\u586b\u5176\u4e00");
        }
        try {
            this.purchaseShoppingCartDao.deleteByBatch(skuIds, cardIds, operUser);
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u5220\u9664\u8d2d\u7269\u8f66\u5931\u8d25\uff1a" + e.getMessage());
            ThrExceptionUtils.thrDelExce("\u6279\u91cf\u5220\u9664\u8d2d\u7269\u8f66\u5931\u8d25");
        }
    }

    @Override
    public void modifyByBatch(List<ShoppingCartBO> reqList) {
        if (CollectionUtils.isEmpty(reqList)) {
            logger.error("\u5165\u53c2\u96c6\u5408\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u5165\u53c2\u96c6\u5408\u4e3a\u7a7a");
        }
        ArrayList<PurchaseShoppingCartPO> shoppingCartPOS = new ArrayList<PurchaseShoppingCartPO>(reqList.size());
        for (ShoppingCartBO bo : reqList) {
            PurchaseShoppingCartPO po = PurchaseShoppingCartPO.toPurchaseShoppingCartPO(bo);
            po.setLastUpdDate(new Date());
            shoppingCartPOS.add(po);
        }
        try {
            this.purchaseShoppingCartDao.updateByBatch(shoppingCartPOS);
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u66f4\u65b0\u8d2d\u7269\u8f66\u5931\u8d25\uff1a" + e.getMessage());
            ThrExceptionUtils.thrUpdExce("\u6279\u91cf\u66f4\u65b0\u8d2d\u7269\u8f66\u5931\u8d25");
        }
    }

    @Override
    public void modifyBySkuId(ShoppingCartBO reqBO) {
        if (null == reqBO.getSkuId() || StringUtils.isBlank((CharSequence)reqBO.getOperUser())) {
            logger.error("\u5165\u53c2\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u5165\u53c2\u4e3a\u7a7a");
        }
        PurchaseShoppingCartPO record = PurchaseShoppingCartPO.toPurchaseShoppingCartPO(reqBO);
        try {
            record.setLastUpdDate(new Date());
            this.purchaseShoppingCartDao.updatePubBySkuId(record);
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u5546\u54c1ID\u66f4\u65b0\u8d2d\u7269\u8f66\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            ThrExceptionUtils.thrUpdExce("\u6839\u636e\u5546\u54c1ID\u66f4\u65b0\u8d2d\u7269\u8f66\u4fe1\u606f\u5931\u8d25");
        }
    }

    @Override
    public void modifyShoppingCartDetail(ShoppingCartBO reqBO) {
        PurchaseShoppingCartPO record;
        if (null == reqBO.getCartId()) {
            logger.error("\u8d2d\u7269\u8f66ID\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u8d2d\u7269\u8f66ID\u4e3a\u7a7a");
        }
        if (StringUtils.isNotBlank((CharSequence)(record = PurchaseShoppingCartPO.toPurchaseShoppingCartPO(reqBO)).getFactory())) {
            record.setWarehouse(this.getWarehouse(record.getFactory()).getWarehouseNo());
        } else if (StringUtils.isBlank((CharSequence)record.getFactory())) {
            record.setWarehouse(null);
        }
        try {
            record.setLastUpdDate(new Date());
            this.purchaseShoppingCartDao.updateDetailByPrimaryKey(record);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u8d2d\u7269\u8f66\u4fe1\u606f\u5931\u8d25:" + e.getMessage());
            ThrExceptionUtils.thrUpdExce("\u66f4\u65b0\u8d2d\u7269\u8f66\u4fe1\u606f\u5931\u8d25");
        }
    }

    @Override
    public List<ShoppingCartBO> listShoppingCartByIds(List<Long> skuIds, String operUser) {
        if (CollectionUtils.isEmpty(skuIds) || StringUtils.isBlank((CharSequence)operUser)) {
            logger.error("\u5165\u53c2\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u5165\u53c2\u4e3a\u7a7a");
        }
        List<PurchaseShoppingCartPO> cartPOS = null;
        try {
            cartPOS = this.purchaseShoppingCartDao.selectByIds(skuIds, operUser);
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u67e5\u8be2\u8d2d\u7269\u8f66\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            ThrExceptionUtils.thrQryExce("\u6279\u91cf\u67e5\u8be2\u8d2d\u7269\u8f66\u4fe1\u606f\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(cartPOS)) {
            return null;
        }
        ArrayList<ShoppingCartBO> rspList = new ArrayList<ShoppingCartBO>(cartPOS.size());
        for (PurchaseShoppingCartPO po : cartPOS) {
            rspList.add(po.toShoppingCartBO());
        }
        return rspList;
    }

    private PurchaseFactoryWarehouseBO getWarehouse(String factoryNo) {
        PurchaseFactoryWarehouseBO warehouseBO = FactoryWarehouseUtils.getByFactoryNo(factoryNo);
        if (null == warehouseBO || StringUtils.isBlank((CharSequence)warehouseBO.getWarehouseNo())) {
            logger.error("\u672a\u83b7\u53d6\u5de5\u5382\u3010" + factoryNo + "\u3011\u7684\u5e93\u5b58\u4fe1\u606f");
            ThrExceptionUtils.thrQryExce("\u672a\u83b7\u53d6\u5de5\u5382\u3010" + factoryNo + "\u3011\u7684\u5e93\u5b58\u4fe1\u606f");
        }
        return warehouseBO;
    }
}

