/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.purchase.busi.impl;

import com.tydic.newretail.purchase.atom.CallScmAtomService;
import com.tydic.newretail.purchase.atom.ContractLogAtomService;
import com.tydic.newretail.purchase.atom.bo.ContractLogBO;
import com.tydic.newretail.purchase.busi.ContractSyncService;
import com.tydic.newretail.purchase.busi.bo.ContractLogReqBO;
import com.tydic.newretail.purchase.thread.ContractSyncThread;
import com.tydic.newretail.purchase.util.ThrExceptionUtils;
import com.tydic.newretail.toolkit.atom.QryEscapeAtomService;
import com.tydic.newretail.toolkit.bo.RspBaseBO;
import com.tydic.newretail.toolkit.util.TkCreateThreadUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ContractSyncServiceImpl
implements ContractSyncService {
    private static final Logger logger = LoggerFactory.getLogger(ContractSyncServiceImpl.class);
    @Autowired
    private ContractLogAtomService contractLogAtomService;
    @Autowired
    private CallScmAtomService callScmAtomService;
    @Resource(name="purchaseQryEscapeAtomService")
    private QryEscapeAtomService qryEscapeAtomService;

    public void syncContract(List<ContractLogReqBO> reqBOS) {
        if (CollectionUtils.isEmpty(reqBOS)) {
            logger.error("\u5165\u53c2\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u5165\u53c2\u4e3a\u7a7a");
        }
        ArrayList<String> skuNos = new ArrayList<String>(reqBOS.size());
        HashMap<String, String> skuMap = new HashMap<String, String>(reqBOS.size());
        for (ContractLogReqBO log : reqBOS) {
            if (StringUtils.isBlank((String)log.getSkuNo()) || StringUtils.isBlank((String)log.getMeterielCode())) {
                logger.error("\u5546\u54c1\u7f16\u7801\u6216\u7269\u6599\u7f16\u7801\u4e3a\u7a7a");
                ThrExceptionUtils.thrEmptyExce("\u5546\u54c1\u7f16\u7801\u6216\u7269\u6599\u7f16\u7801\u4e3a\u7a7a");
            }
            skuNos.add(log.getSkuNo());
            skuMap.put(log.getSkuNo(), log.getMeterielCode());
        }
        List<ContractLogBO> contractLogBOS = this.contractLogAtomService.listLogInfoBySkuNos(skuNos);
        if (CollectionUtils.isEmpty(contractLogBOS)) {
            logger.error("\u672c\u6b21\u672a\u67e5\u8be2\u5230\u5f85\u540c\u6b65\u7684\u5408\u540c\u8bb0\u5f55");
            return;
        }
        for (ContractLogBO bo : contractLogBOS) {
            bo.setMeterielCode((String)skuMap.get(bo.getSkuNo()));
        }
        this.contractLogAtomService.modifyBatchByContractNo(contractLogBOS);
        this.callScm(contractLogBOS);
    }

    private void callScm(List<ContractLogBO> contractLogBOS) {
        try {
            ContractSyncThread saveFace = new ContractSyncThread(this.callScmAtomService, contractLogBOS);
            ExecutorService singleThreadPool = TkCreateThreadUtils.createSimpleThreadPool((Runnable)saveFace, (String)"sync-contract-pool", (int)1, (int)1);
            singleThreadPool.execute(() -> logger.debug(Thread.currentThread().getName()));
            singleThreadPool.shutdown();
        }
        catch (Exception e) {
            logger.error("\u5f00\u542f\u5408\u540c\u540c\u6b65\u7ebf\u7a0b\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public RspBaseBO syncRetry(ContractLogReqBO reqBO) {
        if (null == reqBO.getId()) {
            logger.error("\u5408\u540c\u8bb0\u5f55ID\u4e3a\u7a7a");
            return new RspBaseBO("0001", "\u5408\u540c\u8bb0\u5f55ID\u4e3a\u7a7a");
        }
        ContractLogBO contractLogBO = this.contractLogAtomService.getLogInfoByCnCode(reqBO.getId());
        if (!"03".equals(contractLogBO.getStatus())) {
            String status = this.qryEscapeAtomService.getCodeTitle("PURCHASE_COUNT_SYNC_RSP_TYPE", contractLogBO.getStatus());
            String statusStr = StringUtils.isNotBlank((String)status) ? status : "\u672a\u5b9a\u4e49";
            logger.error("\u5f53\u524d\u5408\u540c\u8bb0\u5f55\u7c7b\u578b\u3010" + statusStr + "\u3011\u4e0d\u80fd\u91cd\u65b0\u53d1\u9001");
            return new RspBaseBO("0010", "\u5f53\u524d\u5408\u540c\u8bb0\u5f55\u7c7b\u578b\u3010" + statusStr + "\u3011\u4e0d\u80fd\u91cd\u65b0\u53d1\u9001");
        }
        ArrayList<ContractLogBO> syncBOs = new ArrayList<ContractLogBO>(1);
        syncBOs.add(contractLogBO);
        this.callScm(syncBOs);
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }
}

