/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.purchase.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.newretail.purchase.atom.CountPriceAtomService;
import com.tydic.newretail.purchase.atom.CountPriceDetailAtomService;
import com.tydic.newretail.purchase.atom.bo.CountPriceAtomBO;
import com.tydic.newretail.purchase.atom.bo.CountPriceAtomReqBO;
import com.tydic.newretail.purchase.atom.bo.CountPriceAtomRspBO;
import com.tydic.newretail.purchase.atom.bo.CountPriceDetailAtomBO;
import com.tydic.newretail.purchase.atom.bo.CountPriceDetailAtomRspBO;
import com.tydic.newretail.purchase.busi.CountPriceBusiService;
import com.tydic.newretail.purchase.busi.CountPriceDetailBusiService;
import com.tydic.newretail.purchase.busi.bo.AddCountPriceInfoBusiReqBO;
import com.tydic.newretail.purchase.busi.bo.AddCountPriceInfoBusiRspBO;
import com.tydic.newretail.purchase.busi.bo.AttachmentBo;
import com.tydic.newretail.purchase.busi.bo.AttachmentReqBO;
import com.tydic.newretail.purchase.busi.bo.AttachmentrRspBo;
import com.tydic.newretail.purchase.busi.bo.CountPriceBusiBO;
import com.tydic.newretail.purchase.busi.bo.CountPriceBusiReqBO;
import com.tydic.newretail.purchase.busi.bo.CountPriceBusiRspBO;
import com.tydic.newretail.purchase.busi.bo.CountPriceDetailBusiBO;
import com.tydic.newretail.purchase.busi.bo.CountPriceDetailInsertBusiBO;
import com.tydic.newretail.purchase.busi.bo.CountPriceUploadFileReqBO;
import com.tydic.newretail.purchase.busi.bo.CountPriceUploadFileRspBO;
import com.tydic.newretail.purchase.busi.bo.UploadFileBO;
import com.tydic.newretail.purchase.dao.CountPriceDao;
import com.tydic.newretail.purchase.dao.po.AttachmentPo;
import com.tydic.newretail.purchase.dao.po.CountPricePO;
import com.tydic.newretail.spcomm.supplier.busi.bo.SSupplierBusiReqBO;
import com.tydic.newretail.spcomm.supplier.busi.bo.SSupplierBusiRspBO;
import com.tydic.newretail.spcomm.supplier.busi.service.QuerySupplierBusiService;
import com.tydic.newretail.toolkit.atom.QryEscapeAtomService;
import com.tydic.newretail.toolkit.bo.RspBatchBaseBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class CountPriceBusiServiceImpl
implements CountPriceBusiService {
    private static final Logger logger = LoggerFactory.getLogger(CountPriceBusiServiceImpl.class);
    @Autowired
    private CountPriceDao countPriceDao;
    @Autowired
    private CountPriceAtomService countPriceAtomService;
    @Autowired
    private CountPriceDetailBusiService countPriceDetailBusiService;
    @Autowired
    private CountPriceDetailAtomService countPriceDetailAtomService;
    @Autowired
    private QuerySupplierBusiService querySupplierBusiService;
    @Resource(name="purchaseQryEscapeAtomService")
    private QryEscapeAtomService qryEscapeAtomService;

    public CountPriceBusiRspBO getCountPriceInfo(CountPriceBusiReqBO countPriceReqBO) {
        logger.debug("\u5206\u9875\u67e5\u8be2\u91cf\u4ef7\u4fe1\u606f\u670d\u52a1\u5165\u53c2:" + countPriceReqBO.toString());
        CountPriceBusiRspBO rspPage = new CountPriceBusiRspBO();
        try {
            Page page = new Page(countPriceReqBO.getCurrent(), countPriceReqBO.getPageSize());
            CountPricePO countPricePO = new CountPricePO();
            BeanUtils.copyProperties((Object)countPriceReqBO, (Object)countPricePO);
            List<Object> rspPO = new ArrayList();
            countPricePO.setIsValid("1");
            rspPO = countPriceReqBO.getSign() == 0 ? this.countPriceDao.selectInfoByPage(page, countPricePO) : this.countPriceDao.selectApproveInfoByPage(page, countPricePO);
            ArrayList<CountPriceBusiBO> rspList = null;
            if (CollectionUtils.isNotEmpty(rspPO)) {
                rspList = new ArrayList<CountPriceBusiBO>(rspPO.size());
                for (CountPricePO countPricePO2 : rspPO) {
                    CountPriceBusiBO bo = new CountPriceBusiBO();
                    SSupplierBusiReqBO supplierBusiReqBO = new SSupplierBusiReqBO();
                    supplierBusiReqBO.setSupplierId(countPricePO2.getSupplierId());
                    SSupplierBusiRspBO supplierBusiRspBO = this.querySupplierBusiService.selectSupplierDetail(supplierBusiReqBO);
                    String currencyTitle = this.qryEscapeAtomService.getCodeTitle("PURCHASE_CURRENCY_CODE", countPricePO2.getCurrencyCode());
                    String saleBuyTaxTitle = this.qryEscapeAtomService.getCodeTitle("PURCHASE_SALE_BUY_TAX_CODE", countPricePO2.getSaleBuyTaxCode());
                    String contractTypeTitle = this.qryEscapeAtomService.getCodeTitle("CONTRACT_TYPE_CODE", countPricePO2.getContractTypeCode());
                    String voucherTypeTitle = this.qryEscapeAtomService.getCodeTitle("VOUCHER_TYPE_CODE", countPricePO2.getVoucherTypeCode());
                    BeanUtils.copyProperties((Object)countPricePO2, (Object)bo);
                    bo.setSupplierName(supplierBusiRspBO.getSupplierFullName());
                    bo.setCurrencyTitle(currencyTitle);
                    bo.setSaleBuyTaxTitle(saleBuyTaxTitle);
                    bo.setContractTypeTitle(contractTypeTitle);
                    bo.setVoucherTypeTitle(voucherTypeTitle);
                    rspList.add(bo);
                }
            } else {
                rspPage.setRows(new ArrayList());
                rspPage.setRecordsTotal(page.getTotalCount());
                rspPage.setTotal(page.getTotalPages());
                rspPage.setRespCode("0000");
                rspPage.setRespDesc("\u91cf\u4ef7\u4fe1\u606f\u4e3a\u7a7a");
                logger.debug("\u5206\u9875\u67e5\u8be2\u91cf\u4ef7\u4fe1\u606f\u670d\u52a1\u51fa\u53c2:" + rspPage.toString());
                return rspPage;
            }
            rspPage.setRecordsTotal(page.getTotalCount());
            rspPage.setRows(rspList);
            rspPage.setTotal(page.getTotalPages());
            rspPage.setRespCode("0000");
            rspPage.setRespDesc("\u67e5\u8be2\u6210\u529f\uff01");
            return rspPage;
        }
        catch (Exception e) {
            logger.error("\u5206\u9875\u67e5\u8be2\u91cf\u4ef7\u4fe1\u606f\u670d\u52a1\u51fa\u9519!", (Throwable)e);
            rspPage.setRespCode("9999");
            rspPage.setRespDesc("\u91cf\u4ef7\u4fe1\u606f\u5217\u8868\u67e5\u8be2\u51fa\u9519\uff01");
            return rspPage;
        }
    }

    public AddCountPriceInfoBusiRspBO insertCountPriceInfo(AddCountPriceInfoBusiReqBO reqBO) {
        AddCountPriceInfoBusiRspBO rspBO = new AddCountPriceInfoBusiRspBO();
        CountPriceDetailAtomBO countPriceDetailAtomBO = new CountPriceDetailAtomBO();
        countPriceDetailAtomBO.setSupplierId(reqBO.getSupplierId());
        countPriceDetailAtomBO.setIsValid("1");
        for (CountPriceDetailBusiBO reqBOs : reqBO.getCountPriceDetailBusiBOList()) {
            countPriceDetailAtomBO.setSkuNo(reqBOs.getSkuNo());
            CountPriceDetailAtomRspBO rspAtomBO = this.countPriceDetailAtomService.queryCountPriceDetail(countPriceDetailAtomBO);
            if (rspAtomBO == null || !CollectionUtils.isNotEmpty(rspAtomBO.getCountPriceDetailAtomBO())) continue;
            for (CountPriceDetailAtomBO detailBo : rspAtomBO.getCountPriceDetailAtomBO()) {
                CountPriceAtomBO countPriceAtomBO = new CountPriceAtomBO();
                countPriceAtomBO.setApplyNo(detailBo.getApplyNo());
                CountPriceAtomRspBO rspAtomBo = this.countPriceAtomService.queryCountPriceInfo(countPriceAtomBO);
                if (rspAtomBo == null || CollectionUtils.isEmpty(rspAtomBo.getCountPriceAtomBO())) {
                    rspBO.setCode("9999");
                    rspBO.setMessage("\u65b0\u589e\u91cf\u4ef7\u5355\u51fa\u9519\uff01");
                    return rspBO;
                }
                if ("03".equals(rspAtomBo.getCountPriceAtomBO().get(0).getStatus()) || reqBO.getStartTime().getTime() < detailBo.getStartTime().getTime() && reqBO.getEndTime().getTime() < detailBo.getStartTime().getTime() || reqBO.getStartTime().getTime() > detailBo.getEndTime().getTime() && reqBO.getEndTime().getTime() > detailBo.getEndTime().getTime()) continue;
                rspBO.setCode("9999");
                rspBO.setMessage("\u8be5\u4f9b\u5e94\u5546\u5728\u540c\u4e00\u65f6\u95f4\u5185\u5b58\u5728\u91cd\u590d\u5546\u54c1\u7684\u91cf\u4ef7\u5355\uff01");
                return rspBO;
            }
        }
        String applyNo = "LJ" + Sequence.getInstance().nextId();
        reqBO.setApplyNo(applyNo);
        CountPriceAtomReqBO countPriceAtomReqBO = new CountPriceAtomReqBO();
        CountPriceDetailInsertBusiBO countPriceDetailBusiBO = new CountPriceDetailInsertBusiBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)countPriceAtomReqBO));
        BeanUtils.copyProperties((Object)reqBO, (Object)countPriceDetailBusiBO);
        this.countPriceAtomService.insertCountPriceInfo(countPriceAtomReqBO);
        this.countPriceDetailBusiService.insert(countPriceDetailBusiBO);
        rspBO.setApplyNo(applyNo);
        rspBO.setCode("0000");
        rspBO.setMessage("\u65b0\u589e\u91cf\u4ef7\u4fe1\u606f\u6210\u529f\uff01");
        return rspBO;
    }

    public CountPriceUploadFileRspBO addFile(CountPriceUploadFileReqBO reqBO) {
        CountPriceUploadFileRspBO rspBO = new CountPriceUploadFileRspBO();
        try {
            AttachmentPo attachmentPo;
            for (UploadFileBO uploadFileReqBO : reqBO.getReqList()) {
                attachmentPo = new AttachmentPo();
                attachmentPo.setApplyNo(uploadFileReqBO.getApplyNo());
                this.countPriceAtomService.deleteAttachmentInfo(attachmentPo);
            }
            for (UploadFileBO uploadFileReqBO : reqBO.getReqList()) {
                if (StringUtils.isEmpty((Object)uploadFileReqBO.getFileName()) || StringUtils.isEmpty((Object)uploadFileReqBO.getFileUrl())) continue;
                attachmentPo = new AttachmentPo();
                attachmentPo.setApplyNo(uploadFileReqBO.getApplyNo());
                attachmentPo.setFileAddr(uploadFileReqBO.getFileUrl());
                attachmentPo.setFileName(uploadFileReqBO.getFileName());
                this.countPriceAtomService.addAttachmentInfo(attachmentPo);
            }
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20\u9644\u4ef6\u51fa\u9519\uff01", (Throwable)e);
            rspBO.setCode("9999");
            rspBO.setMessage("\u4e0a\u4f20\u9644\u4ef6\u51fa\u9519\uff01");
            throw new BusinessException("\u4e0a\u4f20\u9644\u4ef6\u51fa\u9519!", e.getMessage());
        }
        logger.debug("\u4e0a\u4f20\u9644\u4ef6\u6210\u529f\uff1a" + reqBO.getReqList().toString());
        rspBO.setCode("0000");
        rspBO.setMessage("\u4e0a\u4f20\u6210\u529f\uff01");
        return rspBO;
    }

    public AttachmentrRspBo getAttachment(AttachmentReqBO reqBO) {
        AttachmentrRspBo rspBO = new AttachmentrRspBo();
        if (reqBO == null || StringUtils.isEmpty((Object)reqBO.getApplyNo())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u53c2\u6570\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        try {
            AttachmentPo attachmentPo = new AttachmentPo();
            attachmentPo.setApplyNo(reqBO.getApplyNo());
            attachmentPo.setFileStatus("01");
            RspBatchBaseBO<AttachmentBo> rspPo = this.countPriceAtomService.getAttachmentInfo(attachmentPo);
            if (rspPo != null && CollectionUtils.isNotEmpty((Collection)rspPo.getRows())) {
                rspBO.setAttachmentBo(rspPo.getRows());
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u9644\u4ef6\u51fa\u9519\uff01", (Throwable)e);
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u67e5\u8be2\u9644\u4ef6\u51fa\u9519\uff01");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u9644\u4ef6\u6210\u529f\uff01");
        return rspBO;
    }
}

