/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.purchase.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.newretail.purchase.atom.CallScmAtomService;
import com.tydic.newretail.purchase.atom.ContractLogAtomService;
import com.tydic.newretail.purchase.atom.CountPriceAtomService;
import com.tydic.newretail.purchase.atom.CountPriceDetailAtomService;
import com.tydic.newretail.purchase.atom.bo.ContractLogBO;
import com.tydic.newretail.purchase.atom.bo.CountPriceAtomBO;
import com.tydic.newretail.purchase.atom.bo.CountPriceAtomReqBO;
import com.tydic.newretail.purchase.atom.bo.CountPriceAtomRspBO;
import com.tydic.newretail.purchase.atom.bo.CountPriceDetailAtomBO;
import com.tydic.newretail.purchase.atom.bo.CountPriceDetailAtomRspBO;
import com.tydic.newretail.purchase.atom.bo.CountPriceQryAtomRspBO;
import com.tydic.newretail.purchase.bo.PurchaseFactoryWarehouseBO;
import com.tydic.newretail.purchase.bo.PurchaseProvinceBO;
import com.tydic.newretail.purchase.bo.SendCountPriceBO;
import com.tydic.newretail.purchase.bo.SendCountPriceReqBO;
import com.tydic.newretail.purchase.busi.CountPriceDetailBusiService;
import com.tydic.newretail.purchase.busi.bo.ContractLogReqBO;
import com.tydic.newretail.purchase.busi.bo.ContractLogRspBO;
import com.tydic.newretail.purchase.busi.bo.CountPriceDetailBeasBO;
import com.tydic.newretail.purchase.busi.bo.CountPriceDetailBusiBO;
import com.tydic.newretail.purchase.busi.bo.CountPriceDetailBusiInfoBO;
import com.tydic.newretail.purchase.busi.bo.CountPriceDetailBusiReqBO;
import com.tydic.newretail.purchase.busi.bo.CountPriceDetailInsertBusiBO;
import com.tydic.newretail.purchase.busi.bo.CountPriceDetailQueryBusiRspBO;
import com.tydic.newretail.purchase.busi.bo.CountPriceDetailQueryBySkuNoBusiReqBO;
import com.tydic.newretail.purchase.busi.bo.CountPriceDetailQueryBySkuNoBusiRspBO;
import com.tydic.newretail.purchase.busi.bo.CountPriceDetailQueryInfoBO;
import com.tydic.newretail.purchase.busi.bo.CountPriceDetailUpdateBusiReqBO;
import com.tydic.newretail.purchase.busi.bo.CountPriceDetailUpdateMeterielCodeBusiBO;
import com.tydic.newretail.purchase.busi.bo.CountPriceDetailUpdateMeterielCodeBusiReqBO;
import com.tydic.newretail.purchase.busi.bo.CountPriceDetailUpdateMeterielCodeBusiRspBO;
import com.tydic.newretail.purchase.busi.bo.UseCountUpdateBusiReqBO;
import com.tydic.newretail.purchase.busi.bo.UseCountUpdateBusiRspBO;
import com.tydic.newretail.purchase.thread.ContractSyncThread;
import com.tydic.newretail.purchase.util.FactoryWarehouseUtils;
import com.tydic.newretail.purchase.util.PurchaseProvinceUtils;
import com.tydic.newretail.purchase.util.ThrExceptionUtils;
import com.tydic.newretail.spcomm.sku.bo.SupplierSkuDetailBO;
import com.tydic.newretail.spcomm.sku.bo.SupplierSkuStatusBO;
import com.tydic.newretail.spcomm.sku.busi.service.QuerySupplierSkuService;
import com.tydic.newretail.toolkit.atom.QryEscapeAtomService;
import com.tydic.newretail.toolkit.bo.RspBaseBO;
import com.tydic.newretail.toolkit.bo.RspBatchBaseBO;
import com.tydic.newretail.toolkit.util.TkCreateThreadUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class CountPriceDetailBusiServiceImpl
implements CountPriceDetailBusiService {
    private static final Logger log = LoggerFactory.getLogger(CountPriceDetailBusiServiceImpl.class);
    @Autowired
    private CountPriceAtomService countPriceAtomService;
    @Autowired
    private CountPriceDetailAtomService countPriceDetailAtomService;
    @Autowired
    private QuerySupplierSkuService querySupplierSkuService;
    @Autowired
    private CallScmAtomService callScmAtomService;
    @Autowired
    private ContractLogAtomService contractLogAtomService;
    @Resource(name="purchaseQryEscapeAtomService")
    private QryEscapeAtomService qryEscapeAtomService;
    @Resource(name="purProducer")
    ProxyMessageProducer producer;
    @Value(value="${BUY_COMM_TOPIC}")
    private String topic;
    @Value(value="${COUNT_PRICE_GID}")
    private String topicPid;
    @Value(value="${COUNT_PRICE_TAG}")
    private String tagADDCOUNT;

    public CountPriceDetailQueryBusiRspBO queryListPage(CountPriceDetailBusiReqBO reqBO) {
        CountPriceDetailQueryBusiRspBO rspBO = new CountPriceDetailQueryBusiRspBO();
        if (null == reqBO || StringUtils.isEmpty((Object)reqBO.getApplyNo())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        try {
            ArrayList<CountPriceDetailBusiInfoBO> boList;
            log.debug("\u660e\u7ec6\u67e5\u8be2\u670d\u52a1\u5165\u53c2:" + JSON.toJSONString((Object)reqBO));
            CountPriceQryAtomRspBO countPriceQryAtomRspBO = this.countPriceAtomService.select(reqBO.getApplyNo());
            CountPriceDetailAtomRspBO detailRspBO = this.countPriceDetailAtomService.queryListPage(reqBO.getApplyNo());
            if (CollectionUtils.isNotEmpty(detailRspBO.getCountPriceDetailAtomBO()) && !StringUtils.isEmpty((Object)countPriceQryAtomRspBO.getApplyNo())) {
                BeanUtils.copyProperties((Object)((Object)countPriceQryAtomRspBO), (Object)rspBO);
                String currencyTitle = this.qryEscapeAtomService.getCodeTitle("PURCHASE_CURRENCY_CODE", countPriceQryAtomRspBO.getCurrencyCode());
                String saleBuyTaxTitle = this.qryEscapeAtomService.getCodeTitle("PURCHASE_SALE_BUY_TAX_CODE", countPriceQryAtomRspBO.getSaleBuyTaxCode());
                String contractTypeTitle = this.qryEscapeAtomService.getCodeTitle("CONTRACT_TYPE_CODE", countPriceQryAtomRspBO.getContractTypeCode());
                String voucherTypeTitle = this.qryEscapeAtomService.getCodeTitle("VOUCHER_TYPE_CODE", countPriceQryAtomRspBO.getVoucherTypeCode());
                rspBO.setContractTypeTitle(contractTypeTitle);
                rspBO.setVoucherTypeTitle(voucherTypeTitle);
                rspBO.setCurrencyTitle(currencyTitle);
                rspBO.setSaleBuyTaxTitle(saleBuyTaxTitle);
                ArrayList<String> skuNo = new ArrayList<String>();
                boList = new ArrayList<CountPriceDetailBusiInfoBO>();
                for (CountPriceDetailAtomBO countPriceDetailAtomBO : detailRspBO.getCountPriceDetailAtomBO()) {
                    skuNo.add(countPriceDetailAtomBO.getSkuNo());
                    CountPriceDetailBusiInfoBO countPriceDetailBusiBO = new CountPriceDetailBusiInfoBO();
                    countPriceDetailBusiBO.setId(countPriceDetailAtomBO.getId());
                    countPriceDetailBusiBO.setSkuNo(countPriceDetailAtomBO.getSkuNo());
                    countPriceDetailBusiBO.setCount(countPriceDetailAtomBO.getCount());
                    countPriceDetailBusiBO.setPrice(Double.valueOf(countPriceDetailAtomBO.getPrice() == null ? 0.0 : new BigDecimal(countPriceDetailAtomBO.getPrice()).divide(new BigDecimal("10000")).doubleValue()));
                    countPriceDetailBusiBO.setRemainingCount(countPriceDetailAtomBO.getRemainingCount());
                    countPriceDetailBusiBO.setUsedCount(countPriceDetailAtomBO.getUsedCount());
                    countPriceDetailBusiBO.setMeterielCode(countPriceDetailAtomBO.getMeterielCode());
                    SupplierSkuStatusBO supplierSkuStatusBO = new SupplierSkuStatusBO();
                    supplierSkuStatusBO.setSupplierId(countPriceDetailAtomBO.getSupplierId());
                    supplierSkuStatusBO.setSkuNo(countPriceDetailAtomBO.getSkuNo());
                    SupplierSkuDetailBO bo = this.querySupplierSkuService.selectSupplierSkuDetail(supplierSkuStatusBO);
                    if (bo != null) {
                        countPriceDetailBusiBO.setSkuName(bo.getSkuName());
                    }
                    boList.add(countPriceDetailBusiBO);
                }
            } else {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u67e5\u8be2\u91cf\u4ef7\u5546\u54c1\u4fe1\u606f\u4e3a\u7a7a\uff01");
                return rspBO;
            }
            rspBO.setCountPriceDetailBusiBO(boList);
            log.debug("\u660e\u7ec6\u67e5\u8be2\u670d\u52a1\u51fa\u53c2:" + rspBO.toString());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u64cd\u4f5c\u6210\u529f");
            return rspBO;
        }
        catch (Exception e) {
            rspBO = new CountPriceDetailQueryBusiRspBO();
            log.error("\u67e5\u8be2\u91cf\u4ef7\u660e\u7ec6\u51fa\u9519\uff01", (Throwable)e);
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u67e5\u8be2\u91cf\u4ef7\u660e\u7ec6\u51fa\u9519\uff01");
            return rspBO;
        }
    }

    public RspBaseBO insert(CountPriceDetailInsertBusiBO record) {
        RspBaseBO countPriceDetailBusiRspBO = new RspBaseBO();
        log.debug("\u660e\u7ec6\u65b0\u589e\u670d\u52a1\u5165\u53c2:" + JSON.toJSONString((Object)record));
        if (null == record) {
            log.error("\u5165\u53c2\u4e3a\u7a7a");
            throw new BusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)record.getApplyNo()) || StringUtils.isEmpty((Object)record.getEndTime()) || StringUtils.isEmpty((Object)record.getIsValid()) || StringUtils.isEmpty((Object)record.getStartTime()) || StringUtils.isEmpty((Object)record.getStatus()) || StringUtils.isEmpty((Object)record.getSupplierId()) || StringUtils.isEmpty((Object)record.getSupplierNo())) {
            throw new BusinessException("0001", "\u91cf\u4ef7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (record.getCountPriceDetailBusiBOList() != null && record.getCountPriceDetailBusiBOList().size() > 0) {
            ArrayList<CountPriceDetailAtomBO> boList = new ArrayList<CountPriceDetailAtomBO>();
            for (CountPriceDetailBusiBO countPriceDetailBusiBO : record.getCountPriceDetailBusiBOList()) {
                if (StringUtils.isEmpty((Object)countPriceDetailBusiBO.getSkuNo()) || StringUtils.isEmpty((Object)countPriceDetailBusiBO.getPrice()) || StringUtils.isEmpty((Object)countPriceDetailBusiBO.getCount())) {
                    throw new BusinessException("0001", "\u660e\u7ec6\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
                }
                CountPriceDetailAtomBO countPriceDetailAtomBO = new CountPriceDetailAtomBO();
                BeanUtils.copyProperties((Object)countPriceDetailBusiBO, (Object)countPriceDetailAtomBO);
                countPriceDetailAtomBO.setPrice(new BigDecimal(countPriceDetailBusiBO.getPrice()).multiply(new BigDecimal("10000")).longValue());
                countPriceDetailAtomBO.setCrtTime(new Date());
                countPriceDetailAtomBO.setApplyNo(record.getApplyNo());
                countPriceDetailAtomBO.setEndTime(record.getEndTime());
                countPriceDetailAtomBO.setIsValid(record.getIsValid());
                countPriceDetailAtomBO.setStartTime(record.getStartTime());
                countPriceDetailAtomBO.setSupplierId(record.getSupplierId());
                countPriceDetailAtomBO.setSupplierNo(record.getSupplierNo());
                boList.add(countPriceDetailAtomBO);
            }
            try {
                this.countPriceDetailAtomService.insertList(boList);
            }
            catch (Exception e) {
                throw new BusinessException("9999", "\u660e\u7ec6\u65b0\u589e\u5f02\u5e38", (Throwable)e);
            }
        }
        countPriceDetailBusiRspBO.setRespCode("0000");
        countPriceDetailBusiRspBO.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        log.debug("\u660e\u7ec6\u65b0\u589e\u670d\u52a1\u51fa\u53c2:" + JSON.toJSONString((Object)countPriceDetailBusiRspBO));
        return countPriceDetailBusiRspBO;
    }

    public RspBaseBO update(CountPriceDetailUpdateBusiReqBO record) {
        CountPriceAtomReqBO countPriceAtomReqBO;
        CountPriceAtomRspBO countPriceAtomRspBO;
        RspBaseBO rspBO = new RspBaseBO();
        CountPriceAtomBO countPriceAtomBO = new CountPriceAtomBO();
        countPriceAtomBO.setApplyNo(record.getApplyNo());
        countPriceAtomBO.setIsValid("1");
        if ("00".equals(record.getStatus()) || "01".equals(record.getStatus())) {
            countPriceAtomBO.setStatus("00");
            countPriceAtomRspBO = this.countPriceAtomService.queryCountPriceInfo(countPriceAtomBO);
            if (null == countPriceAtomRspBO || CollectionUtils.isEmpty(countPriceAtomRspBO.getCountPriceAtomBO())) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u8be5\u91cf\u4ef7\u5355\u4e0d\u5b58\u5728!");
                return rspBO;
            }
            countPriceAtomReqBO = new CountPriceAtomReqBO();
            BeanUtils.copyProperties((Object)record, (Object)((Object)countPriceAtomReqBO));
            countPriceAtomReqBO.setCrtTime(new Date());
            this.countPriceAtomService.update(countPriceAtomReqBO);
            this.countPriceDetailAtomService.deleteByApplyNo(record.getApplyNo());
            if (CollectionUtils.isNotEmpty((Collection)record.getCountPriceDetailBusiBO())) {
                ArrayList<CountPriceDetailAtomBO> boList = new ArrayList<CountPriceDetailAtomBO>();
                for (CountPriceDetailBusiBO countPriceDetailBusiBO : record.getCountPriceDetailBusiBO()) {
                    if (StringUtils.isEmpty((Object)countPriceDetailBusiBO.getSkuNo()) || StringUtils.isEmpty((Object)countPriceDetailBusiBO.getPrice()) || StringUtils.isEmpty((Object)countPriceDetailBusiBO.getCount())) {
                        throw new BusinessException("0001", "\u660e\u7ec6\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    CountPriceDetailAtomBO countPriceDetailAtomBO = new CountPriceDetailAtomBO();
                    BeanUtils.copyProperties((Object)countPriceDetailBusiBO, (Object)countPriceDetailAtomBO);
                    countPriceDetailAtomBO.setPrice(new BigDecimal(countPriceDetailBusiBO.getPrice()).multiply(new BigDecimal("10000")).longValue());
                    countPriceDetailAtomBO.setCrtTime(new Date());
                    countPriceDetailAtomBO.setApplyNo(record.getApplyNo());
                    countPriceDetailAtomBO.setEndTime(record.getEndTime());
                    countPriceDetailAtomBO.setIsValid(record.getIsValid());
                    countPriceDetailAtomBO.setStartTime(record.getStartTime());
                    countPriceDetailAtomBO.setSupplierId(record.getSupplierId());
                    countPriceDetailAtomBO.setSupplierNo(record.getSupplierNo());
                    boList.add(countPriceDetailAtomBO);
                }
                this.countPriceDetailAtomService.insertList(boList);
            }
        }
        if ("02".equals(record.getStatus()) || "03".equals(record.getStatus())) {
            if ("03".equals(record.getStatus()) && StringUtils.isEmpty((Object)record.getRemark())) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u8bf7\u8f93\u5165\u9a73\u56de\u610f\u89c1\uff01");
                return rspBO;
            }
            countPriceAtomBO.setStatus("01");
            countPriceAtomRspBO = this.countPriceAtomService.queryCountPriceInfo(countPriceAtomBO);
            if (null == countPriceAtomRspBO || CollectionUtils.isEmpty(countPriceAtomRspBO.getCountPriceAtomBO())) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u91cf\u4ef7\u5355\u5ba1\u6279\u5931\u8d25\uff01");
                return rspBO;
            }
            countPriceAtomReqBO = new CountPriceAtomReqBO();
            countPriceAtomReqBO.setApplyNo(record.getApplyNo());
            countPriceAtomReqBO.setStatus(record.getStatus());
            countPriceAtomReqBO.setRemark(record.getRemark());
            this.countPriceAtomService.update(countPriceAtomReqBO);
            if ("02".equals(record.getStatus())) {
                this.sendMessage(record);
                this.addScmInfo(record);
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        log.debug("\u660e\u7ec6\u4fee\u6539\u670d\u52a1\u51fa\u53c2:" + rspBO.toString());
        return rspBO;
    }

    public CountPriceDetailQueryBySkuNoBusiRspBO queryBySupplierIdAndSkuNo(CountPriceDetailQueryBySkuNoBusiReqBO record) {
        CountPriceDetailQueryBySkuNoBusiRspBO rspBO = new CountPriceDetailQueryBySkuNoBusiRspBO();
        ArrayList<CountPriceDetailQueryInfoBO> list = new ArrayList<CountPriceDetailQueryInfoBO>();
        if (null == record || CollectionUtils.isEmpty((Collection)record.getCountPriceDetailBeasBO())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        log.debug("\u6839\u636e\u67e5\u8be2\u670d\u52a1\u5165\u53c2:" + record.toString());
        for (CountPriceDetailBeasBO beasBO : record.getCountPriceDetailBeasBO()) {
            CountPriceDetailQueryInfoBO queryInfoBO = new CountPriceDetailQueryInfoBO();
            queryInfoBO.setSkuNo(beasBO.getSkuNo());
            queryInfoBO.setSupplierId(beasBO.getSupplierId());
            queryInfoBO.setQueryTime(beasBO.getQueryTime());
            CountPriceDetailAtomBO countPriceDetailAtomBO = new CountPriceDetailAtomBO();
            BeanUtils.copyProperties((Object)beasBO, (Object)countPriceDetailAtomBO);
            CountPriceDetailAtomRspBO countPriceDetailAtomRspBO = this.countPriceDetailAtomService.queryBySupplierIdAndSkuNo(countPriceDetailAtomBO);
            if (null == countPriceDetailAtomRspBO || CollectionUtils.isEmpty(countPriceDetailAtomRspBO.getCountPriceDetailAtomBO())) {
                list.add(queryInfoBO);
                continue;
            }
            if (countPriceDetailAtomRspBO.getCountPriceDetailAtomBO().size() > 1) {
                list.add(queryInfoBO);
                continue;
            }
            CountPriceDetailAtomBO atomBO = countPriceDetailAtomRspBO.getCountPriceDetailAtomBO().get(0);
            BeanUtils.copyProperties((Object)atomBO, (Object)queryInfoBO);
            String payConditionCode = this.qryEscapeAtomService.getCodeTitle("PURCHASE_PAY_CONDITION_CODE", atomBO.getPayConditionCode());
            queryInfoBO.setPayConditionCode(payConditionCode);
            list.add(queryInfoBO);
        }
        rspBO.setCountPriceDetailQueryInfoBO(list);
        log.debug("\u91cf\u4ef7\u67e5\u8be2\u51fa\u53c2:" + rspBO.toString());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        return rspBO;
    }

    public UseCountUpdateBusiRspBO usedCountUpdate(UseCountUpdateBusiReqBO record) {
        UseCountUpdateBusiRspBO rspBO = new UseCountUpdateBusiRspBO();
        if (null == record || StringUtils.isEmpty((Object)record.getSupplierId()) || StringUtils.isEmpty((Object)record.getSkuNo())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        log.debug("\u660e\u7ec6\u4fee\u6539\u670d\u52a1\u5165\u53c2:" + record.toString());
        try {
            CountPriceDetailAtomBO countPriceDetailAtomBO = new CountPriceDetailAtomBO();
            BeanUtils.copyProperties((Object)record, (Object)countPriceDetailAtomBO);
            CountPriceDetailAtomRspBO countPriceDetailAtomRspBO = this.countPriceDetailAtomService.queryBySupplierIdAndSkuNoAndTime(countPriceDetailAtomBO);
            if (null == countPriceDetailAtomRspBO || CollectionUtils.isEmpty(countPriceDetailAtomRspBO.getCountPriceDetailAtomBO())) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u67e5\u8be2\u4e3a\u7a7a");
                return rspBO;
            }
            if (countPriceDetailAtomRspBO.getCountPriceDetailAtomBO().size() > 1) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u67e5\u8be2\u6570\u636e\u51fa\u9519");
                return rspBO;
            }
            CountPriceDetailAtomBO atomBO = countPriceDetailAtomRspBO.getCountPriceDetailAtomBO().get(0);
            CountPriceDetailAtomBO reqBO = new CountPriceDetailAtomBO();
            Long sum = atomBO.getUsedCount() + atomBO.getRemainingCount();
            if ("01".equals(atomBO.getContractTypeCode())) {
                if (atomBO.getCount().longValue() != sum.longValue()) {
                    rspBO.setRespCode("9999");
                    rspBO.setRespDesc("\u539f\u6570\u91cf\u4e0d\u4e00\u81f4\uff01");
                    return rspBO;
                }
                reqBO.setRemainingCount(atomBO.getCount() - record.getUsedCount() - atomBO.getUsedCount());
                reqBO.setUsedCount(record.getUsedCount() + atomBO.getUsedCount());
            } else if ("02".equals(atomBO.getContractTypeCode())) {
                reqBO.setUsedCount(record.getUsedCount() + atomBO.getUsedCount());
            }
            reqBO.setSupplierId(record.getSupplierId());
            reqBO.setSkuNo(record.getSkuNo());
            reqBO.setApplyNo(atomBO.getApplyNo());
            reqBO.setQueryTime(record.getQueryTime());
            this.countPriceDetailAtomService.updateCountPriceDetail(reqBO);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u64cd\u4f5c\u6210\u529f");
            return rspBO;
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u91cf\u4ef7\u4f7f\u7528\u91cf\u51fa\u9519\uff01", (Throwable)e);
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u7cfb\u7edf\u5f02\u5e38");
            return rspBO;
        }
    }

    public RspBatchBaseBO<ContractLogRspBO> queryContractLog(ContractLogReqBO req) {
        RspBatchBaseBO rspBO = new RspBatchBaseBO();
        ArrayList<ContractLogRspBO> boList = new ArrayList<ContractLogRspBO>();
        log.debug("\u67e5\u8be2\u91cf\u4ef7\u540c\u6b65\u8bb0\u5f55\u5165\u53c2:" + req.toString());
        try {
            ContractLogBO contractLogBO = new ContractLogBO();
            BeanUtils.copyProperties((Object)req, (Object)contractLogBO);
            RspBatchBaseBO<ContractLogBO> rsp = this.contractLogAtomService.queryContractLogInfo(contractLogBO);
            if (rsp == null || CollectionUtils.isEmpty((Collection)rsp.getRows())) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u67e5\u8be2\u4e3a\u7a7a");
                return rspBO;
            }
            for (ContractLogBO contractLogBo : rsp.getRows()) {
                ContractLogRspBO contractLogReqBO = new ContractLogRspBO();
                BeanUtils.copyProperties((Object)contractLogBo, (Object)contractLogReqBO);
                boList.add(contractLogReqBO);
            }
            rspBO.setRows(boList);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u64cd\u4f5c\u6210\u529f");
            return rspBO;
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u91cf\u4ef7\u540c\u6b65\u8bb0\u5f55\u9519\uff01", (Throwable)e);
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u7cfb\u7edf\u5f02\u5e38");
            return rspBO;
        }
    }

    public void sendMessage(CountPriceDetailUpdateBusiReqBO record) {
        CountPriceDetailAtomBO countPriceDetailAtomBO = new CountPriceDetailAtomBO();
        countPriceDetailAtomBO.setApplyNo(record.getApplyNo());
        countPriceDetailAtomBO.setIsValid("1");
        CountPriceDetailAtomRspBO rspAtomBO = this.countPriceDetailAtomService.queryCountPriceDetail(countPriceDetailAtomBO);
        if (rspAtomBO != null && CollectionUtils.isNotEmpty(rspAtomBO.getCountPriceDetailAtomBO())) {
            SendCountPriceReqBO reqBO = new SendCountPriceReqBO();
            ArrayList<SendCountPriceBO> reqBOList = new ArrayList<SendCountPriceBO>();
            SendCountPriceBO SendCountPriceBO2 = new SendCountPriceBO();
            for (CountPriceDetailAtomBO atomBO : rspAtomBO.getCountPriceDetailAtomBO()) {
                SendCountPriceBO2.setSkuNo(atomBO.getSkuNo());
                SendCountPriceBO2.setSupplierId(atomBO.getSupplierId());
                reqBOList.add(SendCountPriceBO2);
            }
            reqBO.setReqBOList(reqBOList);
            JSONObject json = JSONObject.fromObject((Object)reqBO);
            ProxyMessage message = new ProxyMessage(this.topic, this.tagADDCOUNT, json.toString());
            message.setMessageId(this.topicPid);
            ProxySendResult result = this.producer.send(message);
            log.debug("\u53d1\u9001\u6d88\u606f" + result.getStatus());
        }
    }

    public void addScmInfo(CountPriceDetailUpdateBusiReqBO record) {
        ArrayList<ContractLogBO> contractLogBOList = new ArrayList<ContractLogBO>();
        CountPriceQryAtomRspBO countPriceBO = null;
        CountPriceDetailAtomRspBO detailRspBO = null;
        try {
            countPriceBO = this.countPriceAtomService.select(record.getApplyNo());
            detailRspBO = this.countPriceDetailAtomService.queryListPage(record.getApplyNo());
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u91cf\u4ef7\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            ThrExceptionUtils.thrQryExce("\u67e5\u8be2\u91cf\u4ef7\u4fe1\u606f\u5931\u8d25");
        }
        if (null == countPriceBO || null == detailRspBO) {
            log.error("\u91cf\u4ef7\u5355\u3010" + record.getApplyNo() + "\u3011\u4e0d\u5b58\u5728");
            ThrExceptionUtils.thrQryRspEmptyExce("\u91cf\u4ef7\u5355\u3010" + record.getApplyNo() + "\u3011\u4e0d\u5b58\u5728");
        }
        List<PurchaseFactoryWarehouseBO> list = FactoryWarehouseUtils.listFactoryWarehouseByProvince(null);
        for (PurchaseFactoryWarehouseBO factoryWarehouseBO : list) {
            PurchaseProvinceBO purchaseProvinceBO = PurchaseProvinceUtils.getPorvinceByProCode(factoryWarehouseBO.getProvince());
            if (null == purchaseProvinceBO) {
                log.error("\u672a\u914d\u7f6e\u7701\u4efd\u3010" + factoryWarehouseBO.getProvince() + "\u3011");
                ThrExceptionUtils.thrQryRspEmptyExce("\u672a\u914d\u7f6e\u7701\u4efd\u3010" + factoryWarehouseBO.getProvince() + "\u3011");
            }
            for (CountPriceDetailAtomBO detailBO : detailRspBO.getCountPriceDetailAtomBO()) {
                contractLogBOList.add(this.setAddContractLog(detailBO, countPriceBO, purchaseProvinceBO, factoryWarehouseBO));
            }
        }
        if (CollectionUtils.isNotEmpty(contractLogBOList)) {
            List<ContractLogBO> syncBOs = this.contractLogAtomService.insertContractLogInfo(contractLogBOList);
            try {
                ContractSyncThread saveFace = new ContractSyncThread(this.callScmAtomService, syncBOs);
                ExecutorService singleThreadPool = TkCreateThreadUtils.createSimpleThreadPool((Runnable)saveFace, (String)"sync-contract-pool", (int)1, (int)1);
                singleThreadPool.execute(() -> log.debug(Thread.currentThread().getName()));
                singleThreadPool.shutdown();
            }
            catch (Exception e) {
                log.error("\u5f00\u542f\u5408\u540c\u540c\u6b65\u7ebf\u7a0b\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
    }

    private ContractLogBO setAddContractLog(CountPriceDetailAtomBO detailBO, CountPriceQryAtomRspBO countPriceBO, PurchaseProvinceBO purchaseProvinceBO, PurchaseFactoryWarehouseBO factoryWarehouseBO) {
        ContractLogBO contractLogBO = new ContractLogBO();
        contractLogBO.setApplyId(detailBO.getId().toString());
        contractLogBO.setApplyNo(detailBO.getApplyNo());
        contractLogBO.setSupplierId(detailBO.getSupplierId());
        contractLogBO.setSupplierNo(detailBO.getSupplierNo());
        contractLogBO.setSkuNo(detailBO.getSkuNo());
        contractLogBO.setMeterielCode(detailBO.getMeterielCode());
        contractLogBO.setContractTypeCode(countPriceBO.getContractTypeCode());
        contractLogBO.setVoucherTypeCode(countPriceBO.getVoucherTypeCode());
        contractLogBO.setRequireOrgNo(purchaseProvinceBO.getOrgNo());
        contractLogBO.setDealOrgNo("601");
        contractLogBO.setFactory(factoryWarehouseBO.getFactoryNo());
        contractLogBO.setStartTime(detailBO.getStartTime());
        contractLogBO.setEndTime(detailBO.getEndTime());
        String payConditionCode = this.qryEscapeAtomService.getCodeTitle("PURCHASE_PAY_CONDITION_CODE", countPriceBO.getPayConditionCode());
        contractLogBO.setPayConditionCode(payConditionCode);
        contractLogBO.setInternationalTradingTerms("Z01");
        contractLogBO.setCurrencyCode(countPriceBO.getCurrencyCode());
        contractLogBO.setCount(detailBO.getCount());
        contractLogBO.setPrice(detailBO.getPrice());
        contractLogBO.setPriceUnit("1");
        contractLogBO.setSaleBuyTaxCode(countPriceBO.getSaleBuyTaxCode());
        contractLogBO.setCrtTime(new Date());
        contractLogBO.setStatus("01");
        contractLogBO.setTotalPrice(countPriceBO.getTotalPrice());
        contractLogBO.setTotalCount(countPriceBO.getTotalCount());
        contractLogBO.setContractNo(detailBO.getId().toString());
        return contractLogBO;
    }

    public CountPriceDetailUpdateMeterielCodeBusiRspBO updateMeterielCode(CountPriceDetailUpdateMeterielCodeBusiReqBO req) {
        CountPriceDetailUpdateMeterielCodeBusiRspBO rspBO = new CountPriceDetailUpdateMeterielCodeBusiRspBO();
        if (null == req || CollectionUtils.isEmpty((Collection)req.getCountPriceDetailUpdateMeterielCodeBusiReqBO())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u7269\u6599\u4fee\u6539\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        log.debug("\u7269\u6599\u4fee\u6539\u670d\u52a1\u5165\u53c2:" + req.toString());
        try {
            for (CountPriceDetailUpdateMeterielCodeBusiBO countPriceDetailUpdateMeterielCodeBusiBO : req.getCountPriceDetailUpdateMeterielCodeBusiReqBO()) {
                CountPriceDetailAtomBO countPriceDetailAtomBO = new CountPriceDetailAtomBO();
                BeanUtils.copyProperties((Object)countPriceDetailUpdateMeterielCodeBusiBO, (Object)countPriceDetailAtomBO);
                this.countPriceDetailAtomService.updateBySkuNos(countPriceDetailAtomBO);
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u64cd\u4f5c\u6210\u529f");
            return rspBO;
        }
        catch (Exception e) {
            log.error("\u91cf\u4ef7\u7269\u6599\u4fee\u6539\u8bb0\u5f55\u9519\uff01", (Throwable)e);
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u7cfb\u7edf\u5f02\u5e38");
            return rspBO;
        }
    }
}

