/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.purchase.busi.impl;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.ohaotian.plugin.db.OrderSequence;
import com.tydic.newretail.purchase.atom.CallScmAtomService;
import com.tydic.newretail.purchase.atom.LogisticsInstructionAtomService;
import com.tydic.newretail.purchase.atom.PurchaseOrderAtomService;
import com.tydic.newretail.purchase.bo.LogisticsInstructionBO;
import com.tydic.newretail.purchase.bo.LogisticsInstructionDetailBO;
import com.tydic.newretail.purchase.bo.PurchaseOrdAndDetailBO;
import com.tydic.newretail.purchase.bo.PurchaseOrderDetailBO;
import com.tydic.newretail.purchase.bo.SaveLogisticsReqBO;
import com.tydic.newretail.purchase.service.busi.LogisticsInstructionBusiService;
import com.tydic.newretail.purchase.util.PubCheckParamsUtils;
import com.tydic.newretail.purchase.util.ThrExceptionUtils;
import com.tydic.newretail.toolkit.bo.RspBaseBO;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LogisticsInstructionBusiServiceImpl
implements LogisticsInstructionBusiService {
    private static final Logger logger = LoggerFactory.getLogger(LogisticsInstructionBusiServiceImpl.class);
    @Autowired
    private PurchaseOrderAtomService purchaseOrderAtomService;
    @Autowired
    private LogisticsInstructionAtomService logisticsInstructionAtomService;
    @Autowired
    private OrderSequence prLogisticsSequence;
    @Autowired
    private CallScmAtomService callScmAtomService;

    public RspBaseBO saveLogisticsInsInfo(SaveLogisticsReqBO reqBO) {
        String checkRsp = PubCheckParamsUtils.checkAuth(reqBO.getmRole(), reqBO.getmLoginName());
        if (StringUtils.isNotBlank((CharSequence)checkRsp)) {
            return new RspBaseBO("0009", checkRsp);
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getReqList())) {
            logger.error("\u5165\u53c2\u96c6\u5408\u4e3a\u7a7a");
            return new RspBaseBO("0001", "\u5165\u53c2\u96c6\u5408\u4e3a\u7a7a");
        }
        ArrayList<LogisticsInstructionBO> logisticsInstructionBOS = new ArrayList<LogisticsInstructionBO>();
        ArrayList<PurchaseOrderDetailBO> purchaseOrderDetailBOS = new ArrayList<PurchaseOrderDetailBO>();
        ArrayList<Long> detailIds = new ArrayList<Long>(reqBO.getReqList().size());
        HashMap<Long, Long> countMap = new HashMap<Long, Long>(reqBO.getReqList().size());
        for (PurchaseOrderDetailBO bo : reqBO.getReqList()) {
            this.checkParams(bo);
            detailIds.add(bo.getId());
            countMap.put(bo.getId(), bo.getCurrentShipCount());
        }
        PurchaseOrdAndDetailBO record = new PurchaseOrdAndDetailBO();
        record.setDetailIds(detailIds);
        List<PurchaseOrdAndDetailBO> purchaseOrdAndDetailBOS = this.purchaseOrderAtomService.listSyncedDetail(record);
        if (CollectionUtils.isEmpty(purchaseOrdAndDetailBOS)) {
            logger.error("\u672a\u67e5\u8be2\u5230\u53ef\u64cd\u4f5c\u660e\u7ec6\u96c6\u5408");
            ThrExceptionUtils.thrQryRspEmptyExce("\u672a\u67e5\u8be2\u5230\u53ef\u64cd\u4f5c\u660e\u7ec6\u96c6\u5408");
        }
        HashMap<String, LogisticsInstructionBO> logisticsInstructionBOMap = new HashMap<String, LogisticsInstructionBO>(purchaseOrdAndDetailBOS.size());
        for (PurchaseOrdAndDetailBO purchaseOrdAndDetailBO : purchaseOrdAndDetailBOS) {
            LogisticsInstructionBO logisticsInstructionBO;
            if (logisticsInstructionBOMap.containsKey(purchaseOrdAndDetailBO.getSupplierNo())) {
                logisticsInstructionBO = (LogisticsInstructionBO)logisticsInstructionBOMap.get(purchaseOrdAndDetailBO.getSupplierNo());
            } else {
                logisticsInstructionBO = new LogisticsInstructionBO();
                logisticsInstructionBO.setSupplierId(purchaseOrdAndDetailBO.getSupplierId());
                logisticsInstructionBO.setSupplierNo(purchaseOrdAndDetailBO.getSupplierNo());
                logisticsInstructionBO.setUserNo(reqBO.getmLoginName());
                logisticsInstructionBO.setUserName(reqBO.getmName());
                logisticsInstructionBO.setDeliveryNo(this.getDeliveryNo());
                logisticsInstructionBOMap.put(purchaseOrdAndDetailBO.getSupplierNo(), logisticsInstructionBO);
            }
            List<LogisticsInstructionDetailBO> detailBOS = CollectionUtils.isEmpty((Collection)logisticsInstructionBO.getDetailBOS()) ? new ArrayList(1) : logisticsInstructionBO.getDetailBOS();
            LogisticsInstructionDetailBO detailBO = this.getDetailBO(purchaseOrdAndDetailBO, countMap, purchaseOrderDetailBOS);
            detailBO.setLineNum(String.valueOf((detailBOS.size() + 1) * 10));
            detailBOS.add(detailBO);
            logisticsInstructionBO.setDetailBOS(detailBOS);
        }
        for (Map.Entry entry : logisticsInstructionBOMap.entrySet()) {
            logisticsInstructionBOS.add((LogisticsInstructionBO)entry.getValue());
        }
        this.logisticsInstructionAtomService.saveInfoByBatch(logisticsInstructionBOS);
        this.purchaseOrderAtomService.modifyOrderDetailByBatch(purchaseOrderDetailBOS);
        this.callScmAtomService.syncLogisticsIns(logisticsInstructionBOS);
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }

    private String getDeliveryNo() {
        String deliveryNo = "";
        try {
            Long deliveryNum = this.prLogisticsSequence.nextId();
            deliveryNo = "PL" + String.valueOf(deliveryNum);
        }
        catch (SQLException e) {
            logger.error("\u83b7\u53d6\u914d\u9001\u5355\u53f7\u5e8f\u5217\u5931\u8d25\uff1a" + e.getMessage());
            ThrExceptionUtils.thrQryExce("\u83b7\u53d6\u914d\u9001\u5355\u53f7\u5e8f\u5217\u5931\u8d25");
        }
        return deliveryNo;
    }

    private LogisticsInstructionDetailBO getDetailBO(PurchaseOrdAndDetailBO bo, Map<Long, Long> countMap, List<PurchaseOrderDetailBO> purchaseOrderDetailBOS) {
        LogisticsInstructionDetailBO detailBO = new LogisticsInstructionDetailBO();
        detailBO.setProvince(bo.getProvince());
        detailBO.setPurchaseOrderNo(bo.getPurchaseOrderNo());
        detailBO.setOrderDetailId(bo.getId());
        detailBO.setFactory(bo.getFactory());
        detailBO.setMeterielCode(bo.getMeterielCode());
        if (StringUtils.isBlank((CharSequence)bo.getReturnOrderNo())) {
            logger.error("\u672a\u83b7\u53d6\u5230\u8ba2\u5355\u3010" + bo.getPurchaseOrderNo() + "\u3011\u7684\u5916\u90e8\u8ba2\u5355\u53f7\uff0c\u8bf7\u68c0\u67e5\u6570\u636e");
            ThrExceptionUtils.thrQryRspEmptyExce("\u672a\u83b7\u53d6\u5230\u8ba2\u5355\u3010" + bo.getPurchaseOrderNo() + "\u3011\u7684\u5916\u90e8\u8ba2\u5355\u53f7\uff0c\u8bf7\u68c0\u67e5\u6570\u636e");
        }
        detailBO.setPurchaseVoucher(bo.getReturnOrderNo());
        long count = countMap.get(bo.getId());
        if (bo.getShipCount() + count > bo.getCount()) {
            logger.error("\u53d1\u8d27\u6570\u91cf\u8d85\u8fc7\u9700\u6c42\u6570\u91cf");
            throw new ResourceException("0013", "\u53d1\u8d27\u6570\u91cf\u8d85\u8fc7\u9700\u6c42\u6570\u91cf");
        }
        detailBO.setShipCount(String.valueOf(count));
        detailBO.setWarehouse(bo.getWarehouse());
        PurchaseOrderDetailBO modifyBO = new PurchaseOrderDetailBO();
        modifyBO.setShipCount(Long.valueOf(bo.getShipCount() + count));
        modifyBO.setId(bo.getId());
        purchaseOrderDetailBOS.add(modifyBO);
        return detailBO;
    }

    private void checkParams(PurchaseOrderDetailBO bo) {
        if (null == bo.getId()) {
            logger.error("\u8ba2\u5355\u660e\u7ec6ID\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u8ba2\u5355\u660e\u7ec6ID\u4e3a\u7a7a");
        }
        if (null == bo.getCurrentShipCount()) {
            logger.error("\u53d1\u8d27\u6570\u91cf\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u53d1\u8d27\u6570\u91cf\u4e3a\u7a7a");
        }
        if (1L > bo.getCurrentShipCount()) {
            logger.error("\u53d1\u8d27\u6570\u91cf\u9519\u8bef");
            throw new ResourceException("0007", "\u53d1\u8d27\u6570\u91cf\u9519\u8bef");
        }
    }
}

