/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.purchase.busi.impl;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.ohaotian.plugin.db.OrderSequence;
import com.tydic.newretail.purchase.atom.CallScmAtomService;
import com.tydic.newretail.purchase.atom.PurchaseOrderAtomService;
import com.tydic.newretail.purchase.atom.PurchaseRequireAtomService;
import com.tydic.newretail.purchase.atom.QrySpCommInfoAtomService;
import com.tydic.newretail.purchase.atom.ShoppingCartAtomService;
import com.tydic.newretail.purchase.bo.PurchaseAppliReqBO;
import com.tydic.newretail.purchase.bo.PurchaseOrderBO;
import com.tydic.newretail.purchase.bo.PurchaseOrderDetailBO;
import com.tydic.newretail.purchase.bo.PurchaseRequireBO;
import com.tydic.newretail.purchase.bo.PurchaseRequireDetailBO;
import com.tydic.newretail.purchase.bo.QryPurchaseRequireDetailBO;
import com.tydic.newretail.purchase.bo.QryPurchaseRequireRspBO;
import com.tydic.newretail.purchase.bo.ShoppingCartBO;
import com.tydic.newretail.purchase.busi.CountPriceDetailBusiService;
import com.tydic.newretail.purchase.busi.bo.ContractLogRspBO;
import com.tydic.newretail.purchase.busi.bo.CountPriceDetailQueryInfoBO;
import com.tydic.newretail.purchase.busi.bo.UseCountUpdateBusiReqBO;
import com.tydic.newretail.purchase.busi.bo.UseCountUpdateBusiRspBO;
import com.tydic.newretail.purchase.service.busi.PurchaseReqAppliBusiService;
import com.tydic.newretail.purchase.util.GetCountPriceUtils;
import com.tydic.newretail.purchase.util.PubCheckParamsUtils;
import com.tydic.newretail.purchase.util.ThrExceptionUtils;
import com.tydic.newretail.spcomm.sku.bo.SupplierSkuDetailBO;
import com.tydic.newretail.spcomm.supplier.busi.bo.SSupplierBusiReqBO;
import com.tydic.newretail.spcomm.supplier.busi.bo.SSupplierBusiRspBO;
import com.tydic.newretail.spcomm.supplier.busi.service.QuerySupplierBusiService;
import com.tydic.newretail.toolkit.atom.QryEscapeAtomService;
import com.tydic.newretail.toolkit.bo.RspBaseBO;
import com.tydic.newretail.toolkit.bo.RspPageBaseBO;
import com.tydic.newretail.toolkit.util.TkDateUtils;
import com.tydic.newretail.toolkit.util.TkPropertiesUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseReqAppliBusiServiceImpl
implements PurchaseReqAppliBusiService {
    private static final Logger logger = LoggerFactory.getLogger(PurchaseReqAppliBusiServiceImpl.class);
    @Autowired
    private PurchaseRequireAtomService purchaseRequireAtomService;
    @Autowired
    private QryEscapeAtomService purchaseQryEscapeAtomService;
    @Autowired
    private CountPriceDetailBusiService countPriceDetailBusiService;
    @Autowired
    private QrySpCommInfoAtomService qrySpCommInfoAtonService;
    @Autowired
    private PurchaseOrderAtomService purchaseOrderAtomService;
    @Resource
    private QuerySupplierBusiService querySupplierBusiService;
    @Autowired
    private ShoppingCartAtomService shoppingCartAtomService;
    @Resource(name="prOrderSequence")
    private OrderSequence prOrderSequence;
    @Autowired
    private CallScmAtomService callScmAtomService;

    public RspBaseBO passPurchaseAppli(PurchaseAppliReqBO reqBO) {
        return this.checkPurchaseAppli(reqBO, "02");
    }

    public RspBaseBO returnPurchaseAppli(PurchaseAppliReqBO reqBO) {
        return this.checkPurchaseAppli(reqBO, "03");
    }

    private RspBaseBO checkPurchaseAppli(PurchaseAppliReqBO reqBO, String checkStatus) {
        if (StringUtils.isBlank((CharSequence)reqBO.getmLoginName())) {
            logger.error("\u672a\u83b7\u53d6\u7528\u6237\u540d");
            return new RspBaseBO("0009", "\u672a\u83b7\u53d6\u7528\u6237\u540d");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getReqList())) {
            logger.error("\u5165\u53c2\u96c6\u5408\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u5165\u53c2\u96c6\u5408\u4e3a\u7a7a");
        }
        ArrayList<PurchaseRequireBO> modifyList = new ArrayList<PurchaseRequireBO>(reqBO.getReqList().size());
        for (PurchaseRequireBO bo : reqBO.getReqList()) {
            if (StringUtils.isBlank((CharSequence)bo.getNo())) {
                logger.error("\u9700\u6c42\u5355\u53f7\u4e3a\u7a7a");
                ThrExceptionUtils.thrEmptyExce("\u9700\u6c42\u5355\u53f7\u4e3a\u7a7a");
            }
            PurchaseRequireBO purchaseRequireBO = this.checkPurchaseReq(bo, checkStatus, reqBO.getmLoginName(), reqBO.getmName());
            ArrayList<PurchaseRequireDetailBO> modifyDetailBOs = new ArrayList<PurchaseRequireDetailBO>();
            if ("02".equals(checkStatus)) {
                PurchaseRequireDetailBO detailReqBO = new PurchaseRequireDetailBO();
                detailReqBO.setReqNo(bo.getNo());
                List<QryPurchaseRequireDetailBO> detailBOS = this.purchaseRequireAtomService.getRequireDetailByCondition(detailReqBO);
                if (CollectionUtils.isEmpty(detailBOS)) {
                    logger.error("\u672a\u67e5\u8be2\u5230\u9700\u6c42\u5355\u3010" + bo.getNo() + "\u3011\u8be6\u60c5");
                    ThrExceptionUtils.thrQryRspEmptyExce("\u672a\u67e5\u8be2\u5230\u9700\u6c42\u5355\u3010" + bo.getNo() + "\u3011\u8be6\u60c5");
                }
                HashMap<String, ContractLogRspBO> countLogMap = new HashMap<String, ContractLogRspBO>(detailBOS.size());
                HashMap<String, CountPriceDetailQueryInfoBO> countPriceMap = new HashMap<String, CountPriceDetailQueryInfoBO>(detailBOS.size());
                HashMap<String, SupplierSkuDetailBO> skuMap = new HashMap<String, SupplierSkuDetailBO>(detailBOS.size());
                for (QryPurchaseRequireDetailBO detailBO : detailBOS) {
                    PurchaseRequireDetailBO purchaseRequireDetailBO = detailBO.toPurchaseRequireDetailBO();
                    this.getSkuAndCountPrice(purchaseRequireDetailBO, skuMap, countLogMap, countPriceMap);
                    modifyDetailBOs.add(purchaseRequireDetailBO);
                }
            }
            purchaseRequireBO.setPurchaseRequireDetailBOS(modifyDetailBOs);
            purchaseRequireBO.setRemark(reqBO.getRemark());
            modifyList.add(purchaseRequireBO);
        }
        this.purchaseRequireAtomService.modifyRequireByBatch(modifyList);
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }

    private void getSkuAndCountPrice(PurchaseRequireDetailBO purchaseRequireDetailBO, Map<String, SupplierSkuDetailBO> skuMap, Map<String, ContractLogRspBO> countLogMap, Map<String, CountPriceDetailQueryInfoBO> countPriceMap) {
        if (!"03".equals(purchaseRequireDetailBO.getStatus())) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)purchaseRequireDetailBO.getMeterielCode())) {
            SupplierSkuDetailBO skuDetailBO = null;
            try {
                skuDetailBO = this.qrySpCommInfoAtonService.getSkuDetail(null, purchaseRequireDetailBO.getSupplierId(), purchaseRequireDetailBO.getSkuNo(), skuMap);
            }
            catch (Exception e) {
                logger.error("\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
                ThrExceptionUtils.thrCallExec("\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5931\u8d25");
            }
            if (null != skuDetailBO) {
                if (StringUtils.isBlank((CharSequence)skuDetailBO.getMeterielCode())) {
                    // empty if block
                }
                purchaseRequireDetailBO.setMeterielCode(skuDetailBO.getMeterielCode());
                purchaseRequireDetailBO.setSupplierNo(skuDetailBO.getSupplierNo());
                purchaseRequireDetailBO.setUnitName(skuDetailBO.getSkuUnit());
            }
        }
        boolean hasCountPrice = false;
        CountPriceDetailQueryInfoBO countPrice = GetCountPriceUtils.getCounPrice(this.countPriceDetailBusiService, purchaseRequireDetailBO.getSkuNo(), purchaseRequireDetailBO.getSupplierId(), new Date(), countPriceMap);
        if (null == countPrice) {
            purchaseRequireDetailBO.setAvailableCount(null);
            purchaseRequireDetailBO.setPrice(null);
            purchaseRequireDetailBO.setTaxCode(null);
            return;
        }
        purchaseRequireDetailBO.setAvailableCount(countPrice.getRemainingCount());
        purchaseRequireDetailBO.setPrice(countPrice.getPrice());
        purchaseRequireDetailBO.setTaxCode(countPrice.getSaleBuyTaxCode());
        hasCountPrice = "02".equalsIgnoreCase(countPrice.getContractTypeCode()) || null != purchaseRequireDetailBO.getPrice() && null != purchaseRequireDetailBO.getAvailableCount() && purchaseRequireDetailBO.getCount() <= purchaseRequireDetailBO.getAvailableCount();
        boolean syncFlag = false;
        ContractLogRspBO logRsp = GetCountPriceUtils.getCountPriceLog(countLogMap, this.countPriceDetailBusiService, purchaseRequireDetailBO.getSkuNo(), purchaseRequireDetailBO.getSupplierId(), countPrice.getApplyNo(), purchaseRequireDetailBO.getFactory());
        if (null != logRsp && "02".equals(logRsp.getStatus())) {
            syncFlag = true;
        }
        if (StringUtils.isNotBlank((CharSequence)purchaseRequireDetailBO.getMeterielCode()) && hasCountPrice && syncFlag) {
            purchaseRequireDetailBO.setStatus("01");
        }
    }

    private PurchaseRequireBO checkPurchaseReq(PurchaseRequireBO bo, String checkStatus, String checkUserNo, String checkUserName) {
        QryPurchaseRequireRspBO requireRspBO = this.purchaseRequireAtomService.getRequireByReqNo(bo.getNo());
        if (null == requireRspBO) {
            logger.error("\u9700\u6c42\u5355\u3010" + bo.getNo() + "\u3011\u4e0d\u5b58\u5728");
            ThrExceptionUtils.thrQryRspEmptyExce("\u9700\u6c42\u5355\u3010" + bo.getNo() + "\u3011\u4e0d\u5b58\u5728");
        }
        if (!"01".equals(requireRspBO.getAuditStatus())) {
            String statusStr = this.purchaseQryEscapeAtomService.getCodeTitle("PURCHASE_CHECK_STATUS_TYPE", requireRspBO.getAuditStatus());
            if (StringUtils.isBlank((CharSequence)statusStr)) {
                statusStr = "\u672a\u5b9a\u4e49";
            }
            ThrExceptionUtils.thrStatusWrongExce("\u5f53\u524d\u72b6\u6001\u3010" + requireRspBO.getAuditStatus() + statusStr + "\u3011\u4e0d\u80fd\u8fdb\u884c\u5ba1\u6838\u64cd\u4f5c");
        }
        PurchaseRequireBO purchaseRequireBO = new PurchaseRequireBO();
        purchaseRequireBO.setNo(bo.getNo());
        purchaseRequireBO.setAuditStatus(checkStatus);
        purchaseRequireBO.setCheckUser(checkUserNo);
        purchaseRequireBO.setCheckUserName(checkUserName);
        return purchaseRequireBO;
    }

    public RspBaseBO changeToShoppingCart(PurchaseAppliReqBO reqBO) {
        String checkRsp = PubCheckParamsUtils.checkAuth(reqBO.getmRole(), reqBO.getmLoginName());
        if (StringUtils.isNotBlank((CharSequence)checkRsp)) {
            return new RspBaseBO("0009", checkRsp);
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getReqList())) {
            logger.error("\u5165\u53c2\u96c6\u5408\u4e3a\u7a7a");
            return new RspBaseBO("0001", "\u5165\u53c2\u96c6\u5408\u4e3a\u7a7a");
        }
        HashMap<String, SupplierSkuDetailBO> skuMap = new HashMap<String, SupplierSkuDetailBO>();
        ArrayList<ShoppingCartBO> shoppingCartBOS = new ArrayList<ShoppingCartBO>();
        for (PurchaseRequireBO bo : reqBO.getReqList()) {
            QryPurchaseRequireRspBO requireRspBO = this.purchaseRequireAtomService.getRequireByReqNo(bo.getNo());
            if (null == requireRspBO) {
                logger.error("\u9700\u6c42\u5355\u3010" + bo.getNo() + "\u3011\u4e0d\u5b58\u5728");
                continue;
            }
            PurchaseRequireDetailBO detailReqBO = new PurchaseRequireDetailBO();
            detailReqBO.setReqNo(bo.getNo());
            List<QryPurchaseRequireDetailBO> detailBOS = this.purchaseRequireAtomService.getRequireDetailByCondition(detailReqBO);
            if (CollectionUtils.isEmpty(detailBOS)) {
                logger.error("\u672a\u67e5\u8be2\u5230\u9700\u6c42\u5355\u3010" + bo.getNo() + "\u3011\u660e\u7ec6");
                continue;
            }
            for (QryPurchaseRequireDetailBO qryDetailBO : detailBOS) {
                boolean provinceFlag = reqBO.getmRole().contains(TkPropertiesUtils.getProperty((String)"role.type.province"));
                ShoppingCartBO shoppingCartBO = this.getShoppingCartBO(skuMap, requireRspBO, qryDetailBO, reqBO.getmLoginName(), provinceFlag);
                if (null == shoppingCartBO) continue;
                shoppingCartBOS.add(shoppingCartBO);
            }
        }
        if (CollectionUtils.isNotEmpty(shoppingCartBOS)) {
            this.shoppingCartAtomService.saveBatchShoppingCart(shoppingCartBOS);
        }
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }

    private ShoppingCartBO getShoppingCartBO(Map<String, SupplierSkuDetailBO> skuMap, QryPurchaseRequireRspBO requireRspBO, QryPurchaseRequireDetailBO qryDetailBO, String userName, boolean provinceFlag) {
        SupplierSkuDetailBO skuDetailBO = null;
        try {
            skuDetailBO = this.qrySpCommInfoAtonService.getSkuDetail(null, qryDetailBO.getSupplierId(), qryDetailBO.getSkuNo(), skuMap);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            return null;
        }
        if (null == skuDetailBO) {
            return null;
        }
        ShoppingCartBO shoppingCartBO = new ShoppingCartBO();
        shoppingCartBO.setSkuId(skuDetailBO.getId());
        shoppingCartBO.setLastUpdDate(new Date());
        shoppingCartBO.setDeliveryDate(qryDetailBO.getDeliveryDate());
        shoppingCartBO.setFreeFlag(qryDetailBO.getFreeFlag());
        shoppingCartBO.setReturnFlag(qryDetailBO.getReturnFlag());
        shoppingCartBO.setContent(qryDetailBO.getContent());
        shoppingCartBO.setProjectCategory(qryDetailBO.getProjectCategory());
        shoppingCartBO.setOperUser(userName);
        shoppingCartBO.setBuyingFlag(provinceFlag ? "0" : "1");
        shoppingCartBO.setProvince(qryDetailBO.getProvince());
        shoppingCartBO.setSupplierNo(skuDetailBO.getSupplierNo());
        shoppingCartBO.setSupplierId(qryDetailBO.getSupplierId());
        shoppingCartBO.setCount(qryDetailBO.getCount());
        shoppingCartBO.setCrtTime(qryDetailBO.getCrtTime());
        shoppingCartBO.setSkuNo(qryDetailBO.getSkuNo());
        shoppingCartBO.setWarehouse(qryDetailBO.getWarehouse());
        shoppingCartBO.setFactory(qryDetailBO.getFactory());
        shoppingCartBO.setValidFlag("1");
        return shoppingCartBO;
    }

    public RspBaseBO syncPurchaseDetail(PurchaseAppliReqBO reqBO) {
        String checkRsp = PubCheckParamsUtils.checkAuth(reqBO.getmRole(), reqBO.getmLoginName());
        if (StringUtils.isNotBlank((CharSequence)checkRsp)) {
            return new RspBaseBO("0009", checkRsp);
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getDetailList())) {
            logger.error("\u5165\u53c2\u96c6\u5408\u4e3a\u7a7a");
            return new RspBaseBO("0001", "\u5165\u53c2\u96c6\u5408\u4e3a\u7a7a");
        }
        HashSet<Long> detailIds = new HashSet<Long>(reqBO.getDetailList().size());
        HashSet<String> reqNoSet = new HashSet<String>(reqBO.getDetailList().size());
        for (PurchaseRequireDetailBO bo : reqBO.getDetailList()) {
            if (null == bo.getDetailId()) {
                logger.error("\u9700\u6c42\u660e\u7ec6ID\u4e3a\u7a7a");
                ThrExceptionUtils.thrEmptyExce("\u9700\u6c42\u660e\u7ec6ID\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)bo.getReqNo())) {
                logger.error("\u9700\u6c42\u5355\u53f7\u4e3a\u7a7a");
                ThrExceptionUtils.thrEmptyExce("\u9700\u6c42\u5355\u53f7\u4e3a\u7a7a");
            }
            detailIds.add(bo.getDetailId());
            reqNoSet.add(bo.getReqNo());
        }
        List<PurchaseRequireDetailBO> reqList = this.purchaseRequireAtomService.listDetailByIds(detailIds);
        List<PurchaseRequireBO> purchaseRequireBOS = this.purchaseRequireAtomService.listReqByNos(reqNoSet);
        if (CollectionUtils.isEmpty(purchaseRequireBOS)) {
            logger.error("\u672a\u67e5\u8be2\u5230\u9700\u6c42\u5355");
            ThrExceptionUtils.thrQryRspEmptyExce("\u672a\u67e5\u8be2\u5230\u9700\u6c42\u5355");
        }
        HashMap<String, PurchaseRequireBO> map = new HashMap<String, PurchaseRequireBO>(purchaseRequireBOS.size());
        for (PurchaseRequireBO purchaseRequireBO : purchaseRequireBOS) {
            if (!"02".equals(purchaseRequireBO.getAuditStatus())) {
                String statusStr = this.purchaseQryEscapeAtomService.getCodeTitle("PURCHASE_CHECK_STATUS_TYPE", purchaseRequireBO.getAuditStatus());
                if (StringUtils.isBlank((CharSequence)statusStr)) {
                    statusStr = "\u672a\u5b9a\u4e49";
                }
                ThrExceptionUtils.thrStatusWrongExce("\u5f53\u524d\u9700\u6c42\u5355\u3010" + purchaseRequireBO.getNo() + "\u3011\u72b6\u6001\u3010" + purchaseRequireBO.getAuditStatus() + statusStr + "\u3011\u4e0d\u80fd\u8fdb\u884c\u540c\u6b65\u64cd\u4f5c");
            }
            map.put(purchaseRequireBO.getNo(), purchaseRequireBO);
        }
        List<PurchaseOrderBO> purchaseOrderBOS = this.createOrder(reqBO.getmName(), reqBO.getmLoginName(), reqList, map);
        this.callScmAtomService.syncOrderInfo(purchaseOrderBOS);
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }

    private List<PurchaseOrderBO> createOrder(String userName, String operUser, List<PurchaseRequireDetailBO> reqList, Map<String, PurchaseRequireBO> map) {
        ArrayList<PurchaseOrderBO> purchaseOrderBOS = new ArrayList<PurchaseOrderBO>();
        HashMap<String, PurchaseOrderBO> orderMap = new HashMap<String, PurchaseOrderBO>(reqList.size());
        HashMap<Long, String> spMap = new HashMap<Long, String>(reqList.size());
        ArrayList<PurchaseRequireDetailBO> purchaseRequireDetailBOS = new ArrayList<PurchaseRequireDetailBO>();
        HashMap<String, CountPriceDetailQueryInfoBO> countPriceMap = new HashMap<String, CountPriceDetailQueryInfoBO>(reqList.size());
        HashMap<String, ContractLogRspBO> countLogMap = new HashMap<String, ContractLogRspBO>(reqList.size());
        for (PurchaseRequireDetailBO purchaseRequireDetailBO : reqList) {
            ContractLogRspBO logRsp;
            CountPriceDetailQueryInfoBO countPrice;
            if (StringUtils.isBlank((CharSequence)purchaseRequireDetailBO.getSkuNo()) || null == purchaseRequireDetailBO.getSupplierId()) {
                logger.error("\u5546\u54c1\u7f16\u7801\u6216\u4f9b\u5e94\u5546ID\u4e3a\u7a7a");
                ThrExceptionUtils.thrEmptyExce("\u5546\u54c1\u7f16\u7801\u6216\u4f9b\u5e94\u5546ID\u4e3a\u7a7a");
            }
            if (!map.containsKey(purchaseRequireDetailBO.getReqNo())) {
                logger.error("\u672a\u67e5\u8be2\u5230\u9700\u6c42\u5355\u3010" + purchaseRequireDetailBO.getReqNo() + "\u3011");
                ThrExceptionUtils.thrEmptyExce("\u672a\u67e5\u8be2\u5230\u9700\u6c42\u5355\u3010" + purchaseRequireDetailBO.getReqNo() + "\u3011");
            }
            if (!"01".equals(purchaseRequireDetailBO.getStatus())) {
                String statusStr = this.purchaseQryEscapeAtomService.getCodeTitle("PURCHASE_REQ_DETAIL_STATUS_TYPE", purchaseRequireDetailBO.getStatus());
                if (StringUtils.isBlank((CharSequence)statusStr)) {
                    statusStr = "\u672a\u5b9a\u4e49";
                }
                ThrExceptionUtils.thrStatusWrongExce("\u5f53\u524d\u9700\u6c42\u8be6\u60c5\u3010" + purchaseRequireDetailBO.getDetailId() + "\u3011\u72b6\u6001\u3010" + purchaseRequireDetailBO.getStatus() + statusStr + "\u3011\u4e0d\u80fd\u8fdb\u884c\u540c\u6b65\u64cd\u4f5c");
            }
            if (null == (countPrice = GetCountPriceUtils.getCounPrice(this.countPriceDetailBusiService, purchaseRequireDetailBO.getSkuNo(), purchaseRequireDetailBO.getSupplierId(), new Date(), countPriceMap))) {
                logger.error("\u91cf\u4ef7\u5355\u5931\u6548");
                ThrExceptionUtils.thrQryRspEmptyExce("\u91cf\u4ef7\u5355\u5931\u6548");
            }
            if (null == countPrice.getPrice()) {
                logger.error("\u91cf\u4ef7\u5355\u3010" + countPrice.getApplyNo() + "\u3011\u4ef7\u683c\u4e3a\u7a7a");
                ThrExceptionUtils.thrQryRspEmptyExce("\u91cf\u4ef7\u5355\u3010" + countPrice.getApplyNo() + "\u3011\u4ef7\u683c\u4e3a\u7a7a");
            }
            purchaseRequireDetailBO.setProjectCategory("01");
            if ("01".equals(countPrice.getContractTypeCode())) {
                purchaseRequireDetailBO.setProjectCategory("00");
                if (null == countPrice.getRemainingCount()) {
                    logger.error("\u91cf\u4ef7\u5355\u3010" + countPrice.getApplyNo() + "\u3011\u6570\u91cf\u4e3a\u7a7a");
                    ThrExceptionUtils.thrQryRspEmptyExce("\u91cf\u4ef7\u5355\u3010" + countPrice.getApplyNo() + "\u3011\u6570\u91cf\u4e3a\u7a7a");
                }
                if (null != countPrice.getRemainingCount() && purchaseRequireDetailBO.getCount() > countPrice.getRemainingCount()) {
                    logger.error("\u5546\u54c1\u3010" + purchaseRequireDetailBO.getSkuNo() + "\u3011\u6570\u91cf\u4e0d\u8db3");
                    throw new ResourceException("0012", "\u5546\u54c1\u3010" + purchaseRequireDetailBO.getSkuNo() + "\u3011\u6570\u91cf\u4e0d\u8db3");
                }
            }
            if (null == (logRsp = GetCountPriceUtils.getCountPriceLog(countLogMap, this.countPriceDetailBusiService, purchaseRequireDetailBO.getSkuNo(), purchaseRequireDetailBO.getSupplierId(), countPrice.getApplyNo(), purchaseRequireDetailBO.getFactory())) || !"02".equals(logRsp.getStatus())) {
                logger.error("\u5546\u54c1\u3010" + purchaseRequireDetailBO.getSkuNo() + "\u3011\u7684\u91cf\u4ef7\u5408\u540c\u672a\u540c\u6b65");
                throw new ResourceException("0010", "\u5546\u54c1\u3010" + purchaseRequireDetailBO.getSkuNo() + "\u3011\u7684\u91cf\u4ef7\u5408\u540c\u672a\u540c\u6b65");
            }
            purchaseRequireDetailBO.setPrice(countPrice.getPrice());
            purchaseRequireDetailBO.setAvailableCount(countPrice.getRemainingCount());
            purchaseRequireDetailBO.setContractType(countPrice.getContractTypeCode());
            this.modifyCountPrice(purchaseRequireDetailBO);
            PurchaseRequireBO purchaseRequireBO = map.get(purchaseRequireDetailBO.getReqNo());
            PurchaseOrderBO purchaseOrderBO = null;
            String key = purchaseRequireDetailBO.getSupplierId() + purchaseRequireDetailBO.getProvince();
            if (orderMap.containsKey(key)) {
                purchaseOrderBO = (PurchaseOrderBO)orderMap.get(purchaseRequireDetailBO.getSupplierId());
            } else {
                purchaseOrderBO = this.getPurchaseOrderBO(userName, operUser, spMap, countPrice, purchaseRequireBO, purchaseRequireDetailBO);
                orderMap.put(key, purchaseOrderBO);
            }
            List detailBOS = CollectionUtils.isNotEmpty((Collection)purchaseOrderBO.getPurchaseOrderDetailBOList()) ? purchaseOrderBO.getPurchaseOrderDetailBOList() : new ArrayList(1);
            String row = String.valueOf((detailBOS.size() + 1) * 10);
            PurchaseOrderDetailBO orderDetailBO = this.getOrderDetailBO(purchaseRequireDetailBO, purchaseRequireBO, purchaseOrderBO, row);
            detailBOS.add(orderDetailBO);
            purchaseOrderBO.setPurchaseOrderDetailBOList(detailBOS);
            purchaseRequireDetailBO.setStatus("02");
            purchaseRequireDetailBO.setPurchaseOrderNo(purchaseOrderBO.getPurchaseOrderNo());
            purchaseRequireDetailBOS.add(purchaseRequireDetailBO);
        }
        for (Map.Entry entry : orderMap.entrySet()) {
            purchaseOrderBOS.add((PurchaseOrderBO)entry.getValue());
        }
        try {
            this.purchaseOrderAtomService.saveOrderinfoByBatch(purchaseOrderBOS);
        }
        catch (Exception e) {
            logger.error("\u751f\u6210\u91c7\u8d2d\u8ba2\u5355\u5931\u8d25\uff1a" + e.getMessage());
            ThrExceptionUtils.thrInsExce("\u751f\u6210\u91c7\u8d2d\u8ba2\u5355\u5931\u8d25");
        }
        try {
            this.purchaseRequireAtomService.modifyRequireDetailByBatch(purchaseRequireDetailBOS);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u9700\u6c42\u660e\u7ec6\u5931\u8d25");
        }
        return purchaseOrderBOS;
    }

    private void modifyCountPrice(PurchaseRequireDetailBO detailBO) {
        UseCountUpdateBusiReqBO useCountUpdateBusiReqBO = new UseCountUpdateBusiReqBO();
        useCountUpdateBusiReqBO.setQueryTime(new Date());
        useCountUpdateBusiReqBO.setSkuNo(detailBO.getSkuNo());
        useCountUpdateBusiReqBO.setSupplierId(detailBO.getSupplierId());
        useCountUpdateBusiReqBO.setUsedCount(detailBO.getCount());
        UseCountUpdateBusiRspBO useCountUpdateBusiRspBO = null;
        try {
            useCountUpdateBusiRspBO = this.countPriceDetailBusiService.usedCountUpdate(useCountUpdateBusiReqBO);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u91cf\u4ef7\u660e\u7ec6\u5f02\u5e38\uff1a" + e.getMessage());
            ThrExceptionUtils.thrCallExec("\u4fee\u6539\u91cf\u4ef7\u660e\u7ec6\u5f02\u5e38");
        }
        if (!"0000".equals(useCountUpdateBusiRspBO.getRespCode())) {
            logger.error("\u66f4\u65b0\u91cf\u4ef7\u660e\u7ec6\u5931\u8d25\uff1a" + useCountUpdateBusiRspBO.getRespDesc());
            ThrExceptionUtils.thrUpdExce("\u66f4\u65b0\u91cf\u4ef7\u660e\u7ec6\u5931\u8d25\uff1a" + useCountUpdateBusiRspBO.getRespDesc());
        }
    }

    private PurchaseOrderDetailBO getOrderDetailBO(PurchaseRequireDetailBO detailBO, PurchaseRequireBO purchaseRequireBO, PurchaseOrderBO purchaseOrderBO, String row) {
        if (StringUtils.isBlank((CharSequence)detailBO.getMeterielCode()) || "01".equals(detailBO.getContractType()) && (null == detailBO.getPrice() || null == detailBO.getAvailableCount() || detailBO.getCount() > detailBO.getAvailableCount())) {
            logger.error("\u9700\u6c42\u660e\u7ec6\u3010" + detailBO.getDetailId() + "\u3011\u6570\u636e\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u6570\u636e");
            ThrExceptionUtils.thrEmptyExce("\u9700\u6c42\u660e\u7ec6\u3010" + detailBO.getDetailId() + "\u3011\u6570\u636e\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u6570\u636e");
        }
        PurchaseOrderDetailBO orderDetailBO = new PurchaseOrderDetailBO();
        orderDetailBO.setMeterielCode(detailBO.getMeterielCode());
        orderDetailBO.setConfirmControlCode("0001");
        orderDetailBO.setContent(detailBO.getContent());
        orderDetailBO.setCount(detailBO.getCount());
        orderDetailBO.setCrtTime(new Date());
        orderDetailBO.setDeliveryCompletedFlag(null);
        orderDetailBO.setFactory(detailBO.getFactory());
        orderDetailBO.setWarehouse(detailBO.getWarehouse());
        orderDetailBO.setDeliveryDate(detailBO.getDeliveryDate());
        orderDetailBO.setFlag("X");
        orderDetailBO.setFreeFlag(detailBO.getFreeFlag());
        orderDetailBO.setLastUpdDate(TkDateUtils.formatDate((Date)new Date(), (String)"yyyyMMdd"));
        orderDetailBO.setNeedFeedback("X");
        orderDetailBO.setNo(purchaseRequireBO.getNo());
        orderDetailBO.setPrice(detailBO.getPrice());
        orderDetailBO.setPriceUnit("1");
        orderDetailBO.setProjectCategory(detailBO.getProjectCategory());
        orderDetailBO.setProvince(detailBO.getProvince());
        orderDetailBO.setRequirePeopleName(null);
        orderDetailBO.setRequireTrackNo(null);
        orderDetailBO.setReturnFlag(detailBO.getReturnFlag());
        orderDetailBO.setRow(row);
        orderDetailBO.setSkuNo(detailBO.getSkuNo());
        orderDetailBO.setSupplierId(purchaseOrderBO.getSupplierId());
        orderDetailBO.setSupplierNo(purchaseOrderBO.getSupplierNo());
        orderDetailBO.setTaxCode(detailBO.getTaxCode());
        orderDetailBO.setUnitName(detailBO.getUnitName());
        if (StringUtils.isBlank((CharSequence)detailBO.getUnitName())) {
            orderDetailBO.setUnitName("1");
        }
        return orderDetailBO;
    }

    private PurchaseOrderBO getPurchaseOrderBO(String userName, String operUser, Map<Long, String> spMap, CountPriceDetailQueryInfoBO countPrice, PurchaseRequireBO purchaseRequireBO, PurchaseRequireDetailBO detailBO) {
        PurchaseOrderBO purchaseOrderBO = new PurchaseOrderBO();
        purchaseOrderBO.setBuyingFlag(purchaseRequireBO.getBuyingFlag());
        purchaseOrderBO.setOperUser(operUser);
        purchaseOrderBO.setOperUserName(userName);
        purchaseOrderBO.setCollectiveNumber(null);
        purchaseOrderBO.setCrtTime(new Date());
        purchaseOrderBO.setCurrencyCode(countPrice.getCurrencyCode());
        purchaseOrderBO.setDealOrgNo("601");
        purchaseOrderBO.setInternationalTradingTerms(null);
        purchaseOrderBO.setNo(purchaseRequireBO.getNo());
        purchaseOrderBO.setPayConditionCode(countPrice.getPayConditionCode());
        purchaseOrderBO.setProvince(detailBO.getProvince());
        purchaseOrderBO.setCompanyCode(null);
        purchaseOrderBO.setRequireOrgNo(null);
        purchaseOrderBO.setStatus("00");
        purchaseOrderBO.setSupplierId(detailBO.getSupplierId());
        if (spMap.containsKey(detailBO.getSupplierId())) {
            purchaseOrderBO.setSupplierNo(spMap.get(detailBO.getSupplierId()));
        } else {
            SSupplierBusiReqBO sSupplierBusiReqBO = new SSupplierBusiReqBO();
            sSupplierBusiReqBO.setSupplierId(detailBO.getSupplierId());
            SSupplierBusiRspBO supplierBusiRspBO = null;
            try {
                supplierBusiRspBO = this.querySupplierBusiService.selectSupplierDetail(sSupplierBusiReqBO);
            }
            catch (Exception e) {
                logger.error("\u67e5\u8be2\u4f9b\u5e94\u5546\u4fe1\u606f\u5f02\u5e38\uff1a" + e.getMessage());
                ThrExceptionUtils.thrCallExec("\u67e5\u8be2\u4f9b\u5e94\u5546\u4fe1\u606f\u5f02\u5e38");
            }
            if (null == supplierBusiRspBO || !"0000".equals(supplierBusiRspBO.getRespCode())) {
                logger.error("\u67e5\u8be2\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25");
                ThrExceptionUtils.thrQryExce("\u67e5\u8be2\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25");
            }
            if (StringUtils.isBlank((CharSequence)supplierBusiRspBO.getSupplierNo())) {
                logger.error("\u672a\u67e5\u8be2\u5230\u4f9b\u5e94\u5546\u3010" + supplierBusiRspBO.getSupplierId() + "\u3011\u7684\u7f16\u7801");
                ThrExceptionUtils.thrQryRspEmptyExce("\u672a\u67e5\u8be2\u5230\u4f9b\u5e94\u5546\u3010" + supplierBusiRspBO.getSupplierId() + "\u3011\u7684\u7f16\u7801");
            }
            spMap.put(detailBO.getSupplierId(), supplierBusiRspBO.getSupplierNo());
            purchaseOrderBO.setSupplierNo(supplierBusiRspBO.getSupplierNo());
        }
        Long orderCode = null;
        try {
            orderCode = this.prOrderSequence.nextId();
        }
        catch (SQLException e) {
            logger.error("\u83b7\u53d6\u8ba2\u5355\u53f7\u5e8f\u5217\u5931\u8d25\uff1a" + e.getMessage());
            ThrExceptionUtils.thrQryExce("\u83b7\u53d6\u8ba2\u5355\u53f7\u5e8f\u5217\u5931\u8d25");
        }
        String orderCodeStr = "PO" + String.valueOf(orderCode);
        purchaseOrderBO.setPurchaseOrderNo(orderCodeStr);
        return purchaseOrderBO;
    }

    public RspBaseBO invalidPurchaseDetail(PurchaseAppliReqBO reqBO) {
        String checkRsp = PubCheckParamsUtils.checkAuth(reqBO.getmRole(), reqBO.getmLoginName());
        if (StringUtils.isNotBlank((CharSequence)checkRsp)) {
            return new RspPageBaseBO("0009", checkRsp);
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getDetailIdList())) {
            logger.error("\u9700\u6c42\u660e\u7ec6ID\u4e3a\u7a7a");
            return new RspBaseBO("0001", "\u9700\u6c42\u660e\u7ec6ID\u4e3a\u7a7a");
        }
        HashSet<Long> detailIdSet = new HashSet<Long>(reqBO.getDetailIdList());
        List<PurchaseRequireDetailBO> detailBOS = this.purchaseRequireAtomService.listDetailByIds(detailIdSet);
        if (CollectionUtils.isEmpty(detailBOS)) {
            logger.error("\u672a\u67e5\u8be2\u5230\u9700\u6c42\u660e\u7ec6\u96c6\u5408");
            ThrExceptionUtils.thrQryRspEmptyExce("\u672a\u67e5\u8be2\u5230\u9700\u6c42\u660e\u7ec6\u96c6\u5408");
        }
        for (PurchaseRequireDetailBO detailBO : detailBOS) {
            if (!"03".equals(detailBO.getStatus())) {
                String statusStr = this.purchaseQryEscapeAtomService.getCodeTitle("PURCHASE_REQ_DETAIL_STATUS_TYPE", detailBO.getStatus());
                if (StringUtils.isBlank((CharSequence)statusStr)) {
                    statusStr = "\u672a\u5b9a\u4e49";
                }
                logger.error("\u5f53\u524d\u660e\u7ec6\u3010" + detailBO.getDetailId() + "\u3011\u72b6\u6001\u3010" + statusStr + "\u3011\u4e0d\u80fd\u4f5c\u5e9f");
                ThrExceptionUtils.thrStatusWrongExce("\u5f53\u524d\u660e\u7ec6\u3010" + detailBO.getDetailId() + "\u3011\u72b6\u6001\u3010" + statusStr + "\u3011\u4e0d\u80fd\u4f5c\u5e9f");
            }
            detailBO.setStatus("04");
            detailBO.setLastUpdDate(new Date());
        }
        this.purchaseRequireAtomService.modifyRequireDetailByBatch(detailBOS);
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }
}

