/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.purchase.busi.impl;

import com.tydic.newretail.purchase.atom.PurchaseRequireAtomService;
import com.tydic.newretail.purchase.atom.QrySpCommInfoAtomService;
import com.tydic.newretail.purchase.bo.PurchaseReqTaskReqBO;
import com.tydic.newretail.purchase.bo.PurchaseRequireDetailBO;
import com.tydic.newretail.purchase.busi.CountPriceDetailBusiService;
import com.tydic.newretail.purchase.busi.bo.ContractLogRspBO;
import com.tydic.newretail.purchase.busi.bo.CountPriceDetailQueryInfoBO;
import com.tydic.newretail.purchase.dao.PurchaseRequireDetailDao;
import com.tydic.newretail.purchase.dao.po.PurchaseRequireDetailPO;
import com.tydic.newretail.purchase.service.busi.PurchaseReqTaskService;
import com.tydic.newretail.purchase.util.GetCountPriceUtils;
import com.tydic.newretail.spcomm.sku.bo.SupplierSkuDetailBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseReqTaskServiceImpl
implements PurchaseReqTaskService {
    private static final Logger logger = LoggerFactory.getLogger(PurchaseReqTaskServiceImpl.class);
    @Autowired
    private PurchaseRequireDetailDao purchaseRequireDetailDao;
    @Autowired
    private QrySpCommInfoAtomService qrySpCommInfoAtomService;
    @Autowired
    private PurchaseRequireAtomService purchaseRequireAtomService;
    @Autowired
    private CountPriceDetailBusiService countPriceDetailBusiService;

    public void refreshMaterialCode(PurchaseReqTaskReqBO reqBO) {
        List<PurchaseRequireDetailPO> detailPOS = this.listDetails(reqBO, true);
        if (CollectionUtils.isEmpty(detailPOS)) {
            logger.debug("\u5f53\u524d\u672a\u67e5\u8be2\u5230\u7b49\u5f85\u7269\u6599\u7684\u9700\u6c42\u660e\u7ec6");
            return;
        }
        HashMap<String, SupplierSkuDetailBO> skuMap = new HashMap<String, SupplierSkuDetailBO>(detailPOS.size());
        ArrayList<PurchaseRequireDetailBO> modifyBOs = new ArrayList<PurchaseRequireDetailBO>(detailPOS.size());
        for (PurchaseRequireDetailPO detailPO : detailPOS) {
            PurchaseRequireDetailBO bo = detailPO.toPurchaseRequireDetailBO();
            bo.setLastUpdDate(new Date());
            SupplierSkuDetailBO skuDetailBO = null;
            try {
                skuDetailBO = this.qrySpCommInfoAtomService.getSkuDetail(null, detailPO.getSupplierId(), detailPO.getSkuNo(), skuMap);
            }
            catch (Exception e) {
                logger.error("\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
                continue;
            }
            if (null == skuDetailBO || !StringUtils.isNotBlank((CharSequence)skuDetailBO.getMeterielCode())) continue;
            bo.setMeterielCode(skuDetailBO.getMeterielCode());
            if (StringUtils.isNotBlank((CharSequence)skuDetailBO.getPrice())) {
                bo.setPrice(Long.valueOf(skuDetailBO.getPrice()));
            }
            bo.setAvailableCount(skuDetailBO.getRemainingCount());
            bo.setTaxCode(skuDetailBO.getSaleBuyTaxCode());
            bo.setUnitName(skuDetailBO.getSkuUnit());
            this.checkStatus(bo, detailPO.getSyncStatus());
            modifyBOs.add(bo);
        }
        this.modifyDetail(modifyBOs);
        logger.debug("\u5237\u65b0\u7269\u6599\u7f16\u7801\u5b8c\u6210\uff0c\u672c\u6b21\u66f4\u65b0\u6761\u6570\uff1a{}", (Object)modifyBOs.size());
    }

    public void refreshCountAndPrice(PurchaseReqTaskReqBO reqBO) {
        List<PurchaseRequireDetailPO> detailPOS = this.listDetails(reqBO, false);
        if (CollectionUtils.isEmpty(detailPOS)) {
            logger.debug("\u5f53\u524d\u672a\u67e5\u8be2\u5230\u7b49\u5f85\u91cf\u4ef7\u7684\u9700\u6c42\u660e\u7ec6");
            return;
        }
        ArrayList<PurchaseRequireDetailBO> modifyBOs = new ArrayList<PurchaseRequireDetailBO>(detailPOS.size());
        HashMap<String, CountPriceDetailQueryInfoBO> countPriceMap = new HashMap<String, CountPriceDetailQueryInfoBO>(detailPOS.size());
        HashMap<String, ContractLogRspBO> countLogMap = new HashMap<String, ContractLogRspBO>(detailPOS.size());
        for (PurchaseRequireDetailPO detailPO : detailPOS) {
            boolean hasCountPrice;
            PurchaseRequireDetailBO bo = detailPO.toPurchaseRequireDetailBO();
            bo.setLastUpdDate(new Date());
            CountPriceDetailQueryInfoBO countPrice = null;
            try {
                countPrice = GetCountPriceUtils.getCounPrice(this.countPriceDetailBusiService, detailPO.getSkuNo(), detailPO.getSupplierId(), new Date(), countPriceMap);
            }
            catch (Exception e) {
                logger.error("\u67e5\u8be2\u91cf\u4ef7\u5931\u8d25\uff1a" + e.getMessage());
            }
            if (null == countPrice) continue;
            ContractLogRspBO countLogsRsp = null;
            try {
                countLogsRsp = GetCountPriceUtils.getCountPriceLog(countLogMap, this.countPriceDetailBusiService, detailPO.getSkuNo(), detailPO.getSupplierId(), countPrice.getApplyNo(), detailPO.getFactory());
            }
            catch (Exception e) {
                logger.error("\u67e5\u8be2\u5408\u540c\u540c\u6b65\u8bb0\u5f55\u5931\u8d25\uff1a" + e.getMessage());
            }
            boolean bl = hasCountPrice = null != countPrice.getPrice() && null != countPrice.getRemainingCount();
            if (!hasCountPrice && null == countLogsRsp) continue;
            bo.setAvailableCount(countPrice.getRemainingCount());
            bo.setTaxCode(countPrice.getSaleBuyTaxCode());
            bo.setContractType(countPrice.getContractTypeCode());
            bo.setPrice(countPrice.getPrice());
            bo.setSupplierNo(countPrice.getSupplierNo());
            String status = detailPO.getSyncStatus();
            if (null != countLogsRsp) {
                bo.setSyncStatus(countLogsRsp.getStatus());
                status = countLogsRsp.getStatus();
            }
            this.checkStatus(bo, status);
            modifyBOs.add(bo);
        }
        this.modifyDetail(modifyBOs);
        logger.debug("\u5237\u65b0\u91cf\u4ef7\u5b8c\u6210\uff0c\u672c\u6b21\u66f4\u65b0\u6761\u6570\uff1a{}", (Object)modifyBOs.size());
    }

    private void checkStatus(PurchaseRequireDetailBO bo, String status) {
        boolean syncFlag;
        boolean hasCountPrice = null != bo.getPrice() && null != bo.getCount() && null != bo.getAvailableCount() && bo.getCount() <= bo.getAvailableCount();
        boolean bl = syncFlag = StringUtils.isNotBlank((CharSequence)bo.getMeterielCode()) && (hasCountPrice || "02".equals(bo.getContractType()));
        if (syncFlag && "02".equals(status)) {
            bo.setStatus("01");
        }
    }

    private List<PurchaseRequireDetailPO> listDetails(PurchaseReqTaskReqBO reqBO, boolean materialCodeFlag) {
        List<PurchaseRequireDetailPO> list = null;
        PurchaseRequireDetailPO record = new PurchaseRequireDetailPO();
        if (null != reqBO) {
            record.setSkuNo(reqBO.getSkuNo());
            record.setSupplierId(reqBO.getSupplierId());
        }
        try {
            if (materialCodeFlag) {
                List<List<String>> skuNos = null;
                if (CollectionUtils.isNotEmpty((Collection)reqBO.getSkuNoList())) {
                    skuNos = PurchaseReqTaskServiceImpl.splitList(reqBO.getSkuNoList(), 1000);
                }
                list = this.purchaseRequireDetailDao.selectEmptyMaterialCode(record, skuNos);
                return list;
            }
            ArrayList<PurchaseRequireDetailPO> pos = null;
            if (CollectionUtils.isNotEmpty((Collection)reqBO.getDetailBOS())) {
                pos = new ArrayList<PurchaseRequireDetailPO>(reqBO.getDetailBOS().size());
                for (PurchaseRequireDetailBO bo : reqBO.getDetailBOS()) {
                    pos.add(PurchaseRequireDetailPO.toPurchaseRequireDetailPO(bo));
                }
            }
            list = this.purchaseRequireDetailDao.selectEmptyCountPrice(record, pos);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5f85\u5904\u7406\u660e\u7ec6\u96c6\u5408\u5931\u8d25\uff1a" + e.getMessage());
        }
        return list;
    }

    private void modifyDetail(List<PurchaseRequireDetailBO> modifyBOs) {
        if (CollectionUtils.isNotEmpty(modifyBOs)) {
            try {
                this.purchaseRequireAtomService.modifyRequireDetailByBatch(modifyBOs);
            }
            catch (Exception e) {
                logger.error("\u6279\u91cf\u66f4\u65b0\u9700\u6c42\u660e\u7ec6\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
    }

    public static List<List<String>> splitList(List<String> list, int len) {
        if (CollectionUtils.isEmpty(list) || len < 1) {
            return null;
        }
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        int size = list.size();
        int count = (size + len - 1) / len;
        for (int i = 0; i < count; ++i) {
            List<String> subList = list.subList(i * len, (i + 1) * len > size ? size : len * (i + 1));
            result.add(subList);
        }
        return result;
    }
}

