/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.purchase.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.newretail.purchase.atom.QrySpCommInfoAtomService;
import com.tydic.newretail.purchase.bo.PurchaseFactoryWarehouseBO;
import com.tydic.newretail.purchase.busi.QryContractLogService;
import com.tydic.newretail.purchase.busi.bo.ContractLogRspBO;
import com.tydic.newretail.purchase.busi.bo.QryContractLogReqBO;
import com.tydic.newretail.purchase.dao.ContractLogDao;
import com.tydic.newretail.purchase.dao.po.ContractLogPO;
import com.tydic.newretail.purchase.util.FactoryWarehouseUtils;
import com.tydic.newretail.spcomm.sku.bo.SupplierSkuDetailBO;
import com.tydic.newretail.toolkit.atom.QryEscapeAtomService;
import com.tydic.newretail.toolkit.bo.RspPageBaseBO;
import com.tydic.newretail.toolkit.util.TkDateUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QryContractLogServiceImpl
implements QryContractLogService {
    private static final Logger logger = LoggerFactory.getLogger(QryContractLogServiceImpl.class);
    @Autowired
    private ContractLogDao contractLogDao;
    @Autowired
    private QrySpCommInfoAtomService qrySpCommInfoAtomService;
    @Resource(name="purchaseQryEscapeAtomService")
    private QryEscapeAtomService qryEscapeAtomService;

    public RspPageBaseBO<ContractLogRspBO> listFailureLog(QryContractLogReqBO reqBO) {
        Page page = new Page(reqBO.getCurrent(), reqBO.getPageSize());
        ContractLogPO record = ContractLogPO.toContractLogPO(reqBO);
        List<ContractLogPO> pos = null;
        try {
            pos = this.contractLogDao.selectFailureInfoByPage((Page<ContractLogPO>)page, record);
        }
        catch (Exception e) {
            logger.error("\u5206\u9875\u67e5\u8be2\u540c\u6b65\u8bb0\u5f55\u5931\u8d25\uff1a" + e.getMessage());
            return new RspPageBaseBO("0003", "\u5206\u9875\u67e5\u8be2\u540c\u6b65\u8bb0\u5f55\u5931\u8d25");
        }
        ArrayList<ContractLogRspBO> rspList = null;
        HashMap<String, SupplierSkuDetailBO> skuMap = new HashMap<String, SupplierSkuDetailBO>(pos.size());
        if (CollectionUtils.isNotEmpty(pos)) {
            rspList = new ArrayList<ContractLogRspBO>(pos.size());
            for (ContractLogPO po : pos) {
                ContractLogRspBO bo = po.toContractLogRspBO();
                this.escapeLogInfo(bo, skuMap);
                rspList.add(bo);
            }
        }
        return new RspPageBaseBO("0000", "\u64cd\u4f5c\u6210\u529f", rspList, page.getTotalCount(), page.getTotalPages());
    }

    private void escapeLogInfo(ContractLogRspBO bo, Map<String, SupplierSkuDetailBO> skuMap) {
        SupplierSkuDetailBO skuDetailBO = null;
        try {
            skuDetailBO = this.qrySpCommInfoAtomService.getSkuDetail(null, bo.getSupplierId(), bo.getSkuNo(), skuMap);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
        }
        if (null != skuDetailBO) {
            bo.setSkuName(skuDetailBO.getSkuName());
        }
        PurchaseFactoryWarehouseBO factoryWarehouseBO = FactoryWarehouseUtils.getByFactoryNo(bo.getFactory());
        bo.setFactoryStr(factoryWarehouseBO.getFactoryName());
        if (StringUtils.isNotBlank((CharSequence)bo.getVoucherTypeCode())) {
            bo.setVoucherTypeCodeStr(this.qryEscapeAtomService.getCodeTitle("VOUCHER_TYPE_CODE", bo.getVoucherTypeCode()));
        }
        bo.setStartTimeStr(TkDateUtils.formatDate((Date)bo.getStartTime(), (String)"yyyy-MM-dd"));
        bo.setEndTimeStr(TkDateUtils.formatDate((Date)bo.getEndTime(), (String)"yyyy-MM-dd"));
        bo.setCurrencyCodeStr(this.qryEscapeAtomService.getCodeTitle("PURCHASE_CURRENCY_CODE", bo.getCurrencyCode()));
        bo.setSaleBuyTaxCodeStr(this.qryEscapeAtomService.getCodeTitle("PURCHASE_SALE_BUY_TAX_CODE", bo.getSaleBuyTaxCode()));
        bo.setSyncTimeStr(TkDateUtils.formatDate((Date)bo.getSyncTime(), (String)"yyyy-MM-dd"));
    }
}

