/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.purchase.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.newretail.bo.UserInfoBaseBO;
import com.tydic.newretail.purchase.bo.PurchaseFactoryWarehouseBO;
import com.tydic.newretail.purchase.bo.PurchaseProvinceBO;
import com.tydic.newretail.purchase.bo.QryFactoryReqBO;
import com.tydic.newretail.purchase.bo.QryFactoryWarehouseReqBO;
import com.tydic.newretail.purchase.dao.PurchaseFactoryDao;
import com.tydic.newretail.purchase.dao.po.PurchaseFactoryPO;
import com.tydic.newretail.purchase.dao.po.PurchaseFactoryWarehousePO;
import com.tydic.newretail.purchase.service.busi.QryEscapeBusiService;
import com.tydic.newretail.purchase.util.FactoryWarehouseUtils;
import com.tydic.newretail.purchase.util.PubCheckParamsUtils;
import com.tydic.newretail.purchase.util.PurchaseProvinceUtils;
import com.tydic.newretail.toolkit.atom.QryEscapeAtomService;
import com.tydic.newretail.toolkit.bo.QryEscapeBO;
import com.tydic.newretail.toolkit.bo.RspBatchBaseBO;
import com.tydic.newretail.toolkit.util.TkPropertiesUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QryEscapeBusiServiceImpl
implements QryEscapeBusiService {
    private static final Logger logger = LoggerFactory.getLogger(QryEscapeBusiServiceImpl.class);
    @Autowired
    private PurchaseFactoryDao purchaseFactoryDao;
    @Autowired
    private QryEscapeAtomService purchaseQryEscapeAtomService;

    public RspBatchBaseBO<QryEscapeBO> listSubmitType(UserInfoBaseBO reqBO) {
        List submitType;
        try {
            submitType = this.purchaseQryEscapeAtomService.listEscapeByParentCode("PURCHASE_SUBMIT_TYPE");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u63d0\u4ea4\u4eba\u7c7b\u578b\u5931\u8d25:" + e.getMessage());
            return new RspBatchBaseBO("0003", "\u67e5\u8be2\u63d0\u4ea4\u4eba\u7c7b\u578b\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty((Collection)submitType)) {
            return new RspBatchBaseBO("0002", "\u672a\u914d\u7f6e\u63d0\u4ea4\u4eba\u7c7b\u578b\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        return new RspBatchBaseBO("0000", "\u64cd\u4f5c\u6210\u529f", submitType);
    }

    public RspBatchBaseBO<QryEscapeBO> listProvinceType(UserInfoBaseBO reqBO) {
        String checkRsp = PubCheckParamsUtils.checkAuth(reqBO.getmRole(), reqBO.getmLoginName());
        if (StringUtils.isNotBlank((CharSequence)checkRsp)) {
            return new RspBatchBaseBO("0009", checkRsp);
        }
        boolean buyingFlag = reqBO.getmRole().contains(TkPropertiesUtils.getProperty((String)"role.type.buying"));
        if (buyingFlag) {
            return this.listAllProvinceType();
        }
        ArrayList<QryEscapeBO> province = new ArrayList<QryEscapeBO>(1);
        if (StringUtils.isBlank((CharSequence)reqBO.getmProvince())) {
            return new RspBatchBaseBO("0009", "\u672a\u83b7\u53d6\u7528\u6237\u7701\u4efd");
        }
        QryEscapeBO escapeBO = new QryEscapeBO();
        escapeBO.setEscapeCode(reqBO.getmProvince());
        escapeBO.setParentCode("PURCHASE_PROVINCE_CODE_DIC");
        escapeBO.setEscapeValue(PurchaseProvinceUtils.getPorvinceName(reqBO.getmProvince()));
        province.add(escapeBO);
        return new RspBatchBaseBO("0000", "\u64cd\u4f5c\u6210\u529f", province);
    }

    public RspBatchBaseBO<QryEscapeBO> listAllProvinceType() {
        ArrayList<QryEscapeBO> province = null;
        List<PurchaseProvinceBO> provinceBOS = null;
        try {
            provinceBOS = PurchaseProvinceUtils.listProvince();
        }
        catch (ResourceException e) {
            return new RspBatchBaseBO(e.getMsgCode(), e.getMessage());
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7701\u4efd\u4fe1\u606f\u5f02\u5e38\uff1a" + e.getMessage());
            return new RspBatchBaseBO("9999", "\u67e5\u8be2\u7701\u4efd\u4fe1\u606f\u5f02\u5e38");
        }
        if (CollectionUtils.isNotEmpty(provinceBOS)) {
            province = new ArrayList<QryEscapeBO>(provinceBOS.size());
            for (PurchaseProvinceBO bo : provinceBOS) {
                QryEscapeBO qryEscapeBO = new QryEscapeBO();
                qryEscapeBO.setParentCode("PURCHASE_PROVINCE_CODE_DIC");
                qryEscapeBO.setEscapeCode(bo.getProvince());
                qryEscapeBO.setEscapeValue(bo.getProvinceName());
                province.add(qryEscapeBO);
            }
        }
        if (CollectionUtils.isEmpty(province)) {
            return new RspBatchBaseBO("0002", "\u672a\u914d\u7f6e\u7701\u4efd\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        return new RspBatchBaseBO("0000", "\u64cd\u4f5c\u6210\u529f", province);
    }

    public RspBatchBaseBO<QryEscapeBO> listOrderStatusType() {
        return this.listEscapePub("PURCHASE_ORDER_STATUS_TYPE", "\u8ba2\u5355\u72b6\u6001\u7c7b\u578b");
    }

    public RspBatchBaseBO<QryEscapeBO> listcheckStatusType() {
        return this.listEscapePub("PURCHASE_CHECK_STATUS_TYPE", "\u5ba1\u6838\u72b6\u6001\u7c7b\u578b");
    }

    public RspBatchBaseBO<QryEscapeBO> listItemType() {
        return this.listEscapePub("PURCHASE_ITEM_TYPE", "\u9879\u76ee\u7c7b\u522b");
    }

    private RspBatchBaseBO<QryEscapeBO> listEscapePub(String parentCode, String desc) {
        List list = null;
        try {
            list = this.purchaseQryEscapeAtomService.listEscapeByParentCode(parentCode);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7801\u8868\u5931\u8d25\uff1a" + e.getMessage());
        }
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new RspBatchBaseBO("0002", "\u672a\u914d\u7f6e" + desc + "\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        return new RspBatchBaseBO("0000", "\u64cd\u4f5c\u6210\u529f", list);
    }

    public RspBatchBaseBO<PurchaseFactoryWarehouseBO> listFactory(QryFactoryWarehouseReqBO reqBO) {
        RspBatchBaseBO checkRsp = this.checkParams((UserInfoBaseBO)reqBO);
        if (!"0000".equals(checkRsp.getRespCode())) {
            return checkRsp;
        }
        String province = null;
        if (reqBO.getmRole().contains(TkPropertiesUtils.getProperty((String)"role.type.province"))) {
            province = reqBO.getmProvince();
        } else if (StringUtils.isNotBlank((CharSequence)reqBO.getProvince())) {
            province = reqBO.getProvince();
        }
        List<PurchaseFactoryWarehouseBO> rspList = null;
        try {
            rspList = FactoryWarehouseUtils.listFactoryWarehouseByProvince(province);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5de5\u5382\u4fe1\u606f\u5f02\u5e38\uff1a" + e.getMessage());
            return new RspBatchBaseBO("9999", "\u67e5\u8be2\u5de5\u5382\u4fe1\u606f\u5f02\u5e38");
        }
        return new RspBatchBaseBO("0000", "\u64cd\u4f5c\u6210\u529f", rspList);
    }

    public JSONObject listAllFactory(QryFactoryWarehouseReqBO reqBO) {
        JSONObject rspJson = new JSONObject();
        RspBatchBaseBO checkRsp = this.checkParams((UserInfoBaseBO)reqBO);
        if (!"0000".equals(checkRsp.getRespCode())) {
            rspJson.put("respCode", (Object)checkRsp.getRespCode());
            rspJson.put("respDesc", (Object)checkRsp.getRespDesc());
            return rspJson;
        }
        RspBatchBaseBO<QryEscapeBO> provinceListRsp = this.listProvinceType((UserInfoBaseBO)reqBO);
        if (!"0000".equals(provinceListRsp.getRespCode())) {
            rspJson.put("respCode", (Object)provinceListRsp.getRespCode());
            rspJson.put("respDesc", (Object)provinceListRsp.getRespDesc());
            return rspJson;
        }
        JSONObject data = new JSONObject();
        for (QryEscapeBO bo : provinceListRsp.getRows()) {
            String provinceCode = bo.getEscapeCode();
            reqBO.setProvince(provinceCode);
            RspBatchBaseBO<PurchaseFactoryWarehouseBO> factorys = this.listFactory(reqBO);
            if (!CollectionUtils.isNotEmpty((Collection)factorys.getRows())) continue;
            data.put(provinceCode, (Object)factorys.getRows());
        }
        rspJson.put("respCode", (Object)"0000");
        rspJson.put("respDesc", (Object)"\u64cd\u4f5c\u6210\u529f");
        rspJson.put("data", (Object)data);
        return rspJson;
    }

    public RspBatchBaseBO<PurchaseFactoryWarehouseBO> listFactoryByCondition(QryFactoryReqBO reqBO) {
        RspBatchBaseBO checkRsp = this.checkParams((UserInfoBaseBO)reqBO);
        if (!"0000".equals(checkRsp.getRespCode())) {
            return checkRsp;
        }
        if (reqBO.getmRole().contains(TkPropertiesUtils.getProperty((String)"role.type.province")) && StringUtils.isBlank((CharSequence)reqBO.getmProvince())) {
            logger.error("\u7701\u4efd\u4e3a\u7a7a");
            return new RspBatchBaseBO("0001", "\u7701\u4efd\u4e3a\u7a7a");
        }
        PurchaseFactoryPO record = new PurchaseFactoryPO();
        record.setProvince(reqBO.getmProvince());
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCondition())) {
            record.setCondition(reqBO.getCondition());
        }
        List<PurchaseFactoryWarehousePO> factoryWarehousePOS = null;
        try {
            factoryWarehousePOS = this.purchaseFactoryDao.selectAll(record);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5de5\u5382\u5e93\u5b58\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            return new RspBatchBaseBO("0003", "\u67e5\u8be2\u5de5\u5382\u5e93\u5b58\u4fe1\u606f\u5931\u8d25");
        }
        ArrayList<PurchaseFactoryWarehouseBO> rspList = null;
        if (CollectionUtils.isNotEmpty(factoryWarehousePOS)) {
            rspList = new ArrayList<PurchaseFactoryWarehouseBO>(factoryWarehousePOS.size());
            for (PurchaseFactoryWarehousePO po : factoryWarehousePOS) {
                PurchaseFactoryWarehouseBO bo = po.toPurchaseFactoryWarehouseBO();
                if (StringUtils.isNotBlank((CharSequence)bo.getProvince())) {
                    bo.setProvinceStr(PurchaseProvinceUtils.getPorvinceName(bo.getProvince()));
                }
                rspList.add(bo);
            }
        }
        return new RspBatchBaseBO("0000", "\u64cd\u4f5c\u6210\u529f", rspList);
    }

    public void refreshByParentCode(QryEscapeBO reqBO) {
        if (StringUtils.isBlank((CharSequence)reqBO.getParentCode())) {
            return;
        }
        try {
            this.purchaseQryEscapeAtomService.refresh(reqBO.getParentCode());
        }
        catch (Exception e) {
            logger.error("\u91cd\u65b0\u52a0\u8f7d\u7f13\u5b58\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public void refreshFactory() {
        FactoryWarehouseUtils.refresh();
        PurchaseProvinceUtils.refresh();
    }

    private RspBatchBaseBO checkParams(UserInfoBaseBO reqBO) {
        String checkAuthRsp = PubCheckParamsUtils.checkAuth(reqBO.getmRole(), reqBO.getmLoginName());
        if (StringUtils.isNotBlank((CharSequence)checkAuthRsp)) {
            return new RspBatchBaseBO("0009", checkAuthRsp);
        }
        if (reqBO.getmRole().contains(TkPropertiesUtils.getProperty((String)"role.type.province")) && StringUtils.isBlank((CharSequence)reqBO.getmProvince())) {
            logger.error("\u7701\u5206\u4e3a\u7a7a");
            return new RspBatchBaseBO("0001", "\u7701\u5206\u4e3a\u7a7a");
        }
        return new RspBatchBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }
}

