/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.purchase.busi.impl;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Page;
import com.tydic.newretail.purchase.atom.PurchaseOrderAtomService;
import com.tydic.newretail.purchase.atom.QrySpCommInfoAtomService;
import com.tydic.newretail.purchase.bo.PurchaseFactoryWarehouseBO;
import com.tydic.newretail.purchase.bo.PurchaseOrdAndDetailBO;
import com.tydic.newretail.purchase.bo.QryPurchaseOrdReqBO;
import com.tydic.newretail.purchase.bo.QryPurchaseOrdRspBO;
import com.tydic.newretail.purchase.bo.QryPurchaseOrderDetailBO;
import com.tydic.newretail.purchase.dao.PurchaseOrderDao;
import com.tydic.newretail.purchase.dao.PurchaseOrderDetailDao;
import com.tydic.newretail.purchase.dao.po.PurchaseOrderPO;
import com.tydic.newretail.purchase.service.busi.QryPurchaseOrdBusiService;
import com.tydic.newretail.purchase.util.FactoryWarehouseUtils;
import com.tydic.newretail.purchase.util.PubCheckParamsUtils;
import com.tydic.newretail.purchase.util.PurchaseProvinceUtils;
import com.tydic.newretail.spcomm.sku.bo.SupplierSkuDetailBO;
import com.tydic.newretail.toolkit.atom.QryEscapeAtomService;
import com.tydic.newretail.toolkit.bo.RspBatchBaseBO;
import com.tydic.newretail.toolkit.bo.RspPageBaseBO;
import com.tydic.newretail.toolkit.util.TkDateUtils;
import com.tydic.newretail.toolkit.util.TkPropertiesUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QryPurchaseOrdBusiServiceImpl
implements QryPurchaseOrdBusiService {
    private static final Logger logger = LoggerFactory.getLogger(QryPurchaseOrdBusiServiceImpl.class);
    @Autowired
    private PurchaseOrderDao purchaseOrderDao;
    @Autowired
    private QryEscapeAtomService purchaseQryEscapeAtomService;
    @Autowired
    private PurchaseOrderAtomService purchaseOrderAtomService;
    @Resource
    private QrySpCommInfoAtomService qrySpCommInfoAtonService;
    @Autowired
    private PurchaseOrderDetailDao purchaseOrderDetailDao;

    public RspPageBaseBO<QryPurchaseOrdRspBO> listOrderByPage(QryPurchaseOrdReqBO reqBO) {
        String checkRsp = PubCheckParamsUtils.checkAuth(reqBO.getmRole(), reqBO.getmLoginName());
        if (StringUtils.isNotBlank((CharSequence)checkRsp)) {
            return new RspPageBaseBO("0009", checkRsp);
        }
        boolean provinceFlag = reqBO.getmRole().contains(TkPropertiesUtils.getProperty((String)"role.type.province"));
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        PurchaseOrderPO record = new PurchaseOrderPO();
        if (provinceFlag) {
            if (StringUtils.isBlank((CharSequence)reqBO.getmProvince())) {
                logger.error("\u7701\u4efd\u4e3a\u7a7a");
                return new RspPageBaseBO("0001", "\u7701\u4efd\u4e3a\u7a7a");
            }
            record.setProvince(reqBO.getmProvince());
        } else if (!"-1".equals(reqBO.getProvince())) {
            record.setProvince(reqBO.getProvince());
        }
        if (!"-1".equals(reqBO.getSubmitType())) {
            record.setBuyingFlag(reqBO.getSubmitType());
        }
        record.setOperUser(reqBO.getOperUser());
        record.setNo(reqBO.getReqNo());
        record.setPurchaseOrderNo(reqBO.getOrderNo());
        record.setStartTime(reqBO.getStartTime());
        record.setEndTime(reqBO.getEndTime());
        if (!"-1".equals(reqBO.getOrderStatus())) {
            record.setStatus(reqBO.getOrderStatus());
        }
        List<PurchaseOrderPO> pos = null;
        try {
            pos = this.purchaseOrderDao.selectByPage((Page<PurchaseOrderPO>)page, record);
        }
        catch (Exception e) {
            logger.error("\u5206\u9875\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u5931\u8d25\uff1a" + e.getMessage());
            return new RspPageBaseBO("0003", "\u5206\u9875\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u5931\u8d25");
        }
        ArrayList<QryPurchaseOrdRspBO> rspList = null;
        if (CollectionUtils.isNotEmpty(pos)) {
            rspList = new ArrayList<QryPurchaseOrdRspBO>(pos.size());
            for (PurchaseOrderPO po : pos) {
                QryPurchaseOrdRspBO bo = po.toQryPurchaseOrdRspBO();
                this.escapeOrd(bo, reqBO.getmLoginName());
                rspList.add(bo);
            }
        }
        return new RspPageBaseBO("0000", "\u64cd\u4f5c\u6210\u529f", rspList, page.getTotalCount(), page.getTotalPages());
    }

    public QryPurchaseOrdRspBO getOrderDetail(QryPurchaseOrdReqBO reqBO) {
        String checkRsp = PubCheckParamsUtils.checkAuth(reqBO.getmRole(), reqBO.getmLoginName());
        if (StringUtils.isNotBlank((CharSequence)checkRsp)) {
            return new QryPurchaseOrdRspBO("0009", checkRsp);
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getOrderNo())) {
            logger.error("\u8ba2\u5355\u7f16\u7801\u4e3a\u7a7a");
            return new QryPurchaseOrdRspBO("0001", "\u8ba2\u5355\u7f16\u7801\u4e3a\u7a7a");
        }
        QryPurchaseOrdRspBO rsp = null;
        try {
            rsp = this.purchaseOrderAtomService.getOrderByOrderNo(reqBO.getOrderNo());
        }
        catch (ResourceException e) {
            return new QryPurchaseOrdRspBO(e.getMsgCode(), e.getMessage());
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u5f02\u5e38\uff1a" + e.getMessage());
            return new QryPurchaseOrdRspBO("9999", "\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u5f02\u5e38");
        }
        if (null == rsp) {
            return new QryPurchaseOrdRspBO("0002", "\u91c7\u8d2d\u8ba2\u5355\u3010" + reqBO.getOrderNo() + "\u3011\u4e0d\u5b58\u5728");
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        this.escapeOrd(rsp, reqBO.getmLoginName());
        List<QryPurchaseOrderDetailBO> rspBOList = null;
        try {
            rspBOList = this.purchaseOrderAtomService.getOrderDetail(reqBO.getOrderNo());
        }
        catch (ResourceException e) {
            return new QryPurchaseOrdRspBO(e.getMsgCode(), e.getMessage());
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u8be6\u60c5\u5f02\u5e38");
            return new QryPurchaseOrdRspBO("9999", "\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u8be6\u60c5\u5f02\u5e38");
        }
        if (CollectionUtils.isNotEmpty(rspBOList)) {
            HashMap<String, SupplierSkuDetailBO> skuMap = new HashMap<String, SupplierSkuDetailBO>(rspBOList.size());
            for (QryPurchaseOrderDetailBO bo : rspBOList) {
                this.escapeOrdDetail(bo, skuMap);
            }
        }
        rsp.setRows(rspBOList);
        return rsp;
    }

    private void escapeOrdDetail(QryPurchaseOrderDetailBO bo, Map<String, SupplierSkuDetailBO> skuMap) {
        bo.setProvinceStr(PurchaseProvinceUtils.getPorvinceName(bo.getProvince()));
        try {
            if (null != bo.getPrice()) {
                bo.setPriceStr(String.valueOf(MoneyUtils.Long2BigDecimal((Long)bo.getPrice())));
            }
        }
        catch (Exception e) {
            logger.error("\u4ef7\u683c\u8f6c\u6362\u5931\u8d25\uff1a" + e.getMessage());
        }
        if (StringUtils.isNotBlank((CharSequence)bo.getFactory())) {
            PurchaseFactoryWarehouseBO factoryWarehouseBO = FactoryWarehouseUtils.getByFactoryNo(bo.getFactory());
            if (null == factoryWarehouseBO) {
                bo.setFactoryStr("\u672a\u5b9a\u4e49");
                bo.setWarehouseStr("\u672a\u5b9a\u4e49");
            } else {
                bo.setFactoryStr(factoryWarehouseBO.getFactoryName());
                bo.setWarehouseStr(factoryWarehouseBO.getWarehouseName());
            }
        }
        if (null != bo.getDeliveryDate()) {
            bo.setDeliveryDateStr(TkDateUtils.formatDate((Date)bo.getDeliveryDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        if (null != bo.getCrtTime()) {
            bo.setCrtTimeStr(TkDateUtils.formatDate((Date)bo.getCrtTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        if (StringUtils.isNotBlank((CharSequence)bo.getFreeFlag()) && "1".equals(bo.getFreeFlag())) {
            bo.setFreeFlagStr("\u662f");
        } else {
            bo.setFreeFlagStr("\u5426");
        }
        if (StringUtils.isNotBlank((CharSequence)bo.getReturnFlag()) && "1".equals(bo.getReturnFlag())) {
            bo.setReturnFlagStr("\u662f");
        } else {
            bo.setReturnFlagStr("\u5426");
        }
        SupplierSkuDetailBO detailBO = null;
        try {
            detailBO = this.qrySpCommInfoAtonService.getSkuDetail(null, bo.getSupplierId(), bo.getSkuNo(), skuMap);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
        }
        if (null != detailBO) {
            bo.setBrandCode(detailBO.getBrandCode());
            bo.setSupplierFullName(detailBO.getSupplierFullName());
            bo.setSupplierName(detailBO.getSupplierName());
            bo.setColor(detailBO.getColor());
            bo.setModel(detailBO.getModel());
            bo.setSkuImg(detailBO.getSkuMainPicUrl());
            bo.setSkuName(detailBO.getSkuName());
            bo.setSkuFullName(detailBO.getSkuFullName());
            try {
                if (StringUtils.isNotBlank((CharSequence)detailBO.getIntentPrice())) {
                    bo.setIntentPrice(Long.valueOf(detailBO.getIntentPrice()));
                    bo.setIntentPriceStr(detailBO.getIntentPriceed());
                }
                if (StringUtils.isNotBlank((CharSequence)detailBO.getSuggestPrice())) {
                    bo.setSuggestPrice(Long.valueOf(detailBO.getSuggestPrice()));
                    bo.setSuggestPriceStr(detailBO.getSuggestPriceed());
                }
            }
            catch (NumberFormatException e) {
                logger.error("\u4ef7\u683c\u8f6c\u6362\u5f02\u5e38\uff1a" + e.getMessage());
            }
        }
    }

    private void escapeOrdDetail(PurchaseOrdAndDetailBO bo, Map<String, SupplierSkuDetailBO> skuMap) {
        bo.setProvinceStr(PurchaseProvinceUtils.getPorvinceName(bo.getProvince()));
        try {
            if (null != bo.getPrice()) {
                bo.setPriceStr(String.valueOf(MoneyUtils.Long2BigDecimal((Long)bo.getPrice())));
            }
        }
        catch (Exception e) {
            logger.error("\u4ef7\u683c\u8f6c\u6362\u5931\u8d25\uff1a" + e.getMessage());
        }
        if (StringUtils.isNotBlank((CharSequence)bo.getFactory())) {
            PurchaseFactoryWarehouseBO factoryWarehouseBO = FactoryWarehouseUtils.getByFactoryNo(bo.getFactory());
            if (null == factoryWarehouseBO) {
                bo.setFactoryStr("\u672a\u5b9a\u4e49");
                bo.setWarehouseStr("\u672a\u5b9a\u4e49");
            } else {
                bo.setFactoryStr(factoryWarehouseBO.getFactoryName());
                bo.setWarehouseStr(factoryWarehouseBO.getWarehouseName());
            }
        }
        if (null != bo.getDeliveryDate()) {
            bo.setDeliveryDateStr(TkDateUtils.formatDate((Date)bo.getDeliveryDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        if (null != bo.getCrtTime()) {
            bo.setCrtTimeStr(TkDateUtils.formatDate((Date)bo.getCrtTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        if (StringUtils.isNotBlank((CharSequence)bo.getFreeFlag()) && "1".equals(bo.getFreeFlag())) {
            bo.setFreeFlagStr("\u662f");
        } else {
            bo.setFreeFlagStr("\u5426");
        }
        if (StringUtils.isNotBlank((CharSequence)bo.getReturnFlag()) && "1".equals(bo.getReturnFlag())) {
            bo.setReturnFlagStr("\u662f");
        } else {
            bo.setReturnFlagStr("\u5426");
        }
        SupplierSkuDetailBO detailBO = null;
        try {
            detailBO = this.qrySpCommInfoAtonService.getSkuDetail(null, bo.getSupplierId(), bo.getSkuNo(), skuMap);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
        }
        if (null != detailBO) {
            bo.setBrandCode(detailBO.getBrandCode());
            bo.setSupplierFullName(detailBO.getSupplierFullName());
            bo.setSupplierName(detailBO.getSupplierName());
            bo.setColor(detailBO.getColor());
            bo.setModel(detailBO.getModel());
            bo.setSkuImg(detailBO.getSkuMainPicUrl());
            bo.setSkuName(detailBO.getSkuName());
            bo.setSkuFullName(detailBO.getSkuFullName());
            try {
                if (StringUtils.isNotBlank((CharSequence)detailBO.getIntentPrice())) {
                    bo.setIntentPrice(Long.valueOf(detailBO.getIntentPrice()));
                    bo.setIntentPriceStr(detailBO.getIntentPriceed());
                }
                if (StringUtils.isNotBlank((CharSequence)detailBO.getSuggestPrice())) {
                    bo.setSuggestPrice(Long.valueOf(detailBO.getSuggestPrice()));
                    bo.setSuggestPriceStr(detailBO.getSuggestPriceed());
                }
            }
            catch (NumberFormatException e) {
                logger.error("\u4ef7\u683c\u8f6c\u6362\u5f02\u5e38\uff1a" + e.getMessage());
            }
        }
    }

    public RspBatchBaseBO<PurchaseOrdAndDetailBO> listSyncedOrderDetail(QryPurchaseOrdReqBO reqBO) {
        String province;
        String checkRsp = PubCheckParamsUtils.checkAuth(reqBO.getmRole(), reqBO.getmLoginName());
        if (StringUtils.isNotBlank((CharSequence)checkRsp)) {
            return new RspBatchBaseBO("0009", checkRsp);
        }
        String isBuying = "0";
        boolean provinceFlag = reqBO.getmRole().contains(TkPropertiesUtils.getProperty((String)"role.type.province"));
        if (provinceFlag) {
            if (StringUtils.isBlank((CharSequence)reqBO.getmProvince())) {
                logger.error("\u672a\u83b7\u53d6\u7528\u6237\u7701\u4efd");
                return new RspBatchBaseBO("0009", "\u672a\u83b7\u53d6\u7528\u6237\u7701\u4efd");
            }
            province = reqBO.getmProvince();
        } else {
            isBuying = "1";
            province = reqBO.getProvince();
        }
        PurchaseOrdAndDetailBO record = new PurchaseOrdAndDetailBO();
        record.setProvince(province);
        record.setBuyingFlag(isBuying);
        record.setSupplierId(reqBO.getSupplierId());
        record.setSkuNo(reqBO.getSkuNo());
        List<PurchaseOrdAndDetailBO> purchaseOrdAndDetailBOS = null;
        try {
            purchaseOrdAndDetailBOS = this.purchaseOrderAtomService.listSyncedDetail(record);
        }
        catch (ResourceException e) {
            return new RspBatchBaseBO(e.getMsgCode(), e.getMessage());
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u8ba2\u5355\u660e\u7ec6\u5f02\u5e38\uff1a" + e.getMessage());
            return new RspBatchBaseBO("9999", "\u67e5\u8be2\u8ba2\u5355\u660e\u7ec6\u5f02\u5e38");
        }
        if (CollectionUtils.isNotEmpty(purchaseOrdAndDetailBOS)) {
            HashMap<String, SupplierSkuDetailBO> skuMap = new HashMap<String, SupplierSkuDetailBO>(purchaseOrdAndDetailBOS.size());
            for (PurchaseOrdAndDetailBO bo : purchaseOrdAndDetailBOS) {
                this.escapeOrdDetail(bo, skuMap);
            }
        }
        return new RspBatchBaseBO("0000", "\u64cd\u4f5c\u6210\u529f", purchaseOrdAndDetailBOS);
    }

    private void escapeOrd(QryPurchaseOrdRspBO bo, String loginName) {
        bo.setProvinceStr(PurchaseProvinceUtils.getPorvinceName(bo.getProvince()));
        if (StringUtils.isNotBlank((CharSequence)bo.getStatus())) {
            String statusStr = this.purchaseQryEscapeAtomService.getCodeTitle("PURCHASE_ORDER_STATUS_TYPE", bo.getStatus());
            bo.setStatusStr(StringUtils.isBlank((CharSequence)statusStr) ? "\u672a\u5b9a\u4e49" : statusStr);
        }
        if (null != bo.getCrtTime()) {
            bo.setCrtTimeStr(TkDateUtils.formatDate((Date)bo.getCrtTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        if ("1".equals(bo.getBuyingFlag())) {
            bo.setBuyingFlagStr("\u662f");
        } else {
            bo.setBuyingFlagStr("\u5426");
        }
        String submitTypeStr = this.purchaseQryEscapeAtomService.getCodeTitle("PURCHASE_SUBMIT_TYPE", bo.getBuyingFlag());
        bo.setSubmitTypeStr(StringUtils.isNotBlank((CharSequence)submitTypeStr) ? submitTypeStr : "\u672a\u5b9a\u4e49");
        if (bo.getOperUser().equals(loginName)) {
            bo.setSyncFlag("1");
        } else {
            bo.setSyncFlag("0");
        }
    }
}

