/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.purchase.busi.impl;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Page;
import com.tydic.newretail.purchase.atom.PurchaseRequireAtomService;
import com.tydic.newretail.purchase.atom.QrySpCommInfoAtomService;
import com.tydic.newretail.purchase.bo.PurchaseFactoryWarehouseBO;
import com.tydic.newretail.purchase.bo.PurchaseRequireDetailBO;
import com.tydic.newretail.purchase.bo.QryPurchaseRequireDetailBO;
import com.tydic.newretail.purchase.bo.QryPurchaseRequireReqBO;
import com.tydic.newretail.purchase.bo.QryPurchaseRequireRspBO;
import com.tydic.newretail.purchase.dao.PurchaseRequireDao;
import com.tydic.newretail.purchase.dao.po.PurchaseRequirePO;
import com.tydic.newretail.purchase.service.busi.QryPurchaseReqBusiService;
import com.tydic.newretail.purchase.util.FactoryWarehouseUtils;
import com.tydic.newretail.purchase.util.PubCheckParamsUtils;
import com.tydic.newretail.purchase.util.PurchaseProvinceUtils;
import com.tydic.newretail.spcomm.sku.bo.SupplierSkuDetailBO;
import com.tydic.newretail.toolkit.atom.QryEscapeAtomService;
import com.tydic.newretail.toolkit.bo.RspPageBaseBO;
import com.tydic.newretail.toolkit.util.TkDateUtils;
import com.tydic.newretail.toolkit.util.TkPropertiesUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QryPurchaseReqBusiServiceImpl
implements QryPurchaseReqBusiService {
    private static final Logger logger = LoggerFactory.getLogger(QryPurchaseReqBusiServiceImpl.class);
    @Autowired
    private PurchaseRequireDao purchaseRequireDao;
    @Autowired
    private QryEscapeAtomService purchaseQryEscapeAtomService;
    @Autowired
    private PurchaseRequireAtomService purchaseRequireAtomService;
    @Autowired
    private QrySpCommInfoAtomService qrySpCommInfoAtonService;

    public RspPageBaseBO<QryPurchaseRequireRspBO> listReqByPage(QryPurchaseRequireReqBO reqBO) {
        PurchaseRequirePO record = new PurchaseRequirePO();
        if (!"-1".equals(reqBO.getProvince())) {
            record.setProvince(reqBO.getProvince());
        }
        if (!"-1".equals(reqBO.getSubmitType())) {
            record.setBuyingFlag(reqBO.getSubmitType());
        }
        record.setCheckUser(reqBO.getCheckUser());
        record.setNo(reqBO.getReqNo());
        record.setStartTime(reqBO.getStartTime());
        record.setEndTime(reqBO.getEndTime());
        if (!"-1".equals(reqBO.getCheckStatus())) {
            record.setAuditStatus(reqBO.getCheckStatus());
        }
        return this.listReqByPagePub(record, reqBO.getPageNo(), reqBO.getPageSize());
    }

    public QryPurchaseRequireRspBO getDetailByReqNo(QryPurchaseRequireReqBO reqBO) {
        QryPurchaseRequireRspBO purchaseRequireRspBO = this.getDetailByReqNoPub(reqBO);
        return purchaseRequireRspBO;
    }

    public RspPageBaseBO<QryPurchaseRequireRspBO> listPurchaseProgress(QryPurchaseRequireReqBO reqBO) {
        String checkRsp = PubCheckParamsUtils.checkAuth(reqBO.getmRole(), reqBO.getmLoginName());
        if (StringUtils.isNotBlank((CharSequence)checkRsp)) {
            return new RspPageBaseBO("0009", checkRsp);
        }
        boolean provinceFlag = reqBO.getmRole().contains(TkPropertiesUtils.getProperty((String)"role.type.province"));
        PurchaseRequirePO record = new PurchaseRequirePO();
        if (provinceFlag) {
            if (StringUtils.isBlank((CharSequence)reqBO.getmProvince())) {
                logger.error("\u672a\u83b7\u53d6\u7528\u6237\u7701\u4efd");
                return new RspPageBaseBO("0001", "\u672a\u83b7\u53d6\u7528\u6237\u7701\u4efd");
            }
            record.setProvince(reqBO.getmProvince());
            record.setBuyingFlag("0");
        } else {
            record.setBuyingFlag("1");
            if (!"-1".equals(reqBO.getProvince())) {
                record.setProvince(reqBO.getProvince());
            }
        }
        record.setCheckUser(reqBO.getCheckUser());
        record.setNo(reqBO.getReqNo());
        record.setStartTime(reqBO.getStartTime());
        record.setEndTime(reqBO.getEndTime());
        if (!"-1".equals(reqBO.getCheckStatus())) {
            record.setAuditStatus(reqBO.getCheckStatus());
        }
        return this.listReqByPagePub(record, reqBO.getPageNo(), reqBO.getPageSize());
    }

    private RspPageBaseBO<QryPurchaseRequireRspBO> listReqByPagePub(PurchaseRequirePO record, int pageNo, int pageSize) {
        Page page = new Page(pageNo, pageSize);
        List<PurchaseRequirePO> list = null;
        try {
            if (null != record.getStartTime()) {
                String startTime = TkDateUtils.formatDate((Date)record.getStartTime(), (String)"yyyy-MM-dd");
                startTime = startTime + " 00:00:00";
                record.setStartTime(TkDateUtils.datetimeStrToDate((String)startTime));
            }
            if (null != record.getEndTime()) {
                String endTime = TkDateUtils.formatDate((Date)record.getEndTime(), (String)"yyyy-MM-dd");
                endTime = endTime + " 23:59:59";
                record.setEndTime(TkDateUtils.datetimeStrToDate((String)endTime));
            }
        }
        catch (Exception e) {
            logger.error("\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
            return new RspPageBaseBO("0007", "\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
        }
        try {
            list = this.purchaseRequireDao.selectByPage((Page<PurchaseRequirePO>)page, record);
        }
        catch (Exception e) {
            logger.error("\u5206\u9875\u67e5\u8be2\u91c7\u8d2d\u9700\u6c42\u5355\u5931\u8d25\uff1a" + e.getMessage());
            return new RspPageBaseBO("0003", "\u5206\u9875\u67e5\u8be2\u91c7\u8d2d\u9700\u6c42\u5355\u5931\u8d25");
        }
        ArrayList<QryPurchaseRequireRspBO> rspList = new ArrayList<QryPurchaseRequireRspBO>(list.size());
        for (PurchaseRequirePO po : list) {
            QryPurchaseRequireRspBO bo = po.toQryPurchaseRequireRspBO();
            if (StringUtils.isBlank((CharSequence)bo.getOperUserName())) {
                bo.setOperUserName(bo.getOperUser());
            }
            this.escapeReq(bo);
            rspList.add(bo);
        }
        return new RspPageBaseBO("0000", "\u64cd\u4f5c\u6210\u529f", rspList, page.getTotalCount(), page.getTotalPages());
    }

    private void escapeReq(QryPurchaseRequireRspBO bo) {
        bo.setProvinceStr(PurchaseProvinceUtils.getPorvinceName(bo.getProvince()));
        if (StringUtils.isNotBlank((CharSequence)bo.getAuditStatus())) {
            String statusStr = this.purchaseQryEscapeAtomService.getCodeTitle("PURCHASE_CHECK_STATUS_TYPE", bo.getAuditStatus());
            bo.setAuditStatusStr(StringUtils.isBlank((CharSequence)statusStr) ? "\u672a\u5b9a\u4e49" : statusStr);
        }
        if (null != bo.getCrtTime()) {
            bo.setCrtTimeStr(TkDateUtils.formatDate((Date)bo.getCrtTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        if ("1".equals(bo.getBuyingFlag())) {
            bo.setBuyingFlagStr("\u662f");
        } else {
            bo.setBuyingFlagStr("\u5426");
        }
        String submitTypeStr = this.purchaseQryEscapeAtomService.getCodeTitle("PURCHASE_SUBMIT_TYPE", bo.getBuyingFlag());
        bo.setSubmitTypeStr(StringUtils.isNotBlank((CharSequence)submitTypeStr) ? submitTypeStr : "\u672a\u5b9a\u4e49");
    }

    public QryPurchaseRequireRspBO getPurchaseProDetail(QryPurchaseRequireReqBO reqBO) {
        String checkRsp = PubCheckParamsUtils.checkAuth(reqBO.getmRole(), reqBO.getmLoginName());
        if (StringUtils.isNotBlank((CharSequence)checkRsp)) {
            return new QryPurchaseRequireRspBO("0009", checkRsp);
        }
        QryPurchaseRequireRspBO purchaseRequireRspBO = this.getDetailByReqNoPub(reqBO);
        if (CollectionUtils.isEmpty((Collection)purchaseRequireRspBO.getRows())) {
            return purchaseRequireRspBO;
        }
        ArrayList<QryPurchaseRequireDetailBO> syncedRows = new ArrayList<QryPurchaseRequireDetailBO>();
        ArrayList<QryPurchaseRequireDetailBO> toBeSyncRows = new ArrayList<QryPurchaseRequireDetailBO>();
        ArrayList<QryPurchaseRequireDetailBO> preSubSyncRows = new ArrayList<QryPurchaseRequireDetailBO>();
        for (QryPurchaseRequireDetailBO detailBO : purchaseRequireRspBO.getRows()) {
            if ("01".equals(detailBO.getStatus())) {
                toBeSyncRows.add(detailBO);
                continue;
            }
            if ("03".equals(detailBO.getStatus()) || "04".equals(detailBO.getStatus())) {
                this.escapePreSubmit(detailBO);
                preSubSyncRows.add(detailBO);
                continue;
            }
            syncedRows.add(detailBO);
        }
        purchaseRequireRspBO.setSyncedRows(syncedRows);
        purchaseRequireRspBO.setToBeSyncRows(toBeSyncRows);
        purchaseRequireRspBO.setPreSubSyncRows(preSubSyncRows);
        return purchaseRequireRspBO;
    }

    private void escapePreSubmit(QryPurchaseRequireDetailBO detailBO) {
        detailBO.setInvalidFlag("0");
        if (!"03".equals(detailBO.getStatus())) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)detailBO.getMeterielCode())) {
            detailBO.setStatusDesc("\u7b49\u5f85\u7269\u6599");
        } else if (null == detailBO.getPrice() || null == detailBO.getAvailableCount()) {
            detailBO.setStatusDesc("\u7b49\u5f85\u91cf\u4ef7");
            detailBO.setInvalidFlag("1");
        } else if ("01".equals(detailBO.getContractType()) && detailBO.getCount() > detailBO.getAvailableCount()) {
            detailBO.setStatusDesc("\u6570\u91cf\u4e0d\u8db3");
            detailBO.setInvalidFlag("1");
        } else {
            detailBO.setStatusDesc("\u5408\u540c\u5f85\u540c\u6b65");
        }
    }

    private QryPurchaseRequireRspBO getDetailByReqNoPub(QryPurchaseRequireReqBO reqBO) {
        if (StringUtils.isBlank((CharSequence)reqBO.getReqNo())) {
            logger.error("\u9700\u6c42\u5355\u53f7\u4e3a\u7a7a");
            return new QryPurchaseRequireRspBO("0001", "\u9700\u6c42\u5355\u53f7\u4e3a\u7a7a");
        }
        QryPurchaseRequireRspBO rsp = null;
        try {
            rsp = this.purchaseRequireAtomService.getRequireByReqNo(reqBO.getReqNo());
        }
        catch (ResourceException e) {
            return new QryPurchaseRequireRspBO(e.getMsgCode(), e.getMessage());
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u91c7\u8d2d\u9700\u6c42\u5355\u5f02\u5e38\uff1a" + e.getMessage());
            return new QryPurchaseRequireRspBO("9999", "\u67e5\u8be2\u91c7\u8d2d\u9700\u6c42\u5355\u5f02\u5e38");
        }
        if (null == rsp) {
            return new QryPurchaseRequireRspBO("0002", "\u91c7\u8d2d\u9700\u6c42\u5355\u3010" + reqBO.getReqNo() + "\u3011\u4e0d\u5b58\u5728");
        }
        this.escapeReq(rsp);
        List<QryPurchaseRequireDetailBO> rspList = null;
        PurchaseRequireDetailBO detailBO = new PurchaseRequireDetailBO();
        detailBO.setReqNo(reqBO.getReqNo());
        if (!"-1".equals(reqBO.getProvince())) {
            detailBO.setProvince(reqBO.getProvince());
        }
        try {
            rspList = this.purchaseRequireAtomService.getRequireDetailByCondition(detailBO);
        }
        catch (ResourceException e) {
            return new QryPurchaseRequireRspBO(e.getMsgCode(), e.getMessage());
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u9700\u6c42\u5355\u8be6\u60c5\u5f02\u5e38\uff1a" + e.getMessage());
            return new QryPurchaseRequireRspBO("9999", "\u67e5\u8be2\u9700\u6c42\u5355\u8be6\u60c5\u5f02\u5e38");
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        if (CollectionUtils.isEmpty(rspList)) {
            return rsp;
        }
        HashMap<String, SupplierSkuDetailBO> skuMap = new HashMap<String, SupplierSkuDetailBO>();
        long totalPrice = 0L;
        for (QryPurchaseRequireDetailBO bo : rspList) {
            bo.setProvinceStr(PurchaseProvinceUtils.getPorvinceName(bo.getProvince()));
            if (StringUtils.isNotBlank((CharSequence)bo.getFactory())) {
                PurchaseFactoryWarehouseBO factoryWarehouseBO = FactoryWarehouseUtils.getByFactoryNo(bo.getFactory());
                if (null == factoryWarehouseBO) {
                    bo.setFactoryStr("\u672a\u5b9a\u4e49");
                    bo.setWarehouseStr("\u672a\u5b9a\u4e49");
                } else {
                    bo.setFactoryStr(factoryWarehouseBO.getFactoryName());
                    bo.setWarehouseStr(factoryWarehouseBO.getWarehouseName());
                }
            }
            if (null != bo.getCrtTime()) {
                bo.setCrtTimeStr(TkDateUtils.formatDate((Date)bo.getCrtTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            if (null != bo.getDeliveryDate()) {
                bo.setDeliveryDateStr(TkDateUtils.formatDate((Date)bo.getDeliveryDate(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getFreeFlag()) && "1".equals(bo.getFreeFlag())) {
                bo.setFreeFlagStr("\u662f");
            } else {
                bo.setFreeFlagStr("\u5426");
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getReturnFlag()) && "1".equals(bo.getReturnFlag())) {
                bo.setReturnFlagStr("\u662f");
            } else {
                bo.setReturnFlagStr("\u5426");
            }
            String statusStr = this.purchaseQryEscapeAtomService.getCodeTitle("PURCHASE_REQ_DETAIL_STATUS_TYPE", bo.getStatus());
            bo.setStatusDesc(StringUtils.isNotBlank((CharSequence)statusStr) ? statusStr : "\u672a\u5b9a\u4e49");
            if (null != bo.getLastUpdDate()) {
                bo.setLastUpdDateStr(TkDateUtils.formatDate((Date)bo.getLastUpdDate(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            if ("02".equals(bo.getStatus())) {
                bo.setSyncTimeStr(bo.getLastUpdDateStr());
            }
            SupplierSkuDetailBO skuDetailBO = null;
            try {
                skuDetailBO = this.qrySpCommInfoAtonService.getSkuDetail(null, bo.getSupplierId(), bo.getSkuNo(), skuMap);
            }
            catch (Exception e) {
                logger.error("\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            }
            if (null != skuDetailBO) {
                bo.setBrandCode(skuDetailBO.getBrandCode());
                bo.setSupplierFullName(skuDetailBO.getSupplierFullName());
                bo.setSupplierName(skuDetailBO.getSupplierName());
                bo.setColor(skuDetailBO.getColor());
                bo.setModel(skuDetailBO.getModel());
                bo.setSkuImg(skuDetailBO.getSkuMainPicUrl());
                bo.setSkuName(skuDetailBO.getSkuName());
                bo.setSkuFullName(skuDetailBO.getSkuFullName());
                if (null != skuDetailBO.getSuggestPrice()) {
                    bo.setSuggestPrice(Long.valueOf(skuDetailBO.getSuggestPrice()));
                    bo.setSuggestPriceStr(skuDetailBO.getSuggestPriceed());
                }
                if (null != skuDetailBO.getIntentPrice()) {
                    bo.setIntentPrice(Long.valueOf(skuDetailBO.getIntentPrice()));
                    bo.setIntentPriceStr(skuDetailBO.getIntentPriceed());
                }
            }
            try {
                if (null != bo.getPrice()) {
                    bo.setPriceStr(String.valueOf(MoneyUtils.Long2BigDecimal((Long)bo.getPrice())));
                    totalPrice += bo.getPrice() * bo.getCount();
                    continue;
                }
                if (null == bo.getIntentPrice()) continue;
                totalPrice += bo.getIntentPrice() * bo.getCount();
            }
            catch (Exception e) {
                logger.error("\u4ef7\u683c\u8f6c\u6362\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        try {
            rsp.setTotalPriceStr(String.valueOf(MoneyUtils.Long2BigDecimal((Long)totalPrice)));
            rsp.setTotalPrice(Long.valueOf(totalPrice));
        }
        catch (Exception e) {
            logger.error("\u4ef7\u683c\u8f6c\u6362\u5931\u8d25\uff1a" + e.getMessage());
        }
        rsp.setRows(rspList);
        return rsp;
    }
}

