/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.purchase.busi.impl;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.newretail.bo.UserInfoBaseBO;
import com.tydic.newretail.purchase.atom.PurchaseRequireAtomService;
import com.tydic.newretail.purchase.atom.QrySpCommInfoAtomService;
import com.tydic.newretail.purchase.atom.ShoppingCartAtomService;
import com.tydic.newretail.purchase.bo.PurchaseFactoryWarehouseBO;
import com.tydic.newretail.purchase.bo.PurchaseRequireBO;
import com.tydic.newretail.purchase.bo.PurchaseRequireDetailBO;
import com.tydic.newretail.purchase.bo.RemoveShoppingCartBO;
import com.tydic.newretail.purchase.bo.ShoppingCartBO;
import com.tydic.newretail.purchase.bo.ShoppingCartBatchBO;
import com.tydic.newretail.purchase.bo.ShoppingCartDetailBO;
import com.tydic.newretail.purchase.bo.ShoppingCartModifyRspBO;
import com.tydic.newretail.purchase.busi.CountPriceDetailBusiService;
import com.tydic.newretail.purchase.busi.bo.ContractLogRspBO;
import com.tydic.newretail.purchase.busi.bo.CountPriceDetailQueryInfoBO;
import com.tydic.newretail.purchase.service.busi.ShoppingCartBusiService;
import com.tydic.newretail.purchase.thread.MaterialReminderThread;
import com.tydic.newretail.purchase.util.FactoryWarehouseUtils;
import com.tydic.newretail.purchase.util.GetCountPriceUtils;
import com.tydic.newretail.purchase.util.PubCheckParamsUtils;
import com.tydic.newretail.purchase.util.PurchaseProvinceUtils;
import com.tydic.newretail.purchase.util.ThrExceptionUtils;
import com.tydic.newretail.spcomm.sku.bo.SupplierSkuDetailBO;
import com.tydic.newretail.spcomm.sku.busi.service.AddMaterielRepplyService;
import com.tydic.newretail.toolkit.atom.QryEscapeAtomService;
import com.tydic.newretail.toolkit.bo.RspBaseBO;
import com.tydic.newretail.toolkit.bo.RspBatchBaseBO;
import com.tydic.newretail.toolkit.util.TkCreateThreadUtils;
import com.tydic.newretail.toolkit.util.TkDateUtils;
import com.tydic.newretail.toolkit.util.TkPropertiesUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShoppingCartBusiServiceImpl
implements ShoppingCartBusiService {
    private static final Logger logger = LoggerFactory.getLogger(ShoppingCartBusiServiceImpl.class);
    @Autowired
    private ShoppingCartAtomService shoppingCartAtomService;
    @Autowired
    private QrySpCommInfoAtomService qrySpCommInfoAtonService;
    @Autowired
    private QryEscapeAtomService purchaseQryEscapeAtomService;
    @Autowired
    private PurchaseRequireAtomService purchaseRequireAtomService;
    @Autowired
    private CountPriceDetailBusiService countPriceDetailBusiService;
    @Autowired
    private AddMaterielRepplyService addMaterielRepplyService;

    public RspBatchBaseBO<ShoppingCartBO> listShopCart(UserInfoBaseBO reqBO) {
        String checkAuthRsp = PubCheckParamsUtils.checkAuth(reqBO.getmRole(), reqBO.getmLoginName());
        if (StringUtils.isNotBlank((CharSequence)checkAuthRsp)) {
            return new RspBatchBaseBO("0009", checkAuthRsp);
        }
        List<ShoppingCartBO> shoppingCartBOS = null;
        try {
            shoppingCartBOS = this.shoppingCartAtomService.listShoppingCartByOperUser(reqBO.getmLoginName());
        }
        catch (ResourceException e) {
            return new RspBatchBaseBO(e.getMsgCode(), e.getMessage());
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u8d2d\u7269\u8f66\u5f02\u5e38\uff1a" + e.getMessage());
            return new RspBatchBaseBO("9999", "\u67e5\u8be2\u8d2d\u7269\u8f66\u5f02\u5e38");
        }
        if (CollectionUtils.isEmpty(shoppingCartBOS)) {
            return new RspBatchBaseBO("0000", "\u64cd\u4f5c\u6210\u529f", shoppingCartBOS);
        }
        boolean buyingFlag = reqBO.getmRole().contains(TkPropertiesUtils.getProperty((String)"role.type.buying"));
        if (buyingFlag) {
            List<ShoppingCartBO> rsplist = this.listBuyingDatas(shoppingCartBOS);
            return this.setSkuMsg(rsplist);
        }
        return this.setSkuMsg(shoppingCartBOS);
    }

    private RspBatchBaseBO<ShoppingCartBO> setSkuMsg(List<ShoppingCartBO> bos) {
        HashMap<String, SupplierSkuDetailBO> skuMap = new HashMap<String, SupplierSkuDetailBO>();
        ArrayList<ShoppingCartBO> rspList = new ArrayList<ShoppingCartBO>(bos.size());
        for (ShoppingCartBO bo : bos) {
            SupplierSkuDetailBO detailBO = null;
            try {
                detailBO = this.qrySpCommInfoAtonService.getSkuDetail(bo.getSkuId(), null, null, skuMap);
            }
            catch (ResourceException e) {
                return new RspBatchBaseBO(e.getMsgCode(), e.getMessage());
            }
            catch (Exception e) {
                logger.error("\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
                return new RspBatchBaseBO("9999", "\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5931\u8d25");
            }
            if (null == detailBO) continue;
            bo.setSkuImg(detailBO.getSkuMainPicUrl());
            bo.setSkuFullName(detailBO.getSkuFullName());
            bo.setSkuName(detailBO.getSkuName());
            bo.setSupplierName(detailBO.getSupplierName());
            bo.setSupplierFullName(detailBO.getSupplierFullName());
            try {
                if (null != detailBO.getPrice()) {
                    bo.setPurchasePrice(Long.valueOf(detailBO.getPrice()));
                    bo.setPurchasePriceStr(detailBO.getPriceed());
                }
                if (null != detailBO.getSuggestPrice()) {
                    bo.setSuggestPrice(Long.valueOf(detailBO.getSuggestPrice()));
                    bo.setSuggestPriceStr(detailBO.getSuggestPriceed());
                }
                if (null != detailBO.getIntentPrice()) {
                    bo.setIntentPrice(Long.valueOf(detailBO.getIntentPrice()));
                    bo.setIntentPriceStr(detailBO.getIntentPriceed());
                }
            }
            catch (Exception e) {
                logger.error("\u4ef7\u683c\u8f6c\u6362\u5931\u8d25\uff1a" + e.getMessage());
            }
            this.getShoppingCartDetails(bo);
            this.getEscape(bo);
            rspList.add(bo);
        }
        return new RspBatchBaseBO("0000", "\u64cd\u4f5c\u6210\u529f", rspList);
    }

    private void getEscape(ShoppingCartBO bo) {
        if (StringUtils.isNotBlank((CharSequence)bo.getBuyingFlag()) && "1".equals(bo.getBuyingFlag())) {
            bo.setBuyingFlagStr("\u662f");
        } else {
            bo.setBuyingFlagStr("\u5426");
        }
        if (StringUtils.isNotBlank((CharSequence)bo.getFreeFlag()) && "1".equals(bo.getFreeFlag())) {
            bo.setFreeFlagStr("\u662f");
        } else {
            bo.setFreeFlagStr("\u5426");
        }
        if (StringUtils.isNotBlank((CharSequence)bo.getReturnFlag()) && "1".equals(bo.getReturnFlag())) {
            bo.setReturnFlagStr("\u662f");
        } else {
            bo.setReturnFlagStr("\u5426");
        }
        if (StringUtils.isNotBlank((CharSequence)bo.getFactory())) {
            PurchaseFactoryWarehouseBO factoryWarehouseBO = FactoryWarehouseUtils.getByFactoryNo(bo.getFactory());
            if (null == factoryWarehouseBO) {
                bo.setFactoryStr("\u672a\u5b9a\u4e49");
                bo.setWarehouseStr("\u672a\u5b9a\u4e49");
            } else {
                bo.setFactoryStr(factoryWarehouseBO.getFactoryName());
                bo.setWarehouseStr(factoryWarehouseBO.getWarehouseName());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)bo.getProvince())) {
            bo.setProvinceStr(PurchaseProvinceUtils.getPorvinceName(bo.getProvince()));
        }
        if (StringUtils.isNotBlank((CharSequence)bo.getProjectCategory())) {
            String str = this.purchaseQryEscapeAtomService.getCodeTitle("PURCHASE_ITEM_TYPE", bo.getProjectCategory());
            bo.setProjectCategoryStr(StringUtils.isNotBlank((CharSequence)str) ? str : "\u672a\u5b9a\u4e49");
        }
        if (null != bo.getCrtTime()) {
            bo.setCrtTimeStr(TkDateUtils.formatDate((Date)bo.getCrtTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        if (null != bo.getDeliveryDate()) {
            bo.setDeliveryDateStr(TkDateUtils.formatDate((Date)bo.getDeliveryDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        if (null != bo.getLastUpdDate()) {
            bo.setLastUpdDateStr(TkDateUtils.formatDate((Date)bo.getLastUpdDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
    }

    private void getShoppingCartDetails(ShoppingCartBO bo) {
        if (CollectionUtils.isNotEmpty((Collection)bo.getDetailBOS())) {
            for (ShoppingCartDetailBO detailBO : bo.getDetailBOS()) {
                if (StringUtils.isNotBlank((CharSequence)bo.getFactory())) {
                    PurchaseFactoryWarehouseBO factoryWarehouseBO = FactoryWarehouseUtils.getByFactoryNo(detailBO.getFactory());
                    if (null == factoryWarehouseBO) {
                        detailBO.setFactoryStr("\u672a\u5b9a\u4e49");
                        detailBO.setWarehouseStr("\u672a\u5b9a\u4e49");
                    } else {
                        detailBO.setFactoryStr(factoryWarehouseBO.getFactoryName());
                        detailBO.setWarehouseStr(factoryWarehouseBO.getWarehouseName());
                    }
                }
                if (!StringUtils.isNotBlank((CharSequence)detailBO.getProvince())) continue;
                detailBO.setProvinceStr(PurchaseProvinceUtils.getPorvinceName(detailBO.getProvince()));
            }
        }
    }

    private List<ShoppingCartBO> listBuyingDatas(List<ShoppingCartBO> shoppingCartBOS) {
        HashMap detailMap = new HashMap();
        HashMap<Long, ShoppingCartBO> cartMap = new HashMap<Long, ShoppingCartBO>();
        for (ShoppingCartBO cartBO : shoppingCartBOS) {
            Long skuId = cartBO.getSkuId();
            if (!cartMap.containsKey(skuId)) {
                ShoppingCartBO pubCartBO = new ShoppingCartBO();
                pubCartBO.setOperUser(cartBO.getOperUser());
                pubCartBO.setBuyingFlag(cartBO.getBuyingFlag());
                pubCartBO.setSupplierId(cartBO.getSupplierId());
                pubCartBO.setSupplierNo(cartBO.getSupplierNo());
                pubCartBO.setSkuId(cartBO.getSkuId());
                pubCartBO.setSkuNo(cartBO.getSkuNo());
                pubCartBO.setProvince(cartBO.getProvince());
                pubCartBO.setFreeFlag(cartBO.getFreeFlag());
                pubCartBO.setReturnFlag(cartBO.getReturnFlag());
                pubCartBO.setDeliveryDate(cartBO.getDeliveryDate());
                pubCartBO.setContent(cartBO.getContent());
                pubCartBO.setProjectCategory(cartBO.getProjectCategory());
                cartMap.put(skuId, pubCartBO);
            }
            ShoppingCartDetailBO detailBO = new ShoppingCartDetailBO();
            detailBO.setCount(cartBO.getCount());
            detailBO.setDeliveryDate(cartBO.getDeliveryDate());
            detailBO.setFactory(cartBO.getFactory());
            detailBO.setProvince(cartBO.getProvince());
            detailBO.setWarehouse(cartBO.getWarehouse());
            detailBO.setCartId(cartBO.getCartId());
            if (StringUtils.isNotBlank((CharSequence)detailBO.getFactory())) {
                PurchaseFactoryWarehouseBO factoryWarehouseBO = FactoryWarehouseUtils.getByFactoryNo(detailBO.getFactory());
                if (null == factoryWarehouseBO) {
                    detailBO.setFactoryStr("\u672a\u5b9a\u4e49");
                    detailBO.setWarehouseStr("\u672a\u5b9a\u4e49");
                } else {
                    detailBO.setFactoryStr(factoryWarehouseBO.getFactoryName());
                    detailBO.setWarehouseStr(factoryWarehouseBO.getWarehouseName());
                }
            }
            ArrayList<ShoppingCartDetailBO> detailBOS = new ArrayList<ShoppingCartDetailBO>(1);
            detailBOS.add(detailBO);
            if (detailMap.containsKey(skuId)) {
                ((List)detailMap.get(skuId)).addAll(detailBOS);
                continue;
            }
            detailMap.put(skuId, detailBOS);
        }
        ArrayList<ShoppingCartBO> rspList = new ArrayList<ShoppingCartBO>();
        for (Map.Entry map : cartMap.entrySet()) {
            ShoppingCartBO cartBO = (ShoppingCartBO)map.getValue();
            if (detailMap.containsKey(map.getKey())) {
                cartBO.setDetailBOS((List)detailMap.get(map.getKey()));
            }
            rspList.add(cartBO);
        }
        return rspList;
    }

    public ShoppingCartModifyRspBO modifyShoppingCart(ShoppingCartBatchBO reqBO) {
        String checkAuthRsp = PubCheckParamsUtils.checkAuth(reqBO.getmRole(), reqBO.getmLoginName());
        if (StringUtils.isNotBlank((CharSequence)checkAuthRsp)) {
            return new ShoppingCartModifyRspBO("0009", checkAuthRsp);
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getReqList())) {
            logger.error("\u8d2d\u7269\u8f66\u4fe1\u606f\u96c6\u5408\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u8d2d\u7269\u8f66\u4fe1\u606f\u96c6\u5408\u4e3a\u7a7a");
        }
        boolean buyingFlag = reqBO.getmRole().contains(TkPropertiesUtils.getProperty((String)"role.type.buying"));
        List reqList = reqBO.getReqList();
        ArrayList<Long> cartIds = new ArrayList<Long>();
        for (ShoppingCartBO shoppingCartBO : reqList) {
            if (buyingFlag) {
                this.modifyBuyingDatas(shoppingCartBO, reqBO.getmLoginName(), cartIds);
                continue;
            }
            if (null == shoppingCartBO.getCartId()) {
                logger.error("\u8d2d\u7269\u8f66ID\u4e3a\u7a7a");
                ThrExceptionUtils.thrEmptyExce("\u8d2d\u7269\u8f66ID\u4e3a\u7a7a");
            }
            cartIds.add(shoppingCartBO.getCartId());
            this.shoppingCartAtomService.modifyShoppingCart(shoppingCartBO);
        }
        return new ShoppingCartModifyRspBO("0000", "\u64cd\u4f5c\u6210\u529f", cartIds);
    }

    private void modifyBuyingDatas(ShoppingCartBO shoppingCartBO, String operUser, List<Long> cartIds) {
        PubCheckParamsUtils.checkSkuParams(shoppingCartBO);
        ShoppingCartBO modify = new ShoppingCartBO();
        modify.setOperUser(operUser);
        modify.setSkuId(shoppingCartBO.getSkuId());
        modify.setProjectCategory(shoppingCartBO.getProjectCategory());
        modify.setContent(shoppingCartBO.getContent());
        modify.setReturnFlag(shoppingCartBO.getReturnFlag());
        modify.setFreeFlag(shoppingCartBO.getFreeFlag());
        modify.setDeliveryDate(shoppingCartBO.getDeliveryDate());
        shoppingCartBO.setOperUser(operUser);
        this.shoppingCartAtomService.modifyBySkuId(shoppingCartBO);
        if (CollectionUtils.isEmpty((Collection)shoppingCartBO.getDetailBOS())) {
            return;
        }
        for (ShoppingCartDetailBO bo : shoppingCartBO.getDetailBOS()) {
            List<ShoppingCartBO> cartBOList;
            ShoppingCartBO qryReq;
            if (null == bo.getCartId() && StringUtils.isBlank((CharSequence)bo.getProvince())) {
                logger.error("\u8d2d\u7269\u8f66ID\u548c\u7701\u4efd\u7f16\u7801\u5fc5\u586b\u5176\u4e00");
                ThrExceptionUtils.thrEmptyExce("\u8d2d\u7269\u8f66ID\u548c\u7701\u4efd\u7f16\u7801\u5fc5\u586b\u5176\u4e00");
            }
            ShoppingCartBO cartBO = null;
            if (null == bo.getCartId()) {
                qryReq = new ShoppingCartBO();
                qryReq.setOperUser(operUser);
                qryReq.setSkuId(shoppingCartBO.getSkuId());
                qryReq.setProvince(bo.getProvince());
                cartBOList = this.shoppingCartAtomService.listShoppingCartByCondition(qryReq);
                if (CollectionUtils.isNotEmpty(cartBOList)) {
                    cartBO = cartBOList.get(0);
                }
            } else {
                qryReq = new ShoppingCartBO();
                qryReq.setCartId(bo.getCartId());
                qryReq.setOperUser(operUser);
                cartBOList = this.shoppingCartAtomService.listShoppingCartByCondition(qryReq);
                if (CollectionUtils.isEmpty(cartBOList)) {
                    logger.error("\u8d2d\u7269\u8f66\u8bb0\u5f55\u3010" + bo.getCartId() + "\u3011\u4e0d\u5b58\u5728");
                    ThrExceptionUtils.thrQryRspEmptyExce("\u8d2d\u7269\u8f66\u8bb0\u5f55\u3010" + bo.getCartId() + "\u3011\u4e0d\u5b58\u5728");
                }
                cartBO = cartBOList.get(0);
            }
            if (null == cartBO) {
                cartBO = shoppingCartBO;
                cartBO.setCrtTime(new Date());
                cartBO.setValidFlag("1");
                cartBO.setProvince(bo.getProvince());
                cartBO.setFactory(bo.getFactory());
                cartBO.setCount(bo.getCount());
                cartBO.setBuyingFlag("1");
                cartBO.setOperUser(operUser);
                this.shoppingCartAtomService.saveShoppingCart(cartBO);
                cartIds.add(cartBO.getCartId());
                continue;
            }
            cartBO.setProvince(bo.getProvince());
            cartBO.setFactory(bo.getFactory());
            cartBO.setCount(bo.getCount());
            this.shoppingCartAtomService.modifyShoppingCartDetail(cartBO);
            cartIds.add(cartBO.getCartId());
        }
    }

    public RspBaseBO saveShoppingCart(ShoppingCartBatchBO reqBO) {
        String checkAuthRsp = PubCheckParamsUtils.checkAuth(reqBO.getmRole(), reqBO.getmLoginName());
        if (StringUtils.isNotBlank((CharSequence)checkAuthRsp)) {
            return new RspBaseBO("0009", checkAuthRsp);
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getReqList())) {
            logger.error("\u8d2d\u7269\u8f66\u4fe1\u606f\u96c6\u5408\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u8d2d\u7269\u8f66\u4fe1\u606f\u96c6\u5408\u4e3a\u7a7a");
        }
        List reqList = reqBO.getReqList();
        boolean buyingFlag = reqBO.getmRole().contains(TkPropertiesUtils.getProperty((String)"role.type.buying"));
        for (ShoppingCartBO bo : reqList) {
            PubCheckParamsUtils.checkSkuParams(bo);
            ShoppingCartBO qryBuying = new ShoppingCartBO();
            qryBuying.setSkuId(bo.getSkuId());
            qryBuying.setOperUser(reqBO.getmLoginName());
            List<ShoppingCartBO> shoppingCartBOS = this.shoppingCartAtomService.listShoppingCartByCondition(qryBuying);
            if (CollectionUtils.isNotEmpty(shoppingCartBOS)) {
                if (buyingFlag) continue;
                ShoppingCartBO cartBO = shoppingCartBOS.get(0);
                if (null == cartBO.getCount()) {
                    cartBO.setCount(Long.valueOf(1L));
                } else {
                    cartBO.setCount(Long.valueOf(cartBO.getCount() + 1L));
                }
                this.shoppingCartAtomService.modifyShoppingCart(cartBO);
                continue;
            }
            bo.setBuyingFlag("1");
            if (!buyingFlag) {
                if (StringUtils.isBlank((CharSequence)reqBO.getmProvince())) {
                    logger.error("\u7701\u5206\u4e3a\u7a7a");
                    ThrExceptionUtils.thrEmptyExce("\u7701\u5206\u4e3a\u7a7a");
                }
                bo.setCount(Long.valueOf(1L));
                bo.setBuyingFlag("0");
                bo.setProvince(reqBO.getmProvince());
            }
            bo.setOperUser(reqBO.getmLoginName());
            this.shoppingCartAtomService.saveShoppingCart(bo);
        }
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }

    public RspBaseBO removeShoppingCart(RemoveShoppingCartBO reqBO) {
        String checkAuthRsp = PubCheckParamsUtils.checkAuth(reqBO.getmRole(), reqBO.getmLoginName());
        if (StringUtils.isNotBlank((CharSequence)checkAuthRsp)) {
            return new RspBaseBO("0009", checkAuthRsp);
        }
        ShoppingCartBO cartBO = new ShoppingCartBO();
        cartBO.setOperUser(reqBO.getmLoginName());
        if (StringUtils.isNotBlank((CharSequence)reqBO.getmProvince())) {
            cartBO.setProvince(reqBO.getmProvince());
        }
        if (null != reqBO.getSkuId()) {
            cartBO.setSkuId(reqBO.getSkuId());
        }
        if (null != reqBO.getCartId()) {
            cartBO.setCartId(reqBO.getCartId());
        }
        try {
            this.shoppingCartAtomService.removeShippingCartByCondition(cartBO);
        }
        catch (ResourceException e) {
            return new RspBaseBO(e.getMsgCode(), e.getMessage());
        }
        catch (Exception e) {
            return new RspBaseBO("9999", "\u6e05\u9664\u8d2d\u7269\u8f66\u5f02\u5e38");
        }
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }

    public RspBaseBO removeShoppingCartByBatch(RemoveShoppingCartBO reqBO) {
        String checkAuthRsp = PubCheckParamsUtils.checkAuth(reqBO.getmRole(), reqBO.getmLoginName());
        if (StringUtils.isNotBlank((CharSequence)checkAuthRsp)) {
            return new RspBaseBO("0009", checkAuthRsp);
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getCartIds()) && CollectionUtils.isEmpty((Collection)reqBO.getSkuIds())) {
            logger.error("\u5546\u54c1ID\u96c6\u5408\u4e0e\u8d2d\u7269\u8f66ID\u96c6\u5408\u5fc5\u586b\u5176\u4e00");
            return new RspBaseBO("0001", "\u5546\u54c1ID\u96c6\u5408\u4e0e\u8d2d\u7269\u8f66ID\u96c6\u5408\u5fc5\u586b\u5176\u4e00");
        }
        try {
            this.shoppingCartAtomService.removeByBatch(reqBO.getSkuIds(), reqBO.getCartIds(), reqBO.getmLoginName());
        }
        catch (Exception e) {
            logger.error("\u6e05\u7a7a\u5931\u8d25\uff1a" + e.getMessage());
            return new RspBaseBO("0005", "\u6e05\u7a7a\u5931\u8d25");
        }
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }

    public RspBaseBO submitShoppingCart(ShoppingCartBatchBO reqBO) {
        String checkAuthRsp = PubCheckParamsUtils.checkAuth(reqBO.getmRole(), reqBO.getmLoginName());
        if (StringUtils.isNotBlank((CharSequence)checkAuthRsp)) {
            return new RspBaseBO("0009", checkAuthRsp);
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getSkuIds())) {
            logger.error("\u8d2d\u7269\u8f66ID\u96c6\u5408\u4e3a\u7a7a");
            return new RspBaseBO("0001", "\u8d2d\u7269\u8f66ID\u96c6\u5408\u4e3a\u7a7a");
        }
        List<ShoppingCartBO> cartBOS = this.shoppingCartAtomService.listShoppingCartByIds(reqBO.getSkuIds(), reqBO.getmLoginName());
        if (CollectionUtils.isEmpty(cartBOS)) {
            logger.error("\u672a\u67e5\u8be2\u5230\u8d2d\u7269\u8f66\u4fe1\u606f");
            ThrExceptionUtils.thrQryRspEmptyExce("\u672a\u67e5\u8be2\u5230\u8d2d\u7269\u8f66\u4fe1\u606f");
        }
        Date now = new Date();
        PurchaseRequireBO purchaseRequireBO = new PurchaseRequireBO();
        purchaseRequireBO.setLastUpdDate(now);
        purchaseRequireBO.setAuditStatus("01");
        purchaseRequireBO.setBuyingFlag(reqBO.getmRole().contains(TkPropertiesUtils.getProperty((String)"role.type.buying")) ? "1" : "0");
        purchaseRequireBO.setOperUser(reqBO.getmLoginName());
        purchaseRequireBO.setOperUserName(reqBO.getmName());
        purchaseRequireBO.setCrtTime(now);
        purchaseRequireBO.setProvince(reqBO.getmProvince());
        purchaseRequireBO.setValidFlag("1");
        ArrayList<PurchaseRequireDetailBO> detailBOS = new ArrayList<PurchaseRequireDetailBO>();
        long totalCount = 0L;
        HashMap<String, SupplierSkuDetailBO> skuMap = new HashMap<String, SupplierSkuDetailBO>();
        ArrayList<String> skuNos = new ArrayList<String>();
        HashMap<String, ContractLogRspBO> countLogMap = new HashMap<String, ContractLogRspBO>(cartBOS.size());
        HashMap<String, CountPriceDetailQueryInfoBO> countPriceMap = new HashMap<String, CountPriceDetailQueryInfoBO>(cartBOS.size());
        for (ShoppingCartBO cartBO : cartBOS) {
            this.checkParams(cartBO);
            totalCount += cartBO.getCount().longValue();
            PurchaseRequireDetailBO detailBO = new PurchaseRequireDetailBO();
            SupplierSkuDetailBO supplierSkuDetailBO = this.getSkuInfo(detailBO, cartBO, skuMap);
            if (StringUtils.isBlank((CharSequence)supplierSkuDetailBO.getMeterielCode())) {
                skuNos.add(supplierSkuDetailBO.getSkuNo());
            }
            this.getDetails(now, cartBO, detailBO, supplierSkuDetailBO.getSkuName(), countLogMap, countPriceMap);
            detailBOS.add(detailBO);
        }
        purchaseRequireBO.setTotalNum(Long.valueOf(totalCount));
        purchaseRequireBO.setPurchaseRequireDetailBOS(detailBOS);
        this.purchaseRequireAtomService.saveRequireInfo(purchaseRequireBO);
        this.shoppingCartAtomService.removeByBatch(reqBO.getSkuIds(), null, reqBO.getmLoginName());
        this.materialReminder(skuNos);
        return new RspBaseBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }

    private void materialReminder(List<String> skuNos) {
        try {
            MaterialReminderThread saveFace = new MaterialReminderThread(skuNos, this.addMaterielRepplyService);
            ExecutorService singleThreadPool = TkCreateThreadUtils.createSimpleThreadPool((Runnable)saveFace, (String)"meterial-reminder-pool", (int)1, (int)1);
            singleThreadPool.execute(() -> logger.debug(Thread.currentThread().getName()));
            singleThreadPool.shutdown();
        }
        catch (Exception e) {
            logger.error("\u5f00\u542f\u7269\u6599\u63d0\u9192\u7ebf\u7a0b\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private void getDetails(Date date, ShoppingCartBO cartBO, PurchaseRequireDetailBO detailBO, String skuName, Map<String, ContractLogRspBO> countLogMap, Map<String, CountPriceDetailQueryInfoBO> countPriceMap) {
        boolean countNotEnough;
        CountPriceDetailQueryInfoBO counPrice = GetCountPriceUtils.getCounPrice(this.countPriceDetailBusiService, cartBO.getSkuNo(), cartBO.getSupplierId(), date, countPriceMap);
        if (null == counPrice) {
            return;
        }
        detailBO.setTaxCode(counPrice.getSaleBuyTaxCode());
        detailBO.setPrice(counPrice.getPrice());
        detailBO.setAvailableCount(counPrice.getRemainingCount());
        detailBO.setContractType(counPrice.getContractTypeCode());
        boolean syncFlag = false;
        ContractLogRspBO logRsp = GetCountPriceUtils.getCountPriceLog(countLogMap, this.countPriceDetailBusiService, cartBO.getSkuNo(), cartBO.getSupplierId(), counPrice.getApplyNo(), cartBO.getFactory());
        if (null != logRsp && "02".equals(logRsp.getStatus())) {
            syncFlag = true;
        }
        boolean bl = countNotEnough = null != counPrice.getRemainingCount() && "01".equals(counPrice.getContractTypeCode()) && cartBO.getCount() > counPrice.getRemainingCount();
        if (countNotEnough) {
            logger.error("\u5546\u54c1\u3010" + skuName + "\u3011\u5269\u4f59\u6570\u91cf\u4e0d\u8db3");
            throw new ResourceException("0012", "\u5546\u54c1\u3010" + skuName + "\u3011\u5269\u4f59\u6570\u91cf\u4e0d\u8db3");
        }
        this.getDetailBO(cartBO, date, detailBO, syncFlag);
    }

    private void getDetailBO(ShoppingCartBO cartBO, Date now, PurchaseRequireDetailBO detailBO, boolean syncFlag) {
        boolean hasCountPrice;
        detailBO.setCount(cartBO.getCount());
        detailBO.setProvince(cartBO.getProvince());
        detailBO.setWarehouse(cartBO.getWarehouse());
        detailBO.setFactory(cartBO.getFactory());
        detailBO.setProjectCategory(cartBO.getProjectCategory());
        detailBO.setSkuNo(cartBO.getSkuNo());
        detailBO.setSupplierNo(cartBO.getSupplierNo());
        detailBO.setSupplierId(cartBO.getSupplierId());
        detailBO.setContent(cartBO.getContent());
        detailBO.setCrtTime(now);
        detailBO.setLastUpdDate(now);
        detailBO.setDeliveryDate(cartBO.getDeliveryDate());
        detailBO.setFreeFlag(cartBO.getFreeFlag());
        detailBO.setReturnFlag(cartBO.getReturnFlag());
        detailBO.setValidFlag("1");
        boolean bl = hasCountPrice = StringUtils.isNotBlank((CharSequence)detailBO.getMeterielCode()) && null != detailBO.getAvailableCount() && null != detailBO.getPrice() && detailBO.getCount() <= detailBO.getAvailableCount();
        if (hasCountPrice && syncFlag) {
            detailBO.setStatus("01");
        } else {
            detailBO.setStatus("03");
        }
    }

    private SupplierSkuDetailBO getSkuInfo(PurchaseRequireDetailBO detailBO, ShoppingCartBO cartBO, Map<String, SupplierSkuDetailBO> skuMap) {
        SupplierSkuDetailBO supplierSkuDetailBO = this.qrySpCommInfoAtonService.getSkuDetail(cartBO.getSkuId(), null, null, skuMap);
        if (null == supplierSkuDetailBO) {
            logger.error("\u5546\u54c1\u4e0d\u5b58\u5728");
            ThrExceptionUtils.thrQryRspEmptyExce("\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        detailBO.setMeterielCode(supplierSkuDetailBO.getMeterielCode());
        detailBO.setSupplierNo(supplierSkuDetailBO.getSupplierNo());
        detailBO.setUnitName(supplierSkuDetailBO.getSkuUnit());
        return supplierSkuDetailBO;
    }

    private void checkParams(ShoppingCartBO cartBO) {
        PubCheckParamsUtils.checkSkuParams(cartBO);
        if (StringUtils.isBlank((CharSequence)cartBO.getProvince())) {
            logger.error("\u91c7\u8d2d\u7701\u4efd\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u91c7\u8d2d\u7701\u4efd\u4e3a\u7a7a");
        }
        if (null == cartBO.getCount()) {
            logger.error("\u91c7\u8d2d\u6570\u91cf\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u91c7\u8d2d\u6570\u91cf\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)cartBO.getFactory()) || StringUtils.isBlank((CharSequence)cartBO.getWarehouse())) {
            logger.error("\u5de5\u5382\u4ed3\u5e93\u4fe1\u606f\u4e3a\u7a7a");
            ThrExceptionUtils.thrEmptyExce("\u5de5\u5382\u4ed3\u5e93\u4fe1\u606f\u4e3a\u7a7a");
        }
    }
}

