/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.purchase.util;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.newretail.purchase.bo.PurchaseFactoryWarehouseBO;
import com.tydic.newretail.purchase.dao.PurchaseFactoryDao;
import com.tydic.newretail.purchase.dao.po.PurchaseFactoryPO;
import com.tydic.newretail.purchase.dao.po.PurchaseFactoryWarehousePO;
import com.tydic.newretail.purchase.util.PurchaseProvinceUtils;
import com.tydic.newretail.purchase.util.ThrExceptionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public class FactoryWarehouseUtils
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger logger = LoggerFactory.getLogger(FactoryWarehouseUtils.class);
    private static PurchaseFactoryDao purchaseFactoryDao;
    private static CacheClient cacheClient;
    public static final String PREFIX_FACTORY = "PURCHASE_FAC_";
    public static final String PREFIX_PROVINCE = "PURCHASE_PRO_";

    public static void refresh() {
        FactoryWarehouseUtils.init();
    }

    public static List<PurchaseFactoryWarehouseBO> listFactoryWarehouseByProvince(String province) {
        PurchaseFactoryPO record = new PurchaseFactoryPO();
        if (StringUtils.isNotBlank((CharSequence)province)) {
            String provinceCode = PREFIX_PROVINCE + province;
            Object obj = null;
            try {
                obj = cacheClient.get(provinceCode);
            }
            catch (Exception e) {
                logger.error("\u4ece\u7f13\u5b58\u83b7\u53d6\u6570\u636e\u5931\u8d25\uff1a" + e.getMessage());
            }
            if (null != obj) {
                return (List)obj;
            }
            record.setProvince(province);
        }
        List<PurchaseFactoryWarehousePO> pos = null;
        try {
            pos = purchaseFactoryDao.selectAll(record);
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u7701\u5206\u7f16\u7801\u67e5\u8be2\u5de5\u5382\u5e93\u5b58\u5931\u8d25\uff1a" + e.getMessage());
            ThrExceptionUtils.thrQryExce("\u6839\u636e\u7701\u5206\u7f16\u7801\u67e5\u8be2\u5de5\u5382\u5e93\u5b58\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(pos)) {
            return null;
        }
        HashMap map = new HashMap();
        ArrayList<PurchaseFactoryWarehouseBO> rspList = new ArrayList<PurchaseFactoryWarehouseBO>(pos.size());
        for (PurchaseFactoryWarehousePO purchaseFactoryWarehousePO : pos) {
            String key = PREFIX_PROVINCE + purchaseFactoryWarehousePO.getProvince();
            PurchaseFactoryWarehouseBO bo = purchaseFactoryWarehousePO.toPurchaseFactoryWarehouseBO();
            ArrayList<PurchaseFactoryWarehouseBO> temList = null;
            if (map.containsKey(key)) {
                temList = (ArrayList<PurchaseFactoryWarehouseBO>)map.get(key);
                temList.add(bo);
            } else {
                temList = new ArrayList<PurchaseFactoryWarehouseBO>(1);
                temList.add(bo);
            }
            map.put(key, temList);
            if (StringUtils.isNotBlank((CharSequence)bo.getProvince())) {
                bo.setProvinceStr(PurchaseProvinceUtils.getPorvinceName(bo.getProvince()));
            }
            rspList.add(bo);
        }
        try {
            for (Map.Entry entry : map.entrySet()) {
                cacheClient.set((String)entry.getKey(), entry.getValue());
            }
        }
        catch (Exception e) {
            logger.error("\u653e\u5165\u7f13\u5b58\u5931\u8d25\uff1a" + e.getMessage());
        }
        return rspList;
    }

    public static PurchaseFactoryWarehouseBO getByFactoryNo(String factoryNo) {
        if (StringUtils.isBlank((CharSequence)factoryNo)) {
            return null;
        }
        String factory = PREFIX_FACTORY + factoryNo;
        Object obj = cacheClient.get(factory);
        if (null == obj) {
            PurchaseFactoryPO record = new PurchaseFactoryPO();
            record.setFactoryNo(factoryNo);
            List<PurchaseFactoryWarehousePO> pos = null;
            try {
                pos = purchaseFactoryDao.selectAll(record);
            }
            catch (Exception e) {
                logger.error("\u67e5\u8be2\u5de5\u5382\u5e93\u5b58\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
            }
            if (CollectionUtils.isEmpty(pos)) {
                return null;
            }
            PurchaseFactoryWarehouseBO bo = pos.get(0).toPurchaseFactoryWarehouseBO();
            cacheClient.set(factory, (Object)bo);
            return bo;
        }
        return (PurchaseFactoryWarehouseBO)obj;
    }

    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        if (null == contextRefreshedEvent.getApplicationContext().getParent()) {
            try {
                FactoryWarehouseUtils.init();
            }
            catch (Exception e) {
                logger.error("\u542f\u52a8\u52a0\u8f7d\u5de5\u5382\u4fe1\u606f\u5f02\u5e38\uff1a" + e.getMessage());
            }
        }
    }

    private static void init() {
        logger.debug("\u52a0\u8f7d\u5de5\u5382\u5e93\u5b58\u4fe1\u606f");
        FactoryWarehouseUtils.freshCache(PREFIX_PROVINCE);
        FactoryWarehouseUtils.freshCache(PREFIX_FACTORY);
        PurchaseFactoryPO record = new PurchaseFactoryPO();
        List<PurchaseFactoryWarehousePO> factoryWarehousePOS = null;
        try {
            factoryWarehousePOS = purchaseFactoryDao.selectAll(record);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5de5\u5382\u5e93\u5b58\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
        }
        if (null == factoryWarehousePOS) {
            return;
        }
        HashMap<String, List<PurchaseFactoryWarehouseBO>> map = new HashMap<String, List<PurchaseFactoryWarehouseBO>>();
        for (PurchaseFactoryWarehousePO po : factoryWarehousePOS) {
            String province = PREFIX_PROVINCE + po.getProvince();
            FactoryWarehouseUtils.saveFactoryList(map, province, po);
            String factoryNo = PREFIX_FACTORY + po.getFactoryNo();
            FactoryWarehouseUtils.saveFactory(factoryNo, po);
        }
    }

    public static void freshCache(String prefix) {
        try {
            Set keys = cacheClient.getkeys(prefix + "*");
            if (CollectionUtils.isNotEmpty((Collection)keys)) {
                for (String key : keys) {
                    cacheClient.delete(key);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u6e05\u7a7a\u7f13\u5b58\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private static void saveFactory(String factoryNo, PurchaseFactoryWarehousePO po) {
        if (null == cacheClient.get(factoryNo)) {
            cacheClient.set(factoryNo, (Object)po.toPurchaseFactoryWarehouseBO());
        }
    }

    private static void saveFactoryList(Map<String, List<PurchaseFactoryWarehouseBO>> map, String province, PurchaseFactoryWarehousePO po) {
        List<PurchaseFactoryWarehouseBO> factoryWarehouseBOS = null;
        PurchaseFactoryWarehouseBO bo = po.toPurchaseFactoryWarehouseBO();
        if (StringUtils.isNotBlank((CharSequence)bo.getProvince())) {
            bo.setProvinceStr(PurchaseProvinceUtils.getPorvinceName(bo.getProvince()));
        }
        factoryWarehouseBOS = map.containsKey(province) ? map.get(province) : new ArrayList<PurchaseFactoryWarehouseBO>(1);
        factoryWarehouseBOS.add(bo);
        cacheClient.set(province, factoryWarehouseBOS);
    }

    @Autowired
    public void setPurchaseFactoryDao(PurchaseFactoryDao purchaseFactoryDao) {
        FactoryWarehouseUtils.purchaseFactoryDao = purchaseFactoryDao;
    }

    @Autowired
    public void setCacheClient(CacheClient cacheClient) {
        FactoryWarehouseUtils.cacheClient = cacheClient;
    }
}

