/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.purchase.util;

import com.tydic.newretail.purchase.busi.CountPriceDetailBusiService;
import com.tydic.newretail.purchase.busi.bo.ContractLogReqBO;
import com.tydic.newretail.purchase.busi.bo.ContractLogRspBO;
import com.tydic.newretail.purchase.busi.bo.CountPriceDetailBeasBO;
import com.tydic.newretail.purchase.busi.bo.CountPriceDetailQueryBySkuNoBusiReqBO;
import com.tydic.newretail.purchase.busi.bo.CountPriceDetailQueryBySkuNoBusiRspBO;
import com.tydic.newretail.purchase.busi.bo.CountPriceDetailQueryInfoBO;
import com.tydic.newretail.purchase.util.ThrExceptionUtils;
import com.tydic.newretail.toolkit.bo.RspBatchBaseBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetCountPriceUtils {
    private static final Logger logger = LoggerFactory.getLogger(GetCountPriceUtils.class);

    public static CountPriceDetailQueryInfoBO getCounPrice(CountPriceDetailBusiService countPriceDetailBusiService, String skuNo, Long spId, Date time, Map<String, CountPriceDetailQueryInfoBO> countPriceMap) {
        String countPriceKey = spId + skuNo;
        if (countPriceMap.containsKey(countPriceKey)) {
            return countPriceMap.get(countPriceKey);
        }
        ArrayList<CountPriceDetailBeasBO> countReqList = new ArrayList<CountPriceDetailBeasBO>(1);
        CountPriceDetailBeasBO detailBeasBO = new CountPriceDetailBeasBO();
        detailBeasBO.setQueryTime(time);
        detailBeasBO.setSkuNo(skuNo);
        detailBeasBO.setSupplierId(spId);
        countReqList.add(detailBeasBO);
        CountPriceDetailQueryBySkuNoBusiReqBO countReqBO = new CountPriceDetailQueryBySkuNoBusiReqBO();
        countReqBO.setCountPriceDetailBeasBO(countReqList);
        CountPriceDetailQueryBySkuNoBusiRspBO countRsp = null;
        try {
            countRsp = countPriceDetailBusiService.queryBySupplierIdAndSkuNo(countReqBO);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u91cf\u4ef7\u4fe1\u606f\u5f02\u5e38:" + e.getMessage());
            ThrExceptionUtils.thrCallExec("\u67e5\u8be2\u91cf\u4ef7\u4fe1\u606f\u5f02\u5e38");
        }
        if (null == countRsp) {
            logger.error("\u67e5\u8be2\u91cf\u4ef7\u4fe1\u606f\u51fa\u53c2\u4e3a\u7a7a");
            ThrExceptionUtils.thrCallExec("\u67e5\u8be2\u91cf\u4ef7\u4fe1\u606f\u51fa\u53c2\u4e3a\u7a7a");
        }
        if (!"0000".equals(countRsp.getRespCode())) {
            logger.error("\u91cf\u4ef7\u6821\u9a8c\u5931\u8d25\uff1a" + countRsp.getRespDesc());
            ThrExceptionUtils.thrQryExce("\u91cf\u4ef7\u6821\u9a8c\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty((Collection)countRsp.getCountPriceDetailQueryInfoBO())) {
            return null;
        }
        CountPriceDetailQueryInfoBO rsp = (CountPriceDetailQueryInfoBO)countRsp.getCountPriceDetailQueryInfoBO().get(0);
        countPriceMap.put(countPriceKey, rsp);
        return rsp;
    }

    public static ContractLogRspBO getCountPriceLog(Map<String, ContractLogRspBO> map, CountPriceDetailBusiService countPriceDetailBusiService, String skuNo, Long spId, String applyNo, String factory) {
        String logKey = spId + skuNo + applyNo + factory;
        if (map.containsKey(logKey)) {
            return map.get(logKey);
        }
        ContractLogReqBO contractLogReqBO = new ContractLogReqBO();
        contractLogReqBO.setApplyNo(applyNo);
        contractLogReqBO.setSupplierId(spId);
        contractLogReqBO.setSkuNo(skuNo);
        contractLogReqBO.setFactory(factory);
        RspBatchBaseBO countLogRsp = null;
        try {
            countLogRsp = countPriceDetailBusiService.queryContractLog(contractLogReqBO);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u91cf\u4ef7\u540c\u6b65\u8bb0\u5f55\u5f02\u5e38:" + e.getMessage());
            ThrExceptionUtils.thrCallExec("\u67e5\u8be2\u91cf\u4ef7\u540c\u6b65\u8bb0\u5f55\u5f02\u5e38");
        }
        if (null == countLogRsp) {
            logger.error("\u67e5\u8be2\u91cf\u4ef7\u5408\u540c\u8bb0\u5f55\u51fa\u53c2\u4e3a\u7a7a");
            ThrExceptionUtils.thrCallExec("\u67e5\u8be2\u91cf\u4ef7\u5408\u540c\u8bb0\u5f55\u51fa\u53c2\u4e3a\u7a7a");
        }
        ContractLogRspBO rsp = null;
        if (CollectionUtils.isNotEmpty((Collection)countLogRsp.getRows())) {
            rsp = (ContractLogRspBO)countLogRsp.getRows().get(0);
            map.put(logKey, rsp);
        }
        return rsp;
    }
}

