/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.purchase.util;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.newretail.purchase.bo.PurchaseProvinceBO;
import com.tydic.newretail.purchase.dao.PurchaseProvinceDao;
import com.tydic.newretail.purchase.dao.po.PurchaseProvincePO;
import com.tydic.newretail.purchase.util.FactoryWarehouseUtils;
import com.tydic.newretail.purchase.util.ThrExceptionUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public class PurchaseProvinceUtils
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger logger = LoggerFactory.getLogger(PurchaseProvinceUtils.class);
    private static CacheClient cacheClient;
    private static PurchaseProvinceDao purchaseProvinceDao;
    private static final String PREFIX_PROVINCE = "PURCHASE_PROVINCE_";
    private static final String PREFIX_PRO_TO_ORG = "PURCHASE_PROTOORG_";
    private static final String PREFIX_ORG_TO_PRO = "PURCHASE_ORGTOPRO_";

    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        if (null == contextRefreshedEvent.getApplicationContext().getParent()) {
            try {
                PurchaseProvinceUtils.init();
            }
            catch (Exception e) {
                logger.error("\u542f\u52a8\u52a0\u8f7d\u7701\u4efd\u4fe1\u606f\u5f02\u5e38\uff1a" + e.getMessage());
            }
        }
    }

    public static String getPorvinceName(String provinceCode) {
        if (StringUtils.isBlank((CharSequence)provinceCode)) {
            return null;
        }
        PurchaseProvinceBO provinceBO = PurchaseProvinceUtils.getPorvinceByProCode(provinceCode);
        if (null == provinceBO) {
            return "\u672a\u5b9a\u4e49";
        }
        return provinceBO.getProvinceName();
    }

    public static List<PurchaseProvinceBO> listProvince() {
        Object obj = cacheClient.get("PURCHASE_PROVINCE_CODE_DIC");
        if (null != obj) {
            return (List)obj;
        }
        List<PurchaseProvincePO> provincePOS = null;
        try {
            provincePOS = purchaseProvinceDao.selectAll();
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7701\u4efd\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
        }
        if (CollectionUtils.isEmpty(provincePOS)) {
            return null;
        }
        ArrayList<PurchaseProvinceBO> bos = new ArrayList<PurchaseProvinceBO>(provincePOS.size());
        for (PurchaseProvincePO po : provincePOS) {
            PurchaseProvinceBO bo = po.toPurchaseProvinceBO();
            bos.add(bo);
        }
        try {
            cacheClient.set("PURCHASE_PROVINCE_CODE_DIC", bos);
        }
        catch (Exception e) {
            logger.error("\u7701\u4efd\u4fe1\u606f\u653e\u5165\u7f13\u5b58\u5931\u8d25\uff1a" + e.getMessage());
        }
        return bos;
    }

    public static PurchaseProvinceBO getPorvinceByProCode(String provinceCode) {
        return PurchaseProvinceUtils.getPorvincePub(PREFIX_PRO_TO_ORG, provinceCode);
    }

    public static PurchaseProvinceBO getPorvinceByOrgNo(String orgNo) {
        return PurchaseProvinceUtils.getPorvincePub(PREFIX_ORG_TO_PRO, orgNo);
    }

    private static PurchaseProvinceBO getPorvincePub(String prefix, String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        Object obj = null;
        try {
            obj = cacheClient.get(prefix + code);
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u7701\u4efd\u7f16\u7801\u67e5\u8be2\u7f13\u5b58\u5931\u8d25\uff1a" + e.getMessage());
        }
        if (null != obj) {
            return (PurchaseProvinceBO)obj;
        }
        PurchaseProvincePO purchaseProvincePO = null;
        if (PREFIX_PRO_TO_ORG.equals(prefix)) {
            try {
                purchaseProvincePO = purchaseProvinceDao.selectByProvinceCode(code);
            }
            catch (Exception e) {
                logger.error("\u6839\u636e\u7701\u4efd\u7f16\u7801\u67e5\u8be2\u7701\u4efd\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
                ThrExceptionUtils.thrQryExce("\u6839\u636e\u7701\u4efd\u7f16\u7801\u67e5\u8be2\u7701\u4efd\u4fe1\u606f\u5931\u8d25");
            }
        } else {
            try {
                purchaseProvincePO = purchaseProvinceDao.selectByOrgNo(code);
            }
            catch (Exception e) {
                logger.error("\u6839\u636e\u7ec4\u7ec7\u673a\u6784\u7f16\u7801\u67e5\u8be2\u7701\u4efd\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
                ThrExceptionUtils.thrQryExce("\u6839\u636e\u7ec4\u7ec7\u673a\u6784\u7f16\u7801\u67e5\u8be2\u7701\u4efd\u4fe1\u606f\u5931\u8d25");
            }
        }
        if (null == purchaseProvincePO) {
            return null;
        }
        try {
            cacheClient.set(prefix + code, (Object)purchaseProvincePO.toPurchaseProvinceBO());
        }
        catch (Exception e) {
            logger.error("\u7701\u4efd\u7f16\u7801\u653e\u5165\u7f13\u5b58\u5931\u8d25\uff1a" + e.getMessage());
        }
        return purchaseProvincePO.toPurchaseProvinceBO();
    }

    public static void refresh() {
        PurchaseProvinceUtils.init();
    }

    private static void init() {
        logger.debug("\u542f\u52a8\u52a0\u8f7d\u7701\u4efd\u4fe1\u606f");
        FactoryWarehouseUtils.freshCache(PREFIX_PROVINCE);
        FactoryWarehouseUtils.freshCache(PREFIX_ORG_TO_PRO);
        FactoryWarehouseUtils.freshCache(PREFIX_PRO_TO_ORG);
        List<PurchaseProvincePO> provincePOS = null;
        try {
            provincePOS = purchaseProvinceDao.selectAll();
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7701\u4efd\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
        }
        if (CollectionUtils.isEmpty(provincePOS)) {
            return;
        }
        ArrayList<PurchaseProvinceBO> bos = new ArrayList<PurchaseProvinceBO>(provincePOS.size());
        for (PurchaseProvincePO po : provincePOS) {
            PurchaseProvinceBO bo = po.toPurchaseProvinceBO();
            try {
                cacheClient.set(PREFIX_ORG_TO_PRO + po.getOrgNo(), (Object)bo);
                cacheClient.set(PREFIX_PRO_TO_ORG + po.getProvince(), (Object)bo);
            }
            catch (Exception e) {
                logger.error("\u7701\u4efd\u6216\u91c7\u8d2d\u7ec4\u7ec7\u7f16\u7801\u653e\u5165\u7f13\u5b58\u5931\u8d25\uff1a" + e.getMessage());
            }
            bos.add(bo);
        }
        try {
            cacheClient.set("PURCHASE_PROVINCE_CODE_DIC", bos);
        }
        catch (Exception e) {
            logger.error("\u7701\u4efd\u4fe1\u606f\u653e\u5165\u7f13\u5b58\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Autowired
    public void setCacheClient(CacheClient cacheClient) {
        PurchaseProvinceUtils.cacheClient = cacheClient;
    }

    @Autowired
    public void setPurchaseProvinceDao(PurchaseProvinceDao purchaseProvinceDao) {
        PurchaseProvinceUtils.purchaseProvinceDao = purchaseProvinceDao;
    }
}

