/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.scan;

import android.content.Context;
import android.util.Log;
import android_serialport_api.SerialPort;
import com.tydic.newretail.scan.ChangeTool;
import com.tydic.newretail.scan.ScannerListener;
import com.tydic.newretail.scan.bridgeinterfaces.IWebViewMessageHandlerInterface;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SerialPortUtils {
    public static IWebViewMessageHandlerInterface iWebViewMessageHandlerInterface;
    private static SerialPortUtils instance;
    private final String TAG = "SerialPortUtils";
    private int baudrate = 9600;
    public boolean serialPortStatus = false;
    public String data_;
    public boolean threadStatus;
    public SerialPort serialPort = null;
    public InputStream inputStream = null;
    public OutputStream outputStream = null;
    public ChangeTool changeTool = new ChangeTool();
    public OnDataReceiveListener onDataReceiveListener = null;

    public static String init(Context context) {
        try {
            instance = new SerialPortUtils();
            instance.setOnDataReceiveListener(new ScannerListener());
            instance.openSerialPort("/dev/ttyACM0");
            Log.e((String)"------", (String)"init scanner in util finish");
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e((String)"SerialPortUtils", (String)e.getMessage(), (Throwable)e);
            return e.getMessage();
        }
    }

    public SerialPort openSerialPort(String path) {
        try {
            this.serialPort = new SerialPort(new File(path), this.baudrate, 0);
            this.serialPortStatus = true;
            this.threadStatus = false;
            this.inputStream = this.serialPort.getInputStream();
            this.outputStream = this.serialPort.getOutputStream();
            new ReadThread().start();
        }
        catch (Exception e) {
            Log.e((String)"SerialPortUtils", (String)("openSerialPort: \u6253\u5f00\u4e32\u53e3\u5f02\u5e38\uff1a" + e.toString()));
            return this.serialPort;
        }
        Log.d((String)"SerialPortUtils", (String)"openSerialPort: \u6253\u5f00\u4e32\u53e3");
        return this.serialPort;
    }

    public void closeSerialPort() {
        try {
            this.inputStream.close();
            this.outputStream.close();
            this.serialPortStatus = false;
            this.threadStatus = true;
            this.serialPort.close();
        }
        catch (IOException e) {
            Log.e((String)"SerialPortUtils", (String)("closeSerialPort: \u5173\u95ed\u4e32\u53e3\u5f02\u5e38\uff1a" + e.toString()));
            return;
        }
        Log.d((String)"SerialPortUtils", (String)"closeSerialPort: \u5173\u95ed\u4e32\u53e3\u6210\u529f");
    }

    public void sendSerialPort(String data) {
        Log.d((String)"SerialPortUtils", (String)"sendSerialPort: \u53d1\u9001\u6570\u636e");
        try {
            byte[] sendData = data.getBytes();
            this.data_ = new String(sendData);
            if (sendData.length > 0) {
                this.outputStream.write(sendData);
                this.outputStream.write(10);
                this.outputStream.flush();
                Log.d((String)"SerialPortUtils", (String)"sendSerialPort: \u4e32\u53e3\u6570\u636e\u53d1\u9001\u6210\u529f");
            }
        }
        catch (IOException e) {
            Log.e((String)"SerialPortUtils", (String)("sendSerialPort: \u4e32\u53e3\u6570\u636e\u53d1\u9001\u5931\u8d25\uff1a" + e.toString()));
        }
    }

    public void setOnDataReceiveListener(OnDataReceiveListener dataReceiveListener) {
        this.onDataReceiveListener = dataReceiveListener;
    }

    public static interface OnDataReceiveListener {
        public void onDataReceive(byte[] var1, int var2);
    }

    private class ReadThread
    extends Thread {
        private ReadThread() {
        }

        @Override
        public void run() {
            super.run();
            while (!SerialPortUtils.this.threadStatus) {
                byte[] buffer = new byte[64];
                try {
                    int size = SerialPortUtils.this.inputStream.read(buffer);
                    if (size <= 0) continue;
                    SerialPortUtils.this.onDataReceiveListener.onDataReceive(buffer, size);
                }
                catch (IOException e) {
                    Log.e((String)"SerialPortUtils", (String)("run: \u6570\u636e\u8bfb\u53d6\u5f02\u5e38\uff1a" + e.toString()));
                }
            }
        }
    }
}

