/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.toolkit.util;

import com.tydic.newretail.toolkit.util.SSLSessionReuseFTPSClient;
import com.tydic.newretail.toolkit.util.TkFtpConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import org.apache.commons.net.PrintCommandListener;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.FTPSClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TkFtpUtils {
    private static final Logger logger = LoggerFactory.getLogger(TkFtpUtils.class);
    private FTPSClient ftpClient;
    private static final String SEP_SLASH = "/";
    private TkFtpConfig config;

    public TkFtpUtils() {
        this.ftpClient = this.login(new TkFtpConfig());
    }

    public TkFtpUtils(TkFtpConfig ftpConfig) {
        this.ftpClient = this.login(ftpConfig);
    }

    private FTPSClient login(TkFtpConfig ftpConfig) {
        this.config = ftpConfig;
        this.ftpClient = new SSLSessionReuseFTPSClient();
        try {
            this.ftpClient.setAuthValue("TLS");
            this.ftpClient.addProtocolCommandListener((ProtocolCommandListener)new PrintCommandListener(new PrintWriter(System.out)));
            this.ftpClient.setDefaultTimeout(60000);
            logger.info(">>>>\u5f00\u59cb\u8fde\u63a5ftp\u670d\u52a1\u5668>>>>" + ftpConfig.getHostname() + ":" + ftpConfig.getPort());
            this.ftpClient.connect(ftpConfig.getHostname(), Integer.parseInt(ftpConfig.getPort()));
            this.ftpClient.login(ftpConfig.getUsername(), ftpConfig.getPassword());
            int reply = this.ftpClient.getReplyCode();
            this.ftpClient.setFileTransferMode(10);
            this.ftpClient.setRemoteVerificationEnabled(false);
            this.ftpClient.execPBSZ(0L);
            this.ftpClient.execPROT("P");
            this.ftpClient.enterLocalPassiveMode();
            this.ftpClient.setDataTimeout(180000);
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                this.ftpClient.disconnect();
                logger.error(">>>>FTP\u670d\u52a1\u5668\u8fde\u63a5\u5931\u8d25\uff01>>>>");
                throw new IOException("FTP\u670d\u52a1\u5668\u8fde\u63a5\u5931\u8d25\uff01");
            }
            logger.info(">>>>ftp\u670d\u52a1\u5668\u8fde\u63a5\u6210\u529f>>>>");
        }
        catch (IOException e) {
            logger.error(">>>>FTP\u670d\u52a1\u5668\u8fde\u63a5\u5931\u8d25\uff01>>>>");
        }
        return this.ftpClient;
    }

    private void disconnectFtp() {
        if (this.ftpClient.isConnected()) {
            try {
                this.ftpClient.disconnect();
            }
            catch (IOException e) {
                logger.error("\u65ad\u5f00\u8fde\u63a5\u5931\u8d25\uff01");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadFile(String pathName, String fileName, String originFileName) {
        if (!this.ftpClient.isConnected()) {
            this.login(this.config);
        }
        boolean flag = false;
        InputStream inputStream = null;
        try {
            logger.info(">>>>>\u5f00\u59cb\u4e0a\u4f20\u6587\u4ef6>>>>>>");
            File file = new File(originFileName);
            inputStream = new FileInputStream(file);
            this.ftpClient.setFileType(2);
            if (this.CreateDirecroty(pathName)) {
                this.ftpClient.changeWorkingDirectory(pathName);
            }
            this.ftpClient.storeFile(fileName, inputStream);
            inputStream.close();
            this.ftpClient.logout();
            flag = true;
            logger.info(">>>>>\u4e0a\u4f20\u6587\u4ef6\u6210\u529f>>>>>>");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(">>>>>\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25>>>>>> {}", (Throwable)e);
        }
        finally {
            if (this.ftpClient.isConnected()) {
                try {
                    this.ftpClient.disconnect();
                }
                catch (IOException e) {
                    logger.error("error {}", (Throwable)e);
                }
            }
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.error("error {}", (Throwable)e);
                }
            }
        }
        return flag;
    }

    public boolean CreateDirecroty(String remote) throws IOException {
        boolean success;
        block5: {
            success = true;
            String directory = remote;
            if (!remote.endsWith(SEP_SLASH)) {
                directory = directory + SEP_SLASH;
            }
            if (directory.equalsIgnoreCase(SEP_SLASH) || this.changeWorkingDirectory(directory)) break block5;
            success = false;
            int start = 0;
            int end = 0;
            start = directory.startsWith(SEP_SLASH) ? 1 : 0;
            end = directory.indexOf(SEP_SLASH, start);
            String path = "";
            String paths = "";
            while (true) {
                int count = 0;
                String subDirectory = new String(remote.substring(start, end).getBytes("GBK"), StandardCharsets.ISO_8859_1);
                path = path + SEP_SLASH + subDirectory;
                if (!this.changeWorkingDirectory(subDirectory)) {
                    if (this.makeDirectory(subDirectory)) {
                        this.changeWorkingDirectory(subDirectory);
                    } else {
                        logger.info("\u521b\u5efa\u76ee\u5f55[" + subDirectory + "]\u5931\u8d25");
                        if (++count < 4) continue;
                        throw new IOException("\u521b\u5efa\u76ee\u5f55[" + subDirectory + "]\u5931\u8d25");
                    }
                }
                paths = paths + SEP_SLASH + subDirectory;
                start = end + 1;
                if ((end = directory.indexOf(SEP_SLASH, start)) <= start) break;
            }
        }
        return success;
    }

    public boolean existFile(String path) throws IOException {
        boolean flag = false;
        FTPFile[] ftpFileArr = this.ftpClient.listFiles(path);
        if (ftpFileArr.length > 0) {
            flag = true;
        }
        return flag;
    }

    public boolean makeDirectory(String dir) {
        boolean flag = false;
        try {
            flag = this.ftpClient.makeDirectory(dir);
            if (flag) {
                logger.info("\u521b\u5efa\u6587\u4ef6\u5939" + dir + " \u6210\u529f\uff01");
            } else {
                logger.info("\u521b\u5efa\u6587\u4ef6\u5939" + dir + " \u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            logger.error("error {}", (Throwable)e);
        }
        return flag;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean changeWorkingDirectory(String directory) {
        boolean flag = true;
        try {
            flag = this.ftpClient.changeWorkingDirectory(directory);
            if (!flag) return flag;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean downloadFile(String pathName, String localPath, String fileName) {
        boolean flag = false;
        OutputStream os = null;
        if (fileName == null || "".equals(fileName.trim())) {
            return flag;
        }
        try {
            FTPFile[] ftpFiles;
            logger.info("\u5f00\u59cb\u4e0b\u8f7d\u6587\u4ef6");
            if (!this.ftpClient.isConnected()) {
                this.login(this.config);
            }
            this.ftpClient.changeWorkingDirectory(pathName);
            for (FTPFile file : ftpFiles = this.ftpClient.listFiles()) {
                if (!file.getName().equals(fileName)) continue;
                File localFile = new File(localPath + SEP_SLASH + file.getName());
                os = new FileOutputStream(localFile);
                this.ftpClient.retrieveFile(file.getName(), os);
                os.close();
                break;
            }
            this.ftpClient.logout();
            flag = true;
            logger.info("\u4e0b\u8f7d\u6587\u4ef6\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25error {}", (Throwable)e);
        }
        finally {
            this.disconnectFtp();
            if (null != os) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    logger.error("error {}", (Throwable)e);
                }
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean downloadFile(String pathName, String localPath) {
        boolean flag = false;
        OutputStream os = null;
        try {
            FTPFile[] ftpFiles;
            logger.info("\u5f00\u59cb\u4e0b\u8f7d\u6587\u4ef6");
            if (!this.ftpClient.isConnected()) {
                this.login(this.config);
            }
            this.ftpClient.changeWorkingDirectory(pathName);
            for (FTPFile file : ftpFiles = this.ftpClient.listFiles()) {
                File localFile = new File(localPath + SEP_SLASH + file.getName());
                os = new FileOutputStream(localFile);
                this.ftpClient.retrieveFile(file.getName(), os);
                os.close();
            }
            this.ftpClient.logout();
            flag = true;
            logger.info("\u4e0b\u8f7d\u6587\u4ef6\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25error {}", (Throwable)e);
        }
        finally {
            this.disconnectFtp();
            if (null != os) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    logger.error("error {}", (Throwable)e);
                }
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteFile(String pathName, String fileName) {
        boolean flag = false;
        try {
            logger.info("\u5f00\u59cb\u5220\u9664\u6587\u4ef6");
            if (!this.ftpClient.isConnected()) {
                this.login(this.config);
            }
            this.ftpClient.changeWorkingDirectory(pathName);
            this.ftpClient.dele(fileName);
            this.ftpClient.logout();
            flag = true;
            System.out.println("\u5220\u9664\u6587\u4ef6\u6210\u529f");
            logger.info("\u5220\u9664\u6587\u4ef6\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u5220\u9664\u6587\u4ef6\u5931\u8d25error {}", (Throwable)e);
        }
        finally {
            this.disconnectFtp();
        }
        return flag;
    }

    public FileOutputStream getOutputStream(String localBaseDir, String remoteFilePath) throws Exception {
        FileOutputStream outputStream = new FileOutputStream(localBaseDir + remoteFilePath);
        this.ftpClient.enterLocalPassiveMode();
        this.ftpClient.retrieveFile(remoteFilePath, (OutputStream)outputStream);
        return outputStream;
    }

    public void startDownFile(String localBaseDir, String remoteFilePath) throws Exception {
        if (this.ftpClient != null) {
            try {
                FileOutputStream outputStream = new FileOutputStream(localBaseDir + remoteFilePath);
                this.ftpClient.enterLocalPassiveMode();
                this.ftpClient.retrieveFile(remoteFilePath, (OutputStream)outputStream);
                outputStream.flush();
                outputStream.close();
            }
            catch (Exception e) {
                logger.error("error {}", (Throwable)e);
            }
        } else {
            logger.info("\u8fde\u63a5FTP\u670d\u52a1\u5668\u5931\u8d25");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadFile(String pathName, String fileName, InputStream inputStream) {
        boolean flag = false;
        try {
            this.ftpClient.setFileType(2);
            if (this.CreateDirecroty(pathName)) {
                this.ftpClient.changeWorkingDirectory(pathName);
            }
            this.ftpClient.storeFile(fileName, inputStream);
            inputStream.close();
            this.ftpClient.logout();
            flag = true;
            logger.info(">>>>>\u4e0a\u4f20\u6587\u4ef6\u6210\u529f>>>>>>" + pathName + SEP_SLASH + fileName);
        }
        catch (Exception e) {
            logger.error(">>>>>\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25>>>>>>error {}", (Throwable)e);
        }
        finally {
            if (this.ftpClient.isConnected()) {
                try {
                    this.ftpClient.disconnect();
                }
                catch (IOException e) {
                    logger.error("error {}", (Throwable)e);
                }
            }
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.error("error {}", (Throwable)e);
                }
            }
        }
        return flag;
    }

    public static void main(String[] args) throws Exception {
        try {
            TkFtpConfig ftpConfig = new TkFtpConfig("39.106.31.94", "21", "tyls", "T4tzQh6p7hEZ");
            TkFtpUtils ftp = new TkFtpUtils(ftpConfig);
            ftp.uploadFile("/NEWRETAIL_TEST/input", "test5.xlsx", "/work/test.xlsx");
            ftp.downloadFile("/NEWRETAIL_TEST/input", "/work");
            ftp.downloadFile("/NEWRETAIL_TEST/input", "/work", "test.xlsx");
            ftp.deleteFile("/NEWRETAIL_TEST/input", "test7.xml");
        }
        catch (Exception e) {
            logger.error("error {}", (Throwable)e);
        }
    }
}

